/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.persistent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.youtrack.scripts.persistent.XdScript;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/scripts/persistent/ScriptFullName;", "", "pkg", "", "name", "converted", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "s", "Ljetbrains/youtrack/scripts/persistent/XdScript;", "(Ljetbrains/youtrack/scripts/persistent/XdScript;Z)V", "version", "", "(Ljava/lang/String;Ljava/lang/String;ZI)V", "getConverted", "()Z", "getName", "()Ljava/lang/String;", "getPkg", "getVersion", "()I", "equals", "other", "hashCode", "toString", "Companion", "youtrack-scripts"})
public final class ScriptFullName {
    @NotNull
    private final String pkg;
    @NotNull
    private final String name;
    private final boolean converted;
    private final int version;
    private static final Pattern NEW_NAME_PATTERN;
    private static final Pattern OLD_NAME_PATTERN;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.converted ? this.pkg + '/' + this.name : this.pkg + "->" + this.name;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ScriptFullName && this.converted == ((ScriptFullName)other).converted && Intrinsics.areEqual((Object)this.pkg, (Object)((ScriptFullName)other).pkg) && Intrinsics.areEqual((Object)this.name, (Object)((ScriptFullName)other).name);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public final String getPkg() {
        return this.pkg;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getConverted() {
        return this.converted;
    }

    public final int getVersion() {
        return this.version;
    }

    public ScriptFullName(@NotNull String pkg, @NotNull String name, boolean converted, int version) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.pkg = pkg;
        this.name = name;
        this.converted = converted;
        this.version = version;
    }

    public /* synthetic */ ScriptFullName(String string, String string2, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(string, string2, bl, n);
    }

    public ScriptFullName(@NotNull String pkg, @NotNull String name, boolean converted) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this(pkg, name, converted, 0);
    }

    public /* synthetic */ ScriptFullName(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, string2, bl);
    }

    public ScriptFullName(@NotNull XdScript s, boolean converted) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        this(s.getWorkflow().getName(), s.getName(), converted);
    }

    public /* synthetic */ ScriptFullName(XdScript xdScript, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(xdScript, bl);
    }

    static {
        Companion = new Companion(null);
        NEW_NAME_PATTERN = Pattern.compile("(.+/)+(.+)");
        OLD_NAME_PATTERN = Pattern.compile("(.+->)+(.+)");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/scripts/persistent/ScriptFullName$Companion;", "", "()V", "NEW_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "OLD_NAME_PATTERN", "parse", "Ljetbrains/youtrack/scripts/persistent/ScriptFullName;", "fullName", "", "youtrack-scripts"})
    public static final class Companion {
        @NotNull
        public final ScriptFullName parse(@NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            Matcher matcher = null;
            String delimiter = null;
            boolean converted = false;
            if (StringsKt.contains$default((CharSequence)fullName, (CharSequence)"->", (boolean)false, (int)2, null)) {
                Matcher matcher2 = OLD_NAME_PATTERN.matcher(fullName);
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher2, (String)"OLD_NAME_PATTERN.matcher(fullName)");
                matcher = matcher2;
                delimiter = "->";
                converted = false;
            } else {
                Matcher matcher3 = NEW_NAME_PATTERN.matcher(fullName);
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher3, (String)"NEW_NAME_PATTERN.matcher(fullName)");
                matcher = matcher3;
                delimiter = "/";
                converted = true;
            }
            if (!matcher.find()) {
                throw (Throwable)new IllegalArgumentException("Invalid full name format");
            }
            String string = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(1)");
            String string2 = StringsKt.removeSuffix((String)string, (CharSequence)delimiter);
            String string3 = matcher.group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(2)");
            return new ScriptFullName(string2, string3, converted);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

