/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.sandbox;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jetbrains.youtrack.scripts.internals.MiscKt;
import jetbrains.youtrack.scripts.persistent.BeansKt;
import jetbrains.youtrack.scripts.restricted.UtilsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u001a\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0007H\u0007J\u001a\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0002J/\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u001aJ/\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00072\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00072\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/scripts/sandbox/Utils;", "", "()V", "bufferStream", "Ljava/io/InputStream;", "inputStream", "formatTimestamp", "", "unixTimestamp", "", "format", "timeZoneId", "getLevenshteinDistance", "", "s1", "s2", "readString", "encoding", "timeZone", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "toDate", "Ljava/util/Date;", "timestamp", "formats", "", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Ljava/util/Date;", "toDateTimestamp", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)J", "toUnixTimestamp", "youtrack-scripts"})
public final class Utils {
    public static final Utils INSTANCE;

    @JvmStatic
    public static final long toUnixTimestamp(@NotNull String timestamp, @Nullable String[] formats, @Nullable String timeZoneId) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return INSTANCE.toDate(timestamp, formats, timeZoneId).getTime();
    }

    @JvmStatic
    public static final long toDateTimestamp(@NotNull String timestamp, @Nullable String[] formats, @Nullable String timeZoneId) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        Calendar calendar2 = calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        calendar2.setTime(INSTANCE.toDate(timestamp, formats, timeZoneId));
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return new DateTime(year, month, day, 12, 0, 0, 0, DateTimeZone.UTC).getMillis();
    }

    private final Date toDate(String timestamp, String[] formats, String timeZoneId) {
        String[] stringArray = formats;
        if (formats == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = UtilsKt.getDefaultDateFormat();
        }
        for (String pattern : stringArray) {
            String string;
            if (pattern == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            try {
                SimpleDateFormat simpleDateFormat;
                if (StringsKt.endsWith$default((CharSequence)pattern, (char)'Z', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)pattern, (char)'X', (boolean)false, (int)2, null)) {
                    simpleDateFormat = new SimpleDateFormat(pattern);
                } else {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(pattern);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    SimpleDateFormat $this$apply = simpleDateFormat2;
                    boolean bl6 = false;
                    $this$apply.setTimeZone(INSTANCE.timeZone(timeZoneId));
                    simpleDateFormat = simpleDateFormat2;
                }
                SimpleDateFormat format = simpleDateFormat;
                Date date = format.parse(timestamp);
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"format.parse(timestamp)");
                return date;
            }
            catch (ParseException parseException) {
            }
        }
        if (formats == null) {
            throw (Throwable)new RuntimeException("Timestamp " + timestamp + " does not match default date format (" + UtilsKt.getDefaultDateFormat() + ')');
        }
        throw (Throwable)new RuntimeException("Timestamp " + timestamp + " matches neither of the formats provided (" + ArraysKt.joinToString$default((Object[])formats, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ')');
    }

    @JvmStatic
    @NotNull
    public static final String formatTimestamp(long unixTimestamp, @Nullable String format, @Nullable String timeZoneId) {
        String string = format;
        if (string == null) {
            string = UtilsKt.getDefaultDateFormat();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat $this$apply = simpleDateFormat;
        boolean bl3 = false;
        $this$apply.setTimeZone(INSTANCE.timeZone(timeZoneId));
        String string2 = simpleDateFormat.format(unixTimestamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(format \u2026  }.format(unixTimestamp)");
        return string2;
    }

    private final TimeZone timeZone(String timeZoneId) {
        String string = timeZoneId;
        if (string == null) {
            string = UtilsKt.getDefaultTimeZoneId();
        }
        return TimeZone.getTimeZone(string);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        String string = IOUtils.toString((InputStream)inputStream, (String)encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IOUtils.toString(inputStream, encoding)");
        return string;
    }

    public static /* synthetic */ String readString$default(InputStream inputStream, String string, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            String string2 = Charsets.UTF_8.displayName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Charsets.UTF_8.displayName()");
            string = string2;
        }
        return Utils.readString(inputStream, string);
    }

    @JvmStatic
    public static final int getLevenshteinDistance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        return StringUtils.getLevenshteinDistance((String)s1, (String)s2);
    }

    @JvmStatic
    @NotNull
    public static final InputStream bufferStream(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        return MiscKt.bufferStream(inputStream, BeansKt.getScriptingContextHolder().get());
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

