/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.wrappers;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.youtrack.api.workflow.wrappers.PropertyValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.ValueResolver;
import jetbrains.youtrack.scripts.wrappers.ImmutableIterableWrapper;

public class MutableIterableWrapper
extends ImmutableIterableWrapper {
    protected Set<Object> toBeAdded;
    protected Set<Object> toBeRemoved;
    private PropertyValueResolver propertyValueResolver;
    private Entity self;

    public MutableIterableWrapper(Entity self, PropertyValueResolver valueResolver, Iterable entityIterable) {
        super((ValueResolver)valueResolver, entityIterable);
        this.propertyValueResolver = valueResolver;
        this.self = self;
    }

    @Override
    public Iterable getIterable() {
        return new ChangedIterable();
    }

    @Override
    public int size() {
        return Sequence.fromIterable((Iterable)this.getIterable()).count();
    }

    boolean hasModifications() {
        return SetSequence.fromSet(this.toBeAdded).isNotEmpty() || SetSequence.fromSet(this.toBeRemoved).isNotEmpty();
    }

    public void add(Object o) {
        this.doAdd(this.valueResolver.unwrap(o));
    }

    public void remove(Object o) {
        this.doRemove(this.valueResolver.unwrap(o));
    }

    public void clear() {
        Iterable iterable = this.getIterable();
        for (Object element : Sequence.fromIterable((Iterable)iterable).toListSequence()) {
            this.doRemove(element);
        }
    }

    @Override
    public boolean contains(Object value) {
        value = this.valueResolver.unwrap(value);
        if (SetSequence.fromSet(this.toBeAdded).contains(value)) {
            return true;
        }
        if (SetSequence.fromSet(this.toBeRemoved).contains(value)) {
            return false;
        }
        Iterable values = this.entityIterable;
        return Sequence.fromIterable((Iterable)values).contains(value);
    }

    @Override
    public Iterator iterator() {
        final Iterator entityIterator = this.getIterable().iterator();
        return new Iterator(){
            private Entity current;

            @Override
            public boolean hasNext() {
                return entityIterator.hasNext();
            }

            public Object next() {
                this.current = (Entity)entityIterator.next();
                return MutableIterableWrapper.this.valueResolver.wrapEntity(this.current);
            }

            @Override
            public void remove() {
                MutableIterableWrapper.this.doRemove(this.current);
            }
        };
    }

    private void doAdd(Object e) {
        if (e != null && !EntityOperations.equals((Entity)((Entity)e), (Object)this.self)) {
            this.toBeAdded = this.alaPutIfAbsent(this.toBeAdded, this.toBeRemoved, e);
        }
    }

    private void doRemove(Object e) {
        if (e != null) {
            this.toBeRemoved = this.alaPutIfAbsent(this.toBeRemoved, this.toBeAdded, e);
        }
    }

    private Set<Object> alaPutIfAbsent(Set<Object> target, Set<Object> contender, Object e) {
        if (SetSequence.fromSet(contender).isEmpty() || SetSequence.fromSet(contender).removeElement(e) == null) {
            if (target == null) {
                target = SetSequence.fromSet(new HashSet());
            }
            SetSequence.fromSet(target).addElement(e);
        }
        return target;
    }

    public void applyChanges() {
        if (this.hasModifications()) {
            this.propertyValueResolver.set(this.self, (Object)this.getIterable());
        }
    }

    private static boolean eq_3kkxrh_a0a0a1a(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public class ChangedIterable
    implements Iterable<Object> {
        private Iterable<Object> wrappedSeq;

        public ChangedIterable() {
            this.wrappedSeq = MutableIterableWrapper.this.entityIterable;
            if (MutableIterableWrapper.this.hasModifications()) {
                this.wrappedSeq = Sequence.fromIterable(this.wrappedSeq).union((ISequence)SetSequence.fromSet(MutableIterableWrapper.this.toBeAdded)).subtract((ISequence)SetSequence.fromSet(MutableIterableWrapper.this.toBeRemoved));
            }
        }

        @Override
        public Iterator<Object> iterator() {
            return Sequence.fromIterable(this.wrappedSeq).iterator();
        }

        public boolean matchProperty(Entity entity, String fieldName) {
            return EntityOperations.equals((Entity)entity, (Object)MutableIterableWrapper.this.self) && MutableIterableWrapper.eq_3kkxrh_a0a0a1a(fieldName, fieldName);
        }

        public Iterable<Object> getAdded() {
            return MutableIterableWrapper.this.toBeAdded;
        }

        public Iterable<Object> getRemoved() {
            return MutableIterableWrapper.this.toBeRemoved;
        }
    }
}

