var identifyingProperties = {
  'Issue': 'id',
  'User': 'login'
};
var Iterator = function (iterableWrapper, yField) {
  this._iterator = iterableWrapper.iterator();
  Object.defineProperty(this, 'yField', {value: yField});
};
Iterator.prototype.next = function () {
  var hasNext = this._iterator.hasNext();
  return {
    done: !hasNext,
    value: hasNext ? wrap(this._iterator.next(), this.yField, this.enclosingEntity) : null
  }
};

var CanonicalIterator = function (iterableWrapper, yField) {
  this._iterator = iterableWrapper.iterator();
  Object.defineProperty(this, 'yField', {value: yField});
};
CanonicalIterator.prototype.next = function () {
  return wrap(this._iterator.next(), this.yField, this.enclosingEntity);
};
CanonicalIterator.prototype.hasNext = function () {
  return this._iterator.hasNext();
};

var ImmutableIterableWW = function (iterableWrapper, yField, enclosingEntity, linkName) {
  Object.defineProperty(this, '_wrapped', {value: iterableWrapper});
  Object.defineProperty(this, 'yField', {value: yField});
  Object.defineProperty(this, 'enclosingEntity', {value: enclosingEntity});
  Object.defineProperty(this, 'linkName', {value: linkName});

  var def = function (obj, name) {
    var w = obj._wrapped;
    Object.defineProperty(obj, name, {
      value: function () {
        return new Iterator(w, yField);
      }
    });
  };
  def(this, 'entries');
  def(this, 'values');

  Object.defineProperty(this, 'size', {
    get: function () {
      return this._wrapped.size();
    }
  });

  this.toString = function () {
    var c = 0;
    var iter = this.entries();
    var next;
    var strings = [];
    var size = this.size;
    while (c++ < 100 && (next = iter.next()) && !next.done) {
      strings.push(next.value && next.value.toShortString ? next.value.toShortString() : next.value);
    }
    if (c === 100) {
      strings.push('the Set contains more than 100 elements. Iterate (e.g. using .forEach) to print the rest of the Set');
    }
    return '[' + strings.join(',\n') + ']';
  };
};
ImmutableIterableWW.prototype.forEach = function (visitor) {
  var iterator = this._wrapped.iterator();
  var index = 0;
  while (iterator.hasNext()) {
    visitor(wrap(iterator.next(), this.yField, this.enclosingEntity), index, this);
    index++;
  }
};
ImmutableIterableWW.prototype.first = function () {
  return wrap(this._wrapped.first(), this.yField, this.enclosingEntity);
};
ImmutableIterableWW.prototype.last = function () {
  return wrap(this._wrapped.last(), this.yField, this.enclosingEntity);
};
ImmutableIterableWW.prototype.isEmpty = function () {
  return this._wrapped.isEmpty();
};
ImmutableIterableWW.prototype.isNotEmpty = function () {
  return this._wrapped.isNotEmpty();
};
ImmutableIterableWW.prototype.get = function (index) {
  return wrap(this._wrapped.get(index), this.yField, this.enclosingEntity);
};
ImmutableIterableWW.prototype.has = function (element) {
  return this._wrapped.contains(unwrap(element, this.yField, this.enclosingEntity));
};
ImmutableIterableWW.prototype.find = function (visitor) {
  var iterator = this._wrapped.iterator();
  while (iterator.hasNext()) {
    var elem = iterator.next();
    var value =  wrap(elem, this.yField, this.enclosingEntity);
    var res = visitor(value);
    if (res) {
      return value;
    }
  }
};
ImmutableIterableWW.prototype['@@iterator'] = function () {
  return new Iterator(this._wrapped, this.yField);
};
Object.defineProperty(ImmutableIterableWW.prototype, "_canCheckHistory", {
  value: function () {
    if (!this.enclosingEntity) {
      throw 'Can not access field changes since this Set is not a member of an entity';
    }
  }
});
Object.defineProperty(ImmutableIterableWW.prototype, "isChanged", {
  get: function () {
    this._canCheckHistory();
    return this.enclosingEntity.isChanged(this.linkName || this.yField);
  },
  enumerable: true
});
Object.defineProperty(ImmutableIterableWW.prototype, "added", {
  get: function () {
    this._canCheckHistory();
    return this.enclosingEntity.getAdded(this.linkName || this.yField);
  },
  enumerable: true
});
Object.defineProperty(ImmutableIterableWW.prototype, "removed", {
  get: function () {
    this._canCheckHistory();
    return this.enclosingEntity.getRemoved(this.linkName || this.yField);
  },
  enumerable: true
});
Object.defineProperty(ImmutableIterableWW, "$type", {value: "Set"});

// ------ stuff required for KT -----------
var kt = null;
var getKotlin = function() {
  if (kt === null) {
    kt = require('kotlin').kotlin;
  }
  return kt;
};
var defineKtMetaData = function(target, simpleName, interfaceName) {
  Object.defineProperty(target, "$metadata$", {
    get: function() {
      return {
        kind: getKotlin().Kind_CLASS,
        simpleName: simpleName,
        interfaces: [getKotlin().collections[interfaceName]]
      };
    }
  });
};
defineKtMetaData(CanonicalIterator, 'EntitiesIterator', 'Iterator');
defineKtMetaData(ImmutableIterableWW, 'EntitiesIterable', 'Iterable');
Object.defineProperty(ImmutableIterableWW.prototype, "iterator", {
  value: function () {
    return new CanonicalIterator(this._wrapped, this.yField);
  }});
// ------ end of stuff required for KT ------

function createMutableIterableWW(obj, yField, enclosingEntity, linkName) {
  var ptt = new ImmutableIterableWW(obj, yField, enclosingEntity, linkName);
  var MutableIterableWW = function () {
    this.toString = ptt.toString;
  };
  MutableIterableWW.prototype = ptt;
  MutableIterableWW.prototype.add = function (element) {
    return this._wrapped.add(unwrap(element, yField));
  };
  MutableIterableWW.prototype.delete = function (element) {
    return this._wrapped.remove(unwrap(element, yField));
  };
  MutableIterableWW.prototype.clear = function () {
    return this._wrapped.clear();
  };
  return new MutableIterableWW();
}

var findYCustomField = function (name, project) {
  var cfs = $$fieldsAndLinksMeta.get(project._wrapped);
  var byLocalizedName = null;
  for (var i = 0; i < cfs.length; i ++) { // we want to look for the name first and then for localized name
    if (cfs[i].getName() === name) {
      return cfs[i];
    }
    if (cfs[i].getLocalizedName() === name) {
      byLocalizedName = cfs[i];
    }
  }
  return byLocalizedName
};

var findYIssueLink = function (name) {
  var links = $$fieldsAndLinksMeta.getLinks();
  for (var i = 0; i < links.length; i ++) {
      var link = links[i];
      if (link.getInward() === name || link.getOutward() === name) {
      return link;
    }
  }
};

var findField = function (typeName, fieldName, project) {
  var field = yTypes.getByName(typeName).findField(fieldName);
  if (field) {
    return field;
  }
  if (typeName === 'Issue') {
    var yCustomField = findYCustomField(fieldName, project);
    if (yCustomField) {
      return yCustomField;
    }
    var yIssueLink = findYIssueLink(fieldName);
    if (yIssueLink) {
      return yIssueLink;
    }
  }
  if (exports[typeName].$$declaredProperties.indexOf(fieldName) > -1) {
    return {getName: function () {
      return fieldName;
    }};
  }
  throw 'No field with name ' + fieldName + ' found for type ' + typeName;
};

var wrap = function (obj, yField, enclosingEntity, linkName) {
  var wrapped = obj;
  if (obj instanceof Packages.jetbrains.youtrack.scripts.wrappers.EnumReference) {
    wrapped = obj.getValue();
  } else if (obj instanceof Packages.jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper) {
    wrapped = new entities[obj.getEntityType()](obj);
  } else if (obj instanceof Packages.jetbrains.youtrack.scripts.wrappers.MutableIterableWrapper) {
    wrapped = createMutableIterableWW(obj, yField, enclosingEntity, linkName);
  } else if (obj instanceof Packages.jetbrains.youtrack.api.workflow.wrappers.WorkflowSequence) {
    wrapped = new ImmutableIterableWW(obj, yField, enclosingEntity, linkName);
  }
  return wrapped;
};

var isSprintsField = function (yField) {
  // TODO handle it in a more elegant way
  return yField && yField.getName && yField.getName() === 'sprints';
};

var unwrap = function(obj, yField) {
  var unwrapped = (!obj || !obj._wrapped) ? obj : obj._wrapped;
  if (isSprintsField(yField)) {
    return unwrapped;
  }
  if ((typeof unwrapped === 'string') && yField && (yField instanceof Packages.jetbrains.charisma.persistence.customfields.meta.YBundleCustomField)) {
    unwrapped = new Packages.jetbrains.youtrack.scripts.wrappers.EnumReference(unwrapped);
  }
  return unwrapped;
};

var entities = {};

var unwrapArguments = function (argsArray) {
  if (!Array.isArray(argsArray)) {
    argsArray = Array.prototype.slice.call(argsArray, 0);
  }
  var uw = function (arg) {
    if (Array.isArray(arg)) {
      return arg.map(uw);
    }
    return (!arg || !arg._wrapped) ? arg : arg._wrapped;
  };
  return argsArray.map(uw);
};

var getter = function (yField, name) {
  return function () {
    var result = safeCall(this._wrapped, 'get', [name ? name : yField.getName()], null);
    return wrap(result, yField, this.enclosingEntity || this, name);
  }
};

var setter = function (yField, name) {
  return function (value) {
    safeCall(this._wrapped, 'set', [name ? name : yField.getName(), unwrap(value, yField)], null);
  }
};

var method = function (name, propertyName) { // propertyName is only relevant for methods representing getters/setters
  return function () {
    return wrap(invoke(null, this._wrapped, name, unwrapArguments(arguments)), propertyName, this); // TODO remove first param
  }
};

var staticMethod = function (typeName, name) {
  return function () {
    return wrap(invokeStatic(null, typeName, name, unwrapArguments(arguments))); // TODO remove first param
  }
};

var defineFunctions = function(target, applyTo, functions, enumerable) {
  Object.keys(functions).forEach(function (key) {
    Object.defineProperty(target, key, {
      value: function () {
        return functions[key].apply(applyTo, arguments);
      },
      enumerable: enumerable
    });
  });
};

var constructor = function (name) {
  var type = function () {
    var argsArray = Array.prototype.slice.call(arguments, 0);
    var _w;
    if (argsArray.length == 1 && argsArray[0] instanceof Packages.jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper) {
      _w = argsArray[0];
    } else {
      _w = invokeConstructor(null, name, unwrapArguments(argsArray));
    }
    Object.defineProperty(this, '_wrapped', {value: _w});

    if (name === 'Issue') {
      var cfs = $$fieldsAndLinksMeta.get(this.project._wrapped);
      var flds = this.fields = {};
      Object.defineProperty(this.fields, '_wrapped', {value: this._wrapped});
      Object.defineProperty(this.fields, 'enclosingEntity', {value: this});
      var toStr = function () {
        return '{' + Object.keys(flds).map(function (fld) {
            return '"' + fld + '": ' + flds[fld];
          }).join(',\n') + '}';
      };
      Object.defineProperty(this.fields, 'toString', {value: toStr});
      Object.defineProperty(this.fields, 'toShortString', {value: toStr});
      for (var i = 0; i < cfs.length; i ++) {
        var cf = cfs[i];
        handleField(this, cf, cf.getName(), false);
        handleField(this.fields, cf, cf.getName(), true);
      }
      if ($$declareLinks !== null) {
        var lnks = this.links = {};
        Object.defineProperty(this.links, '_wrapped', {value: this._wrapped});
        Object.defineProperty(this.links, 'enclosingEntity', {value: this});
        Object.defineProperty(this.links, 'toString', {value: function () {
          return '{' + Object.keys(lnks).map(function (lnk) {
            return '"' + lnk + '": ' + lnks[lnk];
          }).join(',\n') + '}';
        }});
        var linksMeta = $$fieldsAndLinksMeta.getLinks();
        for (var i = 0; i < linksMeta.length; i ++) {
          handleLink(this.links, linksMeta[i]);
        }
      }
    }
    var e = this;
    var fieldName = function (field) {
      if (!field) {
        throw "Invalid argument: " + field;
      }
      var ret = typeof field === 'string' ? field : field.name;
      if (!ret) {
        throw "Invalid argument: " + field;
      }
      return ret;
    };
    var entityFunctions = {
      required: function (field, message) {
        Packages.jetbrains.youtrack.workflow.model.Assertion.require(e._wrapped, fieldName(field), message);
      },
      becomes: function (field, expected) {
        return e._wrapped.becomes(fieldName(field), unwrap(expected, findField(name, fieldName(field), e.project)));
      },
      is: function (field, expected) {
        return e._wrapped.fieldEquals(fieldName(field), unwrap(expected, findField(name, fieldName(field), e.project)));
      },
      was: function (field, expected) {
        return e._wrapped.fieldWasEqual(fieldName(field), unwrap(expected, findField(name, fieldName(field), e.project)));
      },
      isChanged: function (field) {
        return e._wrapped.isChanged(fieldName(field));
      },
      oldValue: function (field) {
        return wrap(e._wrapped.getOldValue(fieldName(field)), findField(name, fieldName(field), e.project), e);
      },
      canBeReadBy: function (field, user) {
        return e._wrapped.canBeReadBy(fieldName(field), unwrap(user));
      },
      canBeWrittenBy: function (field, user) {
        return e._wrapped.canBeWrittenBy(fieldName(field), unwrap(user));
      }
    };
    Object.defineProperty(e, 'becomesRemoved', {
      get: function () {
        return e._wrapped.isRemoved();
      },
      enumerable: true
    });
    Object.defineProperty(e, 'isNew', {
      get: function () {
        return e._wrapped.isNew();
      },
      enumerable: true
    });
    Object.defineProperty(e, '$$type', {value: name, enumerable: true});
    Object.defineProperty(e, 'toString', {
      value: function () {
        var props = [];
        for (var prop in e) {
          var propValue = e[prop];
          if (typeof propValue === 'function') {
            props.push('"' + prop + '": function() {}');
          } else {
            props.push('"' + prop + '": "' + (propValue && propValue._wrapped && propValue.toShortString ? propValue.toShortString() : propValue) + '"');
          }
        }
        return '{' + props.join(',\n') + '}';
      }, enumerable: true
    });
    Object.defineProperty(e, 'toShortString', {
      value: function () {
        var ret = '{"$$type": " ' + name + '"';
        var identifyingProperty = identifyingProperties[name];
        if (identifyingProperty) {
          ret += ', "' + identifyingProperty + '": "' + e[identifyingProperty] + '"';
        } else if (e.name) {
          ret += ', "name": "' + e.name + '"';
        }
        return ret + '}';
      }, enumerable: true
    });
    defineFunctions(e, e, entityFunctions, true);
    var obsoleteEntityFunctions = { // these functions are obsolete since it's possible to call them on iterable wrappers
      getAdded: function (field) {
        return new ImmutableIterableWW(e._wrapped.added(fieldName(field)), findField(name, fieldName(field), e.project), e);
      },
      getRemoved: function (field) {
        return new ImmutableIterableWW(e._wrapped.removed(fieldName(field)), findField(name, fieldName(field), e.project), e);
      }
    };
    defineFunctions(e, e, obsoleteEntityFunctions, false);
    if (e.fields) {
      defineFunctions(e.fields, e, entityFunctions, true);
    }
  };
  Object.defineProperty(type, '$type', {value: name});
  return type;
};

var handleLink = function (target, yMember) {
  var defineLinkProperty = function (linksObject, yMember, name) {
    Object.defineProperty(linksObject, name, {
      enumerable: true,
      get: getter(yMember, name)
    });
  };
  defineLinkProperty(target, yMember, yMember.getOutward());
  if (yMember.getLocalizedOutward() && yMember.getLocalizedOutward() !== yMember.getOutward()) {
    defineLinkProperty(target, yMember, yMember.getLocalizedOutward());
  }
  if (yMember.getInward()) { // is directed
    defineLinkProperty(target, yMember, yMember.getInward());
    if (yMember.getLocalizedInward() && yMember.getLocalizedInward() !== yMember.getInward()) {
      defineLinkProperty(target, yMember, yMember.getLocalizedInward());
    }
  }
};

var handleField =  function (target, yMember, name, enumerable) {
  if (!enumerable && this.hasOwnProperty(name)) { // !enumerable means we're dealing with obsolete CF definition. E.g. issue.State
    return;
  }
  const readOnly = yMember.isReadOnly();
  Object.defineProperty(target, name, {
    enumerable: enumerable,
    get: getter(yMember, name),
    set: readOnly ? undefined : setter(yMember, name)
  });
  if (yMember instanceof Packages.jetbrains.charisma.persistence.customfields.meta.YCustomField) {
    // moreover, it's a custom field
    var localizedName = yMember.getLocalizedName();
    if (localizedName && localizedName !== name) {
      Object.defineProperty(target, localizedName, {
        enumerable: enumerable,
        get: getter(yMember, localizedName),
        set: setter(yMember, localizedName)
      });
    }
  }
};

var handleEnumElement = function(target, typeName, name) {
  Object.defineProperty(target, name, {
    enumerable: true,
    get: function () {
      return wrap(getEnumElement(null, typeName, name));
    }
  });
};

var handleStaticMethod = function (target, typeName, memberName) {
  Object.defineProperty(target, memberName, {
    enumerable: true,
    value: staticMethod(typeName, memberName)
  });
};

var handleMethod = function (target, typeName, memberName) {
  Object.defineProperty(target, memberName, {
    enumerable: true,
    value: method(memberName)
  });
};

var handleProperty = function (target, yMember, propertyDescription, yClass) {
  var methodType = yMember.getMethodType();
  var isStatic = methodType.name() === 'STATIC';
  var getterName = propertyDescription.getterName;
  var setterName = propertyDescription.setterName;
  var getter = isStatic ? staticMethod(yClass.getName(), getterName) : method(getterName, propertyDescription.propertyName);
  var setter = isStatic ? staticMethod(yClass.getName(), setterName) : method(setterName, propertyDescription.propertyName);
  Object.defineProperty(target, propertyDescription.propertyName, {
    enumerable: true,
    get: getter,
    set: yClass.findMethod(setterName, 1, methodType) ? setter : undefined
  });
};

var toPropertyDescription = function (yMember) {
  var propertyName = yMember.getPropertyName();
  if (propertyName) {
    return {
      getterName: yMember.getName(),
      setterName: yMember.getCompliantSetterName(),
      propertyName: propertyName
    };
  }
};

var handleClass = function (yClass) {
  var yName = yClass.getName();
  if (entities[yName]) {
    return;
  }
  var entityType = constructor(yName);
  var superYClass = yClass.getSuperClassForJs();
  var declaredProperties = [];
  if (superYClass) {
    var superYClassName = superYClass.getName();
    handleClass(superYClass);
    entityType.prototype = Object.create(entities[superYClassName].prototype);
    entityType.prototype.constructor = entities[superYClassName];
  }
  entities[yName] = entityType;

  var methodsToSkip = [];
  var staticMethodsToSkip = [];
  yClass.getDeclaredMembersArray().forEach(function (yMember) {
    if (!!yMember.isIgnoreInJs && yMember.isIgnoreInJs()) {
      return;
    }

    var memberName = yMember.getName();
    if (yMember instanceof Packages.jetbrains.charisma.persistence.customfields.meta.YEnumElement) {
      handleEnumElement(entityType, yName, memberName);
    } else if (yMember instanceof Packages.jetbrains.charisma.persistence.customfields.meta.YField) {
      handleField(entityType.prototype, yMember, memberName, true);
    } else if (yMember.getMethodType().name() === 'CONSTRUCTOR') {
      // do nothing
    } else {
      var isStatic = yMember.getMethodType().name() === 'STATIC';
      var skip = isStatic ? staticMethodsToSkip : methodsToSkip;
      if (skip.indexOf(memberName) > -1) {
        return;
      }
      var target = isStatic ? entityType : entityType.prototype;
      var propertyDescription = toPropertyDescription(yMember);
      if (propertyDescription) {
        // this means a property should be defined instead of a method
        handleProperty(target, yMember, propertyDescription, yClass);
        skip.push(propertyDescription.setterName);
        declaredProperties.push(propertyDescription.propertyName);
      } else {
        (isStatic ? handleStaticMethod : handleMethod)(target, yName, memberName)
      }
    }
  });
  Object.defineProperty(entityType, "$$declaredProperties", {value: declaredProperties});

  // ------ stuff required for KT -----------
  Object.defineProperty(entityType.prototype, "equals", {
    value: function(another) {
      return this._wrapped.equals((another || {})._wrapped);
    }
  });
  Object.defineProperty(entityType.prototype, "hashCode", {
    value: function() {
      return this._wrapped.hashCode();
    }
  });
  // ------ end of stuff required for KT ------
};
yTypes.get().forEach(handleClass);

// publish
Object.keys(entities).forEach(function (typeName) {
  exports[typeName] = entities[typeName];
});