(function() {
  var toString = function(obj) {
    if (!obj) {
      return '' + obj;
    }
    if (!obj.hasOwnProperty) {// it's true for java objects
      return '{native object}';
    }
    if (Array.isArray(obj)) {
      var stringsArray = obj.map(function (elem) {
        return toString(elem);
      }).join(', ');
      return '[' + stringsArray + ']';
    }
    if (obj.hasOwnProperty('toString')) {
      return obj.toString();
    }
    if (typeof obj === 'object') {
      var ret = '{';
      ret += Object.keys(obj).map(function (prop) {
        var element = obj[prop];
        var wrapWith = (element && typeof element === 'string') ? '"' : '';
        return '"' + prop + '": ' + wrapWith + toString(element) + wrapWith;
      }).join(', ');
      return ret + '}';
    }
    if (typeof obj === 'function') {
      return obj.name + '(){}';
    }
    return obj;
  };

  var cnl = {};
  ['trace', 'debug', 'info', 'warn', 'error', 'fatal', 'log'].forEach(function (level) {
    Object.defineProperty(cnl, level, {
      enumerable: true,
      value: function() {
        logger[level]([].slice.call(arguments).map(function (arg) {
          return toString(arg);
        }).join());
      }
    });
  });
  return cnl;
})();
