/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.main.PeriodicKt;
import jetbrains.charisma.persistent.multinode.MutinodeKt;
import jetbrains.youtrack.agile.persistence.AgileCache;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="agileCache")
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\n\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\b\u0018\u00010\u0006R\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u00060\u0014R\u00020\u00000\u00042\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u00060\u0014R\u00020\u00000\u00042\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u0000\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache;", "", "()V", "items", "", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "Ljetbrains/youtrack/agile/persistence/AgileCache$CacheItem;", "getAgilesWithoutCardSubtasks", "", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "project", "getDefaultSprint", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "agile", "getDefaultSprints", "", "getImplicitAgiles", "getProjectData", "getSyncPrototypes", "", "Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheItem;", "getTimePrototypes", "init", "", "initSecondary", "AgileCacheItem", "CacheItem", "youtrack-scrumboard"})
public final class AgileCache {
    private volatile Map<XdProject, CacheItem> items;

    public final void init() {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        boolean bl2 = false;
        HashMap items = hashMap;
        boolean bl3 = false;
        Sequence $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdAgile.Companion.all());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdAgile agile2 = (XdAgile)((Object)element$iv);
            boolean bl4 = false;
            XdCustomFieldPrototype timePrototype = agile2.getTimePrototype();
            XdCustomFieldPrototype syncPrototype = agile2.getSprintSyncField();
            XdSprint defaultSprint = this.getDefaultSprint(agile2);
            boolean isExplicit2 = agile2.isExplicit();
            boolean hideSubtasksOfCards = agile2.getHideSubtasksOfCards();
            if (defaultSprint == null && timePrototype == null && syncPrototype == null && isExplicit2 && !hideSubtasksOfCards) continue;
            Sequence $this$forEach$iv2 = XdQueryKt.asSequence((XdQuery)((XdQuery)agile2.getProjects()));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                XdProject it = (XdProject)element$iv2;
                boolean bl5 = false;
                Map $this$getOrPut$iv = items;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl6 = false;
                    CacheItem answer$iv = new CacheItem();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                CacheItem item = (CacheItem)object;
                if (!isExplicit2) {
                    item.getImplicitAgiles().add(agile2);
                }
                if (hideSubtasksOfCards) {
                    item.getNoCardSubtasksAgiles().add(agile2);
                }
                if (defaultSprint != null && !defaultSprint.getArchived()) {
                    item.getDefaultSprints().add(defaultSprint);
                }
                if (timePrototype != null) {
                    item.putTimePrototype(timePrototype.getId(), timePrototype, agile2);
                }
                if (syncPrototype == null) continue;
                item.putSyncPrototype(syncPrototype.getId(), syncPrototype, agile2);
            }
        }
        this.items = items;
    }

    public final void initSecondary() {
        if (MutinodeKt.isSecondary()) {
            PeriodicKt.periodicFor((Object)this, (int)30, (Function1)initSecondary.1.INSTANCE);
        }
    }

    @NotNull
    public final List<XdSprint> getDefaultSprints(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        CacheItem cacheItem = this.getProjectData(project2);
        if (cacheItem == null) {
            return CollectionsKt.emptyList();
        }
        CacheItem result2 = cacheItem;
        return result2.getDefaultSprints();
    }

    @NotNull
    public final Map<String, AgileCacheItem> getTimePrototypes(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        CacheItem cacheItem = this.getProjectData(project2);
        if (cacheItem == null) {
            return MapsKt.emptyMap();
        }
        CacheItem result2 = cacheItem;
        return result2.getTimePrototypes();
    }

    @NotNull
    public final Map<String, AgileCacheItem> getSyncPrototypes(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        CacheItem cacheItem = this.getProjectData(project2);
        if (cacheItem == null) {
            return MapsKt.emptyMap();
        }
        CacheItem result2 = cacheItem;
        return result2.getSyncPrototypes();
    }

    private final CacheItem getProjectData(XdProject project2) throws IllegalStateException {
        Map<XdProject, CacheItem> map = this.items;
        if (map == null) {
            throw (Throwable)new IllegalStateException("Cache not initialized");
        }
        Map<XdProject, CacheItem> d = map;
        return d.get(project2);
    }

    @NotNull
    public final Set<XdAgile> getImplicitAgiles(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        CacheItem cacheItem = this.getProjectData(project2);
        if (cacheItem == null) {
            return SetsKt.emptySet();
        }
        CacheItem data = cacheItem;
        return data.getImplicitAgiles();
    }

    @NotNull
    public final Set<XdAgile> getAgilesWithoutCardSubtasks(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        CacheItem cacheItem = this.getProjectData(project2);
        if (cacheItem == null) {
            return SetsKt.emptySet();
        }
        CacheItem data = cacheItem;
        return data.getNoCardSubtasksAgiles();
    }

    private final XdSprint getDefaultSprint(XdAgile agile2) {
        XdSprint xdSprint = agile2.getDefaultSprint();
        if (xdSprint != null) {
            XdSprint xdSprint2 = xdSprint;
            boolean bl = false;
            boolean bl2 = false;
            XdSprint it = xdSprint2;
            boolean bl3 = false;
            return it;
        }
        if (agile2.getDisableSprints() && agile2.getAddNewIssueToKanban()) {
            return (XdSprint)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)agile2.getSprints()), (Function2)getDefaultSprint.2.INSTANCE));
        }
        return null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nJ\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR5\u0010\u000f\u001a&\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00130\u0010j\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R5\u0010\u0017\u001a&\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00130\u0010j\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache$CacheItem;", "", "(Ljetbrains/youtrack/agile/persistence/AgileCache;)V", "defaultSprints", "Ljava/util/ArrayList;", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "getDefaultSprints", "()Ljava/util/ArrayList;", "implicitAgiles", "Ljava/util/HashSet;", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "getImplicitAgiles", "()Ljava/util/HashSet;", "noCardSubtasksAgiles", "getNoCardSubtasksAgiles", "syncPrototypes", "Ljava/util/HashMap;", "", "Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheItem;", "Ljetbrains/youtrack/agile/persistence/AgileCache;", "Lkotlin/collections/HashMap;", "getSyncPrototypes", "()Ljava/util/HashMap;", "timePrototypes", "getTimePrototypes", "putSyncPrototype", "", "id", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "agile", "putTimePrototype", "youtrack-scrumboard"})
    private final class CacheItem {
        @NotNull
        private final ArrayList<XdSprint> defaultSprints = new ArrayList(10);
        @NotNull
        private final HashMap<String, AgileCacheItem> timePrototypes = new HashMap();
        @NotNull
        private final HashMap<String, AgileCacheItem> syncPrototypes = new HashMap();
        @NotNull
        private final HashSet<XdAgile> implicitAgiles = new HashSet();
        @NotNull
        private final HashSet<XdAgile> noCardSubtasksAgiles = new HashSet();

        @NotNull
        public final ArrayList<XdSprint> getDefaultSprints() {
            return this.defaultSprints;
        }

        @NotNull
        public final HashMap<String, AgileCacheItem> getTimePrototypes() {
            return this.timePrototypes;
        }

        @NotNull
        public final HashMap<String, AgileCacheItem> getSyncPrototypes() {
            return this.syncPrototypes;
        }

        @NotNull
        public final HashSet<XdAgile> getImplicitAgiles() {
            return this.implicitAgiles;
        }

        @NotNull
        public final HashSet<XdAgile> getNoCardSubtasksAgiles() {
            return this.noCardSubtasksAgiles;
        }

        public final void putTimePrototype(@NotNull String id, @NotNull XdCustomFieldPrototype prototype, @NotNull XdAgile agile2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
            Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
            Map $this$getOrPut$iv = this.timePrototypes;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(id);
            if (value$iv == null) {
                boolean bl = false;
                AgileCacheItem answer$iv = new AgileCacheItem(prototype);
                $this$getOrPut$iv.put(id, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((AgileCacheItem)object).getAgiles().add(agile2);
        }

        public final void putSyncPrototype(@NotNull String id, @NotNull XdCustomFieldPrototype prototype, @NotNull XdAgile agile2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
            Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
            Map $this$getOrPut$iv = this.syncPrototypes;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(id);
            if (value$iv == null) {
                boolean bl = false;
                AgileCacheItem answer$iv = new AgileCacheItem(prototype);
                $this$getOrPut$iv.put(id, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((AgileCacheItem)object).getAgiles().add(agile2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheItem;", "", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "(Ljetbrains/youtrack/agile/persistence/AgileCache;Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;)V", "agiles", "Ljava/util/HashSet;", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "getAgiles", "()Ljava/util/HashSet;", "getPrototype", "()Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "youtrack-scrumboard"})
    public final class AgileCacheItem {
        @NotNull
        private final HashSet<XdAgile> agiles;
        @NotNull
        private final XdCustomFieldPrototype prototype;

        @NotNull
        public final HashSet<XdAgile> getAgiles() {
            return this.agiles;
        }

        @NotNull
        public final XdCustomFieldPrototype getPrototype() {
            return this.prototype;
        }

        public AgileCacheItem(XdCustomFieldPrototype prototype) {
            Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
            this.prototype = prototype;
            this.agiles = new HashSet();
        }
    }
}

