/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.youtrack.agile.persistence.AgileColumnsKt;
import jetbrains.youtrack.agile.persistence.AgileStatusKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumn;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.XdStateSortOrder;
import jetbrains.youtrack.agile.persistence.XdUserSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.XdUserSwimlaneSettingsKt;
import jetbrains.youtrack.agile.persistence.swimlane.SwimlaneSettingsLogic;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.agile.rest.BeansKt;
import jetbrains.youtrack.agile.sprint.cell.CellIssuesOrderKt;
import jetbrains.youtrack.agile.sprint.logic.SprintLogic;
import jetbrains.youtrack.api.workflow.StateMachineProvider;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.order.XdSortOrder;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.gaprest.exception.LocalizedForbiddenException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u001a\u0010\f\u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0014\u0010\u0016\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\t*\u00020\r2\u0006\u0010\u0018\u001a\u00020\r\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u001c\u0010\u001e\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u0012\u0010 \u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\"\u0010!\u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\n\u001a,\u0010!\u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010\u0003\u001a!\u0010$\u001a\u00020\t*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010&\u001a\u001c\u0010'\u001a\u00020\t*\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0001\u001a$\u0010)\u001a\u00020\t*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a.\u0010+\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010,\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006/"}, d2={"isSprintCard", "", "parent", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "filter", "Lkotlin/Function1;", "swimlaneSettingsLogic", "Ljetbrains/youtrack/agile/persistence/swimlane/SwimlaneSettingsLogic;", "addIssue", "", "Ljetbrains/youtrack/agile/persistence/XdAgileColumn;", "issue", "addIssueToRow", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "rowId", "", "assertCanAddIssue", "constrainsValidationException", "Ljetbrains/exodus/database/exceptions/ConstraintsValidationException;", "Lkotlinx/dnq/XdEntity;", "message", "", "containsIssue", "copySortOrder", "target", "getMakeOrphanMessage", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "isCollapsed", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "isSwimlaneHidden", "swimlaneId", "makeOrphan", "moveIssue", "column", "prevIssue", "moveSwimlane", "prevSwimlaneId", "(Ljetbrains/youtrack/agile/persistence/XdSprint;JLjava/lang/Long;)V", "setCollapsed", "collapsed", "setSwimlaneHidden", "hidden", "shouldSkipAsCardSubtask", "shouldSkipAsCardSubtaskForParent", "sprintLogic", "Ljetbrains/youtrack/agile/sprint/logic/SprintLogic;", "youtrack-scrumboard"})
public final class BoardUtilKt {
    public static final void moveSwimlane(@NotNull XdSprint $this$moveSwimlane, long swimlaneId, @Nullable Long prevSwimlaneId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$moveSwimlane), (String)"$this$moveSwimlane");
        XdSortOrder xdSortOrder = $this$moveSwimlane.getSwimlanesSortOrder$youtrack_scrumboard();
        Object object = $this$moveSwimlane.getAgile().getSwimlaneSettings();
        if (object == null || (object = object.getSortedSwimlaneIds($this$moveSwimlane)) == null) {
            object = CollectionsKt.emptyList();
        }
        xdSortOrder.move(swimlaneId, prevSwimlaneId, (Iterable)object, false);
    }

    public static final void addIssueToRow(@NotNull XdSprint $this$addIssueToRow, @NotNull XdIssue issue2, long rowId) {
        long currentRowId;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$addIssueToRow), (String)"$this$addIssueToRow");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Object object = $this$addIssueToRow.getAgile().getSwimlaneSettings();
        long l = object != null && (object = object.getSettingsLogic()) != null ? object.getSwimlaneId(issue2, $this$addIssueToRow) : (currentRowId = XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID());
        if (currentRowId == rowId) {
            return;
        }
        if (rowId == XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID()) {
            String message = BoardUtilKt.getMakeOrphanMessage($this$addIssueToRow.getAgile(), issue2);
            if (message != null) {
                throw (Throwable)new BadRequestException(message);
            }
            BoardUtilKt.makeOrphan($this$addIssueToRow, issue2);
            return;
        }
        if (!$this$addIssueToRow.getAgile().getShowSwimlanes()) {
            throw (Throwable)new LocalizedBadRequestException("BoardUtil.No_Swimlanes", new Object[0]);
        }
        XdSwimlaneSettings xdSwimlaneSettings = $this$addIssueToRow.getAgile().getSwimlaneSettings();
        if (xdSwimlaneSettings == null) {
            Intrinsics.throwNpe();
        }
        xdSwimlaneSettings.getSettingsLogic().addIssueToSwimlane(issue2, rowId);
    }

    public static final void moveIssue(@NotNull XdSprint $this$moveIssue, @NotNull XdIssue issue2, long swimlaneId, @NotNull XdAgileColumn column2, @Nullable XdIssue prevIssue) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$moveIssue), (String)"$this$moveIssue");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)column2), (String)"column");
        BoardUtilKt.moveIssue($this$moveIssue, issue2, swimlaneId, column2);
        XdStateSortOrder sortOrder = $this$moveIssue.getSortOrder(column2, swimlaneId);
        if (sortOrder == null) {
            sortOrder = (XdStateSortOrder)XdStateSortOrder.Companion.new((Function1)new Function1<XdStateSortOrder, Unit>($this$moveIssue, swimlaneId, column2){
                final /* synthetic */ XdSprint $this_moveIssue;
                final /* synthetic */ long $swimlaneId;
                final /* synthetic */ XdAgileColumn $column;

                public final void invoke(@NotNull XdStateSortOrder $this$new) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                    $this$new.setSwimlaneId(this.$swimlaneId);
                    $this$new.setState(this.$column);
                    $this$new.setSprint(this.$this_moveIssue);
                }
                {
                    this.$this_moveIssue = xdSprint;
                    this.$swimlaneId = l;
                    this.$column = xdAgileColumn;
                    super(1);
                }
            });
        }
        sortOrder.moveIssue(issue2, prevIssue);
    }

    /*
     * WARNING - void declaration
     */
    public static final void moveIssue(@NotNull XdSprint $this$moveIssue, @NotNull XdIssue issue2, long swimlaneId, @NotNull XdAgileColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$moveIssue), (String)"$this$moveIssue");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)column2), (String)"column");
        if (AgileStatusKt.getInvalid($this$moveIssue.getAgile())) {
            throw (Throwable)new LogicException("Agile is invalid.");
        }
        BoardUtilKt.addIssueToRow($this$moveIssue, issue2, swimlaneId);
        if (!BoardUtilKt.containsIssue(column2, issue2)) {
            XdCustomFieldPrototype xdCustomFieldPrototype = $this$moveIssue.getAgile().getStatePrototype();
            if (xdCustomFieldPrototype == null) {
                Intrinsics.throwNpe();
            }
            Entity columnFieldEntity = xdCustomFieldPrototype.getEntity();
            AgileColumnsKt.assertCanMoveIssue(column2, issue2);
            BoardUtilKt.assertCanAddIssue(column2, issue2);
            if (CellIssuesOrderKt.getStateMachineProvider().hasStateMachine(issue2.getProject().getEntity(), columnFieldEntity)) {
                Collection<Entity> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable<XdField> iterable2 = column2.getValuesForIssueProject(issue2);
                Entity entity2 = columnFieldEntity;
                Entity entity3 = issue2.getEntity();
                StateMachineProvider stateMachineProvider = CellIssuesOrderKt.getStateMachineProvider();
                boolean $i$f$map = false;
                void var8_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    XdField xdField = (XdField)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Entity entity4 = it.getEntity();
                    collection.add(entity4);
                }
                collection = (List)destination$iv$iv;
                stateMachineProvider.setValueWithStateMachine(entity3, entity2, (Iterable)collection);
            } else {
                BoardUtilKt.addIssue(column2, issue2);
            }
        }
    }

    private static final void assertCanAddIssue(@NotNull XdAgileColumn $this$assertCanAddIssue, XdIssue issue2) {
        XdCustomFieldPrototype xdCustomFieldPrototype = $this$assertCanAddIssue.getAgile().getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        XdCustomFieldPrototype stateField = xdCustomFieldPrototype;
        XdProjectCustomField xdProjectCustomField = stateField.getProjectCustomField(issue2.getProject());
        if (xdProjectCustomField == null) {
            throw (Throwable)new LocalizedForbiddenException("BoardUtil.No_column_field_in_project", new Object[0]);
        }
        XdProjectCustomField projectField = xdProjectCustomField;
        if (!XdProjectCustomField.isAccessibleInIssue$default((XdProjectCustomField)projectField, (Operation)Operation.UPDATE, (XdIssue)issue2, null, (int)4, null)) {
            throw (Throwable)new LocalizedForbiddenException("BoardUtil.Cant_edit_column", new Object[]{issue2.getIdReadable()});
        }
    }

    private static final boolean containsIssue(@NotNull XdAgileColumn $this$containsIssue, XdIssue issue2) {
        Iterable<XdField> iterable2 = $this$containsIssue.getValuesForIssueProject(issue2);
        XdCustomFieldPrototype xdCustomFieldPrototype = $this$containsIssue.getAgile().getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        return CollectionsKt.contains(iterable2, (Object)xdCustomFieldPrototype.getValue(issue2));
    }

    public static final void addIssue(@NotNull XdAgileColumn $this$addIssue, @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$addIssue), (String)"$this$addIssue");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdField value2 = (XdField)CollectionsKt.firstOrNull($this$addIssue.getValuesForIssueProject(issue2));
        XdCustomFieldPrototype xdCustomFieldPrototype = $this$addIssue.getAgile().getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        xdCustomFieldPrototype.setValue(issue2, (Object)value2);
    }

    public static final void setCollapsed(@NotNull XdAgileColumn $this$setCollapsed, @NotNull XdUser user, boolean collapsed2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$setCollapsed), (String)"$this$setCollapsed");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        BeansKt.getAgileProfileService().getProfile(user).setCollapsedColumn($this$setCollapsed, collapsed2);
    }

    public static /* synthetic */ void setCollapsed$default(XdAgileColumn xdAgileColumn, XdUser xdUser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        BoardUtilKt.setCollapsed(xdAgileColumn, xdUser, bl);
    }

    public static final boolean isCollapsed(@NotNull XdAgileColumn $this$isCollapsed, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$isCollapsed), (String)"$this$isCollapsed");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return XdQueryKt.contains(BeansKt.getAgileProfileService().getProfile(user).getCollapsedColumns(), (XdEntity)$this$isCollapsed);
    }

    public static /* synthetic */ boolean isCollapsed$default(XdAgileColumn xdAgileColumn, XdUser xdUser, int n, Object object) {
        if ((n & 1) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return BoardUtilKt.isCollapsed(xdAgileColumn, xdUser);
    }

    public static final void makeOrphan(@NotNull XdSprint $this$makeOrphan, @NotNull XdIssue issue2) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)$this$makeOrphan), (String)"$this$makeOrphan");
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            if (!$this$makeOrphan.getAgile().getShowSwimlanes()) {
                return;
            }
            Object object = $this$makeOrphan.getAgile().getSwimlaneSettings();
            if (object == null || (object = object.getSettingsLogic()) == null) break block1;
            object.makeOrphan($this$makeOrphan, issue2);
        }
    }

    @Nullable
    public static final String getMakeOrphanMessage(@NotNull XdAgile $this$getMakeOrphanMessage, @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$getMakeOrphanMessage), (String)"$this$getMakeOrphanMessage");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        if (!$this$getMakeOrphanMessage.getShowSwimlanes()) {
            return null;
        }
        Object object = $this$getMakeOrphanMessage.getSwimlaneSettings();
        return object != null && (object = object.getSettingsLogic()) != null ? object.getMakeOrphanMessage(issue2) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSwimlaneHidden(@NotNull XdSprint $this$isSwimlaneHidden, long swimlaneId, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$isSwimlaneHidden), (String)"$this$isSwimlaneHidden");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        XdUserSwimlaneSettings xdUserSwimlaneSettings = XdUserSwimlaneSettingsKt.findSwimlaneSettings($this$isSwimlaneHidden, user);
        if (xdUserSwimlaneSettings == null) return false;
        XdUserSwimlaneSettings settings2 = xdUserSwimlaneSettings;
        if (swimlaneId == XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID()) {
            if (!settings2.getOrphansCollapsed()) return false;
            XdSwimlaneSettings xdSwimlaneSettings = $this$isSwimlaneHidden.getAgile().getSwimlaneSettings();
            if (xdSwimlaneSettings == null) return false;
            boolean bl = xdSwimlaneSettings.getEnabled();
            if (!bl) return false;
            return true;
        }
        boolean bl = settings2.isSwimlaneHidden(swimlaneId);
        return bl;
    }

    public static /* synthetic */ boolean isSwimlaneHidden$default(XdSprint xdSprint, long l, XdUser xdUser, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return BoardUtilKt.isSwimlaneHidden(xdSprint, l, xdUser);
    }

    public static final void setSwimlaneHidden(@NotNull XdSprint $this$setSwimlaneHidden, long swimlaneId, boolean hidden, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$setSwimlaneHidden), (String)"$this$setSwimlaneHidden");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        XdUserSwimlaneSettings settings2 = XdUserSwimlaneSettingsKt.findOrNewSwimlaneSettings($this$setSwimlaneHidden, user);
        if (swimlaneId == XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID()) {
            settings2.setOrphansCollapsed(hidden);
        } else {
            settings2.setSwimlaneHidden(swimlaneId, hidden);
        }
    }

    public static /* synthetic */ void setSwimlaneHidden$default(XdSprint xdSprint, long l, boolean bl, XdUser xdUser, int n, Object object) {
        if ((n & 4) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        BoardUtilKt.setSwimlaneHidden(xdSprint, l, bl, xdUser);
    }

    /*
     * WARNING - void declaration
     */
    public static final void copySortOrder(@NotNull XdSprint $this$copySortOrder, @NotNull XdSprint target) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$copySortOrder), (String)"$this$copySortOrder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)target), (String)"target");
        target.getSwimlanesSortOrder$youtrack_scrumboard().copyOrderFrom($this$copySortOrder.getSwimlanesSortOrder$youtrack_scrumboard());
        Iterable $this$filter$iv = HelpersKt.asIterable((XdQuery)((XdQuery)$this$copySortOrder.getAgile().getColumnSettings()));
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XdAgileColumn it = (XdAgileColumn)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!it.isResolved())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unresolvedColumns = (List)destination$iv$iv;
        Iterable $this$forEach$iv = HelpersKt.asIterable((XdQuery)((XdQuery)$this$copySortOrder.getSortOrders()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdStateSortOrder it = (XdStateSortOrder)((Object)element$iv);
            boolean bl = false;
            if (!unresolvedColumns.contains((Object)it.getState())) continue;
            it.cloneTo(target);
        }
    }

    public static final boolean shouldSkipAsCardSubtask(@NotNull XdSprint $this$shouldSkipAsCardSubtask, @NotNull XdIssue issue2, @NotNull Function1<? super XdIssue, Boolean> filter2, @NotNull SwimlaneSettingsLogic swimlaneSettingsLogic) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$shouldSkipAsCardSubtask), (String)"$this$shouldSkipAsCardSubtask");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)swimlaneSettingsLogic, (String)"swimlaneSettingsLogic");
        if (!$this$shouldSkipAsCardSubtask.getAgile().getHideSubtasksOfCards()) {
            return false;
        }
        XdIssue parent2 = issue2.getParent();
        return BoardUtilKt.isSprintCard(parent2, filter2, swimlaneSettingsLogic);
    }

    public static final boolean shouldSkipAsCardSubtaskForParent(@NotNull XdSprint $this$shouldSkipAsCardSubtaskForParent, @NotNull XdIssue parent2, @NotNull SprintLogic sprintLogic, @NotNull SwimlaneSettingsLogic swimlaneSettingsLogic) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$shouldSkipAsCardSubtaskForParent), (String)"$this$shouldSkipAsCardSubtaskForParent");
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)sprintLogic, (String)"sprintLogic");
        Intrinsics.checkParameterIsNotNull((Object)swimlaneSettingsLogic, (String)"swimlaneSettingsLogic");
        if (!$this$shouldSkipAsCardSubtaskForParent.getAgile().getHideSubtasksOfCards()) {
            return false;
        }
        return BoardUtilKt.isSprintCard(parent2, (Function1<? super XdIssue, Boolean>)((Function1)new Function1<XdIssue, Boolean>($this$shouldSkipAsCardSubtaskForParent, sprintLogic){
            final /* synthetic */ XdSprint $this_shouldSkipAsCardSubtaskForParent;
            final /* synthetic */ SprintLogic $sprintLogic;

            public final boolean invoke(@NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SprintLogic.DefaultImpls.matchesIssue$default(this.$sprintLogic, this.$this_shouldSkipAsCardSubtaskForParent, it, null, 4, null);
            }
            {
                this.$this_shouldSkipAsCardSubtaskForParent = xdSprint;
                this.$sprintLogic = sprintLogic;
                super(1);
            }
        }), swimlaneSettingsLogic);
    }

    @NotNull
    public static final ConstraintsValidationException constrainsValidationException(@NotNull XdEntity $this$constrainsValidationException, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)$this$constrainsValidationException, (String)"$this$constrainsValidationException");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message, $this$constrainsValidationException.getEntity()));
    }

    private static final boolean isSprintCard(XdIssue parent2, Function1<? super XdIssue, Boolean> filter2, SwimlaneSettingsLogic swimlaneSettingsLogic) {
        return parent2 != null && (Boolean)filter2.invoke((Object)parent2) != false && !swimlaneSettingsLogic.isSwimlane(parent2);
    }
}

