/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence;

import java.util.List;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.agile.Localization;
import jetbrains.youtrack.agile.persistence.BoardUtilKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumn;
import jetbrains.youtrack.agile.persistence.XdSprint$Companion$compositeIndices$1;
import jetbrains.youtrack.agile.persistence.XdSprint$Companion$compositeIndices$2;
import jetbrains.youtrack.agile.persistence.XdSprint$agile$2;
import jetbrains.youtrack.agile.persistence.XdSprint$beforeFlush$1;
import jetbrains.youtrack.agile.persistence.XdSprint$getSortOrder$1;
import jetbrains.youtrack.agile.persistence.XdSprint$getSortOrder$2;
import jetbrains.youtrack.agile.persistence.XdSprint$issues$2;
import jetbrains.youtrack.agile.persistence.XdSprint$sortOrders$2;
import jetbrains.youtrack.agile.persistence.XdSprint$swimlaneSettings$2;
import jetbrains.youtrack.agile.persistence.XdSprintKt;
import jetbrains.youtrack.agile.persistence.XdStateSortOrder;
import jetbrains.youtrack.agile.persistence.XdUserSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.core.annotations.Access;
import jetbrains.youtrack.core.annotations.ApiClass;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiJsIgnore;
import jetbrains.youtrack.core.annotations.ApiKtIgnore;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiMpsType;
import jetbrains.youtrack.core.annotations.ApiMpsTypes;
import jetbrains.youtrack.core.annotations.ApiProperty;
import jetbrains.youtrack.core.annotations.ApiPropertyAccess;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.dates.DateMathKt;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.order.XdSortOrder;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdNaturalEntityType;
import kotlinx.dnq.link.OnDeletePolicy;
import kotlinx.dnq.link.XdManyChildrenToParentLink;
import kotlinx.dnq.link.XdManyToManyLink;
import kotlinx.dnq.link.XdParentToManyChildrenLink;
import kotlinx.dnq.link.XdToOneRequiredLink;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.simple.XdMutableConstrainedProperty;
import kotlinx.dnq.simple.XdNullableProperty;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.store.container.StoreContainer;
import kotlinx.dnq.util.ReflectionUtilKt;
import kotlinx.dnq.util.XdPropertyCachedProvider;
import mu.KLoggable;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@ApiClass
@ApiDoc(value="Represents a sprint that is associated with an agile board. Each sprint can include issues from one or more projects.")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 b2\u00020\u0001:\u0001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010R\u001a\u00020SH\u0016J\u001f\u0010T\u001a\u0004\u0018\u00010;2\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010XJ\u0018\u0010Y\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020[2\b\b\u0002\u0010\\\u001a\u00020]J\u0012\u0010^\u001a\u00020\u00102\b\b\u0001\u0010_\u001a\u00020-H\u0007J\u001f\u0010`\u001a\u00020S2\b\u0010A\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010aR1\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u000e\u0010\u000f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR1\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0017\u0010\u0018\u0012\u0004\b\u0012\u0010\t\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R5\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u00198F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b \u0010!\u0012\u0004\b\u001b\u0010\t\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR/\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u0005\u001a\u0004\u0018\u00010\"8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010*\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0014R!\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R+\u00102\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\"8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b5\u0010)\u001a\u0004\b3\u0010%\"\u0004\b4\u0010'R+\u00106\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b9\u0010\u0018\u001a\u0004\b7\u0010\u0014\"\u0004\b8\u0010\u0016R!\u0010:\u001a\b\u0012\u0004\u0012\u00020;0,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b<\u0010/R\u0011\u0010?\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010%R5\u0010A\u001a\u0004\u0018\u00010\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u00198F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bE\u0010!\u0012\u0004\bB\u0010\t\u001a\u0004\bC\u0010\u001d\"\u0004\bD\u0010\u001fR!\u0010F\u001a\b\u0012\u0004\u0012\u00020G0,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010>\u001a\u0004\bH\u0010/R+\u0010K\u001a\u00020J2\u0006\u0010\u0005\u001a\u00020J8@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006c"}, d2={"Ljetbrains/youtrack/agile/persistence/XdSprint;", "Lkotlinx/dnq/XdEntity;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "agile", "agile$annotations", "()V", "getAgile", "()Ljetbrains/youtrack/agile/persistence/XdAgile;", "setAgile", "(Ljetbrains/youtrack/agile/persistence/XdAgile;)V", "agile$delegate", "Lkotlinx/dnq/link/XdManyChildrenToParentLink;", "", "archived", "archived$annotations", "getArchived", "()Z", "setArchived", "(Z)V", "archived$delegate", "Lkotlinx/dnq/simple/XdProperty;", "", "finish", "finish$annotations", "getFinish", "()Ljava/lang/Long;", "setFinish", "(Ljava/lang/Long;)V", "finish$delegate", "Lkotlinx/dnq/simple/XdNullableProperty;", "", "goal", "getGoal", "()Ljava/lang/String;", "setGoal", "(Ljava/lang/String;)V", "goal$delegate", "Lkotlinx/dnq/simple/XdMutableConstrainedProperty;", "isUnscheduled", "issues", "Lkotlinx/dnq/query/XdMutableQuery;", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getIssues", "()Lkotlinx/dnq/query/XdMutableQuery;", "issues$delegate", "Lkotlinx/dnq/link/XdManyToManyLink;", "name", "getName", "setName", "name$delegate", "obsolete", "getObsolete", "setObsolete", "obsolete$delegate", "sortOrders", "Ljetbrains/youtrack/agile/persistence/XdStateSortOrder;", "getSortOrders", "sortOrders$delegate", "Lkotlinx/dnq/link/XdParentToManyChildrenLink;", "sprintId", "getSprintId", "start", "start$annotations", "getStart", "setStart", "start$delegate", "swimlaneSettings", "Ljetbrains/youtrack/agile/persistence/XdUserSwimlaneSettings;", "getSwimlaneSettings", "swimlaneSettings$delegate", "Ljetbrains/youtrack/core/persistent/order/XdSortOrder;", "swimlanesSortOrder", "getSwimlanesSortOrder$youtrack_scrumboard", "()Ljetbrains/youtrack/core/persistent/order/XdSortOrder;", "setSwimlanesSortOrder$youtrack_scrumboard", "(Ljetbrains/youtrack/core/persistent/order/XdSortOrder;)V", "swimlanesSortOrder$delegate", "Lkotlinx/dnq/link/XdToOneRequiredLink;", "beforeFlush", "", "getSortOrder", "column", "Ljetbrains/youtrack/agile/persistence/XdAgileColumn;", "swimlaneId", "(Ljetbrains/youtrack/agile/persistence/XdAgileColumn;Ljava/lang/Long;)Ljetbrains/youtrack/agile/persistence/XdStateSortOrder;", "isAccessible", "operation", "Ljetbrains/youtrack/core/security/Operation;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "isSwimlane", "issue", "setInterval", "(Ljava/lang/Long;Ljava/lang/Long;)V", "Companion", "youtrack-scrumboard"})
public final class XdSprint
extends XdEntity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdManyChildrenToParentLink agile$delegate;
    @NotNull
    private final XdMutableConstrainedProperty name$delegate;
    @Nullable
    private final XdMutableConstrainedProperty goal$delegate;
    @Nullable
    private final XdNullableProperty start$delegate;
    @Nullable
    private final XdNullableProperty finish$delegate;
    @NotNull
    private final XdProperty archived$delegate;
    @NotNull
    private final XdProperty obsolete$delegate;
    @NotNull
    private final XdParentToManyChildrenLink swimlaneSettings$delegate;
    @NotNull
    private final XdToOneRequiredLink swimlanesSortOrder$delegate;
    @NotNull
    private final XdManyToManyLink issues$delegate;
    @NotNull
    private final XdParentToManyChildrenLink sortOrders$delegate;
    @NotNull
    private static final KLogger logger;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "agile", "getAgile()Ljetbrains/youtrack/agile/persistence/XdAgile;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "name", "getName()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "goal", "getGoal()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "start", "getStart()Ljava/lang/Long;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "finish", "getFinish()Ljava/lang/Long;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "archived", "getArchived()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "obsolete", "getObsolete()Z")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "swimlaneSettings", "getSwimlaneSettings()Lkotlinx/dnq/query/XdMutableQuery;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "swimlanesSortOrder", "getSwimlanesSortOrder$youtrack_scrumboard()Ljetbrains/youtrack/core/persistent/order/XdSortOrder;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "issues", "getIssues()Lkotlinx/dnq/query/XdMutableQuery;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdSprint.class), "sortOrders", "getSortOrders()Lkotlinx/dnq/query/XdMutableQuery;"))};
        Companion = new Companion(null);
        logger = Companion.logger();
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.R, scope=ApiScope.WORKFLOW)})
    @ApiDoc(value="The agile board that the sprint belongs to.")
    public static /* synthetic */ void agile$annotations() {
    }

    @NotNull
    public final XdAgile getAgile() {
        return (XdAgile)this.agile$delegate.getValue((XdEntity)this, $$delegatedProperties[0]);
    }

    public final void setAgile(@NotNull XdAgile xdAgile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdAgile), (String)"<set-?>");
        this.agile$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (XdEntity)xdAgile);
    }

    @NotNull
    public final String getName() {
        return (String)this.name$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.name$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    @Nullable
    public final String getGoal() {
        return (String)this.goal$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setGoal(@Nullable String string) {
        this.goal$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.R, scope=ApiScope.WORKFLOW)})
    @ApiMpsType(value=ApiMpsTypes.INSTANT)
    @ApiDoc(value="The start date of the sprint.")
    public static /* synthetic */ void start$annotations() {
    }

    @Nullable
    public final Long getStart() {
        return (Long)this.start$delegate.getValue((XdEntity)this, $$delegatedProperties[3]);
    }

    public final void setStart(@Nullable Long l) {
        this.start$delegate.setValue((XdEntity)this, $$delegatedProperties[3], (Comparable)l);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.R, scope=ApiScope.WORKFLOW)})
    @ApiMpsType(value=ApiMpsTypes.INSTANT)
    @ApiDoc(value="The end date of the sprint.")
    public static /* synthetic */ void finish$annotations() {
    }

    @Nullable
    public final Long getFinish() {
        return (Long)this.finish$delegate.getValue((XdEntity)this, $$delegatedProperties[4]);
    }

    public final void setFinish(@Nullable Long l) {
        this.finish$delegate.setValue((XdEntity)this, $$delegatedProperties[4], (Comparable)l);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.R, scope=ApiScope.WORKFLOW)})
    @ApiJsIgnore
    @ApiKtIgnore
    public static /* synthetic */ void archived$annotations() {
    }

    public final boolean getArchived() {
        return (Boolean)this.archived$delegate.getValue((XdEntity)this, $$delegatedProperties[5]);
    }

    public final void setArchived(boolean bl) {
        this.archived$delegate.setValue((XdEntity)this, $$delegatedProperties[5], (Comparable)Boolean.valueOf(bl));
    }

    public final boolean getObsolete() {
        return (Boolean)this.obsolete$delegate.getValue((XdEntity)this, $$delegatedProperties[6]);
    }

    public final void setObsolete(boolean bl) {
        this.obsolete$delegate.setValue((XdEntity)this, $$delegatedProperties[6], (Comparable)Boolean.valueOf(bl));
    }

    @NotNull
    public final XdMutableQuery<XdUserSwimlaneSettings> getSwimlaneSettings() {
        return this.swimlaneSettings$delegate.getValue((XdEntity)this, $$delegatedProperties[7]);
    }

    @NotNull
    public final XdSortOrder getSwimlanesSortOrder$youtrack_scrumboard() {
        return (XdSortOrder)this.swimlanesSortOrder$delegate.getValue((XdEntity)this, $$delegatedProperties[8]);
    }

    public final void setSwimlanesSortOrder$youtrack_scrumboard(@NotNull XdSortOrder xdSortOrder) {
        Intrinsics.checkParameterIsNotNull((Object)xdSortOrder, (String)"<set-?>");
        this.swimlanesSortOrder$delegate.setValue((XdEntity)this, $$delegatedProperties[8], (XdEntity)xdSortOrder);
    }

    @NotNull
    public final XdMutableQuery<XdIssue> getIssues() {
        return this.issues$delegate.getValue((XdEntity)this, $$delegatedProperties[9]);
    }

    @NotNull
    public final XdMutableQuery<XdStateSortOrder> getSortOrders() {
        return this.sortOrders$delegate.getValue((XdEntity)this, $$delegatedProperties[10]);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final XdStateSortOrder getSortOrder(@NotNull XdAgileColumn column2, @Nullable Long swimlaneId) {
        void value$iv;
        KProperty1 $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)column2), (String)"column");
        Long l = swimlaneId;
        long rowId = l != null ? l : 0L;
        KProperty1 kProperty1 = (KProperty1)XdSprint$getSortOrder$1.INSTANCE;
        XdQuery xdQuery = (XdQuery)this.getSortOrders();
        NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdStateSortOrder.class), (XdEntity)column2);
        $receiver$iv = (KProperty1)XdSprint$getSortOrder$2.INSTANCE;
        Comparable $i$f$eq = Long.valueOf(rowId);
        NodeBase nodeBase2 = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdStateSortOrder.class)), (Comparable)value$iv);
        return (XdStateSortOrder)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)NodeBaseOperationsKt.and((NodeBase)nodeBase, (NodeBase)nodeBase2)));
    }

    public void beforeFlush() {
        super.beforeFlush();
        if (ReflectionUtilKt.hasChanges((XdEntity)this, (KProperty1)((KProperty1)XdSprint$beforeFlush$1.INSTANCE)) && !XdSprintKt.isValidSprintName(this.getName())) {
            throw (Throwable)BoardUtilKt.constrainsValidationException(this, (String)Localization.INSTANCE.getRestrictedNameForSprint().invoke((Object)this.getName()));
        }
    }

    public final void setInterval(@Nullable Long start, @Nullable Long finish) {
        Long l;
        Long actualStart;
        Long l2;
        if (start != null && !DateMathKt.isDateStartInUTC((Long)start)) {
            Companion.getLogger().warn("Aligning start time, " + this.getSprintId() + " start time: " + start + " is not exact date start in UTC");
            long l3 = start;
            DateTimeZone dateTimeZone = DateTimeZone.UTC;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"DateTimeZone.UTC");
            l2 = DateMathKt.getDateStartInTimezone((long)l3, (DateTimeZone)dateTimeZone);
        } else {
            l2 = actualStart = start;
        }
        if (finish != null && !DateMathKt.isDateFinishInUTC((long)finish)) {
            Companion.getLogger().warn("Aligning finish time, " + this.getSprintId() + " finish time: " + finish + " is not exact date finish in UTC");
            long l4 = finish;
            DateTimeZone dateTimeZone = DateTimeZone.UTC;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"DateTimeZone.UTC");
            l = DateMathKt.getDateFinishInTimezone((long)l4, (DateTimeZone)dateTimeZone);
        } else {
            l = finish;
        }
        Long actualFinish = l;
        this.setStart(actualStart);
        this.setFinish(actualFinish);
    }

    public final boolean isAccessible(@NotNull Operation operation, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return this.getAgile().isAccessible(operation, user);
    }

    public static /* synthetic */ boolean isAccessible$default(XdSprint xdSprint, Operation operation, XdUser xdUser, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser = BeansKt.getXdLoggedInUser();
        }
        return xdSprint.isAccessible(operation, xdUser);
    }

    public final boolean isUnscheduled() {
        return this.getStart() == null && this.getFinish() == null;
    }

    @NotNull
    public final String getSprintId() {
        return this.getAgile().getName() + ':' + this.getName();
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Checks whether the specified issue is represented as a swimlane on the agile board that the sprint belongs to.")
    @ApiDocReturns(value="If the specified issue is represented as a swimlane in the sprint, returns `true`.")
    public final boolean isSwimlane(@ApiDoc(value="The issue to check.") @NotNull XdIssue issue2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return this.getAgile().getShowSwimlanes() && ((object = this.getAgile().getSwimlaneSettings()) != null && (object = ((XdSwimlaneSettings)((Object)object)).getSettingsLogic()) != null ? object.isSwimlane(issue2) : false);
    }

    /*
     * WARNING - void declaration
     */
    public XdSprint(@NotNull Entity entity2) {
        void onTargetDelete$iv;
        void onDelete$iv;
        void dbOppositePropertyName$iv;
        KProperty1 oppositeLink$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        super(entity2);
        KProperty1 kProperty1 = XdSprint$agile$2.INSTANCE;
        XdSprint xdSprint = this;
        String dbPropertyName$iv = null;
        XdPropertyCachedProvider xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdManyChildrenToParentLink<XdSprint, XdAgile>>(oppositeLink$iv, dbPropertyName$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                super(0);
            }

            @NotNull
            public final XdManyChildrenToParentLink<XdSprint, XdAgile> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdAgile.class));
                String string = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdManyChildrenToParentLink(xdEntityType2, kProperty1, string);
            }
        });
        xdSprint.agile$delegate = (XdManyChildrenToParentLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.name$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, (String)"versionName", null, null, (int)27, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this.goal$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdStringProp$default((boolean)false, null, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.start$delegate = (XdNullableProperty)PropertyDelegatesKt.xdNullableLongProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
        this.finish$delegate = (XdNullableProperty)PropertyDelegatesKt.xdNullableLongProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[4]);
        this.archived$delegate = (XdProperty)PropertyDelegatesKt.xdBooleanProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[5]);
        this.obsolete$delegate = (XdProperty)PropertyDelegatesKt.xdBooleanProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[6]);
        oppositeLink$iv = (KProperty1)XdSprint$swimlaneSettings$2.INSTANCE;
        xdSprint = this;
        dbPropertyName$iv = null;
        xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdParentToManyChildrenLink<XdSprint, XdUserSwimlaneSettings>>(oppositeLink$iv, dbPropertyName$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                super(0);
            }

            @NotNull
            public final XdParentToManyChildrenLink<XdSprint, XdUserSwimlaneSettings> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdUserSwimlaneSettings.class));
                boolean bl = false;
                String string = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdParentToManyChildrenLink(xdEntityType2, kProperty1, string, bl);
            }
        });
        xdSprint.swimlaneSettings$delegate = (XdParentToManyChildrenLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[7]);
        this.swimlanesSortOrder$delegate = (XdToOneRequiredLink)LinkDelegatesKt.xdLink1$default((XdEntityType)((XdEntityType)XdSortOrder.Companion), null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CASCADE.INSTANCE), null, (int)10, null).provideDelegate((XdEntity)this, $$delegatedProperties[8]);
        oppositeLink$iv = XdSprint$issues$2.INSTANCE;
        dbPropertyName$iv = "_issues";
        String $i$f$xdChildren0_N = "_sprints";
        OnDeletePolicy onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        OnDeletePolicy onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        xdSprint = this;
        xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdManyToManyLink<XdSprint, XdIssue>>(oppositeLink$iv, dbPropertyName$iv, (String)dbOppositePropertyName$iv, (OnDeletePolicy)onDelete$iv, (OnDeletePolicy)onTargetDelete$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            final /* synthetic */ String $dbOppositePropertyName;
            final /* synthetic */ OnDeletePolicy $onDelete;
            final /* synthetic */ OnDeletePolicy $onTargetDelete;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                this.$dbOppositePropertyName = string2;
                this.$onDelete = onDeletePolicy;
                this.$onTargetDelete = onDeletePolicy2;
                super(0);
            }

            @NotNull
            public final XdManyToManyLink<XdSprint, XdIssue> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdIssue.class));
                boolean bl = false;
                OnDeletePolicy onDeletePolicy = this.$onTargetDelete;
                OnDeletePolicy onDeletePolicy2 = this.$onDelete;
                String string = this.$dbOppositePropertyName;
                String string2 = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdManyToManyLink(xdEntityType2, kProperty1, string2, string, onDeletePolicy2, onDeletePolicy, bl);
            }
        });
        xdSprint.issues$delegate = (XdManyToManyLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[9]);
        oppositeLink$iv = (KProperty1)XdSprint$sortOrders$2.INSTANCE;
        xdSprint = this;
        dbPropertyName$iv = null;
        xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdParentToManyChildrenLink<XdSprint, XdStateSortOrder>>(oppositeLink$iv, dbPropertyName$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                super(0);
            }

            @NotNull
            public final XdParentToManyChildrenLink<XdSprint, XdStateSortOrder> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdStateSortOrder.class));
                boolean bl = false;
                String string = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdParentToManyChildrenLink(xdEntityType2, kProperty1, string, bl);
            }
        });
        xdSprint.sortOrders$delegate = (XdParentToManyChildrenLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[10]);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004JP\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u001b\b\u0002\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u000e\u001a\u00020\u00022\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\b\u0019H\u0016R*\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00070\u00060\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/agile/persistence/XdSprint$Companion;", "Lkotlinx/dnq/XdNaturalEntityType;", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "Lmu/KLoggable;", "()V", "compositeIndices", "", "Lkotlin/reflect/KProperty1;", "getCompositeIndices", "()Ljava/util/List;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "new", "agile", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "name", "", "start", "", "finish", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljetbrains/youtrack/agile/persistence/XdAgile;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)Ljetbrains/youtrack/agile/persistence/XdSprint;", "youtrack-scrumboard"})
    public static final class Companion
    extends XdNaturalEntityType<XdSprint>
    implements KLoggable {
        @NotNull
        public KLogger getLogger() {
            return logger;
        }

        @NotNull
        public List<List<KProperty1<XdSprint, ?>>> getCompositeIndices() {
            return CollectionsKt.listOf((Object)CollectionsKt.listOf((Object[])new KMutableProperty1[]{XdSprint$Companion$compositeIndices$1.INSTANCE, XdSprint$Companion$compositeIndices$2.INSTANCE}));
        }

        @NotNull
        public XdSprint new(@NotNull Function1<? super XdSprint, Unit> init) {
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return (XdSprint)super.new((Function1)new Function1<XdSprint, Unit>(init){
                final /* synthetic */ Function1 $init;

                public final void invoke(@NotNull XdSprint $this$new) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                    $this$new.setSwimlanesSortOrder$youtrack_scrumboard((XdSortOrder)XdEntityType.new$default((XdEntityType)XdSortOrder.Companion, null, (int)1, null));
                    this.$init.invoke((Object)((Object)$this$new));
                }
                {
                    this.$init = function1;
                    super(1);
                }
            });
        }

        @NotNull
        public final XdSprint new(@NotNull XdAgile agile2, @NotNull String name2, @Nullable Long start, @Nullable Long finish, @Nullable Function1<? super XdSprint, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return (XdSprint)super.new((Function1)new Function1<XdSprint, Unit>(agile2, name2, start, finish, init){
                final /* synthetic */ XdAgile $agile;
                final /* synthetic */ String $name;
                final /* synthetic */ Long $start;
                final /* synthetic */ Long $finish;
                final /* synthetic */ Function1 $init;

                public final void invoke(@NotNull XdSprint $this$new) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                        $this$new.setAgile(this.$agile);
                        $this$new.setName(this.$name);
                        $this$new.setSwimlanesSortOrder$youtrack_scrumboard((XdSortOrder)XdEntityType.new$default((XdEntityType)XdSortOrder.Companion, null, (int)1, null));
                        $this$new.setInterval(this.$start, this.$finish);
                        Function1 function1 = this.$init;
                        if (function1 == null) break block0;
                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)$this$new));
                    }
                }
                {
                    this.$agile = xdAgile;
                    this.$name = string;
                    this.$start = l;
                    this.$finish = l2;
                    this.$init = function1;
                    super(1);
                }
            });
        }

        public static /* synthetic */ XdSprint new$default(Companion companion, XdAgile xdAgile, String string, Long l, Long l2, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                l = null;
            }
            if ((n & 8) != 0) {
                l2 = null;
            }
            if ((n & 0x10) != 0) {
                function1 = null;
            }
            return companion.new(xdAgile, string, l, l2, (Function1<? super XdSprint, Unit>)function1);
        }

        private Companion() {
            super("Sprint", (StoreContainer)LegacyStoreContainer.INSTANCE);
        }

        @NotNull
        public KLogger logger() {
            return KLoggable.DefaultImpls.logger((KLoggable)this);
        }

        @NotNull
        public KLogger logger(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return KLoggable.DefaultImpls.logger((KLoggable)this, (String)name2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

