/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.customfields.persistence.fields.XdFieldBundle;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.agile.persistence.AgileValuesUtilKt;
import jetbrains.youtrack.agile.persistence.SprintIssuesUtilKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumnFieldValue;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.listener.AgileEntityListener;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$2;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$3;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$4;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleOwnerChange$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateBacklog$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateColumnSettings$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateIssues$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateIssues$2$1$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateSprints$removedSprints$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateSwimlaneSettings$2;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updatedSync$1;
import jetbrains.youtrack.agile.persistence.swimlane.BacklogUtilKt;
import jetbrains.youtrack.agile.persistence.swimlane.XdAttributeBasedSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.swimlane.XdAttributeValue;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.agile.settings.BeansKt;
import jetbrains.youtrack.agile.sprint.logic.SprintLogic;
import jetbrains.youtrack.core.KSecurityLogging;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.persistent.XdSavedQuery;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/agile/persistence/listener/AgileSettingsChangeListener;", "Ljetbrains/youtrack/agile/persistence/listener/AgileEntityListener;", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "()V", "entityType", "Lkotlinx/dnq/XdEntityType;", "getEntityType", "()Lkotlinx/dnq/XdEntityType;", "addedSync", "", "added", "getFieldValuesForProjects", "", "", "field", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "projects", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "handleCache", "old", "handleOwnerChange", "current", "removedSync", "removed", "updateBacklog", "updateColumnSettings", "updateIssues", "updateSprints", "updateSwimlaneSettings", "updatedSync", "Companion", "youtrack-scrumboard"})
public class AgileSettingsChangeListener
implements AgileEntityListener<XdAgile> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public XdEntityType<XdAgile> getEntityType() {
        return (XdEntityType)XdAgile.Companion;
    }

    public void addedSync(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        BeansKt.getAgileCache().init();
    }

    public void updatedSync(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updatedSync$1.INSTANCE)) {
            this.updateBacklog(old, current);
            this.updateSwimlaneSettings(old, current);
            this.updateColumnSettings(current);
            this.updateSprints(old, current);
            this.updateIssues(old, current);
        }
        this.handleCache(old);
        this.handleOwnerChange(old, current);
    }

    public void removedSync(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        if (!removed.isPrivate()) {
            Companion.getSecurityLogger().info("Board " + removed.getName() + " was removed");
        }
    }

    private final void updateSprints(XdAgile old, XdAgile current) {
        XdCustomFieldPrototype sprintSyncField = current.getSprintSyncField();
        if (sprintSyncField != null && !current.getDisableSprints()) {
            Iterable<String> removedSprints2 = this.getFieldValuesForProjects(sprintSyncField, (XdQuery<XdProject>)ReflectionUtilKt.getRemovedLinks((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updateSprints$removedSprints$1.INSTANCE));
            Iterable<String> currentSprints = this.getFieldValuesForProjects(sprintSyncField, (XdQuery<XdProject>)((XdQuery)current.getProjects()));
            List sprintsToArchive = CollectionsKt.minus(removedSprints2, currentSprints);
            Iterable $this$forEach$iv = sprintsToArchive;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                XdSprint xdSprint = current.findSprint(it);
                if (xdSprint != null) {
                    xdSprint.setArchived(true);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<String> getFieldValuesForProjects(XdCustomFieldPrototype field2, XdQuery<XdProject> projects2) {
        void $this$fold$iv;
        Iterable iterable2 = HelpersKt.asIterable(projects2);
        boolean bl = false;
        HashSet initial$iv = new HashSet();
        boolean $i$f$fold = false;
        HashSet accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            XdFieldBundle bundle;
            void it;
            XdProject xdProject = (XdProject)element$iv;
            HashSet seed = accumulator$iv;
            boolean bl2 = false;
            XdProjectCustomField xdProjectCustomField = XdProjectCustomFieldKt.getProjectCustomField((XdProject)it, (XdCustomFieldPrototype)field2);
            Object object = xdProjectCustomField != null ? xdProjectCustomField.getBundle() : null;
            if (!(object instanceof XdFieldBundle)) {
                object = null;
            }
            if ((bundle = (XdFieldBundle)object) != null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable3 = HelpersKt.asIterable((XdQuery)((XdQuery)bundle.getChildren()));
                HashSet hashSet = seed;
                boolean $i$f$map = false;
                void var16_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    XdField xdField = (XdField)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string = it2.getName();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                hashSet.addAll(collection);
            }
            accumulator$iv = seed;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateIssues(XdAgile old, XdAgile current) {
        Iterable $this$forEach$iv = HelpersKt.asIterable((XdQuery)ReflectionUtilKt.getRemovedLinks((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updateIssues$1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdProject project2 = (XdProject)element$iv;
            boolean bl = false;
            if (project2.isRemoved()) continue;
            SprintLogic logic = current.getSprintLogic();
            Iterable $this$forEach$iv2 = HelpersKt.asIterable((XdQuery)((XdQuery)current.getSprints()));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void value$iv;
                void $receiver$iv;
                XdSprint sprint2 = (XdSprint)((Object)element$iv2);
                boolean bl2 = false;
                KProperty1 kProperty1 = (KProperty1)AgileSettingsChangeListener$updateIssues$2$1$1.INSTANCE;
                XdEntity xdEntity = (XdEntity)project2;
                XdQuery<XdIssue> xdQuery = logic.getExplicitIssues(sprint2);
                NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdIssue.class), (XdEntity)value$iv);
                Iterable $this$forEach$iv3 = HelpersKt.asIterable((XdQuery)XdQueryKt.query(xdQuery, (NodeBase)nodeBase));
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    XdIssue it = (XdIssue)element$iv3;
                    boolean bl3 = false;
                    SprintIssuesUtilKt.removeIssueWithoutSwimlanes(sprint2, it);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateColumnSettings(XdAgile current) {
        void $receiver$iv;
        XdCustomFieldPrototype xdCustomFieldPrototype = current.getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            return;
        }
        XdCustomFieldPrototype stateField = xdCustomFieldPrototype;
        Set possibleValues = CollectionsKt.toSet((Iterable)AgileValuesUtilKt.getPossibleValues$default(current, stateField, null, 2, null));
        XdQuery xdQuery = (XdQuery)current.getColumnSettings();
        KProperty1 field$iv = AgileSettingsChangeListener$updateColumnSettings$1.INSTANCE;
        Iterable $this$forEach$iv = HelpersKt.asIterable((XdQuery)XdQueryKt.flatMapDistinct((XdQuery)$receiver$iv, (String)ReflectionUtilKt.getDBName((KProperty1)field$iv, (XdEntityType)$receiver$iv.getEntityType()), (XdEntityType)ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdAgileColumnFieldValue.class))));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdAgileColumnFieldValue it = (XdAgileColumnFieldValue)((Object)element$iv);
            boolean bl = false;
            if (possibleValues.contains(it.getName())) continue;
            it.delete();
        }
    }

    private final void updateBacklog(XdAgile old, XdAgile current) {
        block1: {
            if (!XdQueryKt.isNotEmpty((XdQuery)((XdQuery)current.getProjects())) || !BacklogUtilKt.hasDefaultBacklogQuery(old) || ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)AgileSettingsChangeListener$updateBacklog$1.INSTANCE))) break block1;
            XdSavedQuery xdSavedQuery = current.getBacklog();
            if (xdSavedQuery != null) {
                xdSavedQuery.setQuery(BacklogUtilKt.generateBacklogQuery(current));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSwimlaneSettings(XdAgile old, XdAgile current) {
        XdSwimlaneSettings swimlaneSettings2 = current.getSwimlaneSettings();
        if (swimlaneSettings2 instanceof XdAttributeBasedSwimlaneSettings && Intrinsics.areEqual((Object)swimlaneSettings2.getFilterField(), (Object)jetbrains.charisma.keyword.BeansKt.getPredefinedFieldProject())) {
            void $this$mapTo$iv$iv;
            String string;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = HelpersKt.asIterable((XdQuery)((XdQuery)current.getProjects()));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it;
                XdProject xdProject = (XdProject)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = it.getShortName();
                collection.add(string);
            }
            Set currentProjects = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List values2 = XdQueryKt.toList((XdQuery)((XdQuery)((XdAttributeBasedSwimlaneSettings)swimlaneSettings2).getValues()));
            Iterable $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XdAttributeValue it = (XdAttributeValue)((Object)element$iv);
                boolean bl = false;
                if (currentProjects.contains(it.getName())) continue;
                it.delete();
            }
            Iterable $this$map$iv2 = values2;
            boolean $i$f$map2 = false;
            Iterable element$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                XdAttributeValue xdAttributeValue = (XdAttributeValue)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl = false;
                string = it.getName();
                collection.add(string);
            }
            Set valueNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            Sequence $this$forEach$iv2 = XdQueryKt.asSequence((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updateSwimlaneSettings$2.INSTANCE));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                XdProject it = (XdProject)element$iv2;
                boolean bl = false;
                if (valueNames.contains(it.getShortName())) continue;
                XdAttributeValue.Companion.new((Function1)new Function1<XdAttributeValue, Unit>(it, valueNames, swimlaneSettings2){
                    final /* synthetic */ XdProject $it;
                    final /* synthetic */ Set $valueNames$inlined;
                    final /* synthetic */ XdSwimlaneSettings $swimlaneSettings$inlined;
                    {
                        this.$it = xdProject;
                        this.$valueNames$inlined = set;
                        this.$swimlaneSettings$inlined = xdSwimlaneSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull XdAttributeValue $this$new) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                        $this$new.setName(this.$it.getShortName());
                        $this$new.setParent((XdAttributeBasedSwimlaneSettings)this.$swimlaneSettings$inlined);
                    }
                });
            }
        }
    }

    private final void handleCache(XdAgile old) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new KProperty1[]{AgileSettingsChangeListener$handleCache$1.INSTANCE, (KProperty1)AgileSettingsChangeListener$handleCache$2.INSTANCE, (KProperty1)AgileSettingsChangeListener$handleCache$3.INSTANCE, (KProperty1)AgileSettingsChangeListener$handleCache$4.INSTANCE});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KProperty1 it = (KProperty1)element$iv;
                    boolean bl2 = false;
                    if (!ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            BeansKt.getAgileCache().init();
        }
    }

    private final void handleOwnerChange(XdAgile old, XdAgile current) {
        if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)AgileSettingsChangeListener$handleOwnerChange$1.INSTANCE))) {
            Companion.getSecurityLogger().info("Board owner changed for board " + current.getName() + ": " + old.getOwner().getLogin() + " -> " + current.getOwner().getLogin());
        }
    }

    @Override
    public void add() {
        AgileEntityListener.DefaultImpls.add(this);
    }

    @Override
    public void remove() {
        AgileEntityListener.DefaultImpls.remove(this);
    }

    public void addedAsync(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedAsync(this, (XdEntity)added);
    }

    public void addedSyncAfterConstraints(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncAfterConstraints(this, (XdEntity)added);
    }

    public void addedSyncBeforeConstraints(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncBeforeConstraints(this, (XdEntity)added);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
    public void addedSyncBeforeFlush(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncBeforeFlush(this, (XdEntity)added);
    }

    public void removedAsync(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        AgileEntityListener.DefaultImpls.removedAsync(this, (XdEntity)removed);
    }

    public void removedSyncAfterConstraints(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        AgileEntityListener.DefaultImpls.removedSyncAfterConstraints(this, (XdEntity)removed);
    }

    public void removedSyncBeforeConstraints(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        AgileEntityListener.DefaultImpls.removedSyncBeforeConstraints(this, (XdEntity)removed);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
    public void removedSyncBeforeFlush(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.removedSyncBeforeFlush(this, (XdEntity)added);
    }

    public void updatedAsync(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedAsync(this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncAfterConstraints(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncAfterConstraints(this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncBeforeConstraints(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncBeforeConstraints(this, (XdEntity)old, (XdEntity)current);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
    public void updatedSyncBeforeFlush(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncBeforeFlush(this, (XdEntity)old, (XdEntity)current);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/agile/persistence/listener/AgileSettingsChangeListener$Companion;", "Ljetbrains/youtrack/core/KSecurityLogging;", "()V", "youtrack-scrumboard"})
    public static final class Companion
    extends KSecurityLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

