/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.youtrack.agile.persistence.AgileStatusKt;
import jetbrains.youtrack.agile.persistence.SprintIssuesUtilKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.parser.AgileCategoryUtilKt;
import jetbrains.youtrack.agile.persistence.parser.BaseSprintField;
import jetbrains.youtrack.agile.persistence.parser.CurrentSprintCommandExecutor;
import jetbrains.youtrack.agile.persistence.parser.CurrentSprintFieldValue;
import jetbrains.youtrack.agile.persistence.parser.DefaultSprintFieldValue;
import jetbrains.youtrack.agile.persistence.parser.PresetCommandExecutorFactory;
import jetbrains.youtrack.agile.persistence.parser.RemoveAllBoardSprintsCommandExecutor;
import jetbrains.youtrack.agile.persistence.parser.SprintFieldValue;
import jetbrains.youtrack.agile.sprint.logic.SprintLogic;
import jetbrains.youtrack.api.commands.ICommandExecutorFactory;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.AliasFlag;
import jetbrains.youtrack.api.parser.DateGrouping;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J,\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00192\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010 \u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J \u0010&\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J5\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006*"}, d2={"Ljetbrains/youtrack/agile/persistence/parser/BoardSprintField;", "Ljetbrains/youtrack/agile/persistence/parser/BaseSprintField;", "agile", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "(Ljetbrains/youtrack/agile/persistence/XdAgile;)V", "getAgile", "()Ljetbrains/youtrack/agile/persistence/XdAgile;", "isMultivalue", "", "()Z", "acceptsFieldValue", "context", "Ljetbrains/youtrack/api/context/IContext;", "activity", "Ljetbrains/youtrack/api/context/IContext$Activity;", "projects", "", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "value", "Ljetbrains/youtrack/api/parser/IFieldValue;", "addHasField", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "pos", "filter", "Lkotlinx/dnq/query/XdQuery;", "me", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "filterHasField", "getAddValueCommandExecutorFactory", "Ljetbrains/youtrack/api/commands/ICommandExecutorFactory;", "getRemoveValueCommandExecutorFactory", "getValues", "group", "Ljetbrains/youtrack/api/parser/DateGrouping;", "matchesCommandType", "commandType", "Ljetbrains/youtrack/api/commands/PredefinedCommandType;", "matchesHasField", "matchesIssue", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;Ljetbrains/youtrack/api/parser/IFieldValue;Ljetbrains/youtrack/api/context/IContext;Ljetbrains/youtrack/core/persistent/user/XdUser;)Ljava/lang/Boolean;", "Companion", "youtrack-scrumboard"})
public class BoardSprintField
extends BaseSprintField {
    @NotNull
    private final XdAgile agile;
    private static final int ALIAS_MASK_NO_SPRINTS;
    public static final Companion Companion;

    public boolean isMultivalue() {
        return true;
    }

    @Override
    @Nullable
    public XdQuery<XdIssue> filter(@NotNull IFieldValue<?> value2, @NotNull IContext context, @NotNull XdUser me) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        if (value2 instanceof CurrentSprintFieldValue) {
            return this.filter(this.agile.getSprintLogic().getCurrentSprint(), context);
        }
        return super.filter(value2, context, me);
    }

    public boolean matchesCommandType(@Nullable PredefinedCommandType commandType) {
        if (commandType == null && this.agile.getDisableSprints()) {
            return false;
        }
        return super.matchesCommandType(commandType);
    }

    public boolean acceptsFieldValue(@NotNull IContext context, @NotNull IContext.Activity activity, @NotNull Iterable<XdProject> projects2, @NotNull IFieldValue<?> value2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        if (value2 instanceof SprintFieldValue) {
            XdSprint sprint2 = (XdSprint)((Object)((SprintFieldValue)value2).getFieldValue());
            if (sprint2.isRemoved()) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)sprint2.getAgile()), (Object)((Object)this.agile)) && XdAgile.isAccessible$default(this.agile, Operation.READ, null, 2, null);
        }
        if (value2 instanceof DefaultSprintFieldValue) {
            return this.agile.getDefaultSprint() != null;
        }
        if (value2 instanceof CurrentSprintFieldValue) {
            return this.agile.getSprintLogic().getCurrentSprint() != null;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Iterable<IFieldValue<?>> getValues(@NotNull XdIssue issue2, @NotNull XdUser me, @Nullable DateGrouping group) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        Iterable $this$map$iv = HelpersKt.asIterable(this.agile.getSprintLogic().getIssueSprints(issue2));
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IFieldValue<?> iFieldValue;
            void it;
            XdSprint xdSprint = (XdSprint)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (SprintFieldValue.Companion.findKeyWord((XdSprint)it) == null) {
                throw (Throwable)new RuntimeException("Could find sprint field value " + it);
            }
            collection.add(iFieldValue);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Boolean matchesIssue(@NotNull XdIssue issue2, @Nullable IFieldValue<?> value2, @NotNull IContext context, @NotNull XdUser me) {
        XdSprint sprint2;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        if (!AgileStatusKt.getStatus(this.agile).isValid() || context.isEncloseByIssueFolder((XdEntity)this.agile)) {
            return false;
        }
        context.pushEnclosingIssueFolder((XdEntity)this.agile);
        Object object = value2;
        XdSprint xdSprint = object instanceof SprintFieldValue ? (XdSprint)((Object)((SprintFieldValue)value2).getFieldValue()) : (object instanceof DefaultSprintFieldValue ? this.agile.getDefaultSprint() : (sprint2 = object instanceof CurrentSprintFieldValue ? this.agile.getSprintLogic().getCurrentSprint() : null));
        if (sprint2 == null || sprint2.isRemoved()) {
            return false;
        }
        object = this.agile.getSprintLogic().matchesIssue(sprint2, issue2, context);
        boolean bl = false;
        boolean bl2 = false;
        boolean $this$apply = (Boolean)object;
        boolean bl3 = false;
        context.popEnclosingIssueFolder((XdEntity)this.agile);
        return object;
    }

    public boolean matchesHasField(@NotNull XdIssue issue2, @NotNull IContext context, @NotNull XdUser me) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
            if (!AgileStatusKt.getStatus(this.agile).isValid() || context.isEncloseByIssueFolder((XdEntity)this.agile)) {
                return false;
            }
            context.pushEnclosingIssueFolder((XdEntity)this.agile);
            SprintLogic sprintLogic = this.agile.getSprintLogic();
            Iterable $this$any$iv = HelpersKt.asIterable((XdQuery)((XdQuery)this.agile.getSprints()));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XdSprint it = (XdSprint)((Object)element$iv);
                    boolean bl2 = false;
                    if (!sprintLogic.matchesIssue(it, issue2, context)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean $this$apply = bl3;
        boolean bl6 = false;
        context.popEnclosingIssueFolder((XdEntity)this.agile);
        return bl3;
    }

    public boolean addHasField(@NotNull XdIssue issue2, boolean pos) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        if (pos) {
            SprintLogic sprintLogic = this.agile.getSprintLogic();
            if (!sprintLogic.isExplicit()) {
                return false;
            }
            XdSprint xdSprint = sprintLogic.getCurrentSprint();
            if (xdSprint == null) {
                return false;
            }
            XdSprint sprint2 = xdSprint;
            sprintLogic.addExplicitIssue(sprint2, issue2);
        } else {
            Iterable $this$forEach$iv = HelpersKt.asIterable((XdQuery)((XdQuery)this.agile.getSprints()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XdSprint it = (XdSprint)((Object)element$iv);
                boolean bl = false;
                SprintIssuesUtilKt.removeIssue(it, issue2);
            }
        }
        return true;
    }

    @Nullable
    public XdQuery<XdIssue> filterHasField(@NotNull IContext context, @NotNull XdUser me) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        if (!AgileStatusKt.getStatus(this.agile).isValid() || context.isEncloseByIssueFolder((XdEntity)this.agile)) {
            return null;
        }
        context.pushEnclosingIssueFolder((XdEntity)this.agile);
        XdQuery<XdIssue> xdQuery = this.agile.getSprintLogic().getIssues(context);
        boolean bl = false;
        boolean bl2 = false;
        XdQuery<XdIssue> $this$apply = xdQuery;
        boolean bl3 = false;
        context.popEnclosingIssueFolder((XdEntity)this.agile);
        return xdQuery;
    }

    @Nullable
    public ICommandExecutorFactory getAddValueCommandExecutorFactory(@NotNull IContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        XdSprint xdSprint = this.agile.getSprintLogic().getCurrentSprint();
        if (xdSprint == null) {
            return null;
        }
        XdSprint currentSprint2 = xdSprint;
        return new PresetCommandExecutorFactory(new CurrentSprintCommandExecutor(currentSprint2, PredefinedCommandType.add));
    }

    @Nullable
    public ICommandExecutorFactory getRemoveValueCommandExecutorFactory(@NotNull IContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new PresetCommandExecutorFactory(new RemoveAllBoardSprintsCommandExecutor(this));
    }

    @NotNull
    public final XdAgile getAgile() {
        return this.agile;
    }

    public BoardSprintField(@NotNull XdAgile agile2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
        super(AgileCategoryUtilKt.getBoardPresentation$default(agile2.getName(), null, 2, null), agile2.getDisableSprints() ? ALIAS_MASK_NO_SPRINTS : FieldAlias.Companion.getALL());
        this.agile = agile2;
    }

    static {
        Companion = new Companion(null);
        ALIAS_MASK_NO_SPRINTS = AliasFlag.Companion.toMask(new AliasFlag[]{AliasFlag.COMMAND, AliasFlag.HAS, AliasFlag.SORT, AliasFlag.PRESENTATION});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/agile/persistence/parser/BoardSprintField$Companion;", "", "()V", "ALIAS_MASK_NO_SPRINTS", "", "getALIAS_MASK_NO_SPRINTS", "()I", "youtrack-scrumboard"})
    public static final class Companion {
        protected final int getALIAS_MASK_NO_SPRINTS() {
            return ALIAS_MASK_NO_SPRINTS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

