/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence.swimlane;

import java.util.Collection;
import java.util.List;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.persistent.sortOrder.EntitySortOrder;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.swimlane.DateAttributeProvider;
import jetbrains.youtrack.agile.persistence.swimlane.DateAttributeValue;
import jetbrains.youtrack.agile.persistence.swimlane.SwimlaneSettingsLogic;
import jetbrains.youtrack.agile.persistence.swimlane.XdAttributeBasedSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.agile.settings.SwimlaneAttributeValue;
import jetbrains.youtrack.agile.settings.SwimlaneDateAttributeValue;
import jetbrains.youtrack.agile.sprint.Board;
import jetbrains.youtrack.agile.sprint.order.SwimlanesDisabledOrder;
import jetbrains.youtrack.agile.sprint.row.AttributeBasedSwimlane;
import jetbrains.youtrack.agile.sprint.row.BoardRow;
import jetbrains.youtrack.agile.sprint.row.BoardSwimlanes;
import jetbrains.youtrack.agile.sprint.row.DateBasedSwimlanes;
import jetbrains.youtrack.agile.sprint.row.OrphanRow;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H$\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/agile/persistence/swimlane/DateFieldSettingsLogic;", "Ljetbrains/youtrack/agile/persistence/swimlane/SwimlaneSettingsLogic;", "settings", "Ljetbrains/youtrack/agile/persistence/swimlane/XdAttributeBasedSwimlaneSettings;", "attributeProvider", "Ljetbrains/youtrack/agile/persistence/swimlane/DateAttributeProvider;", "(Ljetbrains/youtrack/agile/persistence/swimlane/XdAttributeBasedSwimlaneSettings;Ljetbrains/youtrack/agile/persistence/swimlane/DateAttributeProvider;)V", "getAttributeProvider", "()Ljetbrains/youtrack/agile/persistence/swimlane/DateAttributeProvider;", "getSettings", "()Ljetbrains/youtrack/agile/persistence/swimlane/XdAttributeBasedSwimlaneSettings;", "getMonth", "Lorg/joda/time/DateTime;", "time", "", "getRow", "Ljetbrains/youtrack/agile/sprint/row/BoardRow;", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "sprint", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "getSwimlaneId", "getSwimlaneOrder", "Ljetbrains/charisma/persistent/sortOrder/EntitySortOrder;", "board", "Ljetbrains/youtrack/agile/sprint/Board;", "getSwimlanes", "", "Ljetbrains/youtrack/agile/persistence/swimlane/DateAttributeValue;", "Ljetbrains/youtrack/agile/sprint/row/BoardSwimlanes;", "getValue", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;)Ljava/lang/Long;", "youtrack-scrumboard"})
public abstract class DateFieldSettingsLogic
implements SwimlaneSettingsLogic {
    @NotNull
    private final XdAttributeBasedSwimlaneSettings settings;
    @NotNull
    private final DateAttributeProvider attributeProvider;

    @Override
    public long getSwimlaneId(@NotNull XdIssue issue2, @NotNull XdSprint sprint2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sprint2), (String)"sprint");
        Long l = this.getValue(issue2);
        if (l == null) {
            return XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID();
        }
        long value2 = l;
        DateAttributeValue dateAttributeValue = this.attributeProvider.fromTimestamp(value2);
        return dateAttributeValue != null ? dateAttributeValue.getId() : XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID();
    }

    @NotNull
    protected final DateTime getMonth(long time) {
        DateTime dateTime = new DateTime(time).withDayOfMonth(1).withMillisOfDay(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time).withDayOf\u2026nth(1).withMillisOfDay(0)");
        return dateTime;
    }

    @Nullable
    protected abstract Long getValue(@NotNull XdIssue var1);

    @Override
    @NotNull
    public BoardRow getRow(@NotNull XdIssue issue2, @NotNull XdSprint sprint2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sprint2), (String)"sprint");
        Long l = this.getValue(issue2);
        if (l == null) {
            return new OrphanRow(sprint2);
        }
        long value2 = l;
        DateAttributeValue dateAttributeValue = this.attributeProvider.fromTimestamp(value2);
        if (dateAttributeValue == null) {
            return new OrphanRow(sprint2);
        }
        DateAttributeValue swimlane = dateAttributeValue;
        return new AttributeBasedSwimlane((SwimlaneAttributeValue)new SwimlaneDateAttributeValue(swimlane), sprint2);
    }

    @Override
    @NotNull
    public BoardSwimlanes getSwimlanes(@NotNull Board board2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)board2), (String)"board");
        return new DateBasedSwimlanes(board2, this);
    }

    @Override
    @NotNull
    public EntitySortOrder<? extends BoardRow> getSwimlaneOrder(@NotNull Board board2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)board2), (String)"board");
        return (EntitySortOrder)new SwimlanesDisabledOrder(board2);
    }

    @NotNull
    public final List<DateAttributeValue> getSwimlanes() {
        return DateAttributeProvider.getAttributeValuesForTimestamp$default(this.attributeProvider, 0L, 1, null);
    }

    @Override
    @NotNull
    public XdAttributeBasedSwimlaneSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final DateAttributeProvider getAttributeProvider() {
        return this.attributeProvider;
    }

    public DateFieldSettingsLogic(@NotNull XdAttributeBasedSwimlaneSettings settings2, @NotNull DateAttributeProvider attributeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings2), (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)attributeProvider, (String)"attributeProvider");
        this.settings = settings2;
        this.attributeProvider = attributeProvider;
    }

    @Override
    @NotNull
    public Function1<XdIssue, Boolean> getSwimlaneFilter() {
        return SwimlaneSettingsLogic.DefaultImpls.getSwimlaneFilter(this);
    }

    @Override
    public void makeTask(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        SwimlaneSettingsLogic.DefaultImpls.makeTask(this, issue2);
    }

    @Override
    public void makeSwimlane(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        SwimlaneSettingsLogic.DefaultImpls.makeSwimlane(this, issue2);
    }

    @Override
    public boolean isSwimlane(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return SwimlaneSettingsLogic.DefaultImpls.isSwimlane(this, issue2);
    }

    @Override
    public boolean canCreateSwimlaneIssue() {
        return SwimlaneSettingsLogic.DefaultImpls.canCreateSwimlaneIssue(this);
    }

    @Override
    public boolean canCreateSwimlaneIssueInProject(@NotNull XdProject entity2) {
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        return SwimlaneSettingsLogic.DefaultImpls.canCreateSwimlaneIssueInProject(this, entity2);
    }

    @Override
    public boolean canCreateTaskInProject(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return SwimlaneSettingsLogic.DefaultImpls.canCreateTaskInProject(this, project2);
    }

    @Override
    @NotNull
    public XdQuery<XdIssue> filterSwimlanes(@NotNull XdQuery<XdIssue> issues2, boolean isSwimlane) {
        Intrinsics.checkParameterIsNotNull(issues2, (String)"issues");
        return SwimlaneSettingsLogic.DefaultImpls.filterSwimlanes(this, issues2, isSwimlane);
    }

    @Override
    @Nullable
    public BoardRow asSwimlane(@NotNull XdIssue issue2, @NotNull XdSprint sprint2, @Nullable Iterable<? extends Entity> taskFilter) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sprint2), (String)"sprint");
        return SwimlaneSettingsLogic.DefaultImpls.asSwimlane(this, issue2, sprint2, taskFilter);
    }

    @Override
    @NotNull
    public Collection<String> getConfigurationErrors() {
        return SwimlaneSettingsLogic.DefaultImpls.getConfigurationErrors(this);
    }

    @Override
    @Nullable
    public String getUsedValuesMessage(@NotNull XdProjectCustomField field2, @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return SwimlaneSettingsLogic.DefaultImpls.getUsedValuesMessage(this, field2, issue2);
    }
}

