/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.sprint.liveupdate;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.sprint.liveupdate.BacklogSubscription;
import jetbrains.youtrack.event.liveupdate.Subscription;
import jetbrains.youtrack.event.liveupdate.SubscriptionsQueue;
import jetbrains.youtrack.eventSource.EventOutputContainer;
import jetbrains.youtrack.gaprest.db.QueryOperationsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/agile/sprint/liveupdate/BacklogSubscriptionImpl;", "Ljetbrains/youtrack/agile/sprint/liveupdate/BacklogSubscription;", "output", "Ljetbrains/youtrack/eventSource/EventOutputContainer;", "snapshotIssues", "", "Ljetbrains/exodus/entitystore/EntityId;", "", "projects", "", "Ljetbrains/exodus/entitystore/Entity;", "search", "", "sprint", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "(Ljetbrains/youtrack/eventSource/EventOutputContainer;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Iterable;Ljetbrains/youtrack/agile/persistence/XdSprint;)V", "getOutput", "()Ljetbrains/youtrack/eventSource/EventOutputContainer;", "getProjects", "()Ljava/util/Set;", "getSearch", "()Ljava/lang/Iterable;", "getSnapshotIssues", "()Ljava/util/Map;", "getSprint", "()Ljetbrains/youtrack/agile/persistence/XdSprint;", "handlePing", "", "matchesIssue", "issue", "Ljetbrains/exodus/database/TransientEntity;", "youtrack-scrumboard"})
public final class BacklogSubscriptionImpl
implements BacklogSubscription {
    @NotNull
    private final EventOutputContainer output;
    @NotNull
    private final Map<EntityId, Boolean> snapshotIssues;
    @NotNull
    private final Set<Entity> projects;
    @Nullable
    private final Iterable<Entity> search;
    @NotNull
    private final XdSprint sprint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePing() {
        Closeable closeable = (Closeable)new SubscriptionsQueue(null, new ReentrantLock());
        boolean bl = false;
        Throwable throwable = null;
        try {
            SubscriptionsQueue queue = (SubscriptionsQueue)closeable;
            boolean bl2 = false;
            queue.doHandlePing(this.getSprint().getEntity(), (Subscription)this, this.getOutput().getOwner());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public boolean matchesIssue(@NotNull TransientEntity issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        if (this.search == null) {
            return true;
        }
        return QueryOperationsKt.contains((QueryEngine)issue2.getStore().getQueryEngine(), this.search, (Entity)((Entity)issue2));
    }

    @NotNull
    public EventOutputContainer getOutput() {
        return this.output;
    }

    @NotNull
    public Map<EntityId, Boolean> getSnapshotIssues() {
        return this.snapshotIssues;
    }

    @NotNull
    public Set<Entity> getProjects() {
        return this.projects;
    }

    @Nullable
    public final Iterable<Entity> getSearch() {
        return this.search;
    }

    @Override
    @NotNull
    public XdSprint getSprint() {
        return this.sprint;
    }

    public BacklogSubscriptionImpl(@NotNull EventOutputContainer output, @NotNull Map<EntityId, Boolean> snapshotIssues, @NotNull Set<Entity> projects2, @Nullable Iterable<? extends Entity> search, @NotNull XdSprint sprint2) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(snapshotIssues, (String)"snapshotIssues");
        Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sprint2), (String)"sprint");
        this.output = output;
        this.snapshotIssues = snapshotIssues;
        this.projects = projects2;
        this.search = search;
        this.sprint = sprint2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return BacklogSubscription.DefaultImpls.getDescription(this);
    }
}

