/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.templates;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jetbrains.charisma.service.UniqueNameUtilKt;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.agile.persistence.builder.AgileAccessSettings;
import jetbrains.youtrack.agile.persistence.builder.AgileBoardBuilder;
import jetbrains.youtrack.agile.persistence.builder.AgileBoardBuilderExtension;
import jetbrains.youtrack.agile.persistence.swimlane.BacklogUtilKt;
import jetbrains.youtrack.agile.plugin.BeansKt;
import jetbrains.youtrack.agile.templates.AgileTemplate;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdSavedQuery;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u001e\u0010\u0015\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J\u0016\u0010\u0018\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u001c\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\bH\u0016J \u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J \u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u001c\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/agile/templates/AgileTemplate;", "", "extensions", "", "Ljetbrains/youtrack/agile/persistence/builder/AgileBoardBuilderExtension;", "getExtensions", "()Ljava/util/Collection;", "name", "", "getName", "()Ljava/lang/String;", "apply", "Ljetbrains/youtrack/agile/persistence/builder/AgileBoardBuilder;", "builder", "canUpdateAllProjects", "", "currentUser", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "projects", "", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "createBuilder", "", "getAgileBuilder", "getAgileName", "getBacklog", "Ljetbrains/youtrack/persistent/XdSavedQuery;", "boardName", "getBacklogName", "getUpdateSettings", "Ljetbrains/youtrack/agile/persistence/builder/AgileAccessSettings;", "getVisibilitySettings", "youtrack-scrumboard"})
public interface AgileTemplate {
    @NotNull
    public String getName();

    @Nullable
    public Collection<AgileBoardBuilderExtension> getExtensions();

    @NotNull
    public AgileBoardBuilder getAgileBuilder(@NotNull List<XdProject> var1);

    @NotNull
    public AgileBoardBuilder apply(@NotNull AgileBoardBuilder var1);

    @NotNull
    public AgileBoardBuilder createBuilder(@NotNull List<XdProject> var1, @NotNull XdUser var2);

    @NotNull
    public String getAgileName(@NotNull Iterable<XdProject> var1);

    @Nullable
    public AgileAccessSettings getVisibilitySettings(@NotNull XdUser var1, @NotNull Iterable<XdProject> var2);

    public boolean canUpdateAllProjects(@NotNull XdUser var1, @NotNull Iterable<XdProject> var2);

    @Nullable
    public AgileAccessSettings getUpdateSettings(@NotNull XdUser var1, @NotNull Iterable<XdProject> var2);

    @NotNull
    public String getBacklogName(@NotNull Iterable<XdProject> var1, @NotNull String var2);

    @Nullable
    public XdSavedQuery getBacklog(@NotNull Iterable<XdProject> var1, @NotNull String var2, @NotNull XdUser var3);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Collection<AgileBoardBuilderExtension> getExtensions(AgileTemplate $this) {
            return BeansKt.getAgileTemplatesService().suitableExtensions($this);
        }

        @NotNull
        public static AgileBoardBuilder getAgileBuilder(AgileTemplate $this, @NotNull List<XdProject> projects2) {
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            XdUser currentUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
            AgileBoardBuilder builder = $this.createBuilder(projects2, currentUser);
            String string = builder.getName();
            Iterable iterable2 = projects2;
            AgileTemplate agileTemplate = $this;
            AgileBoardBuilder agileBoardBuilder = $this.apply(builder);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            return agileBoardBuilder.withBacklog(agileTemplate.getBacklog(iterable2, string3, currentUser));
        }

        @NotNull
        public static AgileBoardBuilder createBuilder(AgileTemplate $this, @NotNull List<XdProject> projects2, @NotNull XdUser currentUser) {
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
            return new AgileBoardBuilder().withProjects(projects2).withName($this.getAgileName((Iterable<XdProject>)projects2)).withCreator(currentUser).withUpdatableBy($this.getUpdateSettings(currentUser, (Iterable<XdProject>)projects2)).withVisibleFor($this.getVisibilitySettings(currentUser, (Iterable<XdProject>)projects2)).withExtensions($this.getExtensions());
        }

        @NotNull
        public static String getAgileName(AgileTemplate $this, @NotNull Iterable<XdProject> projects2) {
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            String base2 = CollectionsKt.joinToString$default(projects2, null, null, null, (int)0, null, (Function1)getAgileName.base.1.INSTANCE, (int)31, null);
            CharSequence charSequence = base2;
            boolean bl = false;
            if (charSequence.length() == 0) {
                base2 = "agile";
            }
            return UniqueNameUtilKt.generateUniqueName$default((String)base2, null, (Function1)getAgileName.1.INSTANCE, (int)2, null);
        }

        @Nullable
        public static AgileAccessSettings getVisibilitySettings(AgileTemplate $this, @NotNull XdUser currentUser, @NotNull Iterable<XdProject> projects2) {
            Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            if ($this.canUpdateAllProjects(currentUser, projects2) && currentUser.hasPermission(Permission.SHARE_WATCH_FOLDER)) {
                return new AgileAccessSettings(true);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public static boolean canUpdateAllProjects(AgileTemplate $this, @NotNull XdUser currentUser, @NotNull Iterable<XdProject> projects2) {
            XdProject[] xdProjectArray;
            void $this$toTypedArray$iv;
            Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            Collection collection = CollectionsKt.toList(projects2);
            Permission permission = Permission.UPDATE_PROJECT;
            XdUser xdUser = currentUser;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            XdProject[] xdProjectArray2 = thisCollection$iv.toArray(new XdProject[0]);
            if (xdProjectArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            XdProject[] xdProjectArray3 = xdProjectArray = xdProjectArray2;
            return xdUser.hasPermissionInProject(permission, Arrays.copyOf(xdProjectArray3, xdProjectArray3.length));
        }

        @Nullable
        public static AgileAccessSettings getUpdateSettings(AgileTemplate $this, @NotNull XdUser currentUser, @NotNull Iterable<XdProject> projects2) {
            Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            return $this.canUpdateAllProjects(currentUser, projects2) ? new AgileAccessSettings(true) : null;
        }

        @NotNull
        public static String getBacklogName(AgileTemplate $this, @NotNull Iterable<XdProject> projects2, @NotNull String boardName) {
            String name2;
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            Intrinsics.checkParameterIsNotNull((Object)boardName, (String)"boardName");
            String projectsSuffix2 = " (" + CollectionsKt.joinToString$default(projects2, null, null, null, (int)0, null, (Function1)getBacklogName.projectsSuffix.1.INSTANCE, (int)31, null) + ")";
            String string = name2 = WatchFolderImpl.toValidName((String)(boardName + projectsSuffix2 + " Backlog"));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            return UniqueNameUtilKt.generateUniqueName$default((String)string, null, (Function1)getBacklogName.1.INSTANCE, (int)2, null);
        }

        @Nullable
        public static XdSavedQuery getBacklog(AgileTemplate $this, @NotNull Iterable<XdProject> projects2, @NotNull String boardName, @NotNull XdUser currentUser) {
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            Intrinsics.checkParameterIsNotNull((Object)boardName, (String)"boardName");
            Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
            String query2 = BacklogUtilKt.generateBacklogQuery(projects2, boardName);
            CharSequence charSequence = query2;
            boolean bl = false;
            if (charSequence.length() > 0 && currentUser.hasPermission(Permission.CREATE_WATCH_FOLDER)) {
                Entity entity2 = jetbrains.charisma.service.BeansKt.getUserProfileService().getSearchRequest(currentUser).save($this.getBacklogName(projects2, boardName), null, query2);
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"userProfileService.getSe\u2026 boardName), null, query)");
                return (XdSavedQuery)XdExtensionsKt.toXd((Entity)entity2);
            }
            return null;
        }
    }
}

