/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototypeKt;
import jetbrains.charisma.customfields.predefined.BeansKt;
import jetbrains.charisma.customfields.predefined.IssueTypeSuppliedField;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.youtrack.agile.persistence.AgileFieldsUtilKt;
import jetbrains.youtrack.agile.persistence.AgileValuesUtilKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.builder.AgileAccessSettings;
import jetbrains.youtrack.agile.persistence.builder.AgileBoardBuilder;
import jetbrains.youtrack.agile.persistence.swimlane.XdIssueBasedSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.agile.templates.PreconfiguredAgileTemplate;
import jetbrains.youtrack.agile.templates.ScrumTypes;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J/\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0016J\u001e\u0010\u0017\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J \u0010\u0019\u001a\u0004\u0018\u00010\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/agile/templates/ScrumAgileTemplate;", "Ljetbrains/youtrack/agile/templates/PreconfiguredAgileTemplate;", "()V", "name", "", "getName", "()Ljava/lang/String;", "apply", "Ljetbrains/youtrack/agile/persistence/builder/AgileBoardBuilder;", "builder", "createAgile", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "projects", "", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "creator", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "createSwimlaneSettings", "Ljetbrains/youtrack/agile/persistence/swimlane/XdSwimlaneSettings;", "state", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "currentUser", "createSwimlaneSettings$youtrack_scrumboard", "getBuilderNoBacklog", "", "getEstimationField", "youtrack-scrumboard"})
public final class ScrumAgileTemplate
extends PreconfiguredAgileTemplate {
    @NotNull
    private static final String name = "scrum";
    public static final ScrumAgileTemplate INSTANCE;

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public AgileBoardBuilder apply(@NotNull AgileBoardBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        XdUser currentUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        List<XdProject> projects2 = builder.getProjects();
        XdCustomFieldPrototype state2 = this.findColumnPrototype$youtrack_scrumboard((Iterable<XdProject>)projects2, currentUser);
        XdSwimlaneSettings swimlaneSettings2 = this.createSwimlaneSettings$youtrack_scrumboard((Iterable<XdProject>)projects2, state2, currentUser);
        XdCustomFieldPrototype estimationField = this.getEstimationField((Iterable<XdProject>)projects2, currentUser);
        return builder.withColumnsPrototype(state2).withSwimlaneSettings(swimlaneSettings2).withColorCoding(this.getColorCoding$youtrack_scrumboard((Iterable<XdProject>)projects2, currentUser)).withEstimationPrototype(estimationField).withColumns(this.getColumns$youtrack_scrumboard((Iterable<XdProject>)projects2, state2, currentUser));
    }

    private final AgileBoardBuilder getBuilderNoBacklog(List<XdProject> projects2, XdUser currentUser) {
        return this.apply(this.createBuilder(projects2, currentUser));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final XdSwimlaneSettings createSwimlaneSettings$youtrack_scrumboard(@NotNull Iterable<XdProject> projects2, @Nullable XdCustomFieldPrototype state2, @NotNull XdUser currentUser) {
        void $this$filterTo$iv$iv;
        XdCustomFieldPrototype foundTypeField;
        XdCustomFieldPrototype xdCustomFieldPrototype;
        Object object;
        List availableSwimlaneFields2;
        block9: {
            Object it;
            Object element$iv$iv2;
            Iterable $this$filterTo$iv$iv2;
            Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
            Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
            Iterable<XdCustomFieldPrototype> $this$filter$iv = AgileFieldsUtilKt.getAvailableIssueBasedSwimlanesFields(projects2, currentUser);
            boolean $i$f$filter = false;
            Iterable<XdCustomFieldPrototype> iterable2 = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                it = (XdCustomFieldPrototype)element$iv$iv2;
                boolean bl = false;
                XdCustomFieldPrototype xdCustomFieldPrototype2 = state2;
                if (!(Intrinsics.areEqual((Object)it.getEntity(), (Object)(xdCustomFieldPrototype2 != null ? xdCustomFieldPrototype2.getEntity() : null)) ^ true)) continue;
                destination$iv$iv22.add(element$iv$iv2);
            }
            availableSwimlaneFields2 = (List)destination$iv$iv22;
            String issueTypeName = BeansKt.getIssueType().getNonLocalizedFieldName();
            $this$filterTo$iv$iv2 = availableSwimlaneFields2;
            boolean destination$iv$iv22 = false;
            Iterable $i$f$filterTo22 = $this$filterTo$iv$iv2;
            boolean bl = false;
            element$iv$iv2 = $i$f$filterTo22.iterator();
            while (element$iv$iv2.hasNext()) {
                Object it2 = it = element$iv$iv2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)issueTypeName)) continue;
                object = it;
                break block9;
            }
            object = null;
        }
        if ((xdCustomFieldPrototype = (foundTypeField = (XdCustomFieldPrototype)object)) == null) {
            xdCustomFieldPrototype = (XdCustomFieldPrototype)CollectionsKt.firstOrNull((List)availableSwimlaneFields2);
        }
        if (xdCustomFieldPrototype == null) {
            return null;
        }
        XdCustomFieldPrototype type = xdCustomFieldPrototype;
        XdEntity result2 = XdIssueBasedSwimlaneSettings.Companion.new((Function1)new Function1<XdIssueBasedSwimlaneSettings, Unit>(type){
            final /* synthetic */ XdCustomFieldPrototype $type;

            public final void invoke(@NotNull XdIssueBasedSwimlaneSettings $this$new) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                $this$new.setField(this.$type);
            }
            {
                this.$type = xdCustomFieldPrototype;
                super(1);
            }
        });
        LinkedHashSet<String> possibleValues = AgileValuesUtilKt.getPossibleValues(projects2, type, currentUser);
        Locale locale = LocaleUtil.DEFAULT_LOCALE;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"LocaleUtil.DEFAULT_LOCALE");
        String feature = IssueTypeSuppliedField.Types.FEATURE.presentation(locale);
        String userStory = ScrumTypes.USER_STORY.presentation();
        Set swimlaneValues = CollectionsKt.intersect((Iterable)possibleValues, (Iterable)SetsKt.setOf((Object[])new String[]{feature, userStory}));
        if (swimlaneValues.isEmpty() && CollectionUtilKt.isNotEmpty((Iterable)possibleValues)) {
            swimlaneValues = SetsKt.setOf((Object)CollectionsKt.first((Iterable)possibleValues));
        }
        result2.setStringValues(swimlaneValues);
        Iterable $this$filter$iv = possibleValues;
        boolean $i$f$filter = false;
        Iterable iterable3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!swimlaneValues.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List possibleTaskValues = (List)destination$iv$iv;
        $this$filter$iv = possibleTaskValues;
        boolean bl = false;
        if (!$this$filter$iv.isEmpty()) {
            Locale locale2 = LocaleUtil.DEFAULT_LOCALE;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"LocaleUtil.DEFAULT_LOCALE");
            String task = IssueTypeSuppliedField.Types.TASK.presentation(locale2);
            if (possibleValues.contains(task)) {
                result2.setDefaultCardType(task);
            } else {
                result2.setDefaultCardType((String)CollectionsKt.first((Iterable)possibleValues));
            }
        }
        return (XdSwimlaneSettings)result2;
    }

    @NotNull
    public final XdAgile createAgile(@NotNull String name2, @NotNull Iterable<XdProject> projects2, @NotNull XdUser creator) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        return this.getBuilderNoBacklog(CollectionsKt.toList(projects2), creator).withName(name2).withVisibleFor(new AgileAccessSettings(true)).withUpdatableBy(new AgileAccessSettings(true)).withBacklog(this.getBacklog(projects2, name2, creator)).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final XdCustomFieldPrototype getEstimationField(Iterable<XdProject> projects2, XdUser currentUser) {
        XdCustomFieldPrototype element$iv;
        XdCustomFieldPrototype xdCustomFieldPrototype;
        boolean bl;
        Iterable<XdCustomFieldPrototype> $this$firstOrNull$iv = AgileFieldsUtilKt.getAvailableEstimationFields(projects2, currentUser);
        boolean $i$f$firstOrNull = false;
        Iterator<XdCustomFieldPrototype> iterator2 = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator2.hasNext()) {
                xdCustomFieldPrototype = null;
                return xdCustomFieldPrototype;
            }
            XdCustomFieldPrototype it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (XdCustomFieldPrototypeKt.isEstimationField((XdCustomFieldPrototype)it)) {
                String string = it.getName();
                String string2 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getDefaultMsg("youtrack.timetracking.estimation", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.getDefaultMsg(Localization.estimation)");
                if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        xdCustomFieldPrototype = element$iv;
        return xdCustomFieldPrototype;
    }

    private ScrumAgileTemplate() {
    }

    static {
        ScrumAgileTemplate scrumAgileTemplate;
        INSTANCE = scrumAgileTemplate = new ScrumAgileTemplate();
        name = name;
    }
}

