/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import jetbrains.youtrack.search.date.DateNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 .2\u00020\u0001:\u0002./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 J \u0010!\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bJ \u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002J(\u0010,\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002J\u000e\u0010-\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u0004R\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\nR\u0011\u0010\u001c\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\n\u00a8\u00060"}, d2={"Ljetbrains/youtrack/search/date/DateLiteral;", "", "node", "Ljetbrains/youtrack/search/date/DateNode;", "(Ljetbrains/youtrack/search/date/DateNode;)V", "data", "", "day", "", "getDay", "()I", "daysInMoth", "getDaysInMoth", "format", "", "getFormat", "()Ljava/lang/String;", "hour", "getHour", "minute", "getMinute", "month", "getMonth", "getNode", "()Ljetbrains/youtrack/search/date/DateNode;", "setNode", "second", "getSecond", "year", "getYear", "getSuggestion", "timeZone", "Ljava/util/TimeZone;", "getValue", "index", "length", "setDigit", "", "digit", "setInRange", "calendar", "Ljava/util/Calendar;", "calendarField", "value", "setValue", "toCalendar", "Companion", "Type", "youtrack-search"})
public final class DateLiteral {
    private final byte[] data;
    @NotNull
    private DateNode node;
    public static final int YEAR_INDEX = 0;
    public static final int YEAR_LENGTH = 4;
    public static final int MONTH_INDEX = 4;
    public static final int MONTH_LENGTH = 2;
    public static final int DAY_INDEX = 6;
    public static final int DAY_LENGTH = 2;
    public static final int HOUR_INDEX = 8;
    public static final int HOUR_LENGTH = 2;
    public static final int MINUTE_INDEX = 10;
    public static final int MINUTE_LENGTH = 2;
    public static final int SECOND_INDEX = 12;
    public static final int SECOND_LENGTH = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getFormat() {
        return this.node.getFormatPresentation(this);
    }

    public final int getDaysInMoth() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        if (this.getYear() != -1) {
            calendar.set(1, this.getYear());
        }
        if (this.getMonth() != -1) {
            calendar.set(2, this.getMonth() - 1);
        }
        return calendar.getActualMaximum(5);
    }

    public final int getYear() {
        return this.getValue(this.data, 0, 4);
    }

    public final int getMonth() {
        return this.getValue(this.data, 4, 2);
    }

    public final int getDay() {
        return this.getValue(this.data, 6, 2);
    }

    public final int getHour() {
        return this.getValue(this.data, 8, 2);
    }

    public final int getMinute() {
        return this.getValue(this.data, 10, 2);
    }

    public final int getSecond() {
        return this.getValue(this.data, 12, 2);
    }

    @NotNull
    public final String getSuggestion(@NotNull TimeZone timeZone) {
        Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
        Calendar calendar = this.toCalendar(timeZone);
        String format = this.node.getSuggestionFormat(this);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(timeZone);
        String string = formatter.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter.format(calendar.time)");
        return string;
    }

    public final void setDigit(int index, int digit) {
        this.data[index] = (byte)digit;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Calendar toCalendar(@NotNull TimeZone timeZone) {
        Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        byte[] current = new byte[14];
        this.setValue(current, 0, 4, calendar.get(1));
        this.setValue(current, 4, 2, calendar.get(2) + 1);
        this.setValue(current, 6, 2, calendar.get(5));
        this.setValue(current, 8, 2, calendar.get(11));
        this.setValue(current, 10, 2, calendar.get(12));
        this.setValue(current, 12, 2, calendar.get(13));
        int n = 0;
        int n2 = this.data.length;
        while (n < n2) {
            void i;
            if (this.data[i] != -1) {
                current[i] = this.data[i];
            }
            ++i;
        }
        calendar.set(5, 1);
        int value = this.getValue(current, 0, 4);
        calendar.set(1, value);
        value = this.getValue(current, 4, 2);
        this.setInRange(calendar, 2, value - 1);
        value = this.getValue(current, 6, 2);
        this.setInRange(calendar, 5, value);
        value = this.getValue(current, 8, 2);
        this.setInRange(calendar, 11, value);
        value = this.getValue(current, 10, 2);
        this.setInRange(calendar, 12, value);
        value = this.getValue(current, 12, 2);
        this.setInRange(calendar, 13, value);
        return calendar;
    }

    private final void setInRange(Calendar calendar, int calendarField, int value) {
        int min = calendar.getActualMinimum(calendarField);
        int max = calendar.getActualMaximum(calendarField);
        calendar.set(calendarField, Math.max(min, Math.min(value, max)));
    }

    /*
     * WARNING - void declaration
     */
    private final int getValue(byte[] data, int index, int length) {
        int value = -1;
        if (data[index] != -1) {
            value = 0;
            int n = index;
            int n2 = index + length;
            while (n < n2) {
                void i;
                byte d2 = data[i];
                value = value * 10 + (d2 != -1 ? d2 : (byte)0);
                ++i;
            }
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private final void setValue(byte[] data, int index, int length, int value) {
        int currentValue = value;
        int n = index + length - 1;
        int n2 = index;
        if (n >= n2) {
            while (true) {
                void i;
                data[i] = (byte)(currentValue % 10);
                currentValue /= 10;
                if (i == n2) break;
                --i;
            }
        }
    }

    @NotNull
    public final DateNode getNode() {
        return this.node;
    }

    public final void setNode(@NotNull DateNode dateNode) {
        Intrinsics.checkParameterIsNotNull((Object)dateNode, (String)"<set-?>");
        this.node = dateNode;
    }

    /*
     * WARNING - void declaration
     */
    public DateLiteral(@NotNull DateNode node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        this.node = node2;
        this.data = new byte[14];
        int n = 0;
        int n2 = this.data.length;
        while (n < n2) {
            void i;
            this.data[i] = (byte)-1;
            ++i;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/search/date/DateLiteral$Type;", "", "(Ljava/lang/String;I)V", "YEAR", "MONTH", "HOUR", "youtrack-search"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type YEAR;
        public static final /* enum */ Type MONTH;
        public static final /* enum */ Type HOUR;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = YEAR = new Type();
            typeArray[1] = MONTH = new Type();
            typeArray[2] = HOUR = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/search/date/DateLiteral$Companion;", "", "()V", "DAY_INDEX", "", "DAY_LENGTH", "HOUR_INDEX", "HOUR_LENGTH", "MINUTE_INDEX", "MINUTE_LENGTH", "MONTH_INDEX", "MONTH_LENGTH", "SECOND_INDEX", "SECOND_LENGTH", "YEAR_INDEX", "YEAR_LENGTH", "youtrack-search"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

