/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date.period;

import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.search.date.period.DayOfWeekPeriod;
import jetbrains.youtrack.search.date.period.DayPeriod;
import jetbrains.youtrack.search.date.period.MonthPeriod;
import jetbrains.youtrack.search.date.period.NamedDatePeriod;
import jetbrains.youtrack.search.date.period.NamedDatePeriodKt;
import jetbrains.youtrack.search.date.period.WeekPeriod;
import jetbrains.youtrack.search.date.period.YearPeriod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0004H\u0017J\b\u0010\u0006\u001a\u00020\u0004H\u0017J\b\u0010\u0007\u001a\u00020\u0004H\u0017J\b\u0010\b\u001a\u00020\u0004H\u0017J\b\u0010\t\u001a\u00020\u0004H\u0017J\b\u0010\n\u001a\u00020\u0004H\u0017J\b\u0010\u000b\u001a\u00020\u0004H\u0017J\b\u0010\f\u001a\u00020\u0004H\u0017J\b\u0010\r\u001a\u00020\u0004H\u0017J\b\u0010\u000e\u001a\u00020\u0004H\u0017J\b\u0010\u000f\u001a\u00020\u0004H\u0017J\b\u0010\u0010\u001a\u00020\u0004H\u0017J\b\u0010\u0011\u001a\u00020\u0004H\u0017J\b\u0010\u0012\u001a\u00020\u0004H\u0017J\b\u0010\u0013\u001a\u00020\u0004H\u0017J\b\u0010\u0014\u001a\u00020\u0004H\u0017J\b\u0010\u0015\u001a\u00020\u0004H\u0017J\b\u0010\u0016\u001a\u00020\u0004H\u0017J\b\u0010\u0017\u001a\u00020\u0004H\u0017J\b\u0010\u0018\u001a\u00020\u0004H\u0017J\b\u0010\u0019\u001a\u00020\u0004H\u0017J\b\u0010\u001a\u001a\u00020\u0004H\u0017J\b\u0010\u001b\u001a\u00020\u0004H\u0017\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/search/date/period/DatePeriodsConfiguration;", "", "()V", "getFriday", "Ljetbrains/youtrack/search/date/period/NamedDatePeriod;", "getLastMonth", "getLastWeek", "getLastWorkingDay", "getLastYear", "getMonday", "getNewer", "getNextMonth", "getNextWeek", "getNextYear", "getOlder", "getSaturday", "getSunday", "getThisMonth", "getThisWeek", "getThisYear", "getThreeWeeksAgo", "getThursday", "getToday", "getTomorrow", "getTuesday", "getTwoWeeksAgo", "getWednesday", "getYesterday", "youtrack-search"})
public class DatePeriodsConfiguration {
    @Bean(value={"todayPeriod"})
    @NotNull
    public NamedDatePeriod getToday() {
        return new DayPeriod("youtrack.dateperiod.today", 0){

            @NotNull
            protected DateTime getDay() {
                return new DateTime(this.getCurrentTimeZone());
            }
        };
    }

    @Bean(value={"tomorrowPeriod"})
    @NotNull
    public NamedDatePeriod getTomorrow() {
        return new DayPeriod("youtrack.dateperiod.tomorrow", 1){

            @NotNull
            protected DateTime getDay() {
                DateTime dateTime = new DateTime(this.getCurrentTimeZone()).plusDays(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(currentTimeZone).plusDays(1)");
                return dateTime;
            }
        };
    }

    @Bean(value={"yesterdayPeriod"})
    @NotNull
    public NamedDatePeriod getYesterday() {
        return new DayPeriod("youtrack.dateperiod.yesterday", 2){

            @NotNull
            protected DateTime getDay() {
                DateTime dateTime = new DateTime(this.getCurrentTimeZone()).minusDays(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(currentTimeZone).minusDays(1)");
                return dateTime;
            }
        };
    }

    @Bean(value={"mondayPeriod"})
    @NotNull
    public NamedDatePeriod getMonday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.monday", 3, 1);
    }

    @Bean(value={"tuesdayPeriod"})
    @NotNull
    public NamedDatePeriod getTuesday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.tuesday", 4, 2);
    }

    @Bean(value={"wednesdayPeriod"})
    @NotNull
    public NamedDatePeriod getWednesday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.wednesday", 5, 3);
    }

    @Bean(value={"thursdayPeriod"})
    @NotNull
    public NamedDatePeriod getThursday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.thursday", 6, 4);
    }

    @Bean(value={"fridayPeriod"})
    @NotNull
    public NamedDatePeriod getFriday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.friday", 7, 5);
    }

    @Bean(value={"saturdayPeriod"})
    @NotNull
    public NamedDatePeriod getSaturday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.saturday", 8, 6);
    }

    @Bean(value={"sundayPeriod"})
    @NotNull
    public NamedDatePeriod getSunday() {
        return new DayOfWeekPeriod("youtrack.dateperiod.sunday", 9, 7);
    }

    @Bean(value={"thisWeekPeriod"})
    @NotNull
    public NamedDatePeriod getThisWeek() {
        return new WeekPeriod("youtrack.dateperiod.this_week", 10, 0);
    }

    @Bean(value={"nextWeekPeriod"})
    @NotNull
    public NamedDatePeriod getNextWeek() {
        return new WeekPeriod("youtrack.dateperiod.next_week", 11, -1);
    }

    @Bean(value={"lastWeekPeriod"})
    @NotNull
    public NamedDatePeriod getLastWeek() {
        return new WeekPeriod("youtrack.dateperiod.last_week", 12, 1);
    }

    @Bean
    @NotNull
    public NamedDatePeriod getTwoWeeksAgo() {
        return new WeekPeriod("youtrack.dateperiod.two_weeks_ago", 13, 2);
    }

    @Bean
    @NotNull
    public NamedDatePeriod getThreeWeeksAgo() {
        return new WeekPeriod("youtrack.dateperiod.three_weeks_ago", 14, 3);
    }

    @Bean(value={"thisMonthPeriod"})
    @NotNull
    public NamedDatePeriod getThisMonth() {
        return new MonthPeriod("youtrack.dateperiod.this_month", 15, 0);
    }

    @Bean(value={"lastMonthPeriod"})
    @NotNull
    public NamedDatePeriod getLastMonth() {
        return new MonthPeriod("youtrack.dateperiod.last_month", 16, 1);
    }

    @Bean(value={"nextMonthPeriod"})
    @NotNull
    public NamedDatePeriod getNextMonth() {
        return new MonthPeriod("youtrack.dateperiod.next_month", 17, -1);
    }

    @Bean(value={"olderPeriod"})
    @NotNull
    public NamedDatePeriod getOlder() {
        return new MonthPeriod("youtrack.dateperiod.older", 18, 2){

            public long getFrom() {
                return Long.MIN_VALUE;
            }

            @NotNull
            public String getDescription() {
                String string = BeansKt.getLocalizer().localizedMsg("NamedDatePeriod.Before_{0}", new Object[]{NamedDatePeriodKt.printHumanDate(this.getTo())});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026{0}\", printHumanDate(to))");
                return string;
            }
        };
    }

    @Bean(value={"thisYearPeriod"})
    @NotNull
    public NamedDatePeriod getThisYear() {
        return new YearPeriod(19, 0);
    }

    @Bean(value={"nextYearPeriod"})
    @NotNull
    public NamedDatePeriod getNextYear() {
        return new YearPeriod(20, -1);
    }

    @Bean(value={"lastYearPeriod"})
    @NotNull
    public NamedDatePeriod getLastYear() {
        return new YearPeriod(21, 1);
    }

    @Bean(value={"lastWorkingDayPeriod"})
    @NotNull
    public NamedDatePeriod getLastWorkingDay() {
        return new DayPeriod("youtrack.dateperiod.last_working_day", 22){

            @NotNull
            protected DateTime getDay() {
                return jetbrains.charisma.timetracking.BeansKt.getTimeTrackingProvider().getLastWorkingDay();
            }
        };
    }

    @Bean(value={"newerPeriod"})
    @NotNull
    public NamedDatePeriod getNewer() {
        return new MonthPeriod("youtrack.dateperiod.newer", 23, 0){

            public long getTo() {
                return Long.MAX_VALUE;
            }

            @NotNull
            public String getDescription() {
                String string = BeansKt.getLocalizer().localizedMsg("NamedDatePeriod.Before_{0}", new Object[]{NamedDatePeriodKt.printHumanDate(this.getTo())});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026{0}\", printHumanDate(to))");
                return string;
            }
        };
    }
}

