/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date.period;

import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.search.date.period.NamedDatePeriod;
import jetbrains.youtrack.search.date.period.NamedDatePeriodKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/search/date/period/MonthPeriod;", "Ljetbrains/youtrack/search/date/period/NamedDatePeriod;", "name", "", "ordinal", "", "ago", "(Ljava/lang/String;II)V", "description", "getDescription", "()Ljava/lang/String;", "from", "", "getFrom", "()J", "month", "Lorg/joda/time/DateTime;", "getMonth", "()Lorg/joda/time/DateTime;", "referenceDate", "getReferenceDate", "to", "getTo", "youtrack-search"})
public class MonthPeriod
extends NamedDatePeriod {
    private final int ago;

    private final DateTime getMonth() {
        DateTime dateTime = new DateTime(this.getCurrentTimeZone()).minusMonths(this.ago);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(currentTimeZone).minusMonths(ago)");
        return dateTime;
    }

    public long getFrom() {
        DateTime dateTime = this.getMonth().dayOfMonth().withMinimumValue().millisOfDay().withMinimumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"month.dayOfMonth().withM\u2026fDay().withMinimumValue()");
        return dateTime.getMillis();
    }

    public long getTo() {
        DateTime dateTime = this.getMonth().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"month.dayOfMonth().withM\u2026fDay().withMaximumValue()");
        return dateTime.getMillis();
    }

    @NotNull
    public DateTime getReferenceDate() {
        DateTime dateTime = this.getMonth().withDayOfMonth(1).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"month.withDayOfMonth(1).withTimeAtStartOfDay()");
        return dateTime;
    }

    @NotNull
    public String getDescription() {
        String string = BeansKt.getLocalizer().localizedMsg("NamedDatePeriod.Period_from_{0}_to_{1}_for_month_period", new Object[]{NamedDatePeriodKt.printHumanDate(this.getFrom()), NamedDatePeriodKt.printHumanDate(this.getTo())});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026manDate(to)\n            )");
        return string;
    }

    public MonthPeriod(@NotNull String name, int ordinal, int ago) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name, ordinal);
        this.ago = ago;
    }
}

