/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date.period;

import jetbrains.youtrack.search.date.period.NamedDatePeriod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/search/date/period/YearPeriod;", "Ljetbrains/youtrack/search/date/period/NamedDatePeriod;", "ordinal", "", "ago", "(II)V", "description", "", "getDescription", "()Ljava/lang/String;", "from", "", "getFrom", "()J", "referenceDate", "Lorg/joda/time/DateTime;", "getReferenceDate", "()Lorg/joda/time/DateTime;", "to", "getTo", "year", "getYear", "youtrack-search"})
public class YearPeriod
extends NamedDatePeriod {
    private final int ago;

    private final DateTime getYear() {
        DateTime dateTime = new DateTime(this.getCurrentTimeZone()).minusYears(this.ago);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(currentTimeZone).minusYears(ago)");
        return dateTime;
    }

    @NotNull
    public String getDescription() {
        return "does not matter";
    }

    public long getFrom() {
        DateTime dateTime = this.getYear().dayOfYear().withMinimumValue().millisOfDay().withMinimumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"year.dayOfYear().withMin\u2026fDay().withMinimumValue()");
        return dateTime.getMillis();
    }

    public long getTo() {
        DateTime dateTime = this.getYear().dayOfYear().withMaximumValue().millisOfDay().withMaximumValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"year.dayOfYear().withMax\u2026fDay().withMaximumValue()");
        return dateTime.getMillis();
    }

    @NotNull
    public DateTime getReferenceDate() {
        DateTime dateTime = this.getYear().withDayOfYear(1).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"year.withDayOfYear(1).withTimeAtStartOfDay()");
        return dateTime;
    }

    public YearPeriod(int ordinal, int ago) {
        super(null, ordinal);
        this.ago = ago;
    }
}

