/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.executor;

import java.util.Arrays;
import java.util.List;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.links.LinkTypeField;
import jetbrains.charisma.links.persistent.DirectedLink;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.persistent.project.ProjectFieldValue;
import jetbrains.charisma.persistent.security.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.context.Context;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.persistent.XdIssueTagKt;
import jetbrains.youtrack.search.parser.SearchRequestExecutor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010\u001bJ[\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0018\u00010 2\u0012\u0010\"\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0018\u00010 2\u0006\u0010#\u001a\u00020\u00022\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%H\u0014\u00a2\u0006\u0002\u0010(J+\u0010)\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010#\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010+J\u001d\u0010,\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010-J\r\u0010.\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010/\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\u0018\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u00063"}, d2={"Ljetbrains/youtrack/search/executor/MakeSatisfyQueryRequestExecutor;", "Ljetbrains/youtrack/search/parser/SearchRequestExecutor;", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;)V", "getIssue", "()Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "setIssue", "and", "left", "right", "(ZZ)Ljava/lang/Boolean;", "empty", "()Ljava/lang/Boolean;", "filterContextIssueFolder", "folder", "Ljetbrains/youtrack/core/persistent/issue/XdIssueFolder;", "context", "Ljetbrains/youtrack/api/context/IContext;", "me", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/youtrack/core/persistent/issue/XdIssueFolder;Ljetbrains/youtrack/api/context/IContext;Ljetbrains/exodus/entitystore/Entity;)Ljava/lang/Boolean;", "filterText", "pos", "query", "", "(ZLjava/lang/String;)Ljava/lang/Boolean;", "getRangeValue", "field", "Ljetbrains/youtrack/api/parser/IField;", "leftValues", "", "Ljetbrains/youtrack/api/parser/IFieldValue;", "rightValues", "nodeIsPos", "assertMaxValues", "Lkotlin/Function1;", "", "", "(Ljetbrains/youtrack/api/parser/IField;Ljava/util/List;Ljava/util/List;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Boolean;", "getValue", "value", "(Ljetbrains/youtrack/api/parser/IField;Ljetbrains/youtrack/api/parser/IFieldValue;Z)Ljava/lang/Boolean;", "hasField", "(Ljetbrains/youtrack/api/parser/IField;Z)Ljava/lang/Boolean;", "merge", "or", "tryAddLink", "link", "Ljetbrains/charisma/links/LinkTypeField;", "youtrack-search"})
public final class MakeSatisfyQueryRequestExecutor
extends SearchRequestExecutor<Boolean> {
    @NotNull
    private XdIssue issue;

    @Override
    @Nullable
    protected Boolean filterContextIssueFolder(@NotNull XdIssueFolder folder2, @NotNull IContext context, @NotNull Entity me) {
        Intrinsics.checkParameterIsNotNull((Object)folder2, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        return true;
    }

    @Override
    @NotNull
    protected Boolean getValue(@NotNull IField field, @Nullable IFieldValue<?> value, boolean nodeIsPos) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (!nodeIsPos) {
            return false;
        }
        if (field.isPrototyped()) {
            Entity entity = field.getCustomFieldPrototype();
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            XdCustomFieldPrototype proto = (XdCustomFieldPrototype)XdExtensionsKt.toXd((Entity)entity);
            XdProjectCustomField xdProjectCustomField = proto.getProjectCustomField(this.issue.getProject());
            if (xdProjectCustomField == null) {
                return false;
            }
            XdProjectCustomField projectCustomField = xdProjectCustomField;
            if (!XdProjectCustomField.isAccessibleInIssue$default((XdProjectCustomField)projectCustomField, (Operation)Operation.UPDATE, (XdIssue)this.issue, null, (int)4, null)) {
                throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("MakeSatisfyQeuryRequestExecutor.You_don_t_have_write_access_to_some_of_issue_fields", new Object[0]));
            }
        }
        if (field == jetbrains.charisma.keyword.BeansKt.getPredefinedFieldProject()) {
            IFieldValue<?> iFieldValue = value;
            if (iFieldValue == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.persistent.project.ProjectFieldValue");
            }
            ProjectFieldValue project = (ProjectFieldValue)iFieldValue;
            return Intrinsics.areEqual((Object)project.getMatchingProject(), (Object)this.issue.getProject());
        }
        if (field == jetbrains.charisma.keyword.BeansKt.getPredefinedFieldVisibleTo()) {
            IFieldValue<?> iFieldValue = value;
            Object object = iFieldValue != null ? iFieldValue.getFieldValue() : null;
            if (!(object instanceof XdUserGroup)) {
                object = null;
            }
            XdUserGroup group = (XdUserGroup)object;
            Context context = new Context();
            context.setSelectedIssues((Iterable)CollectionsKt.listOf((Object)this.issue));
            if (group != null && CollectionsKt.contains((Iterable)BeansKt.getVisibilityOptionsProviderFactory().getProvider().getAllGroups((IContext)context), (Object)group)) {
                this.issue.getPermittedGroup().add((XdEntity)group);
            }
            return true;
        }
        if (field instanceof LinkTypeField) {
            IFieldValue<?> iFieldValue = value;
            Object object = iFieldValue != null ? iFieldValue.getFieldValue() : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.core.persistent.issue.XdIssue");
            }
            return this.tryAddLink((LinkTypeField)field, (XdIssue)object);
        }
        if (field == jetbrains.charisma.keyword.BeansKt.getPredefinedFieldTag()) {
            Object object = value;
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            Object name = object;
            XdIssueTagKt.addTag$default((XdIssue)this.issue, name, null, (int)2, null);
            return true;
        }
        return field.setIssueValue(this.issue, value, this.getContext(), this.getMe());
    }

    @Override
    @NotNull
    protected Boolean and(boolean left, boolean right) {
        return left && right;
    }

    @Override
    @NotNull
    protected Boolean or(boolean left, boolean right) {
        return left || right;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Boolean getRangeValue(@NotNull IField field, @Nullable List<? extends IFieldValue<?>> leftValues, @Nullable List<? extends IFieldValue<?>> rightValues, boolean nodeIsPos, @NotNull Function1<? super Integer, Unit> assertMaxValues) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull(assertMaxValues, (String)"assertMaxValues");
        Boolean result = null;
        boolean bl = false;
        List list = leftValues;
        if (list == null) {
            boolean bl2 = false;
            list = CollectionsKt.emptyList();
        }
        for (IFieldValue leftValue : (Iterable)list) {
            void values;
            assertMaxValues.invoke((Object)((int)(values + true)));
            result = (Boolean)this.union(result, this.getValue(field, leftValue, nodeIsPos));
            ++values;
        }
        return result;
    }

    private final boolean tryAddLink(LinkTypeField link, XdIssue issue) {
        XdProject[] xdProjectArray;
        XdProject linkedProject;
        XdProject project = this.issue.getProject();
        if (Intrinsics.areEqual((Object)project, (Object)(linkedProject = issue.getProject()))) {
            XdProject[] xdProjectArray2 = new XdProject[1];
            xdProjectArray = xdProjectArray2;
            xdProjectArray2[0] = project;
        } else {
            XdProject[] xdProjectArray3 = new XdProject[2];
            xdProjectArray3[0] = linkedProject;
            xdProjectArray = xdProjectArray3;
            xdProjectArray3[1] = project;
        }
        XdProject[] projects = xdProjectArray;
        if (!this.getMe().hasPermissionInProject(Permission.LINK_ISSUE, Arrays.copyOf(projects, projects.length))) {
            return false;
        }
        DirectedLink directedLink = link.getLink();
        if (directedLink.getDirection() != LinkDirection.INWARD) {
            Entity entity = directedLink.getPrototype();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"directedLink.prototype");
            ((XdIssueLinkPrototype)XdExtensionsKt.toXd((Entity)entity)).link(this.issue, issue);
        } else {
            Entity entity = directedLink.getPrototype();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"directedLink.prototype");
            ((XdIssueLinkPrototype)XdExtensionsKt.toXd((Entity)entity)).link(issue, this.issue);
        }
        return true;
    }

    @Override
    @NotNull
    protected Boolean merge() {
        boolean result = true;
        for (String filterGroup : CollectionsKt.union((Iterable)this.getPos().keySet(), (Iterable)this.getNeg().keySet())) {
            Boolean bl = (Boolean)this.getPos().get(filterGroup);
            boolean p = bl != null ? bl : true;
            Boolean bl2 = (Boolean)this.getNeg().get(filterGroup);
            boolean n = bl2 != null ? bl2 : false;
            result = result && p && !n;
        }
        return result;
    }

    @Override
    @NotNull
    protected Boolean empty() {
        return true;
    }

    @Override
    @NotNull
    protected Boolean filterText(boolean pos, @NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return false;
    }

    @Override
    @NotNull
    protected Boolean hasField(@NotNull IField field, boolean nodeIsPos) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return field.addHasField(this.issue, nodeIsPos);
    }

    @NotNull
    public final XdIssue getIssue() {
        return this.issue;
    }

    public final void setIssue(@NotNull XdIssue xdIssue) {
        Intrinsics.checkParameterIsNotNull((Object)xdIssue, (String)"<set-?>");
        this.issue = xdIssue;
    }

    public MakeSatisfyQueryRequestExecutor(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        this.issue = issue;
    }
}

