/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.parser.search.IssueQuerySatisfier;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.IParseResult;
import jetbrains.youtrack.api.parser.Parser;
import jetbrains.youtrack.context.Context;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.search.executor.MakeSatisfyQueryRequestExecutor;
import jetbrains.youtrack.search.parser.ASTUtilKt;
import jetbrains.youtrack.search.parser.ParserImpl;
import jetbrains.youtrack.search.parser.SearchRequestNode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="issueQuerySatisfier")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/search/parser/IssueQuerySatisfierImpl;", "Ljetbrains/charisma/parser/search/IssueQuerySatisfier;", "()V", "makeIssueSatisfyQuery", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "query", "", "contextFolders", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssueFolder;", "Companion", "youtrack-search"})
public final class IssueQuerySatisfierImpl
implements IssueQuerySatisfier {
    public static final Companion Companion = new Companion(null);

    public void makeIssueSatisfyQuery(@NotNull XdIssue issue, @NotNull String query, @NotNull Iterable<? extends XdIssueFolder> contextFolders) {
        XdUser currentUser;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(contextFolders, (String)"contextFolders");
        IContext context = (IContext)new Context();
        Parser parser = BeansKt.getParser();
        if (parser == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.search.parser.ParserImpl");
        }
        IParseResult parseResult = ((ParserImpl)parser).parse((Iterable)contextFolders, query, context);
        if (parseResult.matchesIssue(issue, context, currentUser = BeansKt.getXdLoggedInUser())) {
            return;
        }
        if (!CollectionUtilKt.isEmpty(parseResult.getParseErrors(context, currentUser))) {
            return;
        }
        SearchRequestNode req = parseResult.getAst();
        Sequence<SearchRequestNode> acceptableRequests = ASTUtilKt.getSearchRequestPartWithoutDifferentProject(req, issue.getProject());
        for (SearchRequestNode searchRequestPart : acceptableRequests) {
            context = (IContext)new Context();
            new MakeSatisfyQueryRequestExecutor(issue).filter(searchRequestPart, context, currentUser.getEntity());
            if (!parseResult.matchesIssue(issue, context, currentUser)) continue;
            return;
        }
        Companion.getLogger().warn("Failed to make issue satisfy query {" + query + '}');
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/search/parser/IssueQuerySatisfierImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-search"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

