/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.HeavyRequestException;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IParseResult;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.search.executor.HeavySearchRequestExecutorFactory;
import jetbrains.youtrack.search.executor.IssuesSearchRequestExecutor;
import jetbrains.youtrack.search.executor.MatchesSearchRequestExecutor;
import jetbrains.youtrack.search.parser.ASTUtilExtKt;
import jetbrains.youtrack.search.parser.ComplexityAnalyzerKt;
import jetbrains.youtrack.search.parser.ErrorAnalyzerKt;
import jetbrains.youtrack.search.parser.ParseErrorImpl;
import jetbrains.youtrack.search.parser.SearchRequestExecutor;
import jetbrains.youtrack.search.parser.SearchRequestNode;
import jetbrains.youtrack.search.parser.TextSearchAnalyzer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J0\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010(\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\u0011H\u0016J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010+\u001a\u00020\u000eH\u0016J\b\u0010,\u001a\u00020\u000eH\u0016J \u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Ljetbrains/youtrack/search/parser/ParseResult;", "Ljetbrains/youtrack/api/parser/IParseResult;", "inputQuery", "", "(Ljava/lang/String;)V", "ast", "Ljetbrains/youtrack/search/parser/SearchRequestNode;", "getAst", "()Ljetbrains/youtrack/search/parser/SearchRequestNode;", "setAst", "(Ljetbrains/youtrack/search/parser/SearchRequestNode;)V", "getInputQuery", "()Ljava/lang/String;", "isComplexRequest", "", "()Z", "savedQueries", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssueFolder;", "getSavedQueries", "()Ljava/lang/Iterable;", "extractPositiveProjectsWithContext", "", "Ljetbrains/exodus/entitystore/EntityId;", "executor", "Ljetbrains/youtrack/search/executor/IssuesSearchRequestExecutor;", "context", "Ljetbrains/youtrack/api/context/IContext;", "getIssues", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "me", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "getIssuesAndPositiveProjects", "Lkotlin/Pair;", "getLooksLikeSearch", "field", "Ljetbrains/youtrack/api/parser/IField;", "getParseErrors", "Ljetbrains/youtrack/search/parser/ParseErrorImpl;", "getSyntaxErrors", "getTextSearch", "", "hasAndExpression", "hasOrExpression", "matchesIssue", "issue", "Companion", "youtrack-search"})
public final class ParseResult
implements IParseResult {
    @NotNull
    public SearchRequestNode ast;
    @NotNull
    private final String inputQuery;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SearchRequestNode getAst() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return searchRequestNode;
    }

    public void setAst(@NotNull SearchRequestNode searchRequestNode) {
        Intrinsics.checkParameterIsNotNull((Object)searchRequestNode, (String)"<set-?>");
        this.ast = searchRequestNode;
    }

    @NotNull
    public XdQuery<XdIssue> getIssues(@NotNull IContext context, @NotNull XdUser me) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        return this.getIssues(new IssuesSearchRequestExecutor(), context, me);
    }

    @NotNull
    public Pair<XdQuery<XdIssue>, Set<EntityId>> getIssuesAndPositiveProjects(@NotNull IContext context, @NotNull XdUser me) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        IssuesSearchRequestExecutor executor = new IssuesSearchRequestExecutor();
        XdQuery<XdIssue> issues = this.getIssues(executor, context, me);
        return TuplesKt.to(issues, this.extractPositiveProjectsWithContext(executor, context));
    }

    private final Set<EntityId> extractPositiveProjectsWithContext(IssuesSearchRequestExecutor executor, IContext context) {
        Set result = executor.getPositiveProjectIds();
        if (context != null) {
            Set contextIds = context.getPositiveProjectIds();
            if (result.isEmpty()) {
                result = contextIds;
            } else {
                Collection collection = contextIds;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    result = new HashSet(result);
                    ((HashSet)result).addAll(contextIds);
                }
            }
        }
        return result;
    }

    private final XdQuery<XdIssue> getIssues(IssuesSearchRequestExecutor executor, IContext context, XdUser me) {
        XdQuery xdQuery;
        try {
            xdQuery = XdQueryKt.asQuery((Iterable)((Iterable)executor.filter(this.getAst(), context, me.getEntity())), (XdEntityType)((XdEntityType)XdIssue.Companion));
        }
        catch (HeavyRequestException e) {
            xdQuery = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdIssue.Companion));
        }
        return xdQuery;
    }

    public boolean matchesIssue(@NotNull XdIssue issue, @NotNull IContext context, @NotNull XdUser me) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        try {
            bl = (Boolean)new MatchesSearchRequestExecutor(issue).filter(this.getAst(), context, me.getEntity());
        }
        catch (HeavyRequestException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public Collection<String> getTextSearch(@Nullable IField field) {
        return TextSearchAnalyzer.Companion.getTextSearch(this.getAst(), field);
    }

    @NotNull
    public XdQuery<XdIssue> getLooksLikeSearch(@NotNull IField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return XdQueryKt.asQuery(TextSearchAnalyzer.Companion.getLooksLikeSearch(this.getAst(), field), (XdEntityType)((XdEntityType)XdIssue.Companion));
    }

    @Nullable
    public Iterable<ParseErrorImpl> getParseErrors(@NotNull IContext context, @NotNull XdUser me) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        Iterable<ParseErrorImpl> parseErrors = this.getSyntaxErrors();
        if (CollectionUtilKt.isEmpty(parseErrors)) {
            try {
                SearchRequestExecutor<List<String>> executor = Companion.getHeavySearchRequestExecutorFactory().createExecutor();
                List<String> result = executor.filter(this.getAst(), context, me.getEntity());
                Collection collection = result;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    ArrayList<ParseErrorImpl> errors = new ArrayList<ParseErrorImpl>();
                    for (String e : result) {
                        errors.add(new ParseErrorImpl(e));
                    }
                    return errors;
                }
            }
            catch (HeavyRequestException e) {
                Companion.getLogger().warn("Can't check search request for errors: " + e.getMessage());
            }
        }
        return parseErrors;
    }

    @Nullable
    public Iterable<ParseErrorImpl> getSyntaxErrors() {
        Sequence<ParseErrorImpl> sequence = ErrorAnalyzerKt.getParseErrors(this.getAst());
        return sequence != null ? SequencesKt.asIterable(sequence) : null;
    }

    public boolean isComplexRequest() {
        return ComplexityAnalyzerKt.isComplexRequest(this.getAst());
    }

    public boolean hasOrExpression() {
        return ASTUtilExtKt.hasOrExpression(this.getAst());
    }

    public boolean hasAndExpression() {
        return ASTUtilExtKt.hasAndExpression(this.getAst());
    }

    @NotNull
    public Iterable<XdIssueFolder> getSavedQueries() {
        return SequencesKt.asIterable(ASTUtilExtKt.getSavedQueries(this.getAst()));
    }

    @NotNull
    public String getInputQuery() {
        return this.inputQuery;
    }

    public ParseResult(@NotNull String inputQuery) {
        Intrinsics.checkParameterIsNotNull((Object)inputQuery, (String)"inputQuery");
        this.inputQuery = inputQuery;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/search/parser/ParseResult$Companion;", "Lmu/KLogging;", "()V", "heavySearchRequestExecutorFactory", "Ljetbrains/youtrack/search/executor/HeavySearchRequestExecutorFactory;", "getHeavySearchRequestExecutorFactory", "()Ljetbrains/youtrack/search/executor/HeavySearchRequestExecutorFactory;", "youtrack-search"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final HeavySearchRequestExecutorFactory getHeavySearchRequestExecutorFactory() {
            String name$iv = "heavySearchRequestExecutorFactory";
            boolean $i$f$getBean = false;
            Object object = ServiceLocator.getBean((String)name$iv);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.search.executor.HeavySearchRequestExecutorFactory");
            }
            return (HeavySearchRequestExecutorFactory)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

