/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.teamcity.impl;

import java.util.Collection;
import java.util.List;
import jetbrains.charisma.customfields.persistence.fields.XdBuild;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.XdVcsServer;
import jetbrains.youtrack.integration.service.AbstractVcsServiceKt;
import jetbrains.youtrack.integration.service.VcsCommonService;
import jetbrains.youtrack.integration.service.ci.BuildStatus;
import jetbrains.youtrack.integration.service.ci.BuildType;
import jetbrains.youtrack.integration.service.ci.BuildsIntegrationService;
import jetbrains.youtrack.integration.teamcity.dto.TeamcityBuildDTO;
import jetbrains.youtrack.integration.teamcity.impl.TeamcityProcessingAdapter;
import jetbrains.youtrack.integration.teamcity.impl.TeamcityPullBuildsAction;
import jetbrains.youtrack.integration.teamcity.impl.api.TeamcityRestClient;
import jetbrains.youtrack.integration.teamcity.persistence.BuildExtKt;
import jetbrains.youtrack.integration.teamcity.persistence.XdTeamcityBranchAction;
import jetbrains.youtrack.integration.teamcity.persistence.XdTeamcityChangeProcessor;
import jetbrains.youtrack.integration.teamcity.persistence.XdTeamcityServer;
import jetbrains.youtrack.integration.teamcity.persistence.XdTeamcityUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\"B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Ljetbrains/youtrack/integration/teamcity/impl/TeamcityBuildsService;", "Ljetbrains/youtrack/integration/service/ci/BuildsIntegrationService;", "Ljetbrains/youtrack/integration/teamcity/dto/TeamcityBuildDTO;", "Ljetbrains/youtrack/integration/teamcity/impl/TeamcityProcessingAdapter;", "vcsCommonService", "Ljetbrains/youtrack/integration/service/VcsCommonService;", "(Ljetbrains/youtrack/integration/service/VcsCommonService;)V", "integrationUser", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "getIntegrationUser", "()Ljetbrains/youtrack/core/persistent/user/XdUser;", "getVcsCommonService", "()Ljetbrains/youtrack/integration/service/VcsCommonService;", "hasMatchesBuild", "", "build", "Ljetbrains/charisma/customfields/persistence/fields/XdBuild;", "existedBuilds", "", "newAction", "Ljetbrains/youtrack/integration/teamcity/impl/TeamcityPullBuildsAction;", "restClient", "Ljetbrains/youtrack/integration/teamcity/impl/api/TeamcityRestClient;", "processor", "Ljetbrains/youtrack/integration/teamcity/persistence/XdTeamcityChangeProcessor;", "postProcessNewBuild", "", "adapter", "dto", "processBuild", "startProcessingIssues", "query", "", "startProcessingRelatedIssues", "Companion", "youtrack-teamcity-integration"})
public final class TeamcityBuildsService
extends BuildsIntegrationService<TeamcityBuildDTO, TeamcityProcessingAdapter> {
    @NotNull
    private final VcsCommonService vcsCommonService;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public XdUser getIntegrationUser() {
        return (XdUser)XdTeamcityUser.Companion.get();
    }

    @NotNull
    public final TeamcityPullBuildsAction newAction(@NotNull TeamcityRestClient restClient2, @NotNull XdTeamcityChangeProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)restClient2, (String)"restClient");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor), (String)"processor");
        TeamcityBuildsService teamcityBuildsService = this;
        TeamcityRestClient teamcityRestClient = restClient2;
        XdTeamcityChangeProcessor xdTeamcityChangeProcessor = processor;
        return new TeamcityPullBuildsAction(teamcityRestClient, xdTeamcityChangeProcessor, teamcityBuildsService);
    }

    public final void processBuild(@NotNull TeamcityBuildDTO build, @NotNull XdTeamcityChangeProcessor processor) {
        XdTeamcityBranchAction action;
        Intrinsics.checkParameterIsNotNull((Object)((Object)build), (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor), (String)"processor");
        AbstractVcsServiceKt.setProgressMessage((XdVcsChangeProcessor)processor, (String)BeansKt.getLocalizer().localizedMsg("TeamcityBuildConfMapping.Process_TeamCity_build_{0}", new Object[]{build.getNumber()}));
        XdTeamcityBranchAction xdTeamcityBranchAction = action = build.getBranch() == null || build.getDefaultBranch() ? processor.getDefaultBranchActions() : processor.getFeatureBranchActions();
        if (action == null) {
            processor.logInfo("Build " + build.getNumber() + ". No action found for branch " + build.getBranch());
        } else {
            String branchString;
            String string = branchString = Intrinsics.areEqual((Object)((Object)action), (Object)((Object)processor.getDefaultBranchActions())) ? "default branch" : "feature branch " + build.getBranch();
            if (build.getStatus() == BuildStatus.FAILED && !action.getProcessRedBuilds()) {
                processor.logInfo("Build " + build.getNumber() + " assembled from " + branchString + "has 'failed' status. It will not be processed");
            } else {
                processor.logInfo("Build " + build.getNumber() + ". Taking actions defined for " + branchString);
                this.apply(build, new TeamcityProcessingAdapter(processor, action));
                Long l = build.getStart();
                processor.setTeamcityLastBuildAssembled(l != null ? l : 0L);
            }
        }
        processor.setLastBuild(build, false);
    }

    public void postProcessNewBuild(@NotNull XdBuild build, @NotNull TeamcityProcessingAdapter adapter, @NotNull TeamcityBuildDTO dto) {
        Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dto), (String)"dto");
        XdVcsServer xdVcsServer = adapter.getBuildProcessor().getServer();
        if (xdVcsServer == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.integration.teamcity.persistence.XdTeamcityServer");
        }
        BuildExtKt.setServer(build, (XdTeamcityServer)xdVcsServer);
        BuildExtKt.setBuildId(build, String.valueOf(dto.getId()));
        BuildType buildType = dto.getType();
        BuildExtKt.setBuildTypeId(build, buildType != null ? buildType.getId() : null);
        BuildType buildType2 = dto.getType();
        BuildExtKt.setBuildTypeName(build, buildType2 != null ? buildType2.getName() : null);
        BuildExtKt.setBranch(build, dto.getBranch());
    }

    public void startProcessingIssues(@NotNull TeamcityProcessingAdapter adapter, @NotNull TeamcityBuildDTO dto, @NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dto), (String)"dto");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        AbstractVcsServiceKt.setProgressMessage((XdVcsChangeProcessor)adapter.getProcessor(), (String)BeansKt.getLocalizer().localizedMsg("TeamcityBuildConfMapping.Process_resolved_issues_for_build_{0}", new Object[]{query, dto.getNumber()}));
    }

    public void startProcessingRelatedIssues(@NotNull TeamcityProcessingAdapter adapter, @NotNull TeamcityBuildDTO dto) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dto), (String)"dto");
        AbstractVcsServiceKt.setProgressMessage((XdVcsChangeProcessor)adapter.getBuildProcessor(), (String)BeansKt.getLocalizer().localizedMsg("TeamcityBuildConfMapping.Process_teamcity_related_issues_for_build_{0}", new Object[]{dto.getNumber()}));
    }

    public boolean hasMatchesBuild(@NotNull XdBuild build, @NotNull List<XdBuild> existedBuilds) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
            Intrinsics.checkParameterIsNotNull(existedBuilds, (String)"existedBuilds");
            String buildTypeId = BuildExtKt.getBuildTypeId(build);
            Iterable $this$any$iv = existedBuilds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XdBuild it = (XdBuild)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)BuildExtKt.getBuildTypeId(it), (Object)buildTypeId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public VcsCommonService getVcsCommonService() {
        return this.vcsCommonService;
    }

    public TeamcityBuildsService(@NotNull VcsCommonService vcsCommonService) {
        Intrinsics.checkParameterIsNotNull((Object)vcsCommonService, (String)"vcsCommonService");
        this.vcsCommonService = vcsCommonService;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/integration/teamcity/impl/TeamcityBuildsService$Companion;", "Lmu/KLogging;", "()V", "youtrack-teamcity-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

