/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.util.Collections;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jetbrains.exodus.env.EnvironmentConfig;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StaticSettings {
    @NotNull
    @NonNls
    static final String DEBUG_DIRECTORY_SETTING = "jetbrains.dnq.textIndex.debugDirectory";
    @NotNull
    @NonNls
    static final String RAM_DIRECTORY_SETTING = "jetbrains.dnq.textIndex.RAMDirectory";
    @NotNull
    @NonNls
    static final String NRT_CACHE_SIZE = "jetbrains.dnq.textIndex.NRTCacheSizeMB";
    @NotNull
    @NonNls
    static final String USE_PATRICIA_AS_VFS_TREE_SETTING = "jetbrains.dnq.textIndex.usePatriciaAsVFSTree";
    private static final boolean USE_PATRICIA_AS_VFS_TREE_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("jetbrains.dnq.textIndex.usePatriciaAsVFSTree", "true"));
    @NotNull
    @NonNls
    static final String INDEX_INPUT_BUFFER_SIZE = "jetbrains.dnq.textIndex.indexInputBufferSize";
    @NotNull
    @NonNls
    static final String INDEX_INPUT_MERGE_BUFFER_SIZE = "jetbrains.dnq.textIndex.indexInputMergeBufferSize";
    @NotNull
    @NonNls
    static final String STOP_WORD_EXCEPTIONS_SETTING = "jetbrains.dnq.textIndex.stopWordExceptions";
    @NotNull
    @NonNls
    static final String VFS_CLUSTER_SIZE_SETTING = "jetbrains.dnq.textIndex.vfsClusterSize";
    @NotNull
    @NonNls
    static final String EXACT_MATCH_ENABLED_SETTING = "jetbrains.dnq.textIndex.exactMatch.enabled";
    static boolean EXACT_MATCH_ALLOWED = Boolean.parseBoolean(System.getProperty("jetbrains.dnq.textIndex.exactMatch.enabled", "false"));
    @NotNull
    @NonNls
    static final String EXACT_MATCH_PROJECT_EXCEPTIONS_SETTING = "jetbrains.dnq.textIndex.exactMatch.projectExceptions";
    private static final String[] EXACT_MATCH_PROJECT_EXCEPTIONS;
    @NotNull
    @NonNls
    static final String LIVE_UPDATE_PROJECT_EXCEPTIONS_SETTING = "jetbrains.dnq.textIndex.liveUpdate.projectExceptions";
    private static final String[] LIVE_UPDATE_PROJECT_EXCEPTIONS;
    @NotNull
    @NonNls
    static final String FAIR_LOCK_SETTING = "jetbrains.dnq.textIndex.fairLock";
    @NotNull
    @NonNls
    static final String READ_LOCK_TIMEOUT_SETTING = "jetbrains.dnq.textIndex.readLockTimeout";
    private static final long READ_LOCK_TIMEOUT;
    @NotNull
    @NonNls
    static final String CHECK_INDEX_ON_ERROR_SETTING = "jetbrains.dnq.textIndex.chackIndexOnError";
    @NotNull
    @NonNls
    static final String FILES_DELETION_DELAY_SETTING = "jetbrains.dnq.textIndex.filesDeletionDelay";
    @NotNull
    @NonNls
    static final String MAX_INDEXING_TRANSACTION_DURATION_SETTING = "jetbrains.dnq.textIndex.maxTxnDuration";
    private static long MAX_INDEXING_TRANSACTION_DURATION;
    @NotNull
    @NonNls
    static final String INITIAL_INDEXING_DELAY_SETTING = "jetbrains.dnq.textIndex.initialIndexingDelay";
    private static final long INITIAL_INDEXING_DELAY;
    @NotNull
    @NonNls
    static final String IGNORE_VERSION_SETTING = "jetbrains.dnq.textIndex.ignoreVersion";
    @NotNull
    @NonNls
    static final String START_SUSPENDED_SETTING = "jetbrains.dnq.textIndex.startSuspended";
    @NotNull
    @NonNls
    static final String IGNORE_BRACES_SETTING = "jetbrains.dnq.textIndex.ignoreBraces";
    @NotNull
    @NonNls
    public static final String MIN_PREFIX_QUERY_LENGTH_SETTING = "jetbrains.dnq.textIndex.minPrefixQueryLength";
    @NotNull
    @NonNls
    public static final String TEXT_INDEX_THREADS_SETTING = "jetbrains.dnq.textIndex.threads";
    private static final int TEXT_INDEX_THREADS;
    @NotNull
    @NonNls
    public static final String TEXT_INDEX_TITLE_BOOST_FACTOR_SETTING = "jetbrains.dnq.textIndex.titleBoostFactor";
    private static final int TEXT_INDEX_TITLE_BOOST_FACTOR;
    @NotNull
    @NonNls
    static final String TEXT_INDEX_TRANSACTION_TIMEOUT_SETTING = "jetbrains.dnq.textIndex.txnTimeout";
    private static int TEXT_INDEX_TRANSACTION_TIMEOUT;
    @NotNull
    @NonNls
    static final String TEXT_INDEX_CACHED_RESULTS_LIFESPAN_SETTING = "jetbrains.dnq.textIndex.cachedResultsLifespan";
    @NotNull
    @NonNls
    static final String RAM_INDICES_CACHE_SIZE_SETTING = "jetbrains.dnq.textIndex.RAMIndicesCacheSize";
    private static final Pattern STOP_WORD_SPLIT_PATTERN;
    private static final String[] STOP_WORD_EXCEPTIONS;

    StaticSettings() {
    }

    static boolean useDebugDirectory() {
        return Boolean.getBoolean(DEBUG_DIRECTORY_SETTING);
    }

    static boolean useRAMDirectory() {
        return Boolean.getBoolean(RAM_DIRECTORY_SETTING);
    }

    static double getNRTCacheSizeMb() {
        double nrtSize = 0.0;
        try {
            nrtSize = Double.parseDouble(System.getProperty(NRT_CACHE_SIZE, "0.0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return nrtSize;
    }

    static boolean usePatriciaAsVFSDefaultTree() {
        return USE_PATRICIA_AS_VFS_TREE_BY_DEFAULT;
    }

    static int getIndexInputBufferSize(int defaultValue) {
        return Integer.getInteger(INDEX_INPUT_BUFFER_SIZE, defaultValue);
    }

    static int getIndexInputMergeBufferSize(int defaultValue) {
        return Integer.getInteger(INDEX_INPUT_MERGE_BUFFER_SIZE, defaultValue);
    }

    @NotNull
    static String[] getStopWordExceptions() {
        return STOP_WORD_EXCEPTIONS;
    }

    static int getVfsClusterSize() {
        return Integer.getInteger(VFS_CLUSTER_SIZE_SETTING, 16384);
    }

    static boolean getExactMatchAllowed() {
        return EXACT_MATCH_ALLOWED;
    }

    static String[] getExactMatchProjectExceptions() {
        return EXACT_MATCH_PROJECT_EXCEPTIONS;
    }

    static String[] getLiveUpdateProjectExceptions() {
        return LIVE_UPDATE_PROJECT_EXCEPTIONS;
    }

    static boolean useFairLock() {
        return Boolean.getBoolean(FAIR_LOCK_SETTING);
    }

    static long getReadLockTimeout() {
        return READ_LOCK_TIMEOUT;
    }

    static boolean checkIndexOnError() {
        return Boolean.getBoolean(CHECK_INDEX_ON_ERROR_SETTING);
    }

    static int getFilesDeletionDelay() {
        return Integer.getInteger(FILES_DELETION_DELAY_SETTING, EnvironmentConfig.DEFAULT.getGcFilesDeletionDelay());
    }

    static long getMaxIndexingTxnDuration() {
        return MAX_INDEXING_TRANSACTION_DURATION;
    }

    static long getInitialIndexingDelay() {
        return INITIAL_INDEXING_DELAY;
    }

    static boolean ignoreVersion() {
        return Boolean.getBoolean(IGNORE_VERSION_SETTING);
    }

    static boolean startSuspended() {
        String startSuspended = System.getProperty(START_SUSPENDED_SETTING);
        return startSuspended == null || "true".equalsIgnoreCase(startSuspended);
    }

    static boolean ignoreBraces() {
        return Boolean.getBoolean(IGNORE_BRACES_SETTING);
    }

    static int getMinPrefixQueryLength() {
        return Integer.getInteger(MIN_PREFIX_QUERY_LENGTH_SETTING, 3);
    }

    static int getTextIndexThreads() {
        return TEXT_INDEX_THREADS;
    }

    static float getTitleBoostFactor() {
        return TEXT_INDEX_TITLE_BOOST_FACTOR;
    }

    static int getTextIndexTxnTimeout() {
        return TEXT_INDEX_TRANSACTION_TIMEOUT;
    }

    static boolean isTextIndexCachedResultsLifespanDefined() {
        return System.getProperty(TEXT_INDEX_CACHED_RESULTS_LIFESPAN_SETTING) != null;
    }

    static int getRAMIndicesCacheSize() {
        return Integer.getInteger(RAM_INDICES_CACHE_SIZE_SETTING, 4096);
    }

    static Long getTextIndexCachedResultsLifespan() {
        return Long.getLong(TEXT_INDEX_CACHED_RESULTS_LIFESPAN_SETTING);
    }

    private static String[] mergeExceptions(@Nullable String hardCodedExceptions, @Nullable String configuredExceptions) {
        TreeSet set = new TreeSet();
        if (hardCodedExceptions != null) {
            Collections.addAll(set, STOP_WORD_SPLIT_PATTERN.split(hardCodedExceptions));
        }
        if (configuredExceptions != null) {
            Collections.addAll(set, STOP_WORD_SPLIT_PATTERN.split(configuredExceptions));
        }
        return set.toArray(new String[0]);
    }

    static {
        READ_LOCK_TIMEOUT = Long.getLong(READ_LOCK_TIMEOUT_SETTING, 60000L);
        MAX_INDEXING_TRANSACTION_DURATION = Long.getLong(MAX_INDEXING_TRANSACTION_DURATION_SETTING, 3000L);
        INITIAL_INDEXING_DELAY = Long.getLong(INITIAL_INDEXING_DELAY_SETTING, 1000L);
        TEXT_INDEX_THREADS = Integer.getInteger(TEXT_INDEX_THREADS_SETTING, 1);
        TEXT_INDEX_TITLE_BOOST_FACTOR = Integer.getInteger(TEXT_INDEX_TITLE_BOOST_FACTOR_SETTING, 2);
        TEXT_INDEX_TRANSACTION_TIMEOUT = Integer.getInteger(TEXT_INDEX_TRANSACTION_TIMEOUT_SETTING, 0);
        STOP_WORD_SPLIT_PATTERN = Pattern.compile(",");
        EXACT_MATCH_PROJECT_EXCEPTIONS = StaticSettings.mergeExceptions(null, System.getProperty(EXACT_MATCH_PROJECT_EXCEPTIONS_SETTING));
        LIVE_UPDATE_PROJECT_EXCEPTIONS = StaticSettings.mergeExceptions(null, System.getProperty(LIVE_UPDATE_PROJECT_EXCEPTIONS_SETTING));
        STOP_WORD_EXCEPTIONS = StaticSettings.mergeExceptions("as", System.getProperty(STOP_WORD_EXCEPTIONS_SETTING));
    }
}

