/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import jetbrains.exodus.env.Transaction;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.jetbrains.annotations.NotNull;

final class TransactionalIndexSearcherReference
implements AutoCloseable {
    @NotNull
    private final TextIndexManagerImpl textIndexManager;
    @NotNull
    private final IndexSearcher indexSearcher;
    @NotNull
    private final Transaction txn;
    private int reentrantUsers;

    TransactionalIndexSearcherReference(@NotNull TextIndexManagerImpl textIndexManager, @NotNull IndexReaderReference indexReaderReference) {
        this.textIndexManager = textIndexManager;
        Transaction txn = null;
        textIndexManager.lockShared();
        try {
            this.txn = txn = textIndexManager.beginReadonlyTransaction();
            this.indexSearcher = new IndexSearcher(indexReaderReference.get());
            this.reentrantUsers = 1;
        }
        catch (Throwable t) {
            textIndexManager.unlockShared();
            if (txn != null) {
                txn.abort();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    void incReentrantUsers() {
        ++this.reentrantUsers;
    }

    int decReentrantUsers() {
        return --this.reentrantUsers;
    }

    @NotNull
    IndexSearcher get() {
        return this.indexSearcher;
    }

    @Override
    public void close() {
        try {
            this.txn.abort();
        }
        finally {
            this.textIndexManager.unlockShared();
        }
    }

    static interface IndexReaderReference {
        public IndexReader get();
    }
}

