/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex.analysis;

import java.io.Reader;
import jetbrains.youtrack.textindex.analysis.CharTablesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/textindex/analysis/ExtraDelimiterReader;", "Ljava/io/Reader;", "input", "replaceColon", "", "(Ljava/io/Reader;Z)V", "prevIsDelimiter", "prevIsSharp", "close", "", "read", "", "cbuf", "", "off", "len", "Companion", "youtrack-text-search"})
public final class ExtraDelimiterReader
extends Reader {
    private boolean prevIsDelimiter;
    private boolean prevIsSharp;
    private final Reader input;
    private final boolean replaceColon;
    public static final char DOT = '.';
    public static final char UNDERLINE = '_';
    public static final char COLON = ':';
    public static final char SPACE = ' ';
    public static final char ASTERISK = '*';
    public static final char SLASH = '/';
    public static final char BACKSLASH = '\\';
    public static final char SEMICOLON = ';';
    public static final char HARD_SIGN = '\u042a';
    public static final char APOSTROPHE = '\'';
    public static final char SHARP = '#';
    private static final char[] EXTRA_DELIMITERS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)cbuf, (String)"cbuf");
        int read = this.input.read(cbuf, off, len);
        int n = 0;
        int n2 = read;
        while (n < n2) {
            void i;
            char c = cbuf[off + i];
            if (ExtraDelimiterReader.Companion.isExtraDelimiter(c) || this.replaceColon && c == ':') {
                cbuf[off + i] = 32;
                if (this.prevIsSharp) {
                    cbuf[off + i - 1] = 1066;
                }
                this.prevIsDelimiter = true;
                this.prevIsSharp = false;
            } else {
                boolean isSharp;
                boolean bl = isSharp = c == '#';
                if (c == '#' && this.prevIsDelimiter) {
                    cbuf[off + i] = 1066;
                    this.prevIsDelimiter = false;
                } else {
                    boolean bl2 = this.prevIsDelimiter = !isSharp && !CharTablesKt.isLetterOrDigit(c);
                    if (this.prevIsDelimiter && this.prevIsSharp) {
                        cbuf[off + i - 1] = 1066;
                    }
                }
                this.prevIsSharp = isSharp;
            }
            ++i;
        }
        if (this.prevIsSharp && read > 0) {
            cbuf[off + read - 1] = 1066;
        }
        return read;
    }

    @Override
    public void close() {
        this.input.close();
    }

    public ExtraDelimiterReader(@NotNull Reader input, boolean replaceColon) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this.input = input;
        this.replaceColon = replaceColon;
        this.prevIsDelimiter = true;
    }

    static {
        Companion = new Companion(null);
        EXTRA_DELIMITERS = new char[]{'.', '_', '\''};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/textindex/analysis/ExtraDelimiterReader$Companion;", "", "()V", "APOSTROPHE", "", "ASTERISK", "BACKSLASH", "COLON", "DOT", "EXTRA_DELIMITERS", "", "HARD_SIGN", "SEMICOLON", "SHARP", "SLASH", "SPACE", "UNDERLINE", "isExtraDelimiter", "", "c", "youtrack-text-search"})
    public static final class Companion {
        private final boolean isExtraDelimiter(char c) {
            for (char ch : EXTRA_DELIMITERS) {
                if (c != ch) continue;
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

