/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex.async;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.youtrack.textindex.SearchSection;
import jetbrains.youtrack.textindex.TextIndexManagerBase;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import jetbrains.youtrack.textindex.async.AbstractTextIndexJob;
import org.jetbrains.annotations.NotNull;

public final class QueueUnindexedDocumentsJob
extends AbstractTextIndexJob {
    public QueueUnindexedDocumentsJob(@NotNull TextIndexManagerBase manager) {
        super(manager, Priority.above_normal);
    }

    protected void execute() {
        TextIndexManagerImpl manager = this.getProcessor();
        if (manager.isSuspended()) {
            manager.queueIn(this, 1000L);
        } else {
            QueueUnindexedDocumentsJob.process(manager);
        }
    }

    static void process(TextIndexManagerImpl manager) {
        TextIndexManagerBase.log.info((Object)"Started queueing unindexed entities.");
        PersistentEntityStoreImpl store = manager.getPersistentStore();
        TextIndexMetaData metadata = manager.getMetaData();
        long savedLastIndexJobStartTime = manager.getSavedLastIndexJobStartTime();
        store.executeInReadonlyTransaction(txn -> {
            for (String entityType : metadata.getIndexedEntityTypes()) {
                EntityIterable entities = txn.sort(entityType, "updated", true);
                try (SearchSection ignored = new SearchSection(manager);){
                    for (Entity entity : entities) {
                        Long updated = (Long)entity.getProperty("updated");
                        manager.indexDocument(entity.getId(), updated != null && updated >= savedLastIndexJobStartTime);
                    }
                }
            }
        });
        TextIndexManagerBase.log.info((Object)"Unindexed entities queued.");
    }

    public String getName() {
        return "Caclulate unindexed documents to be reindexed";
    }
}

