/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.watchDog;

import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.exodus.entitystore.PersistentEntityStoreStatistics;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.management.StatisticsItem;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.persistent.BeansKt;
import jetbrains.youtrack.scheduling.LocalCronScheduling;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import jetbrains.youtrack.textindex.async.ReindexJob;
import jetbrains.youtrack.watchDog.TextIndexSizeWatchDog;
import jetbrains.youtrack.watchDog.TextIndexSizeWatchDogKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="textIndexSizeWatchDog")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/watchDog/TextIndexSizeWatchDog;", "Ljetbrains/youtrack/scheduling/LocalCronScheduling;", "()V", "cron", "", "getCron", "()Ljava/lang/String;", "cron$delegate", "Lkotlin/Lazy;", "dangerousMinutes", "", "getDangerousMinutes", "()I", "setDangerousMinutes", "(I)V", "execute", "", "shouldExecute", "", "shouldSchedule", "Companion", "youtrack-text-search"})
public final class TextIndexSizeWatchDog
extends LocalCronScheduling {
    private volatile int dangerousMinutes;
    @NotNull
    private final Lazy cron$delegate = LazyKt.lazy((Function0)cron.2.INSTANCE);
    public static final Companion Companion = new Companion(null);

    public final int getDangerousMinutes() {
        return this.dangerousMinutes;
    }

    public final void setDangerousMinutes(int n) {
        this.dangerousMinutes = n;
    }

    @NotNull
    public String getCron() {
        Lazy lazy = this.cron$delegate;
        TextIndexSizeWatchDog textIndexSizeWatchDog = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public boolean shouldSchedule() {
        return TextIndexSizeWatchDogKt.access$getTextIndexSizeWatchDogEnabled$p();
    }

    public boolean shouldExecute() {
        return TextIndexSizeWatchDogKt.access$getTextIndexSizeWatchDogEnabled$p();
    }

    public void execute() {
        TextIndexManagerImpl tim = jetbrains.youtrack.textindex.BeansKt.getTextIndexManagerImpl();
        ContextualEnvironment contextualEnvironment = tim.environment;
        Intrinsics.checkExpressionValueIsNotNull((Object)contextualEnvironment, (String)"tim.environment");
        StatisticsItem statisticsItem = contextualEnvironment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.DISK_USAGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"tim.environment.statisti\u2026atistics.Type.DISK_USAGE)");
        long textIndexUsage = statisticsItem.getTotal();
        if (textIndexUsage < 1000000000L) {
            this.dangerousMinutes = 0;
        } else {
            StatisticsItem statisticsItem2 = jetbrains.youtrack.config.BeansKt.getPersistentDataEnvironment().getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.DISK_USAGE);
            Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem2, (String)"persistentDataEnvironmen\u2026atistics.Type.DISK_USAGE)");
            long dbUsage = statisticsItem2.getTotal();
            StatisticsItem statisticsItem3 = BeansKt.getPersistentEntityStore().getStatistics().getStatisticsItem((Enum)PersistentEntityStoreStatistics.Type.BLOBS_DISK_USAGE);
            Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem3, (String)"persistentEntityStore.st\u2026cs.Type.BLOBS_DISK_USAGE)");
            long blobsUsage = statisticsItem3.getTotal();
            if (textIndexUsage > dbUsage + blobsUsage || !CharismaLicenseChecker.isEnoughDiskSpace()) {
                int n;
                Companion.getLogger().info((Function0)new Function0<String>(this, textIndexUsage, dbUsage, blobsUsage){
                    final /* synthetic */ TextIndexSizeWatchDog this$0;
                    final /* synthetic */ long $textIndexUsage;
                    final /* synthetic */ long $dbUsage;
                    final /* synthetic */ long $blobsUsage;

                    @NotNull
                    public final String invoke() {
                        return "Text index size = " + this.$textIndexUsage + ", database size = " + (this.$dbUsage + this.$blobsUsage) + ", dangerous minutes = " + this.this$0.getDangerousMinutes();
                    }
                    {
                        this.this$0 = textIndexSizeWatchDog;
                        this.$textIndexUsage = l;
                        this.$dbUsage = l2;
                        this.$blobsUsage = l3;
                        super(0);
                    }
                });
                ++this.dangerousMinutes;
                int n2 = n = this.dangerousMinutes;
                if (1 <= n2 && 15 >= n2) {
                    Companion.getLogger().info((Function0)execute.2.INSTANCE);
                    tim.environment.gc();
                } else {
                    Companion.getLogger().info((Function0)execute.3.INSTANCE);
                    new ReindexJob(tim);
                    this.dangerousMinutes = 0;
                }
            }
            if (!CharismaLicenseChecker.isEnoughDiskSpace()) {
                Companion.getLogger().info((Function0)execute.4.INSTANCE);
                new ReindexJob(tim);
                this.dangerousMinutes = 0;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/watchDog/TextIndexSizeWatchDog$Companion;", "Lmu/KLogging;", "()V", "youtrack-text-search"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

