/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.LocalizationKt;
import jetbrains.youtrack.timetracking.PeriodValueService;
import jetbrains.youtrack.timetracking.persistence.XdPeriodFieldFormat;
import jetbrains.youtrack.timetracking.persistence.XdWorkTimeSettingsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0015\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/timetracking/PeriodValueService;", "", "()V", "formatters", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/Locale;", "Lorg/joda/time/format/PeriodFormatter;", "periodFormat", "Ljetbrains/youtrack/timetracking/persistence/XdPeriodFieldFormat;", "getPeriodFormat", "()Ljetbrains/youtrack/timetracking/persistence/XdPeriodFieldFormat;", "format", "", "minutes", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "locale", "(Ljava/lang/Integer;Ljava/util/Locale;)Ljava/lang/String;", "period", "Lorg/joda/time/Period;", "formatter", "fullFormat", "OnlyMinutesFormatter", "UpToDaysHoursFormatter", "UpToHoursFormatter", "youtrack-time-tracking"})
public final class PeriodValueService {
    private ConcurrentHashMap<Locale, PeriodFormatter> formatters = new ConcurrentHashMap();

    private final XdPeriodFieldFormat getPeriodFormat() {
        return (XdPeriodFieldFormat)((Object)LegacySupportKt.transactional((Function1)periodFormat.1.INSTANCE));
    }

    @NotNull
    public final String format(@Nullable Integer minutes) {
        Locale locale2 = (Locale)LegacySupportKt.transactional((Function1)format.locale.1.INSTANCE);
        return this.format(minutes, locale2);
    }

    @NotNull
    public final String format(@Nullable Period period) {
        Locale locale2 = (Locale)LegacySupportKt.transactional((Function1)format.locale.2.INSTANCE);
        Period period2 = period;
        return this.format(period2 != null ? Integer.valueOf(XdWorkTimeSettingsKt.toMinutes(period2)) : null, locale2);
    }

    @NotNull
    public final String format(@Nullable Integer minutes, @NotNull Locale locale2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)locale2, (String)"locale");
        Integer n = minutes;
        if (n == null) {
            return "";
        }
        n.intValue();
        XdPeriodFieldFormat xdPeriodFieldFormat = this.getPeriodFormat();
        if (Intrinsics.areEqual((Object)((Object)xdPeriodFieldFormat), (Object)((Object)XdPeriodFieldFormat.Companion.getDAYS_HOURS_MINUTES()))) {
            string = UpToDaysHoursFormatter.INSTANCE.format(minutes);
        } else if (Intrinsics.areEqual((Object)((Object)xdPeriodFieldFormat), (Object)((Object)XdPeriodFieldFormat.Companion.getHOURS_MINUTES()))) {
            string = UpToHoursFormatter.INSTANCE.format(minutes);
        } else if (Intrinsics.areEqual((Object)((Object)xdPeriodFieldFormat), (Object)((Object)XdPeriodFieldFormat.Companion.getMINUTES()))) {
            string = OnlyMinutesFormatter.INSTANCE.format(minutes);
        } else {
            String string2 = this.formatter(locale2).print((ReadablePeriod)XdWorkTimeSettingsKt.toPeriod(minutes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"formatter(locale).print(minutes.toPeriod())");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        return string;
    }

    @NotNull
    public final String fullFormat(@Nullable Period period) {
        if (period == null) {
            return "";
        }
        Locale locale2 = (Locale)LegacySupportKt.transactional((Function1)fullFormat.locale.1.INSTANCE);
        String string = this.formatter(locale2).print((ReadablePeriod)period);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter(locale).print(period)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public final String fullFormat(@Nullable Integer minutes) {
        Integer n = minutes;
        if (n == null) {
            return "";
        }
        n.intValue();
        Locale locale2 = (Locale)LegacySupportKt.transactional((Function1)fullFormat.locale.2.INSTANCE);
        String string = this.formatter(locale2).print((ReadablePeriod)BeansKt.getWorkTimeSettings().getPeriod(minutes));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter(locale).print(\u2026tings.getPeriod(minutes))");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public final String format(@Nullable Period period, @NotNull Locale locale2) {
        Intrinsics.checkParameterIsNotNull((Object)locale2, (String)"locale");
        Period period2 = period;
        return this.format(period2 != null ? Integer.valueOf(XdWorkTimeSettingsKt.toMinutes(period2)) : null, locale2);
    }

    private final PeriodFormatter formatter(Locale locale2) {
        ConcurrentMap $this$getOrPut$iv = this.formatters;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(locale2);
        if (object == null) {
            boolean bl = false;
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getMsgInLocale("TimeTracking.w", locale2, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.getMsgInLocale(\"TimeTracking.w\", locale)");
            String week = string;
            String string2 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getMsgInLocale("TimeTracking.d", locale2, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.getMsgInLocale(\"TimeTracking.d\", locale)");
            String day = string2;
            String string3 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getMsgInLocale("TimeTracking.h", locale2, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"localizer.getMsgInLocale(\"TimeTracking.h\", locale)");
            String hour = string3;
            String string4 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getMsgInLocale("TimeTracking.m", locale2, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"localizer.getMsgInLocale(\"TimeTracking.m\", locale)");
            String minute = string4;
            PeriodFormatter periodFormatter = new PeriodFormatterBuilder().rejectSignedValues(true).appendWeeks().appendSuffix(week + ' ').appendDays().appendSuffix(day + ' ').appendHours().appendSuffix(hour + ' ').appendMinutes().appendSuffix(minute + ' ').toFormatter();
            boolean bl2 = false;
            boolean bl3 = false;
            PeriodFormatter default$iv = periodFormatter;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(locale2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"formatters.getOrPut(loca\u2026 .toFormatter()\n        }");
        return (PeriodFormatter)object;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/timetracking/PeriodValueService$UpToHoursFormatter;", "", "()V", "format", "", "period", "", "youtrack-time-tracking"})
    public static final class UpToHoursFormatter {
        public static final UpToHoursFormatter INSTANCE;

        @NotNull
        public final String format(int period) {
            int hours = period / 60;
            int minutes = period % 60;
            StringBuilder builder2 = new StringBuilder();
            if (hours > 0) {
                builder2.append(hours).append(LocalizationKt.getH() + ' ');
            }
            if (minutes > 0) {
                builder2.append(minutes).append(LocalizationKt.getM() + ' ');
            }
            String string = builder2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }

        private UpToHoursFormatter() {
        }

        static {
            UpToHoursFormatter upToHoursFormatter;
            INSTANCE = upToHoursFormatter = new UpToHoursFormatter();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/timetracking/PeriodValueService$UpToDaysHoursFormatter;", "", "()V", "format", "", "period", "", "youtrack-time-tracking"})
    public static final class UpToDaysHoursFormatter {
        public static final UpToDaysHoursFormatter INSTANCE;

        @NotNull
        public final String format(int period) {
            int days = period / BeansKt.getWorkTimeSettings().getMinutesADay();
            int reducedMinutes = period % BeansKt.getWorkTimeSettings().getMinutesADay();
            int hours = reducedMinutes / 60;
            int minutes = reducedMinutes % 60;
            StringBuilder builder2 = new StringBuilder();
            if (days > 0) {
                builder2.append(days).append(LocalizationKt.getD() + ' ');
            }
            if (hours > 0) {
                builder2.append(hours).append(LocalizationKt.getH() + ' ');
            }
            if (minutes > 0) {
                builder2.append(minutes).append(LocalizationKt.getM() + ' ');
            }
            String string = builder2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }

        private UpToDaysHoursFormatter() {
        }

        static {
            UpToDaysHoursFormatter upToDaysHoursFormatter;
            INSTANCE = upToDaysHoursFormatter = new UpToDaysHoursFormatter();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/timetracking/PeriodValueService$OnlyMinutesFormatter;", "", "()V", "format", "", "period", "", "youtrack-time-tracking"})
    public static final class OnlyMinutesFormatter {
        public static final OnlyMinutesFormatter INSTANCE;

        @NotNull
        public final String format(int period) {
            return period + LocalizationKt.getM();
        }

        private OnlyMinutesFormatter() {
        }

        static {
            OnlyMinutesFormatter onlyMinutesFormatter;
            INSTANCE = onlyMinutesFormatter = new OnlyMinutesFormatter();
        }
    }
}

