/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking;

import java.util.concurrent.TimeUnit;
import jetbrains.charisma.customfields.persistence.XdAbstractCustomFieldPrototype;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.charisma.timetracking.TimeTrackingProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.parser.api.IPredicate;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.TimeTrackingProviderImpl$createWorkTypeFieldValuePredicate$1$1$1;
import jetbrains.youtrack.timetracking.parser.BaseWorkItemField;
import jetbrains.youtrack.timetracking.parser.WorkTypeFieldValue;
import jetbrains.youtrack.timetracking.periodField.PeriodFieldType;
import jetbrains.youtrack.timetracking.periodField.parser.AddWorkItemCommandExecutor;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.springframework.stereotype.Service;

@Service(value="timeTrackingProvider")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010!\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020#2\u0006\u0010!\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020#2\u0006\u0010!\u001a\u00020&H\u0016J\u0018\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u00062"}, d2={"Ljetbrains/youtrack/timetracking/TimeTrackingProviderImpl;", "Ljetbrains/charisma/timetracking/TimeTrackingProvider;", "()V", "daysAWeek", "", "getDaysAWeek", "()I", "lastWorkingDay", "Lorg/joda/time/DateTime;", "getLastWorkingDay", "()Lorg/joda/time/DateTime;", "minutesPerDay", "getMinutesPerDay", "createWorkItemCommandExecutor", "Ljetbrains/youtrack/api/commands/ICommandExecutor;", "type", "Lkotlinx/dnq/XdEntity;", "date", "", "duration", "description", "", "createWorkTypeFieldValuePredicate", "Ljetbrains/youtrack/parser/api/IPredicate;", "context", "Ljetbrains/youtrack/api/context/IContext;", "getMinutes", "period", "Lorg/joda/time/Period;", "getPeriod", "minutes", "getTimeTrackingSpentTime", "Ljetbrains/exodus/entitystore/Entity;", "project", "isPeriodField", "", "prototype", "isTimeTrackingEnabled", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "isTimeTrackingRelated", "field", "Ljetbrains/youtrack/api/parser/IField;", "isTimeTrackingSpentTime", "isTimeTrackingWriteAccessible", "isWorkDay", "day", "zone", "Lorg/joda/time/DateTimeZone;", "parse", "value", "youtrack-time-tracking"})
public final class TimeTrackingProviderImpl
implements TimeTrackingProvider {
    @NotNull
    public Period getPeriod(int minutes) {
        return BeansKt.getWorkTimeSettings().getPeriod(minutes);
    }

    public int getDaysAWeek() {
        return BeansKt.getWorkTimeSettings().getDaysAWeek();
    }

    public int getMinutesPerDay() {
        return BeansKt.getWorkTimeSettings().getMinutesADay();
    }

    public boolean isWorkDay(long day, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        return BeansKt.getWorkTimeSettings().isWorkDay(day, zone);
    }

    @NotNull
    public DateTime getLastWorkingDay() {
        DateTimeZone dateTimeZone;
        long candidate = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L);
        if (jetbrains.charisma.persistent.BeansKt.getCurrentUser().isPresent()) {
            GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
            Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
            dateTimeZone = generalUserProfile.getTimeZone();
        } else {
            dateTimeZone = jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getTimezone();
        }
        DateTimeZone timeZone = dateTimeZone;
        while (true) {
            DateTimeZone dateTimeZone2 = timeZone;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone2, (String)"timeZone");
            if (this.isWorkDay(candidate, dateTimeZone2)) break;
            candidate -= TimeUnit.DAYS.toMillis(1L);
        }
        return new DateTime(candidate, timeZone);
    }

    @NotNull
    public Period parse(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return BeansKt.getWorkTimeSettings().parse(value2);
    }

    public int getMinutes(@NotNull Period period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        return BeansKt.getWorkTimeSettings().getMinutes(period);
    }

    public boolean isPeriodField(@NotNull Entity prototype) {
        Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
        return ((XdAbstractCustomFieldPrototype)XdExtensionsKt.toXd((Entity)prototype)).getType() instanceof PeriodFieldType;
    }

    @NotNull
    public ICommandExecutor createWorkItemCommandExecutor(@Nullable XdEntity type2, long date2, int duration2, @Nullable String description) {
        XdEntity xdEntity = type2;
        if (!(xdEntity instanceof XdWorkItemType)) {
            xdEntity = null;
        }
        return new AddWorkItemCommandExecutor((XdWorkItemType)xdEntity, date2, duration2, description);
    }

    @NotNull
    public IPredicate createWorkTypeFieldValuePredicate(@NotNull IContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new IPredicate(context){
            final /* synthetic */ IContext $context;

            public final boolean matches(@Nullable Object o) {
                if (o instanceof WorkTypeFieldValue) {
                    XdWorkItemType value2 = (XdWorkItemType)((Object)((WorkTypeFieldValue)((Object)o)).getFieldValue());
                    return this.$context.allSelectedProjects((Function1)new Function1<XdProject, Boolean>(value2){
                        final /* synthetic */ XdWorkItemType $value;

                        public final boolean invoke(@NotNull XdProject it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return XdQueryKt.contains((XdQuery)XdQueryKt.mapDistinct((XdQuery)((XdQuery)this.$value.getUsages()), (KProperty1)((KProperty1)TimeTrackingProviderImpl$createWorkTypeFieldValuePredicate$1$1$1.INSTANCE)), (XdEntity)((XdEntity)it));
                        }
                        {
                            this.$value = xdWorkItemType;
                            super(1);
                        }
                    });
                }
                return true;
            }
            {
                this.$context = iContext;
            }
        };
    }

    public boolean isTimeTrackingEnabled(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2).getEnabled();
    }

    public boolean isTimeTrackingWriteAccessible(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser().hasPermissionInProject(Permission.UPDATE_WORK_ITEM, new XdProject[]{project2});
    }

    public boolean isTimeTrackingSpentTime(@NotNull Entity project2, @NotNull Entity prototype) {
        XdPeriodProjectCustomField xdPeriodProjectCustomField;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
        XdProject xdProject = (XdProject)XdExtensionsKt.toXd((Entity)project2);
        return this.isTimeTrackingEnabled(xdProject) && Intrinsics.areEqual((Object)prototype, (xdPeriodProjectCustomField = XdTimeTrackingSettingsKt.getTimeTrackingSettings(xdProject).getSpentTime()) != null && (xdPeriodProjectCustomField = xdPeriodProjectCustomField.getPrototype()) != null ? xdPeriodProjectCustomField.getEntity() : null);
    }

    @Nullable
    public Entity getTimeTrackingSpentTime(@NotNull Entity project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        XdTimeTrackingSettings tts = XdTimeTrackingSettingsKt.getTimeTrackingSettings((XdProject)XdExtensionsKt.toXd((Entity)project2));
        if (tts.getEnabled()) {
            XdPeriodProjectCustomField xdPeriodProjectCustomField = tts.getSpentTime();
            return xdPeriodProjectCustomField != null ? xdPeriodProjectCustomField.getEntity() : null;
        }
        return null;
    }

    public boolean isTimeTrackingRelated(@NotNull IField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return field instanceof BaseWorkItemField;
    }
}

