/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.gaprest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.components.SequenceGetter;
import jetbrains.gap.resource.components.impl.ReadOnlyEntity;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.reports.BeansKt;
import jetbrains.youtrack.api.reports.DataExporter;
import jetbrains.youtrack.api.reports.ExportDataSource;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.gaprest.RestInternal;
import jetbrains.youtrack.gaprest.filters.HttpContextAccessorFilterKt;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.rest.RestParametersExtractor;
import jetbrains.youtrack.rest.TimeRestParamExtractable;
import jetbrains.youtrack.timetracking.export.WorkItemExportDataSource;
import jetbrains.youtrack.timetracking.gaprest.IssueWorkItem;
import jetbrains.youtrack.timetracking.gaprest.WorkItemsFilter;
import jetbrains.youtrack.timetracking.gaprest.WorkItemsFilterData;
import jetbrains.youtrack.timetracking.gaprest.WorkItemsResource;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="workItems")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\rH\u0002J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011*\b\u0012\u0004\u0012\u00020\u001f0\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/timetracking/gaprest/WorkItemsResource;", "Ljetbrains/gap/resource/components/SequenceGetter;", "Ljetbrains/youtrack/timetracking/gaprest/IssueWorkItem;", "Ljetbrains/youtrack/rest/RestParametersExtractor;", "Ljetbrains/youtrack/rest/TimeRestParamExtractable;", "()V", "defaultTopValue", "", "getDefaultTopValue", "()I", "export", "Ljavax/ws/rs/core/Response;", "accept", "", "request", "Ljetbrains/youtrack/timetracking/gaprest/WorkItemsFilter;", "filterAll", "Lkotlin/sequences/Sequence;", "query", "getAll", "getElementResource", "Ljetbrains/gap/resource/components/impl/ReadOnlyEntity;", "element", "list", "asFilter", "Ljetbrains/youtrack/timetracking/gaprest/WorkItemsFilterData;", "Ljavax/servlet/http/HttpServletRequest;", "searchQuery", "getIssueFolder", "Ljetbrains/youtrack/core/persistent/issue/XdIssueFolder;", "kt", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "youtrack-time-tracking"})
public final class WorkItemsResource
implements SequenceGetter<IssueWorkItem>,
RestParametersExtractor,
TimeRestParamExtractable {
    private final int defaultTopValue = 1000;

    public int getDefaultTopValue() {
        return this.defaultTopValue;
    }

    @NotNull
    public Sequence<IssueWorkItem> getAll() {
        return this.kt(WorkItemsFilterData.Companion.getEMPTY().filterWithSecurity());
    }

    @NotNull
    public Sequence<IssueWorkItem> filterAll(@Nullable String query2) {
        Object object = HttpContextAccessorFilterKt.getGapRequest();
        if (object == null || (object = this.asFilter((HttpServletRequest)object, query2)) == null || (object = ((WorkItemsFilterData)object).filterWithSecurity()) == null || (object = this.kt((Sequence<XdIssueWorkItem>)object)) == null) {
            object = SequencesKt.emptySequence();
        }
        return object;
    }

    @NotNull
    public ReadOnlyEntity<IssueWorkItem> getElementResource(@NotNull IssueWorkItem element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
        return new ReadOnlyEntity((Entity)element);
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="/export")
    @RestInternal
    @NotNull
    public final Response export(@HeaderParam(value="Accept") @NotNull String accept, @NotNull WorkItemsFilter request) {
        List list;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)accept, (String)"accept");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Sequence<XdIssueWorkItem> workItems2 = request.toDatabaseFilter().assertValid().filterWithSecurity();
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)accept, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<DataExporter> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DataExporter dataExporter;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (BeansKt.getDataExporterFactory().forMime(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DataExporter it$iv$iv = dataExporter;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        DataExporter dataExporter = (DataExporter)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (dataExporter == null) {
            throw (Throwable)new BadRequestException("Don't know how to export issues as " + accept);
        }
        DataExporter exporter = dataExporter;
        List<String> list2 = request.getIssueFields();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IField iField;
                void it;
                element$iv$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                if (jetbrains.charisma.keyword.BeansKt.getFilterFieldAwareCollection().find((String)it) == null) {
                    throw (Throwable)new BadRequestException("Can't find field '" + (String)it + '\'');
                }
                collection.add(iField);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = null;
        }
        List issueFields = list;
        Response response = exporter.export((ExportDataSource)new WorkItemExportDataSource(workItems2, issueFields), Response.ok());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"exporter.export(WorkItem\u2026ueFields), Response.ok())");
        return response;
    }

    @POST
    @RestInternal
    @NotNull
    public final Sequence<IssueWorkItem> list(@NotNull WorkItemsFilter request) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Sequence<XdIssueWorkItem> workItems2 = request.toDatabaseFilter().assertValid().filterWithSecurity();
        return this.kt(workItems2);
    }

    /*
     * WARNING - void declaration
     */
    private final WorkItemsFilterData asFilter(@NotNull HttpServletRequest $this$asFilter, String searchQuery) {
        String string;
        Collection<XdWorkItemType> collection;
        List<XdUser> list;
        List<XdUserGroup> list2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        String string2;
        XdIssueFolder xdIssueFolder;
        List<XdUser> list3;
        List<XdUser> list4;
        List<XdUserGroup> list5;
        List<XdUserGroup> list6;
        String[] stringArray;
        Long l7;
        Long startTimestamp;
        Long l8 = this.extractDate($this$asFilter, "startDate");
        if (l8 == null) {
            l8 = startTimestamp = this.extractTimestamp($this$asFilter, "start");
        }
        if ((l7 = this.extractDate($this$asFilter, "endDate")) == null) {
            l7 = this.extractTimestamp($this$asFilter, "end");
        }
        Long endTimestamp = l7;
        Long createdStartTimestamp = this.extractTimestamp($this$asFilter, "createdStart");
        Long createdEndTimestamp = this.extractTimestamp($this$asFilter, "createdEnd");
        Long updatedStartTimestamp = this.extractTimestamp($this$asFilter, "updatedStart");
        Long updatedEndTimestamp = this.extractTimestamp($this$asFilter, "updatedEnd");
        Long l9 = startTimestamp;
        long l10 = l9 != null ? l9 : 0L;
        Long l11 = endTimestamp;
        long l12 = l11 != null ? l11 : 0x7FFFFFFFFFFFFFFEL;
        Long l13 = updatedStartTimestamp;
        long l14 = l13 != null ? l13 : 0L;
        Long l15 = updatedEndTimestamp;
        long l16 = l15 != null ? l15 : 0x7FFFFFFFFFFFFFFEL;
        Long l17 = createdStartTimestamp;
        long l18 = l17 != null ? l17 : 0L;
        Long l19 = createdEndTimestamp;
        long l20 = l19 != null ? l19 : 0x7FFFFFFFFFFFFFFEL;
        String string3 = searchQuery;
        String string4 = $this$asFilter.getParameter("folderId");
        XdIssueFolder xdIssueFolder2 = string4 != null ? this.getIssueFolder(string4) : null;
        List<XdUser> list7 = this.extractUsers($this$asFilter, "author");
        List<XdUser> list8 = this.extractUsers($this$asFilter, "creator");
        List<XdUserGroup> list9 = this.extractUserGroups($this$asFilter, "authorGroups");
        List<XdUserGroup> list10 = this.extractUserGroups($this$asFilter, "creatorGroups");
        String[] stringArray2 = $this$asFilter.getParameter("withoutWorkType");
        if (stringArray2 != null) {
            stringArray = stringArray2;
            list6 = list10;
            list5 = list9;
            list4 = list8;
            list3 = list7;
            xdIssueFolder = xdIssueFolder2;
            string2 = string3;
            l6 = l20;
            l5 = l18;
            l4 = l16;
            l3 = l14;
            l2 = l12;
            l = l10;
            bl3 = false;
            bl2 = Boolean.parseBoolean((String)stringArray);
            l10 = l;
            l12 = l2;
            l14 = l3;
            l16 = l4;
            l18 = l5;
            l20 = l6;
            string3 = string2;
            xdIssueFolder2 = xdIssueFolder;
            list7 = list3;
            list8 = list4;
            list9 = list5;
            list10 = list6;
            bl = bl2;
        } else {
            bl = false;
        }
        String[] stringArray3 = $this$asFilter.getParameterValues("workTypes");
        if (stringArray3 != null) {
            Collection<XdWorkItemType> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            stringArray = stringArray3;
            bl2 = bl;
            list6 = list10;
            list5 = list9;
            list4 = list8;
            list3 = list7;
            xdIssueFolder = xdIssueFolder2;
            string2 = string3;
            l6 = l20;
            l5 = l18;
            l4 = l16;
            l3 = l14;
            l2 = l12;
            l = l10;
            boolean $i$f$map = false;
            list2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            list = $this$mapTo$iv$iv;
            int n = ((List<XdUser>)list).length;
            for (int i = 0; i < n; ++i) {
                XdWorkItemType xdWorkItemType;
                void it;
                List<XdUser> item$iv$iv;
                List<XdUser> list11 = item$iv$iv = list[i];
                collection2 = destination$iv$iv;
                boolean bl4 = false;
                void v24 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"it");
                if (XdWorkItemType.Companion.tryFindByName((String)v24) == null) {
                    throw (Throwable)new BadRequestException("Can't find by work type '" + (String)it + '\'');
                }
                collection2.add(xdWorkItemType);
            }
            collection2 = (List)destination$iv$iv;
            l10 = l;
            l12 = l2;
            l14 = l3;
            l16 = l4;
            l18 = l5;
            l20 = l6;
            string3 = string2;
            xdIssueFolder2 = xdIssueFolder;
            list7 = list3;
            list8 = list4;
            list9 = list5;
            list10 = list6;
            bl = bl2;
            collection = collection2;
        } else {
            collection = null;
        }
        stringArray = collection;
        bl3 = bl;
        list2 = list10;
        List<XdUserGroup> list12 = list9;
        List<XdUser> list13 = list8;
        list = list7;
        XdIssueFolder xdIssueFolder3 = xdIssueFolder2;
        String string5 = string = string3;
        XdIssueFolder xdIssueFolder4 = xdIssueFolder3;
        List<XdUserGroup> list14 = list2;
        List<XdUserGroup> list15 = list12;
        List<XdUser> list16 = list13;
        List<XdUser> list17 = list;
        boolean bl5 = bl3;
        String[] stringArray4 = stringArray;
        long l21 = l20;
        long l22 = l18;
        long l23 = l16;
        long l24 = l14;
        long l25 = l12;
        long l26 = l10;
        return new WorkItemsFilterData(l26, l25, l24, l23, l22, l21, (List<XdWorkItemType>)stringArray4, bl5, list17, list16, list15, list14, xdIssueFolder4, string5);
    }

    private final XdIssueFolder getIssueFolder(@NotNull String $this$getIssueFolder) {
        XdIssueFolder xdIssueFolder = (XdIssueFolder)PersitenceExtensionsKt.tryFindById((XdEntityType)((XdEntityType)XdIssueFolder.Companion), (String)$this$getIssueFolder);
        if (xdIssueFolder == null) {
            throw (Throwable)new NotFoundException("Folder with id: " + $this$getIssueFolder + " is not found");
        }
        return xdIssueFolder;
    }

    private final Sequence<IssueWorkItem> kt(@NotNull Sequence<XdIssueWorkItem> $this$kt) {
        Sequence<XdIssueWorkItem> sequence = $this$kt;
        boolean bl = false;
        return SequencesKt.map(sequence, (Function1)kt.1.INSTANCE);
    }

    @NotNull
    public Sequence<IssueWorkItem> applySecurity(@NotNull Sequence<? extends IssueWorkItem> values2) {
        Intrinsics.checkParameterIsNotNull(values2, (String)"values");
        return SequenceGetter.DefaultImpls.applySecurity((SequenceGetter)this, values2);
    }

    public void assertAccess() {
        SequenceGetter.DefaultImpls.assertAccess((SequenceGetter)this);
    }

    @NotNull
    public WebApplicationException elementNotFound(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return SequenceGetter.DefaultImpls.elementNotFound((SequenceGetter)this, (String)id);
    }

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public List<Entity> get(@QueryParam(value="query") @Nullable String query2, @QueryParam(value="$skip") @Nullable Integer skip, @QueryParam(value="$top") @Nullable Integer top) {
        return SequenceGetter.DefaultImpls.get((SequenceGetter)this, (String)query2, (Integer)skip, (Integer)top);
    }

    @Path(value="{id}")
    @NotNull
    public Object getElementById(@PathParam(value="id") @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return SequenceGetter.DefaultImpls.getElementById((SequenceGetter)this, (String)id);
    }

    @Nullable
    public Boolean extractBoolean(@Nullable HttpServletRequest $this$extractBoolean, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractBoolean((RestParametersExtractor)this, (HttpServletRequest)$this$extractBoolean, (String)paramName);
    }

    @Nullable
    public Integer extractInt(@Nullable HttpServletRequest $this$extractInt, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractInt((RestParametersExtractor)this, (HttpServletRequest)$this$extractInt, (String)paramName);
    }

    @Nullable
    public XdIssue extractIssue(@Nullable HttpServletRequest $this$extractIssue, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractIssue((RestParametersExtractor)this, (HttpServletRequest)$this$extractIssue, (String)paramName);
    }

    @Nullable
    public XdUser extractUser(@Nullable HttpServletRequest $this$extractUser, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractUser((RestParametersExtractor)this, (HttpServletRequest)$this$extractUser, (String)paramName);
    }

    @NotNull
    public List<XdUserGroup> extractUserGroups(@Nullable HttpServletRequest $this$extractUserGroups, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractUserGroups((RestParametersExtractor)this, (HttpServletRequest)$this$extractUserGroups, (String)paramName);
    }

    @NotNull
    public List<XdUser> extractUsers(@Nullable HttpServletRequest $this$extractUsers, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractUsers((RestParametersExtractor)this, (HttpServletRequest)$this$extractUsers, (String)paramName);
    }

    @Nullable
    public Long extractDate(@Nullable String value2) {
        return TimeRestParamExtractable.DefaultImpls.extractDate((TimeRestParamExtractable)this, (String)value2);
    }

    @Nullable
    public Long extractDate(@Nullable HttpServletRequest $this$extractDate, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return TimeRestParamExtractable.DefaultImpls.extractDate((TimeRestParamExtractable)this, (HttpServletRequest)$this$extractDate, (String)paramName);
    }

    @Nullable
    public Pair<Long, Long> extractIntervalParams(@Nullable HttpServletRequest $this$extractIntervalParams) {
        return TimeRestParamExtractable.DefaultImpls.extractIntervalParams((TimeRestParamExtractable)this, (HttpServletRequest)$this$extractIntervalParams);
    }

    @Nullable
    public Long extractTimestamp(@Nullable HttpServletRequest $this$extractTimestamp, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return TimeRestParamExtractable.DefaultImpls.extractTimestamp((TimeRestParamExtractable)this, (HttpServletRequest)$this$extractTimestamp, (String)paramName);
    }
}

