/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.periodField;

import jetbrains.charisma.customfields.persistence.XdAbstractCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.periodField.PeriodFieldValueRenderer;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkTimeSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import webr.framework.function.HtmlStringUtil;
import webr.framework.textBuilder.TBuilderContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/timetracking/periodField/EstimationFieldValueRenderer;", "Ljetbrains/youtrack/timetracking/periodField/PeriodFieldValueRenderer;", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "nullValueText", "", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "renderEstimationWithSpentTime", "estimatedMinutes", "", "spentMinutes", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "renderSingleValue", "value", "", "detalizationLevel", "Ljetbrains/youtrack/api/customfields/DetalizationLevel;", "youtrack-time-tracking"})
public final class EstimationFieldValueRenderer
extends PeriodFieldValueRenderer {
    private final XdIssue issue;

    @Override
    @NotNull
    protected String renderSingleValue(@NotNull Object value2, @NotNull DetalizationLevel detalizationLevel) {
        XdPeriodProjectCustomField timeSpent2;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)detalizationLevel, (String)"detalizationLevel");
        if (!(value2 instanceof Period)) {
            throw (Throwable)new IllegalArgumentException("Value of type " + value2.getClass() + " is not supported");
        }
        XdWorkTimeSettings settings = BeansKt.getWorkTimeSettings();
        if (detalizationLevel == DetalizationLevel.FULL && this.issue != null && (timeSpent2 = XdTimeTrackingSettingsKt.getTimeTrackingSettings(this.issue.getProject()).getSpentTime()) != null && (jetbrains.youtrack.core.security.BeansKt.getLoggedInUserOrNull() == null || XdProjectCustomField.isAccessible$default((XdProjectCustomField)timeSpent2, (Operation)Operation.READ, null, (int)2, null))) {
            XdCustomFieldPrototype tsp = timeSpent2.getPrototype();
            return this.renderEstimationWithSpentTime(settings.getMinutes((Period)value2), BeansKt.getPeriodFieldType().getValueInMinutes(this.issue, (XdAbstractCustomFieldPrototype)tsp));
        }
        return super.renderSingleValue(value2, detalizationLevel);
    }

    @NotNull
    public final String renderEstimationWithSpentTime(@Nullable Integer estimatedMinutes, @Nullable Integer spentMinutes) {
        int spentMinutes2;
        if (estimatedMinutes == null) {
            return this.getNullValue();
        }
        Integer n = spentMinutes;
        int n2 = spentMinutes2 = n != null ? n : 0;
        if (estimatedMinutes >= spentMinutes2) {
            int timeLeft = estimatedMinutes - spentMinutes2;
            int offset = estimatedMinutes == 0 ? -256 : -(Math.round((float)spentMinutes2 / (float)estimatedMinutes.intValue() * (float)16) * 16);
            String timeStr = BeansKt.getWorkTimeSettings().format(estimatedMinutes);
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("EstimationFieldValueRenderer.{time}_left_out_of_{1}", new Object[]{BeansKt.getWorkTimeSettings().format(timeLeft), timeStr});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026ormat(timeLeft), timeStr)");
            String title = string;
            String string2 = ContentBuilder.toString((_FunctionTypes._void_P1_E0)((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(title, offset, timeStr){
                final /* synthetic */ String $title;
                final /* synthetic */ int $offset;
                final /* synthetic */ String $timeStr;

                public final void invoke(TBuilderContext builderContext) {
                    builderContext.appendIndent();
                    builderContext.append("<span title=\"");
                    builderContext.append(HtmlStringUtil.html((Object)this.$title));
                    builderContext.append("\" class=\"ttrack-progress-ico\" style=\"background-position: 0 ");
                    builderContext.append(String.valueOf(this.$offset + 1) + "px");
                    builderContext.append("\"></span>");
                    builderContext.append(HtmlStringUtil.html((Object)this.$timeStr));
                    builderContext.appendNewLine();
                }
                {
                    this.$title = string;
                    this.$offset = n;
                    this.$timeStr = string2;
                }
            }), (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ContentBuilder.toString(\u2026e()\n            }, false)");
            return string2;
        }
        String timeStr = BeansKt.getWorkTimeSettings().format(estimatedMinutes);
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("EstimationFieldValueRenderer.{time}_overdue_out_of_{1}", new Object[]{BeansKt.getWorkTimeSettings().format(spentMinutes2 - estimatedMinutes), timeStr});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026timatedMinutes), timeStr)");
        String title = string;
        String string3 = ContentBuilder.toString((_FunctionTypes._void_P1_E0)((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(title, timeStr){
            final /* synthetic */ String $title;
            final /* synthetic */ String $timeStr;

            public final void invoke(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<span title=\"");
                builderContext.append(HtmlStringUtil.html((Object)this.$title));
                builderContext.append("\" class=\"ttrack-progress-ico ttrack-progress-ico-overdue\"></span>");
                builderContext.append(HtmlStringUtil.html((Object)this.$timeStr));
                builderContext.appendNewLine();
            }
            {
                this.$title = string;
                this.$timeStr = string2;
            }
        }), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ContentBuilder.toString(\u2026e()\n            }, false)");
        return string3;
    }

    public EstimationFieldValueRenderer(@NotNull XdIssue issue2, @NotNull String nullValueText) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)nullValueText, (String)"nullValueText");
        super(nullValueText);
        this.issue = issue2;
    }

    public EstimationFieldValueRenderer(@NotNull String nullValueText) {
        Intrinsics.checkParameterIsNotNull((Object)nullValueText, (String)"nullValueText");
        super(nullValueText);
        this.issue = null;
    }
}

