/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.periodField.parser;

import java.util.Locale;
import javax.ws.rs.ForbiddenException;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\u00020\t*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/timetracking/periodField/parser/AddWorkItemCommandExecutor;", "Ljetbrains/youtrack/api/commands/ICommandExecutor;", "type", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "date", "", "duration", "", "description", "", "(Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;JILjava/lang/String;)V", "debugDescription", "getDebugDescription", "()Ljava/lang/String;", "getDescription", "getDuration", "()I", "field", "Ljetbrains/youtrack/api/parser/IField;", "getField", "()Ljetbrains/youtrack/api/parser/IField;", "isTailCommand", "", "()Z", "presentation", "getPresentation", "getType", "()Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "execute", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "toStringWithoutYear", "youtrack-time-tracking"})
public class AddWorkItemCommandExecutor
implements ICommandExecutor {
    private final long date;
    @Nullable
    private final XdWorkItemType type;
    private final int duration;
    @Nullable
    private final String description;

    @NotNull
    public String getDebugDescription() {
        StringBuilder sb = new StringBuilder("");
        if (this.type != null) {
            sb.append(this.type.getName()).append(":");
        }
        GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        DateTimeZone userTimeZone = generalUserProfile.getTimeZone();
        if (new DateTime(this.date, DateTimeZone.UTC).getDayOfMonth() != new DateTime(System.currentTimeMillis(), userTimeZone).getDayOfMonth()) {
            sb.append(this.toStringWithoutYear(this.date)).append(":");
        }
        sb.append(BeansKt.getWorkTimeSettings().format(this.duration));
        CharSequence charSequence = this.description;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            sb.append(":").append(this.description);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String getPresentation() {
        String durationStr = BeansKt.getWorkTimeSettings().format(this.duration);
        String dateStr = this.toStringWithoutYear(this.date);
        Object object = this.type;
        if (object == null || (object = object.getName()) == null) {
            object = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("TimeTracking.work", new Object[0]);
        }
        Object workType = object;
        CharSequence charSequence = this.description;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("AddWorkItemCommandExecutor.Add_{period}_of_work_on_{date}", new Object[]{durationStr, workType, dateStr});
        }
        return jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("AddWorkItemCommandExecutor.Add_{period}_of_work_on_{date}_with_description_{2}", new Object[]{durationStr, workType, dateStr, this.description});
    }

    public void execute(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        if (!XdTimeTrackingSettingsKt.getTimeTrackingSettings(issue2.getProject()).getEnabled()) {
            throw (Throwable)new IllegalStateException("Time tracking is disabled");
        }
        if (!XdTimeTrackingSettingsKt.canCreateWorkItem$default(issue2.getProject(), null, 1, null)) {
            throw (Throwable)new ForbiddenException("You are not allowed to create work item");
        }
        XdIssueWorkItem.Companion.new(issue2, jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser(), this.date, (Function1<? super XdIssueWorkItem, Unit>)((Function1)new Function1<XdIssueWorkItem, Unit>(this){
            final /* synthetic */ AddWorkItemCommandExecutor this$0;

            public final void invoke(@NotNull XdIssueWorkItem $this$new) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                $this$new.setDuration(this.this$0.getDuration());
                $this$new.setDescription(this.this$0.getDescription());
                $this$new.setType(this.this$0.getType());
            }
            {
                this.this$0 = addWorkItemCommandExecutor;
                super(1);
            }
        }));
    }

    @NotNull
    public IField getField() {
        return jetbrains.charisma.keyword.BeansKt.getPredefinedFieldWork();
    }

    public boolean isTailCommand() {
        return false;
    }

    private final String toStringWithoutYear(long $this$toStringWithoutYear) {
        String string = DateTimeOperations.print((DateTime)new DateTime($this$toStringWithoutYear, DateTimeZone.UTC), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("date-no-year"), (Locale)jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getLocale());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DateTimeOperations.print\u2026year\"), localizer.locale)");
        return string;
    }

    @Nullable
    public final XdWorkItemType getType() {
        return this.type;
    }

    public final int getDuration() {
        return this.duration;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    public AddWorkItemCommandExecutor(@Nullable XdWorkItemType type2, long date2, int duration2, @Nullable String description) {
        this.type = type2;
        this.duration = duration2;
        this.description = description;
        this.date = XdWorkItemKt.toMidnightInUTC$default(date2, null, 1, null);
    }
}

