/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.periodField.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.parser.api.CharIterable;
import jetbrains.youtrack.parser.api.CharIterator;
import jetbrains.youtrack.parser.api.IPredicate;
import jetbrains.youtrack.parser.api.PredicateUtilKt;
import jetbrains.youtrack.parser.api.PrefixIterator;
import jetbrains.youtrack.timetracking.periodField.parser.PeriodFieldValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ljetbrains/youtrack/timetracking/periodField/parser/PeriodPrefixIterator;", "Ljetbrains/youtrack/parser/api/PrefixIterator;", "Ljetbrains/youtrack/timetracking/periodField/parser/PeriodFieldValue;", "()V", "days", "", "daysChars", "", "", "hours", "hoursChars", "minutes", "minutesChars", "state", "value", "weeks", "weeksChars", "addValues", "", "periods", "", "Lorg/joda/time/Period;", "convert", "Lkotlin/Function1;", "getCurrentValue", "getDescendantValues", "Lkotlin/sequences/Sequence;", "predicate", "Ljetbrains/youtrack/parser/api/IPredicate;", "getKeys", "key", "", "getValues", "matchDigit", "", "next", "matchLetter", "matchSpace", "move", "step", "Ljetbrains/youtrack/parser/api/CharIterable;", "Companion", "youtrack-time-tracking"})
public class PeriodPrefixIterator
implements PrefixIterator<PeriodFieldValue> {
    private int weeks;
    private int days;
    private int hours;
    private int minutes;
    private int value;
    private int state = WAITING_FOR_FIRST_BLOCK;
    private final Set<Character> weeksChars = this.getKeys("TimeTracking.w");
    private final Set<Character> daysChars = this.getKeys("TimeTracking.d");
    private final Set<Character> hoursChars = this.getKeys("TimeTracking.h");
    private final Set<Character> minutesChars = this.getKeys("TimeTracking.m");
    private static final int PARSING_FIRST_BLOCK = 0;
    private static final int PARSING_BLOCK = 1;
    private static final int WAITING_FOR_BLOCK = 2;
    private static final int WAITING_FOR_FIRST_BLOCK = 4;
    private static final int WAITING_FOR_BLOCK_AFTER_SPACE = 5;
    private static final int ERROR = 6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Sequence<PeriodFieldValue> getValues(@Nullable IPredicate predicate) {
        PeriodFieldValue filterCreator = null;
        if (this.state != PARSING_BLOCK && this.state != WAITING_FOR_FIRST_BLOCK && this.state != ERROR && this.state != WAITING_FOR_BLOCK_AFTER_SPACE) {
            filterCreator = new PeriodFieldValue(this.getCurrentValue());
        }
        return filterCreator != null && (predicate == null || predicate.matches((Object)filterCreator)) ? SequencesKt.sequenceOf((Object[])new PeriodFieldValue[]{filterCreator}) : SequencesKt.emptySequence();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Sequence<PeriodFieldValue> getDescendantValues(@Nullable IPredicate predicate) {
        void $this$mapTo$iv$iv;
        boolean varyWeeks;
        if (this.state == ERROR) {
            return SequencesKt.emptySequence();
        }
        boolean bl = false;
        ArrayList<Period> descendantPeriods = new ArrayList<Period>();
        boolean varyMinutes = this.minutes == 0;
        boolean varyHours = this.hours == 0 && varyMinutes;
        boolean varyDays = this.days == 0 && varyHours;
        boolean bl2 = varyWeeks = this.weeks == 0 && varyDays;
        if (varyWeeks) {
            descendantPeriods.add(new Period().withWeeks(this.value));
            descendantPeriods.add(new Period().withDays(this.value));
            descendantPeriods.add(new Period().withHours(this.value));
            descendantPeriods.add(new Period().withMinutes(this.value));
        } else {
            descendantPeriods.add(this.getCurrentValue());
        }
        if (varyWeeks) {
            this.addValues((List<Period>)descendantPeriods, (Function1<? super Period, Period>)((Function1)new Function1<Period, Period>(this){
                final /* synthetic */ PeriodPrefixIterator this$0;

                @Nullable
                public final Period invoke(@NotNull Period it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getWeeks() != 0 ? null : it.withWeeks(PeriodPrefixIterator.access$getValue$p(this.this$0) == 0 ? 1 : PeriodPrefixIterator.access$getValue$p(this.this$0));
                }
                {
                    this.this$0 = periodPrefixIterator;
                    super(1);
                }
            }));
        }
        if (varyDays) {
            this.addValues((List<Period>)descendantPeriods, (Function1<? super Period, Period>)((Function1)new Function1<Period, Period>(this){
                final /* synthetic */ PeriodPrefixIterator this$0;

                @Nullable
                public final Period invoke(@NotNull Period it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getDays() != 0 ? null : it.withDays(PeriodPrefixIterator.access$getValue$p(this.this$0) == 0 ? 3 : PeriodPrefixIterator.access$getValue$p(this.this$0));
                }
                {
                    this.this$0 = periodPrefixIterator;
                    super(1);
                }
            }));
        }
        if (varyHours) {
            this.addValues((List<Period>)descendantPeriods, (Function1<? super Period, Period>)((Function1)new Function1<Period, Period>(this){
                final /* synthetic */ PeriodPrefixIterator this$0;

                @Nullable
                public final Period invoke(@NotNull Period it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getHours() != 0 ? null : it.withHours(PeriodPrefixIterator.access$getValue$p(this.this$0) == 0 ? 2 : PeriodPrefixIterator.access$getValue$p(this.this$0));
                }
                {
                    this.this$0 = periodPrefixIterator;
                    super(1);
                }
            }));
        }
        if (varyMinutes) {
            this.addValues((List<Period>)descendantPeriods, (Function1<? super Period, Period>)((Function1)new Function1<Period, Period>(this){
                final /* synthetic */ PeriodPrefixIterator this$0;

                @Nullable
                public final Period invoke(@NotNull Period it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getMinutes() != 0 ? null : it.withMinutes(PeriodPrefixIterator.access$getValue$p(this.this$0) == 0 ? 45 : PeriodPrefixIterator.access$getValue$p(this.this$0));
                }
                {
                    this.this$0 = periodPrefixIterator;
                    super(1);
                }
            }));
        }
        Iterable $this$map$iv = descendantPeriods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Period period = (Period)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            PeriodFieldValue periodFieldValue = new PeriodFieldValue((Period)it);
            collection.add(periodFieldValue);
        }
        List res = (List)destination$iv$iv;
        return PredicateUtilKt.filterWith((Sequence)CollectionsKt.asSequence((Iterable)res), (IPredicate)predicate);
    }

    public boolean move(@NotNull CharIterable step) {
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        CharIterator i = step.iterator();
        while (i.hasNext()) {
            char next = Character.toLowerCase(i.next());
            int n = this.state;
            if (n == WAITING_FOR_FIRST_BLOCK) {
                if (this.matchDigit(next)) {
                    this.state = PARSING_FIRST_BLOCK;
                    continue;
                }
                this.state = ERROR;
                return false;
            }
            if (n == PARSING_FIRST_BLOCK) {
                if (this.matchDigit(next)) continue;
                if (this.matchLetter(next)) {
                    this.state = WAITING_FOR_BLOCK;
                    continue;
                }
                this.state = ERROR;
                return false;
            }
            if (n == WAITING_FOR_BLOCK) {
                if (this.matchDigit(next)) {
                    this.state = PARSING_BLOCK;
                    continue;
                }
                if (this.matchSpace(next)) {
                    this.state = WAITING_FOR_BLOCK_AFTER_SPACE;
                    continue;
                }
                this.state = ERROR;
                return false;
            }
            if (n == PARSING_BLOCK) {
                if (this.matchDigit(next)) continue;
                if (this.matchLetter(next)) {
                    this.state = WAITING_FOR_BLOCK;
                    continue;
                }
                this.state = ERROR;
                return false;
            }
            if (n != WAITING_FOR_BLOCK_AFTER_SPACE) continue;
            if (this.matchDigit(next)) {
                this.state = PARSING_BLOCK;
                continue;
            }
            if (this.matchSpace(next)) continue;
            this.state = ERROR;
            return false;
        }
        return true;
    }

    private final boolean matchDigit(char next) {
        char c = next;
        if ('0' <= c && '9' >= c) {
            this.value = this.value * 10 + (next - 48);
            return true;
        }
        return false;
    }

    private final boolean matchLetter(char next) {
        if (this.weeksChars.contains(Character.valueOf(next)) && this.weeks == 0) {
            this.weeks = this.value;
            this.value = 0;
            return true;
        }
        if (this.daysChars.contains(Character.valueOf(next)) && this.days == 0) {
            this.days = this.value;
            this.value = 0;
            return true;
        }
        if (this.hoursChars.contains(Character.valueOf(next)) && this.hours == 0) {
            this.hours = this.value;
            this.value = 0;
            return true;
        }
        if (this.minutesChars.contains(Character.valueOf(next)) && this.minutes == 0) {
            this.minutes = this.value;
            this.value = 0;
            return true;
        }
        return false;
    }

    private final Period getCurrentValue() {
        Period period;
        if (this.state == PARSING_FIRST_BLOCK) {
            Period period2 = new Period().withHours(this.value);
            period = period2;
            Intrinsics.checkExpressionValueIsNotNull((Object)period2, (String)"Period().withHours(value)");
        } else {
            Period period3 = new Period().withWeeks(this.weeks).withDays(this.days).withHours(this.hours).withMinutes(this.minutes);
            period = period3;
            Intrinsics.checkExpressionValueIsNotNull((Object)period3, (String)"Period().withWeeks(weeks\u2026urs).withMinutes(minutes)");
        }
        return period;
    }

    private final boolean matchSpace(char next) {
        return next == ' ';
    }

    private final Set<Character> getKeys(String key) {
        return SetsKt.hashSetOf((Object[])new Character[]{Character.valueOf(BeansKt.getLocalizer().localizedMsgInServerLocale(key, new Object[0]).charAt(0)), Character.valueOf(BeansKt.getLocalizer().getDefaultMsg(key, new Object[0]).charAt(0))});
    }

    /*
     * WARNING - void declaration
     */
    private final void addValues(List<Period> periods, Function1<? super Period, Period> convert) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = periods;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Period period;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Period it = (Period)element$iv$iv;
            boolean bl2 = false;
            if ((Period)convert.invoke((Object)it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Period it$iv$iv = period;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List toAdd = (List)destination$iv$iv;
        periods.addAll(toAdd);
    }

    static {
        PARSING_BLOCK = 1;
        WAITING_FOR_BLOCK = 2;
        WAITING_FOR_FIRST_BLOCK = 4;
        WAITING_FOR_BLOCK_AFTER_SPACE = 5;
        ERROR = 6;
    }

    public static final /* synthetic */ int access$getValue$p(PeriodPrefixIterator $this) {
        return $this.value;
    }

    public static final /* synthetic */ void access$setValue$p(PeriodPrefixIterator $this, int n) {
        $this.value = n;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/timetracking/periodField/parser/PeriodPrefixIterator$Companion;", "", "()V", "ERROR", "", "PARSING_BLOCK", "PARSING_FIRST_BLOCK", "WAITING_FOR_BLOCK", "WAITING_FOR_BLOCK_AFTER_SPACE", "WAITING_FOR_FIRST_BLOCK", "youtrack-time-tracking"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

