/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.persistence;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.annotations.Access;
import jetbrains.youtrack.core.annotations.ApiClass;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiMpsIgnore;
import jetbrains.youtrack.core.annotations.ApiMpsType;
import jetbrains.youtrack.core.annotations.ApiMpsTypes;
import jetbrains.youtrack.core.annotations.ApiProperty;
import jetbrains.youtrack.core.annotations.ApiPropertyAccess;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.annotations.ApiSince;
import jetbrains.youtrack.core.dates.DateMathKt;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.core.persistent.XdMentionsProvider;
import jetbrains.youtrack.core.persistent.article.XdArticle;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.XdExternalReference;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdBaseWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem$beforeFlush$1;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.plugin.IssueWorkItemSecurityServiceKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.XdNaturalEntityType;
import kotlinx.dnq.link.OnDeletePolicy;
import kotlinx.dnq.link.XdToManyLink;
import kotlinx.dnq.link.XdToOneOptionalLink;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdSearchingNode;
import kotlinx.dnq.simple.XdNullableProperty;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.store.container.StoreContainer;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

@ApiClass
@ApiDoc(value="Represents a work item that has been added to an issue.")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020CH\u0016J\u0018\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\b\b\u0002\u0010I\u001a\u000201J\b\u0010J\u001a\u00020CH\u0007R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\fR1\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00158F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001c\u0010\u000e\u0012\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR/\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0006\u001a\u0004\u0018\u00010\u001d8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R!\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R!\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010+\u001a\u0004\b.\u0010)R!\u00100\u001a\b\u0012\u0004\u0012\u0002010&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010+\u001a\u0004\b2\u0010)R5\u00104\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b:\u0010;\u0012\u0004\b5\u0010\u0012\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010=\u001a\u00020<2\u0006\u0010\u000f\u001a\u00020<8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006L"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "Ljetbrains/youtrack/timetracking/persistence/XdBaseWorkItem;", "Ljetbrains/youtrack/core/persistent/XdMentionsProvider;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "", "_date", "get_date", "()J", "set_date", "(J)V", "_date$delegate", "Lkotlinx/dnq/simple/XdProperty;", "value", "date", "date$annotations", "()V", "getDate", "setDate", "", "duration", "duration$annotations", "getDuration", "()I", "setDuration", "(I)V", "duration$delegate", "Ljetbrains/youtrack/persistent/XdExternalReference;", "externalReference", "getExternalReference", "()Ljetbrains/youtrack/persistent/XdExternalReference;", "setExternalReference", "(Ljetbrains/youtrack/persistent/XdExternalReference;)V", "externalReference$delegate", "Lkotlinx/dnq/link/XdToOneOptionalLink;", "mentionedArticles", "Lkotlinx/dnq/query/XdMutableQuery;", "Ljetbrains/youtrack/core/persistent/article/XdArticle;", "getMentionedArticles", "()Lkotlinx/dnq/query/XdMutableQuery;", "mentionedArticles$delegate", "Lkotlinx/dnq/link/XdToManyLink;", "mentionedIssues", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getMentionedIssues", "mentionedIssues$delegate", "mentionedUsers", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "getMentionedUsers", "mentionedUsers$delegate", "oldDate", "oldDate$annotations", "getOldDate", "()Ljava/lang/Long;", "setOldDate", "(Ljava/lang/Long;)V", "oldDate$delegate", "Lkotlinx/dnq/simple/XdNullableProperty;", "Lorg/joda/time/Period;", "timePeriod", "getTimePeriod", "()Lorg/joda/time/Period;", "setTimePeriod", "(Lorg/joda/time/Period;)V", "beforeFlush", "", "constructor", "isAccessible", "", "operation", "Ljetbrains/youtrack/core/security/Operation;", "user", "remove", "Companion", "youtrack-time-tracking"})
public final class XdIssueWorkItem
extends XdBaseWorkItem
implements XdMentionsProvider {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdProperty _date$delegate;
    @Nullable
    private final XdNullableProperty oldDate$delegate;
    @NotNull
    private final XdProperty duration$delegate;
    @Nullable
    private final XdToOneOptionalLink externalReference$delegate;
    @NotNull
    private final XdToManyLink mentionedIssues$delegate;
    @NotNull
    private final XdToManyLink mentionedUsers$delegate;
    @NotNull
    private final XdToManyLink mentionedArticles$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "_date", "get_date()J")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "oldDate", "getOldDate()Ljava/lang/Long;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "duration", "getDuration()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "externalReference", "getExternalReference()Ljetbrains/youtrack/persistent/XdExternalReference;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "mentionedIssues", "getMentionedIssues()Lkotlinx/dnq/query/XdMutableQuery;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "mentionedUsers", "getMentionedUsers()Lkotlinx/dnq/query/XdMutableQuery;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdIssueWorkItem.class), "mentionedArticles", "getMentionedArticles()Lkotlinx/dnq/query/XdMutableQuery;"))};
        Companion = new Companion(null);
    }

    @Override
    public void constructor() {
        super.constructor();
        this.setDate(XdWorkItemKt.toMidnightInUTC$default(this.getCreated(), null, 1, null));
    }

    public final long get_date() {
        return ((Number)((Object)this._date$delegate.getValue((XdEntity)this, $$delegatedProperties[0]))).longValue();
    }

    public final void set_date(long l) {
        this._date$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (Comparable)Long.valueOf(l));
    }

    @Deprecated(message="scheduled for removal. use date instead.")
    public static /* synthetic */ void oldDate$annotations() {
    }

    @Nullable
    public final Long getOldDate() {
        return (Long)this.oldDate$delegate.getValue((XdEntity)this, $$delegatedProperties[1]);
    }

    public final void setOldDate(@Nullable Long l) {
        this.oldDate$delegate.setValue((XdEntity)this, $$delegatedProperties[1], (Comparable)l);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.RW, scope=ApiScope.WORKFLOW), @ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The duration of the work item in minutes.\nWritable since 2018.1.40800")
    public static /* synthetic */ void duration$annotations() {
    }

    public final int getDuration() {
        return ((Number)((Object)this.duration$delegate.getValue((XdEntity)this, $$delegatedProperties[2]))).intValue();
    }

    public final void setDuration(int n) {
        this.duration$delegate.setValue((XdEntity)this, $$delegatedProperties[2], (Comparable)Integer.valueOf(n));
    }

    @Nullable
    public final XdExternalReference getExternalReference() {
        return (XdExternalReference)this.externalReference$delegate.getValue((XdEntity)this, $$delegatedProperties[3]);
    }

    public final void setExternalReference(@Nullable XdExternalReference xdExternalReference) {
        this.externalReference$delegate.setValue((XdEntity)this, $$delegatedProperties[3], (XdEntity)xdExternalReference);
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.R, scope=ApiScope.WORKFLOW), @ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The date and time that is assigned to the work item. Stored as a Unix timestamp in UTC. The time part is set to midnight for the current date.")
    @ApiMpsType(value=ApiMpsTypes.INSTANT)
    public static /* synthetic */ void date$annotations() {
    }

    public final long getDate() {
        return this.get_date();
    }

    public final void setDate(long value2) {
        this.set_date(XdWorkItemKt.toMidnightInUTC$default(value2, null, 1, null));
    }

    @NotNull
    public final Period getTimePeriod() {
        return BeansKt.toTimePeriod(this.getDuration());
    }

    public final void setTimePeriod(@NotNull Period value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.setDuration(jetbrains.charisma.timetracking.BeansKt.getTimeTrackingProvider().getMinutes(value2));
    }

    @NotNull
    public XdMutableQuery<XdIssue> getMentionedIssues() {
        return this.mentionedIssues$delegate.getValue((XdEntity)this, $$delegatedProperties[4]);
    }

    @NotNull
    public XdMutableQuery<XdUser> getMentionedUsers() {
        return this.mentionedUsers$delegate.getValue((XdEntity)this, $$delegatedProperties[5]);
    }

    @NotNull
    public XdMutableQuery<XdArticle> getMentionedArticles() {
        return this.mentionedArticles$delegate.getValue((XdEntity)this, $$delegatedProperties[6]);
    }

    public void beforeFlush() {
        XdIssueWorkItem entity2;
        super.beforeFlush();
        XdIssueWorkItem xdIssueWorkItem = entity2 = this.isRemoved() ? null : this;
        if ((this.isNew() || ReflectionUtilKt.hasChanges((XdEntity)this, (KProperty1)((KProperty1)XdIssueWorkItem$beforeFlush$1.INSTANCE))) && this.getDuration() <= 0) {
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueWorkItem.Work_duration_can_t_be_empty", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026duration_can_t_be_empty\")");
            Void void_ = PersitenceExtensionsKt.userFriendlyFail((String)string, (XdEntity)entity2);
            throw null;
        }
        if (!DateMathKt.isDateStartInUTC((Long)this.getDate())) {
            Void void_ = PersitenceExtensionsKt.userFriendlyFail((String)(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueWorkItem.incorrect_date", new Object[0]) + this.getDate()), (XdEntity)entity2);
            throw null;
        }
    }

    public final boolean isAccessible(@NotNull Operation operation, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return XdEntitySecurityService.DefaultImpls.isAccessible$default((XdEntitySecurityService)IssueWorkItemSecurityServiceKt.getIssueWorkItemSecurityService(), (XdEntity)this, null, (Operation)operation, (XdUser)user, null, (int)18, null);
    }

    public static /* synthetic */ boolean isAccessible$default(XdIssueWorkItem xdIssueWorkItem, Operation operation, XdUser xdUser, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return xdIssueWorkItem.isAccessible(operation, xdUser);
    }

    @Deprecated(message="to be moved to public api location")
    @ApiMethod(name="delete", scopes={ApiScope.WORKFLOW})
    @ApiMpsIgnore
    @ApiDoc(value="Permanently deletes the work item.")
    @ApiSince(value="2018.2.42312")
    public final void remove() {
        this.delete();
    }

    public XdIssueWorkItem(@NotNull Entity entity2) {
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        super(entity2);
        this._date$delegate = (XdProperty)PropertyDelegatesKt.xdRequiredLongProp$default((String)"date", (boolean)false, null, (int)6, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.oldDate$delegate = (XdNullableProperty)PropertyDelegatesKt.xdNullableLongProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this.duration$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.externalReference$delegate = (XdToOneOptionalLink)LinkDelegatesKt.xdLink0_1$default((XdEntityType)((XdEntityType)XdExternalReference.Companion), null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE), (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE), (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
        OnDeletePolicy onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        OnDeletePolicy onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        this.mentionedIssues$delegate = (XdToManyLink)LinkDelegatesKt.xdLink0_N$default((XdEntityType)((XdEntityType)XdIssue.Companion), null, (OnDeletePolicy)onDeletePolicy, (OnDeletePolicy)onDeletePolicy2, (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[4]);
        onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        this.mentionedUsers$delegate = (XdToManyLink)LinkDelegatesKt.xdLink0_N$default((XdEntityType)((XdEntityType)XdUser.Companion), null, (OnDeletePolicy)onDeletePolicy, (OnDeletePolicy)onDeletePolicy2, (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[5]);
        onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        this.mentionedArticles$delegate = (XdToManyLink)LinkDelegatesKt.xdLink0_N$default((XdEntityType)((XdEntityType)XdArticle.Companion), null, (OnDeletePolicy)onDeletePolicy, (OnDeletePolicy)onDeletePolicy2, (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[6]);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ9\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0019\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem$Companion;", "Lkotlinx/dnq/XdNaturalEntityType;", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "()V", "find", "Lkotlinx/dnq/query/XdQuery;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "start", "", "end", "new", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "author", "date", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "youtrack-time-tracking"})
    public static final class Companion
    extends XdNaturalEntityType<XdIssueWorkItem> {
        @NotNull
        public final XdIssueWorkItem new(@NotNull XdIssue issue2, @NotNull XdUser author2, long date2, @Nullable Function1<? super XdIssueWorkItem, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)author2, (String)"author");
            return (XdIssueWorkItem)Companion.new((Function1)new Function1<XdIssueWorkItem, Unit>(issue2, date2, author2, init){
                final /* synthetic */ XdIssue $issue;
                final /* synthetic */ long $date;
                final /* synthetic */ XdUser $author;
                final /* synthetic */ Function1 $init;

                public final void invoke(@NotNull XdIssueWorkItem $this$new) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                        $this$new.setIssue(this.$issue);
                        $this$new.setDate(XdWorkItemKt.toMidnightInUTC$default(this.$date, null, 1, null));
                        $this$new.setAuthor(this.$author);
                        $this$new.setCreator((XdUser)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getLoggedInUser())));
                        $this$new.setCreated(System.currentTimeMillis());
                        Function1 function1 = this.$init;
                        if (function1 == null) break block0;
                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)$this$new));
                    }
                }
                {
                    this.$issue = xdIssue;
                    this.$date = l;
                    this.$author = xdUser;
                    this.$init = function1;
                    super(1);
                }
            });
        }

        @NotNull
        public final XdQuery<XdIssueWorkItem> find(@NotNull XdUser user, long start2, long end2) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            return XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)Companion), (Function2)((Function2)new Function2<FilteringContext, XdIssueWorkItem, XdSearchingNode>(user, start2, end2){
                final /* synthetic */ XdUser $user;
                final /* synthetic */ long $start;
                final /* synthetic */ long $end;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueWorkItem it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $this$filter.eq((XdEntity)it.getAuthor(), (XdEntity)this.$user).and($this$filter.between((Comparable)Long.valueOf(it.get_date()), TuplesKt.to((Object)this.$start, (Object)this.$end)));
                }
                {
                    this.$user = xdUser;
                    this.$start = l;
                    this.$end = l2;
                    super(2);
                }
            }));
        }

        private Companion() {
            super("IssueWorkItem", (StoreContainer)LegacyStoreContainer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

