/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.parser.api.CharIterableFactory;
import jetbrains.youtrack.parser.api.PrefixIterator;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.periodField.parser.PeriodFieldValue;
import jetbrains.youtrack.timetracking.periodField.parser.PeriodPrefixIterable;
import jetbrains.youtrack.timetracking.persistence.XdWorkTimeSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkTypeSorting;
import jetbrains.youtrack.timetracking.plugin.FormatArgumentException;
import jetbrains.youtrack.timetracking.plugin.WeekDays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.link.XdToOneOptionalLink;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.singleton.XdSingletonEntityType;
import kotlinx.dnq.store.container.StoreContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0001:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0006J\u000e\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u0002012\u0006\u0010.\u001a\u00020\u0006J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u0002012\u0006\u0010#\u001a\u00020,R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R+\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR+\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u000bR/\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R0\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010'\u00a8\u0006;"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdWorkTimeSettings;", "Lkotlinx/dnq/XdEntity;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "", "_worksDaysOfWeek", "get_worksDaysOfWeek", "()I", "set_worksDaysOfWeek", "(I)V", "_worksDaysOfWeek$delegate", "Lkotlinx/dnq/simple/XdProperty;", "allWeekDays", "", "Ljetbrains/youtrack/timetracking/plugin/WeekDays;", "getAllWeekDays", "()Ljava/util/List;", "daysAWeek", "getDaysAWeek", "setDaysAWeek", "daysAWeek$delegate", "minutesADay", "getMinutesADay", "setMinutesADay", "minutesADay$delegate", "Ljetbrains/youtrack/timetracking/persistence/XdWorkTypeSorting;", "workTypeSorting", "getWorkTypeSorting", "()Ljetbrains/youtrack/timetracking/persistence/XdWorkTypeSorting;", "setWorkTypeSorting", "(Ljetbrains/youtrack/timetracking/persistence/XdWorkTypeSorting;)V", "workTypeSorting$delegate", "Lkotlinx/dnq/link/XdToOneOptionalLink;", "value", "worksDaysOfWeek", "getWorksDaysOfWeek", "setWorksDaysOfWeek", "(Ljava/util/List;)V", "beforeFlush", "", "error", "messageId", "", "format", "minutes", "getMinutes", "period", "Lorg/joda/time/Period;", "getPeriod", "isWorkDay", "", "day", "", "zone", "Lorg/joda/time/DateTimeZone;", "parse", "Companion", "youtrack-time-tracking"})
public final class XdWorkTimeSettings
extends XdEntity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdProperty minutesADay$delegate;
    @NotNull
    private final XdProperty daysAWeek$delegate;
    @NotNull
    private final XdProperty _worksDaysOfWeek$delegate;
    @Nullable
    private final XdToOneOptionalLink workTypeSorting$delegate;
    public static final int MINUTES_IN_HOUR = 60;
    private static final int MAX_MINUTES = Integer.MAX_VALUE;
    private static final int MAX_HOURS = 0x2222222;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdWorkTimeSettings.class), "minutesADay", "getMinutesADay()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdWorkTimeSettings.class), "daysAWeek", "getDaysAWeek()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdWorkTimeSettings.class), "_worksDaysOfWeek", "get_worksDaysOfWeek()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdWorkTimeSettings.class), "workTypeSorting", "getWorkTypeSorting()Ljetbrains/youtrack/timetracking/persistence/XdWorkTypeSorting;"))};
        Companion = new Companion(null);
    }

    public void beforeFlush() {
        super.beforeFlush();
        if (this.getMinutesADay() < 0) {
            this.error("WorkTimeSettings.Can_t_have_negative_amount_of_hours_in_a_day");
        }
        if (this.getMinutesADay() == 0) {
            this.error("WorkTimeSettings.You_can_t_have_zero_amount_of_hours_in_a_day");
        }
        if ((long)this.getMinutesADay() > TimeUnit.DAYS.toMinutes(1L)) {
            this.error("WorkTimeSettings.You_can_t_have_more_than_24_hours_in_a_day");
        }
        if (this.getDaysAWeek() <= 0) {
            this.error("WorkTimeSettings.You_can_t_have_negative_or_zero_amount_of_days_in_a_week");
        }
        if (this.getDaysAWeek() > 7) {
            this.error("WorkTimeSettings.You_can_t_have_more_then_7_days_in_a_week");
        }
    }

    private final void error(String messageId) {
        UserConstraintValidationException userConstraintValidationException;
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg(messageId, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(messageId)");
        String message = string;
        if (this.isRemoved()) {
            userConstraintValidationException = new UserConstraintValidationException(message, null, 2, null);
        } else {
            Entity entity2 = this.getEntity();
            if (entity2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
            }
            userConstraintValidationException = new UserConstraintValidationException(message, (Entity)((TransientEntity)entity2));
        }
        UserConstraintValidationException userException = userConstraintValidationException;
        throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)userException);
    }

    public final int getMinutesADay() {
        return ((Number)((Object)this.minutesADay$delegate.getValue((XdEntity)this, $$delegatedProperties[0]))).intValue();
    }

    public final void setMinutesADay(int n) {
        this.minutesADay$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (Comparable)Integer.valueOf(n));
    }

    public final int getDaysAWeek() {
        return ((Number)((Object)this.daysAWeek$delegate.getValue((XdEntity)this, $$delegatedProperties[1]))).intValue();
    }

    public final void setDaysAWeek(int n) {
        this.daysAWeek$delegate.setValue((XdEntity)this, $$delegatedProperties[1], (Comparable)Integer.valueOf(n));
    }

    public final int get_worksDaysOfWeek() {
        return ((Number)((Object)this._worksDaysOfWeek$delegate.getValue((XdEntity)this, $$delegatedProperties[2]))).intValue();
    }

    public final void set_worksDaysOfWeek(int n) {
        this._worksDaysOfWeek$delegate.setValue((XdEntity)this, $$delegatedProperties[2], (Comparable)Integer.valueOf(n));
    }

    @Nullable
    public final XdWorkTypeSorting getWorkTypeSorting() {
        return (XdWorkTypeSorting)this.workTypeSorting$delegate.getValue((XdEntity)this, $$delegatedProperties[3]);
    }

    public final void setWorkTypeSorting(@Nullable XdWorkTypeSorting xdWorkTypeSorting) {
        this.workTypeSorting$delegate.setValue((XdEntity)this, $$delegatedProperties[3], (XdEntity)xdWorkTypeSorting);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WeekDays> getWorksDaysOfWeek() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllWeekDays();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WeekDays it = (WeekDays)((Object)element$iv$iv);
            boolean bl = false;
            if (!((this.get_worksDaysOfWeek() & 1 << it.ordinal()) != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void setWorksDaysOfWeek(@NotNull List<? extends WeekDays> value2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        this.setDaysAWeek(value2.size());
        this.set_worksDaysOfWeek(0);
        Iterable $this$forEach$iv = value2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WeekDays it = (WeekDays)((Object)element$iv);
            boolean bl = false;
            XdWorkTimeSettings xdWorkTimeSettings = this;
            xdWorkTimeSettings.set_worksDaysOfWeek(xdWorkTimeSettings.get_worksDaysOfWeek() + (1 << it.ordinal()));
        }
    }

    public final boolean isWorkDay(long day, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        int dayOfWeek = new DateTime(day, zone).dayOfWeek().get() % 7;
        return (this.get_worksDaysOfWeek() & 1 << dayOfWeek) != 0;
    }

    @NotNull
    public final Period getPeriod(int minutes) {
        return XdWorkTimeSettingsKt.toPeriod(minutes, this.getDaysAWeek(), this.getMinutesADay());
    }

    public final int getMinutes(@NotNull Period period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        int weeks = period.getWeeks();
        int days = period.getDays();
        int hours = period.getHours();
        int minutes = period.getMinutes();
        if (weeks < 0 || days < 0 || hours < 0 || minutes < 0) {
            throw (Throwable)new LogicException("Period values can't be negative");
        }
        int totalDays = weeks * this.getDaysAWeek() + days;
        if (totalDays > Integer.MAX_VALUE / this.getMinutesADay() || totalDays < 0) {
            throw (Throwable)new LogicException("Value is too big");
        }
        if (hours > 0x2222222 || hours < 0) {
            throw (Throwable)new LogicException("Value is too big");
        }
        int totalMinutes = totalDays * this.getMinutesADay() + hours * 60 + minutes;
        if (totalMinutes < 0) {
            throw (Throwable)new LogicException("Value is too big");
        }
        return totalMinutes;
    }

    @NotNull
    public final Period parse(@NotNull String value2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        PrefixIterator<PeriodFieldValue> prefixIterator = new PeriodPrefixIterable().prefixIterator();
        String string2 = value2;
        CharIterableFactory charIterableFactory = jetbrains.charisma.keyword.BeansKt.getCharIterableFactory();
        PrefixIterator<PeriodFieldValue> prefixIterator2 = prefixIterator;
        boolean bl = false;
        string2 = string = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
        bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trimEnd((CharSequence)string3)).toString();
        prefixIterator2.move(charIterableFactory.createCharSequenceIterable((CharSequence)string));
        Sequence sequence = prefixIterator.getValues(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)sequence, (String)"prefixIterator.getValues(null)");
        PeriodFieldValue periodFieldValue = (PeriodFieldValue)((Object)SequencesKt.firstOrNull((Sequence)sequence));
        if (periodFieldValue == null || (periodFieldValue = (Period)periodFieldValue.getFieldValue()) == null) {
            throw (Throwable)((Object)new FormatArgumentException(value2));
        }
        return periodFieldValue;
    }

    @NotNull
    public final String format(int minutes) {
        return BeansKt.getPeriodValueService().format(minutes);
    }

    @NotNull
    public final List<WeekDays> getAllWeekDays() {
        int firstDay = jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getDefaultFirstDayOfWeek();
        List days = ArraysKt.toList((Object[])WeekDays.values());
        if (firstDay != 0) {
            days = CollectionsKt.plus((Collection)days.subList(firstDay, 7), (Iterable)days.subList(0, firstDay));
        }
        return days;
    }

    public XdWorkTimeSettings(@NotNull Entity entity2) {
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        super(entity2);
        this.minutesADay$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.daysAWeek$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this._worksDaysOfWeek$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default((String)"worksDaysOfWeek", null, (int)2, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.workTypeSorting$delegate = (XdToOneOptionalLink)LinkDelegatesKt.xdLink0_1$default((XdEntityType)((XdEntityType)XdWorkTypeSorting.Companion), null, null, null, (int)14, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdWorkTimeSettings$Companion;", "Lkotlinx/dnq/singleton/XdSingletonEntityType;", "Ljetbrains/youtrack/timetracking/persistence/XdWorkTimeSettings;", "()V", "MAX_HOURS", "", "MAX_MINUTES", "MINUTES_IN_HOUR", "initSingleton", "", "youtrack-time-tracking"})
    public static final class Companion
    extends XdSingletonEntityType<XdWorkTimeSettings> {
        protected void initSingleton(@NotNull XdWorkTimeSettings $this$initSingleton) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)$this$initSingleton), (String)"$this$initSingleton");
            $this$initSingleton.setMinutesADay((int)TimeUnit.HOURS.toMinutes(8L));
            $this$initSingleton.setDaysAWeek(5);
            $this$initSingleton.set_worksDaysOfWeek(Integer.parseInt("0111110", 2));
        }

        private Companion() {
            super("WorkTimeSettings", (StoreContainer)LegacyStoreContainer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

