/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.persistence.listeners;

import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.timetracking.periodField.RecalculateIssuesSpentTime;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.listeners.TimeTrackingSettingsListener$updatedSync$1;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.listener.XdEntityListener;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/timetracking/persistence/listeners/TimeTrackingSettingsListener;", "Lkotlinx/dnq/listener/XdEntityListener;", "Ljetbrains/youtrack/timetracking/persistence/XdTimeTrackingSettings;", "()V", "addedSync", "", "added", "updatedSync", "old", "current", "updatedSyncBeforeConstraints", "recalculateAll", "youtrack-time-tracking"})
public final class TimeTrackingSettingsListener
implements XdEntityListener<XdTimeTrackingSettings> {
    public void updatedSyncBeforeConstraints(@NotNull XdTimeTrackingSettings old, @NotNull XdTimeTrackingSettings current) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
                XdPeriodProjectCustomField xdPeriodProjectCustomField = current.getSpentTime();
                if ((xdPeriodProjectCustomField != null ? xdPeriodProjectCustomField.getCondition() : null) != null) break block4;
                XdPeriodProjectCustomField xdPeriodProjectCustomField2 = current.getEstimate();
                if ((xdPeriodProjectCustomField2 != null ? xdPeriodProjectCustomField2.getCondition() : null) == null) break block5;
            }
            if (current.getEnabled()) {
                String string = BeansKt.getLocalizer().localizedMsg("TimeTrackingSettingsListener.cant_use_conditional", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026er.cant_use_conditional\")");
                throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(string, null, 2, null));
            }
            current.setSpentTime(null);
            current.setEstimate(null);
        }
    }

    public void updatedSync(@NotNull XdTimeTrackingSettings old, @NotNull XdTimeTrackingSettings current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)TimeTrackingSettingsListener$updatedSync$1.INSTANCE))) {
            this.recalculateAll(current);
        }
    }

    public void addedSync(@NotNull XdTimeTrackingSettings added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        this.recalculateAll(added);
    }

    private final void recalculateAll(@NotNull XdTimeTrackingSettings $this$recalculateAll) {
        XdPeriodProjectCustomField timeSpent2 = $this$recalculateAll.getSpentTime();
        if ($this$recalculateAll.getEnabled() && timeSpent2 != null) {
            Entity author2 = jetbrains.youtrack.core.security.BeansKt.getLoggedInUserOrNull();
            if (author2 == null) {
                throw (Throwable)new RuntimeException("Could not start spent time refactoring due to undefined refactoring author");
            }
            jetbrains.charisma.persistence.customfields.BeansKt.getUserActionJobContainer().addOrReplaceTransactionSafeSilentTransactionalJobOnBehalfOf(author2, (Runnable)new RecalculateIssuesSpentTime(timeSpent2), "Recount spent time for issues in project " + $this$recalculateAll.getProject().getName(), new Entity[]{$this$recalculateAll.getEntity()});
        }
    }

    public void addedAsync(@NotNull XdTimeTrackingSettings added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)added);
    }

    public void addedSyncAfterConstraints(@NotNull XdTimeTrackingSettings added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)added);
    }

    public void addedSyncBeforeConstraints(@NotNull XdTimeTrackingSettings added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)added);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
    public void addedSyncBeforeFlush(@NotNull XdTimeTrackingSettings added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added);
    }

    public void removedAsync(@NotNull XdTimeTrackingSettings removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)removed);
    }

    public void removedSync(@NotNull XdTimeTrackingSettings removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)removed);
    }

    public void removedSyncAfterConstraints(@NotNull XdTimeTrackingSettings removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)removed);
    }

    public void removedSyncBeforeConstraints(@NotNull XdTimeTrackingSettings removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)removed);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
    public void removedSyncBeforeFlush(@NotNull XdTimeTrackingSettings added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added);
    }

    public void updatedAsync(@NotNull XdTimeTrackingSettings old, @NotNull XdTimeTrackingSettings current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncAfterConstraints(@NotNull XdTimeTrackingSettings old, @NotNull XdTimeTrackingSettings current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
    public void updatedSyncBeforeFlush(@NotNull XdTimeTrackingSettings old, @NotNull XdTimeTrackingSettings current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
    }
}

