/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.workflow;

import jetbrains.charisma.customfields.persistence.XdAbstractCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiJsAcceptsJson;
import jetbrains.youtrack.core.annotations.ApiJsIgnore;
import jetbrains.youtrack.core.annotations.ApiJsOptional;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiMpsType;
import jetbrains.youtrack.core.annotations.ApiMpsTypes;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.annotations.ApiSince;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.periodField.PeriodFieldType;
import jetbrains.youtrack.timetracking.persistence.XdBaseWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import jetbrains.youtrack.timetracking.persistence.XdWorkTimeSettings;
import jetbrains.youtrack.timetracking.workflow.TimeTrackingExtensionsKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.TransientEntityUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0007\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0007\u001a\f\u0010\u0010\u001a\u00020\u0006*\u00020\u0011H\u0007\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0006H\u0007\u001a)\u0010\u0014\u001a\u00020\u0015*\u00020\u00112\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010\u0018\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0007\u001a$\u0010\u001c\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015H\u0007\u001a#\u0010\"\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010$\u001a\u0014\u0010%\u001a\u00020\u0013*\u00020\u00112\u0006\u0010#\u001a\u00020\u0006H\u0007\u001a\u0014\u0010&\u001a\u00020\u0013*\u00020\u001b2\u0006\u0010#\u001a\u00020\u001aH\u0007\u001a\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001aM\u0010(\u001a\u00020\u0002*\u00020\u00032\n\b\u0001\u0010)\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0001\u0010*\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,H\u0007\u00a2\u0006\u0002\u0010-\u00a8\u0006."}, d2={"editedWorkItems", "", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "findPeriodFieldPrototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "Ljetbrains/youtrack/timetracking/persistence/XdTimeTrackingSettings;", "name", "", "getPeriodCustomField", "Ljetbrains/youtrack/timetracking/persistence/XdPeriodProjectCustomField;", "localizationId", "getPeriodFieldOldValueInMinutes", "", "fieldName", "getPeriodFieldValueInMinutes", "getTimeTrackingSettings", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "initDefaults", "", "intervalToWorkingMinutes", "", "start", "end", "(Ljetbrains/youtrack/core/persistent/issue/XdProject;Ljava/lang/Long;Ljava/lang/Long;)J", "isUsingMarkdown", "", "Ljetbrains/youtrack/timetracking/persistence/XdBaseWorkItem;", "new", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem$Companion;", "issue", "author", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "date", "setPeriodFieldValueInMinutes", "value", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;Ljava/lang/String;Ljava/lang/Integer;)V", "setTimeTrackingSettings", "setUsingMarkdown", "workItems", "workflowAddWorkItem", "description", "duration", "type", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;Ljava/lang/String;Ljava/lang/Long;Ljetbrains/youtrack/core/persistent/user/XdUser;Ljava/lang/Integer;Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;)Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "youtrack-time-tracking"})
public final class TimeTrackingExtensionsKt {
    @Deprecated(message="for Workflow only")
    @ApiDoc(value="Adds a work item to the issue.")
    @ApiDocReturns(value="The new work item.")
    @ApiMethod(name="addWorkItem", scopes={})
    @ApiJsAcceptsJson
    @NotNull
    public static final XdIssueWorkItem workflowAddWorkItem(@NotNull XdIssue $this$workflowAddWorkItem, @ApiDoc(value="The description of the work item.") @Nullable String description, @ApiJsOptional @ApiDoc(value="The date that is assigned to the work item.") @ApiMpsType(value=ApiMpsTypes.INSTANT) @Nullable Long date2, @ApiJsOptional @ApiDoc(value="The user who performed the work.") @Nullable XdUser author2, @ApiDoc(value="The work duration in minutes.") @Nullable Integer duration2, @ApiJsOptional @ApiDoc(value="The work item type.") @Nullable XdWorkItemType type2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$workflowAddWorkItem, (String)"$this$workflowAddWorkItem");
        XdUser xdUser = author2;
        if (xdUser == null) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        Long l = date2;
        return XdIssueWorkItem.Companion.new($this$workflowAddWorkItem, xdUser, l != null ? l : System.currentTimeMillis(), (Function1<? super XdIssueWorkItem, Unit>)((Function1)new Function1<XdIssueWorkItem, Unit>(duration2, type2, description){
            final /* synthetic */ Integer $duration;
            final /* synthetic */ XdWorkItemType $type;
            final /* synthetic */ String $description;

            public final void invoke(@NotNull XdIssueWorkItem $this$new) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                $this$new.setDuration(this.$duration == null || this.$duration <= 0 ? 1 : this.$duration);
                $this$new.setType(this.$type);
                $this$new.setDescription(this.$description);
            }
            {
                this.$duration = n;
                this.$type = xdWorkItemType;
                this.$description = string;
                super(1);
            }
        }));
    }

    @ApiDoc(value="Gets the number of minutes that occurred during working hours in a specified interval.\nFor example, if the interval is two days and the number of working hours in a day is set to 8, the result is 2 * 8 * 60 = 960")
    @ApiDocReturns(value="The number of minutes that occurred during working hours in the specified interval.")
    @ApiMethod(scopes={})
    public static final long intervalToWorkingMinutes(@NotNull XdProject $this$intervalToWorkingMinutes, @ApiDoc(value="Start of the interval.") @Nullable Long start2, @ApiDoc(value="End of the interval.") @Nullable Long end2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$intervalToWorkingMinutes, (String)"$this$intervalToWorkingMinutes");
        Long l = end2;
        Long l2 = start2;
        long duration2 = (l != null ? l : 0L) - (l2 != null ? l2 : 0L);
        int minutes = (int)(duration2 / (long)1000 / (long)60);
        int hours = minutes / 60;
        minutes = Math.min(minutes % 60, 60);
        int days = hours / 24;
        hours = Math.min(hours % 24, BeansKt.getWorkTimeSettings().getMinutesADay() / 60);
        int weeks = days / 7;
        days = Math.min(days % 7, BeansKt.getWorkTimeSettings().getDaysAWeek());
        XdWorkTimeSettings xdWorkTimeSettings = BeansKt.getWorkTimeSettings();
        Period period = new Period().withWeeks(weeks).withDays(days).withHours(hours).withMinutes(minutes);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period().withWeeks(weeks\u2026urs).withMinutes(minutes)");
        return xdWorkTimeSettings.getMinutes(period);
    }

    @Deprecated(message="for Workflow only")
    @ApiDoc(value="The set of work items that have been added to the issue.")
    @ApiMethod(name="getWorkItems", scopes={})
    @NotNull
    public static final Iterable<XdIssueWorkItem> workItems(@NotNull XdIssue $this$workItems) {
        Intrinsics.checkParameterIsNotNull((Object)$this$workItems, (String)"$this$workItems");
        return XdQueryKt.asIterable(XdWorkItemKt.getWorkItems($this$workItems));
    }

    @Deprecated(message="for Workflow only")
    @ApiDoc(value="The set of work items that are edited in the current transaction.\nWork items that are added and removed are not considered to be edited.\nInstead, these are represented by the `issue.workItems.added` and\n`issue.workItems.removed` properties.")
    @ApiSince(value="2017.4.37824")
    @ApiMethod(name="getEditedWorkItems", scopes={})
    @NotNull
    public static final Iterable<XdIssueWorkItem> editedWorkItems(@NotNull XdIssue $this$editedWorkItems) {
        Intrinsics.checkParameterIsNotNull((Object)$this$editedWorkItems, (String)"$this$editedWorkItems");
        return SequencesKt.asIterable((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence(XdWorkItemKt.getWorkItems($this$editedWorkItems)), (Function1)editedWorkItems.1.INSTANCE));
    }

    @Deprecated(message="for Workflow only")
    @ApiDoc(value="When `true`, the work item description is parsed as Markdown. When `false`, the work item description is parsed as YouTrack Wiki.\nChanging this value does not transform the markup from one syntax to another.")
    @ApiSince(value="2017.4.38870")
    @ApiMethod(scopes={})
    public static final boolean isUsingMarkdown(@NotNull XdBaseWorkItem $this$isUsingMarkdown) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$isUsingMarkdown), (String)"$this$isUsingMarkdown");
        return $this$isUsingMarkdown.getUsesMarkdown();
    }

    @Deprecated(message="for Workflow only")
    @ApiMethod(scopes={})
    public static final void setUsingMarkdown(@NotNull XdBaseWorkItem $this$setUsingMarkdown, boolean value2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$setUsingMarkdown), (String)"$this$setUsingMarkdown");
        $this$setUsingMarkdown.setUsesMarkdown(value2);
    }

    @Deprecated(message="for Workflow only")
    @ApiMethod(scopes={ApiScope.PLUGIN})
    public static final void initDefaults(@NotNull XdTimeTrackingSettings $this$initDefaults) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$initDefaults), (String)"$this$initDefaults");
        $this$initDefaults.setEstimate(TimeTrackingExtensionsKt.getPeriodCustomField($this$initDefaults, "youtrack.timetracking.estimation"));
        $this$initDefaults.setSpentTime(TimeTrackingExtensionsKt.getPeriodCustomField($this$initDefaults, "youtrack.timetracking.spent_time"));
    }

    @Deprecated(message="for OLD WORKFLOW only")
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsIgnore
    public static final int getPeriodFieldValueInMinutes(@NotNull XdIssue $this$getPeriodFieldValueInMinutes, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPeriodFieldValueInMinutes, (String)"$this$getPeriodFieldValueInMinutes");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProjectCustomField field = XdProjectCustomFieldKt.getProjectCustomField((XdProject)$this$getPeriodFieldValueInMinutes.getProject(), (String)fieldName);
        if (field != null) {
            Integer value2;
            XdCustomFieldPrototype prototype = field.getPrototype();
            Integer n = value2 = BeansKt.getPeriodFieldType().getValueInMinutes($this$getPeriodFieldValueInMinutes, (XdAbstractCustomFieldPrototype)prototype);
            return n != null ? n : 0;
        }
        throw (Throwable)new IllegalArgumentException("Field " + fieldName + " is not found in project " + $this$getPeriodFieldValueInMinutes.getProject().getShortName());
    }

    @Deprecated(message="for OLD WORKFLOW only")
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsIgnore
    public static final int getPeriodFieldOldValueInMinutes(@NotNull XdIssue $this$getPeriodFieldOldValueInMinutes, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPeriodFieldOldValueInMinutes, (String)"$this$getPeriodFieldOldValueInMinutes");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProjectCustomField field = XdProjectCustomFieldKt.getProjectCustomField((XdProject)$this$getPeriodFieldOldValueInMinutes.getProject(), (String)fieldName);
        if (field != null) {
            Integer value2;
            XdCustomFieldPrototype prototype = field.getPrototype();
            Integer n = value2 = (Integer)TransientEntityUtilKt.getOldPrimitiveValue((XdEntity)((XdEntity)$this$getPeriodFieldOldValueInMinutes), (String)prototype.getId());
            return n != null ? n : 0;
        }
        throw (Throwable)new IllegalArgumentException("Field " + fieldName + " is not found in project " + $this$getPeriodFieldOldValueInMinutes.getProject().getShortName());
    }

    @Deprecated(message="for OLD WORKFLOW only")
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsIgnore
    public static final void setPeriodFieldValueInMinutes(@NotNull XdIssue $this$setPeriodFieldValueInMinutes, @NotNull String fieldName, @Nullable Integer value2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setPeriodFieldValueInMinutes, (String)"$this$setPeriodFieldValueInMinutes");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProjectCustomField field = XdProjectCustomFieldKt.getProjectCustomField((XdProject)$this$setPeriodFieldValueInMinutes.getProject(), (String)fieldName);
        if (field == null) {
            throw (Throwable)new IllegalArgumentException("Field " + fieldName + " is not found in project " + $this$setPeriodFieldValueInMinutes.getProject().getShortName());
        }
        XdCustomFieldPrototype prototype = field.getPrototype();
        PeriodFieldType.setValueInMinutes$default(BeansKt.getPeriodFieldType(), $this$setPeriodFieldValueInMinutes, (XdAbstractCustomFieldPrototype)prototype, value2, true, null, 16, null);
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    @ApiDoc(value="Time tracking settings of the project.")
    @NotNull
    public static final XdTimeTrackingSettings getTimeTrackingSettings(@NotNull XdProject $this$getTimeTrackingSettings) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getTimeTrackingSettings, (String)"$this$getTimeTrackingSettings");
        return XdTimeTrackingSettingsKt.getTimeTrackingSettings($this$getTimeTrackingSettings);
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    public static final void setTimeTrackingSettings(@NotNull XdProject $this$setTimeTrackingSettings, @NotNull XdTimeTrackingSettings value2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setTimeTrackingSettings, (String)"$this$setTimeTrackingSettings");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
        XdTimeTrackingSettingsKt.setTimeTrackingSettings($this$setTimeTrackingSettings, value2);
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    @NotNull
    public static final XdIssueWorkItem new(@NotNull XdIssueWorkItem.Companion $this$new, @NotNull XdIssue issue2, @NotNull XdUser author2, long date2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$this$new");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)author2, (String)"author");
        return $this$new.new(issue2, author2, date2, (Function1<? super XdIssueWorkItem, Unit>)((Function1)new.1.INSTANCE));
    }

    private static final XdPeriodProjectCustomField getPeriodCustomField(@NotNull XdTimeTrackingSettings $this$getPeriodCustomField, String localizationId) {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getDefaultMsg(localizationId, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.getDefaultMsg(localizationId)");
        XdCustomFieldPrototype prototype = TimeTrackingExtensionsKt.findPeriodFieldPrototype($this$getPeriodCustomField, string);
        XdProjectCustomField projectCustomField = BeansKt.getPeriodFieldType().getProjectCustomField($this$getPeriodCustomField.getProject(), prototype);
        if (!jetbrains.charisma.installation.BeansKt.getLocalizationService().isDefaultLocale()) {
            projectCustomField.getPrototype().setLocalizedName(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getMsgInLocale(localizationId, jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLocale(), new Object[0]));
        }
        XdProjectCustomField xdProjectCustomField = projectCustomField;
        if (xdProjectCustomField == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField");
        }
        return (XdPeriodProjectCustomField)xdProjectCustomField;
    }

    private static final XdCustomFieldPrototype findPeriodFieldPrototype(@NotNull XdTimeTrackingSettings $this$findPeriodFieldPrototype, String name2) {
        XdCustomFieldPrototype prototype = BeansKt.getPeriodFieldType().findOrCreatePrototype(name2);
        if (Intrinsics.areEqual((Object)prototype.getType().getName(), (Object)BeansKt.getPeriodFieldType().getName()) ^ true) {
            TimeTrackingExtensionsKt.findPeriodFieldPrototype($this$findPeriodFieldPrototype, name2 + "_");
        }
        return prototype;
    }
}

