/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.upsource.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.youtrack.api.ring.RingConfig;
import jetbrains.youtrack.api.ring.RingServiceDiscovery;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.vcs.XdVcsChange;
import jetbrains.youtrack.integration.service.AbstractVcsService;
import jetbrains.youtrack.integration.service.AbstractVcsServiceKt;
import jetbrains.youtrack.integration.service.misc.ExceptionOutputKt;
import jetbrains.youtrack.integration.upsource.BeansKt;
import jetbrains.youtrack.integration.upsource.Localization;
import jetbrains.youtrack.integration.upsource.impl.UpsourceDiscoveryService;
import jetbrains.youtrack.integration.upsource.impl.UpsourceService;
import jetbrains.youtrack.integration.upsource.persistence.XdUpsourceChangesProcessor;
import jetbrains.youtrack.integration.upsource.persistence.XdUpsourceServer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.creator.XdFindOrNewKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@org.springframework.stereotype.Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0015*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/integration/upsource/impl/UpsourceDiscoveryService;", "", "ringServiceDiscovery", "Ljetbrains/youtrack/api/ring/RingServiceDiscovery;", "upsourceService", "Ljetbrains/youtrack/integration/upsource/impl/UpsourceService;", "(Ljetbrains/youtrack/api/ring/RingServiceDiscovery;Ljetbrains/youtrack/integration/upsource/impl/UpsourceService;)V", "logger", "Lmu/KLogger;", "ringConfig", "Ljetbrains/youtrack/api/ring/RingConfig;", "getRingConfig", "()Ljetbrains/youtrack/api/ring/RingConfig;", "allResources", "", "Ljetbrains/jetpass/api/security/Resource;", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "discover", "", "discoverAsync", "", "discoverServers", "removeIfPossible", "", "processor", "Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;", "sync", "Ljetbrains/youtrack/integration/upsource/persistence/XdUpsourceServer;", "service", "Ljetbrains/jetpass/api/Service;", "youtrack-upsource-integration"})
public class UpsourceDiscoveryService {
    private final KLogger logger;
    private final RingServiceDiscovery ringServiceDiscovery;
    private final UpsourceService upsourceService;

    @NotNull
    public RingConfig getRingConfig() {
        return jetbrains.youtrack.config.BeansKt.getRingConfig();
    }

    @NotNull
    public final String discover() {
        String string = this.discoverServers();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void discoverAsync() {
        jetbrains.charisma.persistent.BeansKt.getQuartzThreadExecutor().execute(new Runnable(this){
            final /* synthetic */ UpsourceDiscoveryService this$0;

            public final void run() {
                UpsourceDiscoveryService.access$discoverServers(this.this$0);
            }
            {
                this.this$0 = upsourceDiscoveryService;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String discoverServers() {
        Object object;
        this.logger.warn("[Upsource integration] start discovering");
        if (!this.getRingConfig().isEnabled()) {
            this.logger.warn("[Upsource integration] Hub integration is not active, skipping discovery");
            return null;
        }
        if (!BeansKt.getUpsourceAux().startDiscovery()) {
            this.logger.info("[Upsource integration] Discovery already in progress");
            return null;
        }
        try {
            try {
                object = this.ringServiceDiscovery.allByType("Upsource");
            }
            catch (Exception e) {
                this.logger.warn("[Upsource integration] there is no corresponding Upsource services in Hub. Let's skip discovery.", (Throwable)e);
                String string = null;
                BeansKt.getUpsourceAux().endDiscovery();
                return string;
            }
            Iterable iterable = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"try {\n                ri\u2026return null\n            }");
            Iterable allUpsourceServers = iterable;
            Iterable $this$forEach$iv = XdQueryKt.toList((XdQuery)XdUpsourceServer.Companion.all());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean unused;
                boolean bl;
                XdUpsourceServer server2;
                block22: {
                    server2 = (XdUpsourceServer)((Object)element$iv);
                    boolean bl2 = false;
                    this.logger.info("[Upsource integration] checking server " + server2.getUrl());
                    Iterable $this$all$iv = allUpsourceServers;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            Service it = (Service)element$iv2;
                            boolean bl3 = false;
                            Service service = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)service, (String)"it");
                            if (Intrinsics.areEqual((Object)service.getId(), (Object)server2.getServiceId()) ^ true && Intrinsics.areEqual((Object)it.getHomeUrl(), (Object)server2.getUrl()) ^ true) continue;
                            bl = false;
                            break block22;
                        }
                        bl = true;
                    }
                }
                if (!(unused = bl)) continue;
                this.logger.info("[Upsource integration] there is no corresponding Hub service for server " + server2.getUrl());
                this.logger.info("[Upsource integration] checking " + server2.getUrl() + " for further removal");
                List cps2 = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdVcsChangeProcessor.Companion), (Function2)((Function2)new Function2<FilteringContext, XdVcsChangeProcessor, XdSearchingNode>(server2){
                    final /* synthetic */ XdUpsourceServer $server;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdVcsChangeProcessor it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((XdEntity)it.getServer(), (XdEntity)this.$server);
                    }
                    {
                        this.$server = xdUpsourceServer;
                        super(2);
                    }
                })));
                if (cps2.isEmpty()) {
                    this.logger.info("[Upsource integration] " + server2.getUrl() + " has no change processors. Remove it.");
                    server2.delete();
                    LegacySupportKt.flush();
                    continue;
                }
                Iterable $this$forEach$iv2 = cps2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    XdVcsChangeProcessor it = (XdVcsChangeProcessor)element$iv3;
                    boolean bl4 = false;
                    if (!this.removeIfPossible(it)) continue;
                    LegacySupportKt.flush();
                }
            }
            for (Service service : allUpsourceServers) {
                StringBuilder stringBuilder = new StringBuilder().append("[Upsource integration] service found on ");
                Service service2 = service;
                Intrinsics.checkExpressionValueIsNotNull((Object)service2, (String)"service");
                this.logger.info(stringBuilder.append(service2.getHomeUrl()).toString());
                XdUpsourceServer server3 = (XdUpsourceServer)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdUpsourceServer.Companion), (Function2)((Function2)new Function2<FilteringContext, XdUpsourceServer, XdSearchingNode>(service){
                    final /* synthetic */ Service $service;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUpsourceServer it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        Comparable comparable = (Comparable)((Object)it.getUrl());
                        Service service = this.$service;
                        Intrinsics.checkExpressionValueIsNotNull((Object)service, (String)"service");
                        return $this$filter.eq(comparable, (Comparable)((Object)service.getHomeUrl()));
                    }
                    {
                        this.$service = service;
                        super(2);
                    }
                })));
                if (server3 == null) {
                    XdQuery servers2 = XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdUpsourceServer.Companion), (Function2)((Function2)new Function2<FilteringContext, XdUpsourceServer, XdSearchingNode>(service){
                        final /* synthetic */ Service $service;

                        @NotNull
                        public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUpsourceServer it) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                            Comparable comparable = (Comparable)((Object)it.getServiceId());
                            Service service = this.$service;
                            Intrinsics.checkExpressionValueIsNotNull((Object)service, (String)"service");
                            return $this$filter.eq(comparable, (Comparable)((Object)service.getId()));
                        }
                        {
                            this.$service = service;
                            super(2);
                        }
                    }));
                    if (XdQueryKt.size((XdQuery)servers2) == 1) {
                        server3 = (XdUpsourceServer)XdQueryKt.first((XdQuery)servers2);
                        this.logger.info("[Upsource integration] updating server url from " + server3.getUrl() + " to " + service.getHomeUrl());
                        String string = service.getHomeUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.homeUrl");
                        server3.setUrl(string);
                    } else {
                        this.logger.info("[Upsource integration] creating new upsource integration " + service.getHomeUrl());
                        String string = service.getHomeUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.homeUrl");
                        String string2 = service.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"service.id");
                        server3 = XdUpsourceServer.Companion.new(string, string2);
                    }
                } else {
                    this.logger.info("[Upsource integration] updating server on " + service.getHomeUrl() + " to serviceId " + service.getId());
                    String string = service.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.id");
                    server3.setServiceId(string);
                }
                if (server3.isEnabled()) {
                    this.sync(server3, service);
                    this.logger.info("[Upsource integration] creating mappings for " + service.getHomeUrl());
                    continue;
                }
                this.logger.warn("[Upsource integration] server " + service.getHomeUrl() + " is disabled");
            }
            object = null;
            return object;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, (Function0)discoverServers.2.INSTANCE);
            Function1<Object, String> function1 = Localization.INSTANCE.getDiscoveryFailure();
            String string = ExceptionOutputKt.createLocalizationObject((Exception)e).getLocalizedMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"createLocalizationObject(e).localizedMessage");
            object = (String)function1.invoke((Object)string);
            return object;
        }
        finally {
            BeansKt.getUpsourceAux().endDiscovery();
        }
    }

    private final void sync(@NotNull XdUpsourceServer $this$sync, Service service) {
        boolean bl = false;
        HashSet<XdUpsourceChangesProcessor> newCps = new HashSet<XdUpsourceChangesProcessor>();
        for (XdProject project : XdQueryKt.toList((XdQuery)XdProject.Companion.all())) {
            Iterable<Resource> resources;
            if (this.allResources(project) == null) {
                continue;
            }
            boolean bl2 = false;
            HashSet<XdUpsourceChangesProcessor> cps2 = new HashSet<XdUpsourceChangesProcessor>();
            for (Resource resource : resources) {
                Service service2 = resource.getService();
                Intrinsics.checkExpressionValueIsNotNull((Object)service2, (String)"resource.service");
                if (!Intrinsics.areEqual((Object)service2.getId(), (Object)service.getId())) continue;
                XdUpsourceChangesProcessor cp2 = (XdUpsourceChangesProcessor)XdFindOrNewKt.findOrNew((XdEntityType)((XdEntityType)XdUpsourceChangesProcessor.Companion), (Function1)((Function1)new Function1<XdUpsourceChangesProcessor, Unit>(project, resource){
                    final /* synthetic */ XdProject $project;
                    final /* synthetic */ Resource $resource;

                    public final void invoke(@NotNull XdUpsourceChangesProcessor $this$findOrNew) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$findOrNew), (String)"$receiver");
                        $this$findOrNew.setProject(this.$project);
                        String string = this.$resource.getKey();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resource.key");
                        $this$findOrNew.setUpsourceHubResourceKey(string);
                    }
                    {
                        this.$project = xdProject;
                        this.$resource = resource;
                        super(1);
                    }
                }));
                cp2.setUpsourceHubResourceId(resource.getId());
                cp2.setServer($this$sync);
                cp2.setUpsourceProjectName(resource.getName());
                if (cp2.isNew()) {
                    cp2.setEnabled(true);
                    cp2.setTaxidermy(true);
                    newCps.add(cp2);
                }
                cps2.add(cp2);
            }
            Iterable $this$forEach$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdUpsourceChangesProcessor.Companion), (Function2)((Function2)new Function2<FilteringContext, XdUpsourceChangesProcessor, XdSearchingNode>($this$sync, project){
                final /* synthetic */ XdUpsourceServer $this_sync;
                final /* synthetic */ XdProject $project;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUpsourceChangesProcessor it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $this$filter.eq((XdEntity)it.getServer(), (XdEntity)this.$this_sync).and($this$filter.eq((XdEntity)it.getProject(), (XdEntity)this.$project));
                }
                {
                    this.$this_sync = xdUpsourceServer;
                    this.$project = xdProject;
                    super(2);
                }
            })));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XdUpsourceChangesProcessor it = (XdUpsourceChangesProcessor)((Object)element$iv);
                boolean bl3 = false;
                if (cps2.contains((Object)it) || this.removeIfPossible(it) || !it.isEnabled()) continue;
                it.setOrphan(true);
                AbstractVcsServiceKt.setStateMessage((XdVcsChangeProcessor)it, (String)((String)Localization.INSTANCE.getNoCorrespondingUpsourceProjectFound().invoke()));
            }
        }
        LegacySupportKt.flush();
        this.upsourceService.asyncPull($this$sync, (Collection<XdUpsourceChangesProcessor>)newCps);
    }

    @Nullable
    public Iterable<Resource> allResources(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = jetbrains.charisma.ring.BeansKt.getRingDataStore().getProjectRingId(project);
        if (string == null) {
            return null;
        }
        String projectRingId = string;
        IdItem idItem = BeansKt.getRingAPI().getProjectDAO().get(projectRingId);
        if (idItem == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"ringAPI.projectDAO.get(projectRingId)!!");
        return ((Project)idItem).getResources();
    }

    private final boolean removeIfPossible(XdVcsChangeProcessor processor) {
        boolean hasChanges2 = XdQueryKt.isNotEmpty((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdVcsChange.Companion), (Function2)((Function2)new Function2<FilteringContext, XdVcsChange, XdSearchingNode>(processor){
            final /* synthetic */ XdVcsChangeProcessor $processor;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdVcsChange it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.contains((XdQuery)it.getProcessors(), (XdEntity)this.$processor);
            }
            {
                this.$processor = xdVcsChangeProcessor;
                super(2);
            }
        })));
        if (!hasChanges2) {
            processor.delete();
            return true;
        }
        return false;
    }

    public UpsourceDiscoveryService(@NotNull RingServiceDiscovery ringServiceDiscovery, @NotNull UpsourceService upsourceService) {
        Intrinsics.checkParameterIsNotNull((Object)ringServiceDiscovery, (String)"ringServiceDiscovery");
        Intrinsics.checkParameterIsNotNull((Object)((Object)upsourceService), (String)"upsourceService");
        this.ringServiceDiscovery = ringServiceDiscovery;
        this.upsourceService = upsourceService;
        this.logger = AbstractVcsService.Companion.getLogger();
    }

    public static final /* synthetic */ String access$discoverServers(UpsourceDiscoveryService $this) {
        return $this.discoverServers();
    }
}

