/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.upsource.persistence;

import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.dao.api.security.ProjectDAO;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.XdVcsServer;
import jetbrains.youtrack.integration.upsource.BeansKt;
import jetbrains.youtrack.integration.upsource.persistence.XdUpsourceServer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdNaturalEntityType;
import kotlinx.dnq.simple.XdMutableConstrainedProperty;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.store.container.StoreContainer;
import mu.KLoggable;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiDoc(value="$ignore")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016R/\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R/\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR+\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\r\u001a\u0004\b\u001d\u0010\t\"\u0004\b\u001e\u0010\u000bR/\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\r\u001a\u0004\b!\u0010\t\"\u0004\b\"\u0010\u000b\u00a8\u0006+"}, d2={"Ljetbrains/youtrack/integration/upsource/persistence/XdUpsourceChangesProcessor;", "Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "", "hash", "getHash", "()Ljava/lang/String;", "setHash", "(Ljava/lang/String;)V", "hash$delegate", "Lkotlinx/dnq/simple/XdMutableConstrainedProperty;", "logPrefix", "getLogPrefix", "", "orphan", "getOrphan", "()Z", "setOrphan", "(Z)V", "orphan$delegate", "Lkotlinx/dnq/simple/XdProperty;", "upsourceHubResourceId", "getUpsourceHubResourceId", "setUpsourceHubResourceId", "upsourceHubResourceId$delegate", "upsourceHubResourceKey", "getUpsourceHubResourceKey", "setUpsourceHubResourceKey", "upsourceHubResourceKey$delegate", "upsourceProjectName", "getUpsourceProjectName", "setUpsourceProjectName", "upsourceProjectName$delegate", "canSeeChanges", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "constructor", "", "isAccessible", "Companion", "youtrack-upsource-integration"})
public final class XdUpsourceChangesProcessor
extends XdVcsChangeProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdProperty orphan$delegate;
    @Nullable
    private final XdMutableConstrainedProperty hash$delegate;
    @NotNull
    private final XdMutableConstrainedProperty upsourceHubResourceKey$delegate;
    @Nullable
    private final XdMutableConstrainedProperty upsourceHubResourceId$delegate;
    @Nullable
    private final XdMutableConstrainedProperty upsourceProjectName$delegate;
    @NotNull
    private static final KLogger logger;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdUpsourceChangesProcessor.class), "orphan", "getOrphan()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdUpsourceChangesProcessor.class), "hash", "getHash()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdUpsourceChangesProcessor.class), "upsourceHubResourceKey", "getUpsourceHubResourceKey()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdUpsourceChangesProcessor.class), "upsourceHubResourceId", "getUpsourceHubResourceId()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdUpsourceChangesProcessor.class), "upsourceProjectName", "getUpsourceProjectName()Ljava/lang/String;"))};
        Companion = new Companion(null);
        logger = Companion.logger();
    }

    public void constructor() {
        this.setEnabled(true);
    }

    public final boolean getOrphan() {
        return (Boolean)this.orphan$delegate.getValue((XdEntity)this, $$delegatedProperties[0]);
    }

    public final void setOrphan(boolean bl) {
        this.orphan$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (Comparable)Boolean.valueOf(bl));
    }

    @Nullable
    public final String getHash() {
        return (String)this.hash$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setHash(@Nullable String string) {
        this.hash$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    @NotNull
    public final String getUpsourceHubResourceKey() {
        return (String)this.upsourceHubResourceKey$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setUpsourceHubResourceKey(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.upsourceHubResourceKey$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
    }

    @Nullable
    public final String getUpsourceHubResourceId() {
        return (String)this.upsourceHubResourceId$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setUpsourceHubResourceId(@Nullable String string) {
        this.upsourceHubResourceId$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
    }

    @Nullable
    public final String getUpsourceProjectName() {
        return (String)this.upsourceProjectName$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public final void setUpsourceProjectName(@Nullable String string) {
        this.upsourceProjectName$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)string);
    }

    public boolean canSeeChanges(@NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return this.isAccessible(user);
    }

    @NotNull
    public String getLogPrefix() {
        return "Upsource Integration [" + this.getProject().getShortName() + "<-" + this.getUpsourceProjectName() + '(' + this.getUpsourceHubResourceKey() + ")]: ";
    }

    public boolean isAccessible(@NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (user.isService() || user.isSystem()) {
            return true;
        }
        XdVcsServer xdVcsServer = this.getServer();
        if (xdVcsServer == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.integration.upsource.persistence.XdUpsourceServer");
        }
        String permissionId = BeansKt.getUpsourceService().getReadRevisionsPermissionId((XdUpsourceServer)xdVcsServer);
        if (permissionId == null) {
            this.logError("Failed to find id of a permission that defines if a user has access to an Upsource project");
            return false;
        }
        String userRingId = jetbrains.charisma.ring.BeansKt.getRingDataStore().getUserRingId(user);
        if (userRingId == null) {
            Companion.getLogger().warn((Function0)new Function0<String>(user){
                final /* synthetic */ XdUser $user;

                @NotNull
                public final String invoke() {
                    return "ring id is not specified for " + this.$user.getLogin();
                }
                {
                    this.$user = xdUser;
                    super(0);
                }
            });
            return false;
        }
        Set accessibleProjectIds = BeansKt.getRingAPI().getPermissionCache().user(userRingId, true).withPermission(permissionId).getAccessibleProjects();
        ProjectDAO projectDAO = BeansKt.getRingAPI().getProjectDAO();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDAO, (String)"ringAPI.projectDAO");
        Project project = projectDAO.getGlobal();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ringAPI.projectDAO.global");
        String globalProjectId = project.getId();
        String projectRingId = jetbrains.charisma.ring.BeansKt.getRingDataStore().getProjectRingId(this.getProject());
        return CollectionsKt.contains((Iterable)accessibleProjectIds, (Object)projectRingId) || accessibleProjectIds.contains(globalProjectId);
    }

    public XdUpsourceChangesProcessor(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(entity);
        this.orphan$delegate = (XdProperty)PropertyDelegatesKt.xdBooleanProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.hash$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdStringProp$default((boolean)false, null, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this.upsourceHubResourceKey$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.upsourceHubResourceId$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdStringProp$default((boolean)false, null, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
        this.upsourceProjectName$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdStringProp$default((boolean)false, null, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[4]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/integration/upsource/persistence/XdUpsourceChangesProcessor$Companion;", "Lkotlinx/dnq/XdNaturalEntityType;", "Ljetbrains/youtrack/integration/upsource/persistence/XdUpsourceChangesProcessor;", "Lmu/KLoggable;", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "youtrack-upsource-integration"})
    public static final class Companion
    extends XdNaturalEntityType<XdUpsourceChangesProcessor>
    implements KLoggable {
        @NotNull
        public KLogger getLogger() {
            return logger;
        }

        private Companion() {
            super("UpsourceChangesProcessor", (StoreContainer)LegacyStoreContainer.INSTANCE);
        }

        @NotNull
        public KLogger logger() {
            return KLoggable.DefaultImpls.logger((KLoggable)this);
        }

        @NotNull
        public KLogger logger(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return KLoggable.DefaultImpls.logger((KLoggable)this, (String)name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

