/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.gap.vcs;

import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import jetbrains.charisma.persistent.Issue;
import jetbrains.charisma.persistent.Project;
import jetbrains.charisma.plugin.PluginResource;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.components.impl.entity.RootEntitySequenceResource;
import jetbrains.gap.resource.components.impl.entity.RootSequenceElementResource;
import jetbrains.gap.resource.pojo.FieldException;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.XodusDatabase;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.integration.gap.vcs.IssueVcsChangesPluginResource;
import jetbrains.youtrack.integration.gap.vcs.VcsChange;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.vcs.XdVcsChange;
import jetbrains.youtrack.integration.persistence.vcs.XdVcsChangeKt;
import jetbrains.youtrack.integration.service.VcsService;
import jetbrains.youtrack.integration.service.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.service.vcs.VcsChangesServiceKt;
import jetbrains.youtrack.integration.workflow.VcsMethodsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/integration/gap/vcs/IssueVcsChangesPluginResource;", "Ljetbrains/charisma/plugin/PluginResource;", "Ljetbrains/charisma/persistent/Issue;", "()V", "path", "", "getPath", "()Ljava/lang/String;", "invoke", "", "item", "youtrack-vcs-ci-integration"})
public final class IssueVcsChangesPluginResource
implements PluginResource<Issue> {
    @NotNull
    private final String path = "vcsChanges";

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public Object invoke(@NotNull Issue item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return new RootEntitySequenceResource<VcsChange>(item){
            @NotNull
            private final KClass<? extends VcsChange> baseType;
            final /* synthetic */ Issue $item;

            @NotNull
            public KClass<? extends VcsChange> getBaseType() {
                return this.baseType;
            }

            @NotNull
            public VcsChange doApply(@NotNull VcsChange entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                if (entity.getState() == 2) {
                    XdVcsChange xdVcsChange = (XdVcsChange)XdExtensionsKt.toXd((Entity)((Entity)entity.getEntity()));
                    xdVcsChange.setState((byte)2);
                    VcsChangesServiceKt.getVcsChangesService().triggerWorkflow(xdVcsChange);
                    return (VcsChange)HelpersKt.find$default((DatabaseEntity)entity, null, (int)1, null);
                }
                if (entity.getState() == 0) {
                    XdVcsChange xdVcsChange = (XdVcsChange)XdExtensionsKt.toXd((Entity)((Entity)entity.getEntity()));
                    if (xdVcsChange.getState() == 2) {
                        xdVcsChange.setState((byte)0);
                        VcsChangesServiceKt.getVcsChangesService().triggerWorkflow(xdVcsChange);
                        return (VcsChange)HelpersKt.find$default((DatabaseEntity)entity, null, (int)1, null);
                    }
                    throw (Throwable)new BadRequestException(BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.This_change_has_never_been_autoattached_to_the_issue", new Object[0]));
                }
                if (entity.getState() == 1) {
                    this.checkAlreadyExists(entity);
                    Issue issue2 = entity.getIssue();
                    XdIssue anotherXdIssue = issue2 != null && (issue2 = (Issue)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)issue2), null, (int)1, null)) != null ? issue2.getXdEntity() : null;
                    XdIssue issue3 = this.$item.getXdEntity();
                    if (anotherXdIssue != null && Intrinsics.areEqual((Object)anotherXdIssue, (Object)issue3) ^ true) {
                        XdVcsChange xdVcsChange = XdVcsChangeKt.findChangeByVersion(anotherXdIssue, entity.getVersion());
                        if (xdVcsChange == null) {
                            throw (Throwable)new BadRequestException(BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Issue_{0}_does_not_have_change_{1}_attached", new Object[]{anotherXdIssue.getIdReadable(), entity.getVersion()}));
                        }
                        XdVcsChange existing2 = xdVcsChange;
                        existing2.setState((byte)2);
                        VcsChangesServiceKt.getVcsChangesService().triggerWorkflow(existing2);
                        VcsService<XdVcsChangeProcessor> service = jetbrains.youtrack.integration.service.BeansKt.getServiceRegistry().serviceOf(existing2.getProcessor());
                        CommonChangeDTO dto2 = service.mapChange(existing2);
                        VcsMethodsKt.prepareToAttach(dto2, issue3);
                        XdVcsChange newChange = VcsChangesServiceKt.getVcsChangesService().updateOrCreateChange((XdVcsChangeProcessor)((Object)CollectionsKt.first(dto2.getProcessors())), dto2, issue3);
                        XdQueryKt.addAll(newChange.getProcessors(), (XdQuery)((XdQuery)existing2.getProcessors()));
                        XdEntity $this$kt$iv = newChange;
                        boolean $i$f$kt = false;
                        Entity $receiver$iv$iv = $this$kt$iv.getEntity();
                        return (VcsChange)XodusDatabase.INSTANCE.wrap(VcsChange.class, $receiver$iv$iv, new Object[0]);
                    }
                    return this.doCreate(entity);
                }
                throw (Throwable)new FieldException("state", VcsChange.class, "incorrect-value", null, 8, null);
            }

            @NotNull
            public VcsChange doCreate(@NotNull VcsChange entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                this.checkAlreadyExists(entity);
                CommonChangeDTO commonChangeDTO = VcsMethodsKt.findChange(this.$item.getXdEntity(), entity.getVersion());
                if (commonChangeDTO == null) {
                    throw (Throwable)new NotFoundException(BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Could_not_find_change_with_version_{0}", new Object[]{entity.getVersion()}));
                }
                CommonChangeDTO dto2 = commonChangeDTO;
                XdEntity $this$kt$iv = VcsChangesServiceKt.getVcsChangesService().updateOrCreateChange((XdVcsChangeProcessor)((Object)CollectionsKt.first(dto2.getProcessors())), dto2, this.$item.getXdEntity());
                boolean $i$f$kt = false;
                Entity $receiver$iv$iv = $this$kt$iv.getEntity();
                return (VcsChange)XodusDatabase.INSTANCE.wrap(VcsChange.class, $receiver$iv$iv, new Object[0]);
            }

            private final void checkAlreadyExists(VcsChange entity) {
                Object v3;
                block5: {
                    String string = entity.getVersion();
                    if (string == null) {
                        return;
                    }
                    String hash = string;
                    Sequence $this$firstOrNull$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)XdVcsChangeKt.getVcsChanges(this.$item.getXdEntity())));
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        XdVcsChange it = (XdVcsChange)((Object)element$iv);
                        boolean bl2 = false;
                        if (hash.length() >= 7) {
                            String string2 = it.getVersion();
                            bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)hash, (boolean)false, (int)2, null) : false;
                        } else {
                            bl = Intrinsics.areEqual((Object)it.getVersion(), (Object)entity.getVersion());
                        }
                        if (!bl) continue;
                        v3 = element$iv;
                        break block5;
                    }
                    v3 = null;
                }
                XdVcsChange existing2 = v3;
                if (existing2 != null) {
                    throw (Throwable)new BadRequestException(BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Issue_is_already_associated_with_the_change", new Object[0]));
                }
            }

            public void doDelete(@NotNull VcsChange entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                entity.getXdEntity().deletePermanently();
            }

            public void assertDeleteAccess(@Nullable VcsChange entity) {
                if (entity == null) {
                    throw (Throwable)new NotFoundException("No entity provided");
                }
                if (entity.getState() != 1) {
                    throw (Throwable)new BadRequestException(BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Can_only_remove_a_manually_attached_change", new Object[0]));
                }
            }

            public void assertUpdateAccess() {
                if (!this.$item.canUpdatePrivate()) {
                    Object[] objectArray = new Object[1];
                    Project project = this.$item.getProject();
                    objectArray[0] = project != null ? project.getShortName() : null;
                    throw (Throwable)new ForbiddenException(BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.You_don_t_have_permission_to_update_issue_private_fields_in_project_{0}", objectArray));
                }
            }

            @NotNull
            public Sequence<VcsChange> getAll() {
                return SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)((XdQuery)XdVcsChangeKt.getVcsChanges(this.$item.getXdEntity()))), (Function1)invoke.getAll.1.INSTANCE);
            }

            @NotNull
            public Object getElementResource(@NotNull VcsChange element) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
                return new RootSequenceElementResource((jetbrains.gap.resource.Entity)element, (RootEntitySequenceResource)this);
            }
            {
                this.$item = $captured_local_variable$0;
                this.baseType = Reflection.getOrCreateKotlinClass(VcsChange.class);
            }

            public int getDefaultTopValue() {
                return RootEntitySequenceResource.DefaultImpls.getDefaultTopValue((RootEntitySequenceResource)this);
            }

            @NotNull
            public Sequence<VcsChange> applySecurity(@NotNull Sequence<? extends VcsChange> values) {
                Intrinsics.checkParameterIsNotNull(values, (String)"values");
                return RootEntitySequenceResource.DefaultImpls.applySecurity((RootEntitySequenceResource)this, values);
            }

            public void assertAccess() {
                RootEntitySequenceResource.DefaultImpls.assertAccess((RootEntitySequenceResource)this);
            }

            @NotNull
            public VcsChange create(@NotNull Class<? extends VcsChange> clazz, Object ... args) {
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                return (VcsChange)RootEntitySequenceResource.DefaultImpls.create((RootEntitySequenceResource)this, clazz, (Object[])args);
            }

            @NotNull
            public WebApplicationException elementNotFound(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                return RootEntitySequenceResource.DefaultImpls.elementNotFound((RootEntitySequenceResource)this, (String)id);
            }

            @NotNull
            public Sequence<VcsChange> filterAll(@Nullable String query2) {
                return RootEntitySequenceResource.DefaultImpls.filterAll((RootEntitySequenceResource)this, (String)query2);
            }

            @GET
            @Produces(value={"application/json"})
            @NotNull
            public List<jetbrains.gap.resource.Entity> get(@QueryParam(value="query") @Nullable String query2, @QueryParam(value="$skip") @Nullable Integer skip, @QueryParam(value="$top") @Nullable Integer top) {
                return RootEntitySequenceResource.DefaultImpls.get((RootEntitySequenceResource)this, (String)query2, (Integer)skip, (Integer)top);
            }

            @Path(value="{id}")
            @NotNull
            public Object getElementById(@PathParam(value="id") @NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                return RootEntitySequenceResource.DefaultImpls.getElementById((RootEntitySequenceResource)this, (String)id);
            }

            @POST
            @Produces(value={"application/json"})
            @NotNull
            public jetbrains.gap.resource.Entity post(@Nullable jetbrains.gap.resource.Entity entity) {
                return RootEntitySequenceResource.DefaultImpls.post((RootEntitySequenceResource)this, (jetbrains.gap.resource.Entity)entity);
            }
        };
    }
}

