/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.service;

import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.BeansKt;
import jetbrains.youtrack.integration.service.ProgressStateHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/integration/service/VcsCommonService;", "", "()V", "addStateMessage", "", "changesProcessor", "Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;", "message", "", "logException", "processor", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "asError", "", "setSynchronizedAt", "Companion", "youtrack-vcs-ci-integration"})
public final class VcsCommonService {
    public static final Companion Companion = new Companion(null);

    public final void logException(@NotNull XdVcsChangeProcessor processor2, @NotNull Exception e, @NotNull String message, boolean asError, boolean addStateMessage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (addStateMessage) {
            this.addStateMessage(processor2, message);
        }
        String m = processor2.getLogPrefix() + message + ". Reason: ";
        if (asError) {
            Companion.getLogger().error(m, (Throwable)e);
        } else {
            Companion.getLogger().warn(m + e.getMessage());
            Companion.getLogger().debug(m, (Throwable)e);
        }
    }

    public final void setSynchronizedAt(@NotNull XdVcsChangeProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        String dateTime = DateFormats.INSTANCE.getFormatter("gmailLike").withLocale(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getLocale()).print((ReadableInstant)new DateTime(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getTimezone()));
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("TeamcityBuildConfMapping.Synchronized_at_{0}", new Object[]{dateTime});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026onized_at_{0}\", dateTime)");
        this.addStateMessage(processor2, string);
    }

    private final void addStateMessage(XdVcsChangeProcessor changesProcessor, String message) {
        ProgressStateHolder psh = BeansKt.getProgressStateHolder();
        String stateMessage = psh.getStateMessage(changesProcessor);
        CharSequence charSequence = stateMessage;
        boolean bl = false;
        String newStateMessage = charSequence.length() == 0 ? message : stateMessage + '\n' + message;
        psh.setStateMessage(changesProcessor, newStateMessage);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/integration/service/VcsCommonService$Companion;", "Lmu/KLogging;", "()V", "youtrack-vcs-ci-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

