/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.user.XdGitHostingIntegrationUser;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.service.vcs.VcsChangesServiceKt;
import jetbrains.youtrack.integration.vcs.impl.AbstractVcsPayloadConsumer;
import jetbrains.youtrack.integration.vcs.impl.CommitLookup;
import jetbrains.youtrack.integration.vcs.impl.VcsHostingService;
import jetbrains.youtrack.integration.vcs.impl.VcsRestClient;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\b\u0012\u0004\u0012\u0002H\u00040\u0006B/\u0012 \u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00022\u0006\u0010\u0015\u001a\u00020\u0016H$\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00020\u001e2\u0006\u0010\u0010\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00028\u00022\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010'J\"\u0010(\u001a\u00020\u000f*\u00020\u00022\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020\u001e2\u0006\u0010*\u001a\u00020\u001aH\u0002R.\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/AbstractVcsChangesConsumer;", "PROCESSOR", "Ljetbrains/youtrack/integration/vcs/persistence/XdVcsHostingChangesProcessor;", "PUSH", "COMMIT", "Ljetbrains/youtrack/integration/vcs/impl/AbstractVcsPayloadConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/CommitLookup;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/VcsHostingService;", "Ljetbrains/youtrack/integration/vcs/impl/VcsRestClient;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/VcsHostingService;Ljetbrains/youtrack/integration/vcs/persistence/XdVcsHostingChangesProcessor;)V", "getVcsService", "()Ljetbrains/youtrack/integration/vcs/impl/VcsHostingService;", "consume", "", "payload", "(Ljava/lang/Object;)V", "createDto", "Ljetbrains/youtrack/integration/service/vcs/CommonChangeDTO;", "commit", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "(Ljava/lang/Object;Ljetbrains/youtrack/integration/service/UserResolution;)Ljetbrains/youtrack/integration/service/vcs/CommonChangeDTO;", "findCommit", "version", "", "getBranch", "(Ljava/lang/Object;)Ljava/lang/String;", "getCommits", "", "(Ljava/lang/Object;)Ljava/util/List;", "getRepositoryPath", "getVersion", "mapCommit", "enforceCommittersGroup", "", "(Ljava/lang/Object;Z)Ljetbrains/youtrack/integration/service/vcs/CommonChangeDTO;", "resolveUser", "(Ljava/lang/Object;)Ljetbrains/youtrack/integration/service/UserResolution;", "logBranchDoesNotMatch", "commits", "branch", "youtrack-vcs-hosting-integration"})
public abstract class AbstractVcsChangesConsumer<PROCESSOR extends XdVcsHostingChangesProcessor, PUSH, COMMIT>
extends AbstractVcsPayloadConsumer<PROCESSOR, PUSH>
implements CommitLookup<COMMIT> {
    @NotNull
    private final VcsHostingService<PROCESSOR, ? extends VcsRestClient<PROCESSOR, COMMIT>> vcsService;

    /*
     * WARNING - void declaration
     */
    @Override
    public void consume(PUSH payload) {
        void $this$mapNotNullTo$iv$iv;
        String repoPathFromPayload = this.getRepositoryPath(payload);
        if (!StringsKt.equals((String)((XdVcsHostingChangesProcessor)((Object)this.getProcessor())).getPath(), (String)repoPathFromPayload, (boolean)true)) {
            this.getProcessor().logError("Processor is not set to process changes from repository " + repoPathFromPayload);
            return;
        }
        String branch = this.getBranch(payload);
        String logicalBranch = this.matchesBranchSpec(branch);
        List<COMMIT> commits = this.getCommits(payload);
        if (logicalBranch == null) {
            this.logBranchDoesNotMatch((XdVcsHostingChangesProcessor)((Object)this.getProcessor()), (List<? extends COMMIT>)commits, branch);
            return;
        }
        Iterable $this$mapNotNull$iv = commits;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CommonChangeDTO commonChangeDTO;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            CommonChangeDTO commonChangeDTO2 = this.mapCommit(it, true);
            boolean bl3 = false;
            boolean bl4 = false;
            CommonChangeDTO dto = commonChangeDTO2;
            boolean bl5 = false;
            CommonChangeDTO commonChangeDTO3 = dto;
            if (commonChangeDTO3 != null) {
                commonChangeDTO3.setBranch(logicalBranch);
            }
            if (commonChangeDTO2 == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            CommonChangeDTO it$iv$iv = commonChangeDTO;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changes = (List)destination$iv$iv;
        Collection collection = changes;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getVcsService().executeProcessing((XdVcsChangeProcessor)this.getProcessor(), (XdEntityType)XdGitHostingIntegrationUser.Companion, true, (Function0)new Function0<Unit>(this, changes){
                final /* synthetic */ AbstractVcsChangesConsumer this$0;
                final /* synthetic */ List $changes;

                public final void invoke() {
                    VcsChangesServiceKt.getVcsChangesService().processChanges((XdVcsChangeProcessor)this.this$0.getProcessor(), CollectionsKt.asSequence((Iterable)this.$changes));
                }
                {
                    this.this$0 = abstractVcsChangesConsumer;
                    this.$changes = list2;
                    super(0);
                }
            });
        }
    }

    @NotNull
    protected abstract String getBranch(PUSH var1);

    @Nullable
    protected abstract String getRepositoryPath(PUSH var1);

    @NotNull
    protected abstract List<COMMIT> getCommits(PUSH var1);

    @NotNull
    protected abstract CommonChangeDTO createDto(COMMIT var1, @NotNull UserResolution var2);

    @NotNull
    protected abstract String getVersion(COMMIT var1);

    @NotNull
    public abstract UserResolution resolveUser(COMMIT var1);

    @Override
    @Nullable
    public CommonChangeDTO findCommit(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        COMMIT COMMIT = this.getVcsService().rest(this.getProcessor()).findCommit(version);
        if (COMMIT == null) {
            return null;
        }
        COMMIT commit = COMMIT;
        return this.mapCommit(commit, false);
    }

    private final CommonChangeDTO mapCommit(COMMIT commit, boolean enforceCommittersGroup) {
        UserResolution ur = this.resolveUser(commit);
        XdUser user = ur.getUser();
        if (user == null) {
            this.getProcessor().logDebug("Could not find YouTrack user for " + ur.getVcsUser() + " when processing " + this.getVersion(commit));
        } else if (enforceCommittersGroup && Intrinsics.areEqual((Object)ur.getNoUserReason(), (Object)XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP())) {
            this.getProcessor().logInfo("Skipping commit " + this.getVersion(commit) + " by vcs user " + ur.getVcsUser() + " (YouTrack user " + user.getLogin() + ')' + " since they do not belong to the committers group");
            return null;
        }
        return this.createDto(commit, ur);
    }

    private final void logBranchDoesNotMatch(@NotNull XdVcsHostingChangesProcessor $this$logBranchDoesNotMatch, List<? extends COMMIT> commits, String branch) {
        boolean multiple = commits.size() > 1;
        $this$logBranchDoesNotMatch.logInfo("Skipped commit" + (multiple ? "s " : " ") + ' ' + CollectionsKt.joinToString$default((Iterable)commits, (CharSequence)",", null, null, (int)0, null, (Function1)new Function1<COMMIT, String>(this){
            final /* synthetic */ AbstractVcsChangesConsumer this$0;

            @NotNull
            public final String invoke(COMMIT it) {
                return this.this$0.getVersion(it);
            }
            {
                this.this$0 = abstractVcsChangesConsumer;
                super(1);
            }
        }, (int)30, null) + " since " + (multiple ? "their" : "its") + " branch (" + branch + ") does not match the spec " + this.getOneLineBranchSpec($this$logBranchDoesNotMatch));
    }

    @Override
    @NotNull
    public VcsHostingService<PROCESSOR, ? extends VcsRestClient<PROCESSOR, COMMIT>> getVcsService() {
        return this.vcsService;
    }

    public AbstractVcsChangesConsumer(@NotNull VcsHostingService<PROCESSOR, ? extends VcsRestClient<PROCESSOR, COMMIT>> vcsService, @NotNull PROCESSOR processor2) {
        Intrinsics.checkParameterIsNotNull(vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        super(vcsService, processor2);
        this.vcsService = vcsService;
    }
}

