/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.VcsUserResolutionServiceKt;
import jetbrains.youtrack.integration.vcs.impl.AbstractVcsChangesConsumer;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.BitBucketChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.BitBucketService;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20Commit;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20ReferenceState;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20User;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucketRest;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.Bitbucket20ChangesWithRepo;
import jetbrains.youtrack.integration.vcs.persistence.XdBitBucketChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u0000 \u001c2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0004H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/BitbucketVcsChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/AbstractVcsChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/persistence/XdBitBucketChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/Bitbucket20ChangesWithRepo;", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/BitBucket20Commit;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/BitBucketService;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/BitBucketService;Ljetbrains/youtrack/integration/vcs/persistence/XdBitBucketChangesProcessor;)V", "getVcsService", "()Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/BitBucketService;", "createDto", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/BitBucketChangeDTO;", "commit", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "extractEmail", "", "rawAuthor", "getBranch", "payload", "getCommits", "", "getRepositoryPath", "getVersion", "matchesBranchSpec", "branchName", "resolveUser", "Companion", "youtrack-vcs-hosting-integration"})
public class BitbucketVcsChangesConsumer
extends AbstractVcsChangesConsumer<XdBitBucketChangesProcessor, Bitbucket20ChangesWithRepo, BitBucket20Commit> {
    @NotNull
    private final BitBucketService vcsService;
    private static final Pattern EMAIL_PATTERN;
    public static final Companion Companion;

    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull Bitbucket20ChangesWithRepo payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return payload.getRepo().getFullName();
    }

    @Override
    @NotNull
    protected String getBranch(@NotNull Bitbucket20ChangesWithRepo payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Object object = payload.getChanges().getNew();
        if (object == null || (object = ((BitBucket20ReferenceState)object).getName()) == null) {
            object = "master";
        }
        return object;
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull BitBucket20Commit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return commit.getHash();
    }

    @Override
    @NotNull
    protected List<BitBucket20Commit> getCommits(@NotNull Bitbucket20ChangesWithRepo payload) {
        Collection<BitBucket20Commit> collection;
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String branch = this.getBranch(payload);
        List<BitBucket20Commit> result = payload.getChanges().getCommits();
        if (payload.getChanges().getTruncated()) {
            ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).logInfo("Webhook commits were truncated, starting job to load them");
            XdBitBucketChangesProcessor xdBitBucketChangesProcessor = (XdBitBucketChangesProcessor)((Object)this.getProcessor());
            StringBuilder stringBuilder = new StringBuilder().append("Loading truncated comments for push ");
            BitBucket20ReferenceState bitBucket20ReferenceState = payload.getChanges().getNew();
            if (bitBucket20ReferenceState == null) {
                Intrinsics.throwNpe();
            }
            BitBucket20Commit bitBucket20Commit = bitBucket20ReferenceState.getTarget();
            if (bitBucket20Commit == null) {
                Intrinsics.throwNpe();
            }
            xdBitBucketChangesProcessor.logInfo(stringBuilder.append(bitBucket20Commit.getHash()).toString());
            BitBucketRest rest = this.getVcsService().rest((XdBitBucketChangesProcessor)((Object)this.getProcessor()));
            collection = rest.getCommitsRange((XdBitBucketChangesProcessor)((Object)this.getProcessor()), payload.getChanges().getOld(), (BitBucket20Commit)CollectionsKt.last(payload.getChanges().getCommits()), branch);
        } else {
            collection = CollectionsKt.emptyList();
        }
        Collection<BitBucket20Commit> additionalCommits = collection;
        List list2 = CollectionsKt.plus((Collection)result, (Iterable)additionalCommits);
        boolean bl = false;
        boolean bl2 = false;
        List commits = list2;
        boolean bl3 = false;
        Iterable $this$forEach$iv = commits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BitBucket20Commit it = (BitBucket20Commit)element$iv;
            boolean bl4 = false;
            it.setBranch(branch);
        }
        return list2;
    }

    @NotNull
    protected BitBucketChangeDTO createDto(@NotNull BitBucket20Commit commit, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        return new BitBucketChangeDTO(null, userResolution.getUser(), userResolution.getNoUserReason(), commit, (XdVcsChangeProcessor)this.getProcessor(), userResolution.getVcsUser());
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull BitBucket20Commit commit) {
        String fromEmail;
        String author;
        block7: {
            String string;
            String rawAuthor;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
                BitBucket20User bitBucket20User = commit.getAuthor().getUser();
                author = bitBucket20User != null ? bitBucket20User.getNickname() : null;
                rawAuthor = commit.getAuthor().getRaw();
                CharSequence charSequence = rawAuthor;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return new UserResolution(null, author, XdNoUserReason.Companion.getBITBUCKET_NO_USER_INFO_PROVIDED());
                }
                fromEmail = this.extractEmail(rawAuthor);
                if (fromEmail == null) break block6;
                CharSequence charSequence2 = fromEmail;
                boolean bl2 = false;
                if (!(charSequence2.length() == 0)) break block7;
            }
            if ((string = author) == null) {
                string = rawAuthor;
            }
            return new UserResolution(null, string, XdNoUserReason.Companion.getBITBUCKET_NO_RAW_EMAIL());
        }
        Pair userResolution = VcsUserResolutionServiceKt.getVcsUserResolutionService().resolveUser(fromEmail, (XdVcsChangeProcessor)this.getProcessor(), XdNoUserReason.Companion.getBITBUCKET_NO_USER_FOUND_IN_YOUTRACK(), XdNoUserReason.Companion.getBITBUCKET_USER_NOT_UNIQUE(), XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP());
        XdUser xdUser = (XdUser)userResolution.getFirst();
        String string = author;
        if (string == null) {
            string = fromEmail;
        }
        return new UserResolution(xdUser, string, (XdNoUserReason)userResolution.getSecond());
    }

    private final String extractEmail(String rawAuthor) {
        Matcher matcher = EMAIL_PATTERN.matcher(rawAuthor);
        return matcher.find() ? matcher.group() : null;
    }

    @Override
    @Nullable
    public String matchesBranchSpec(@NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        String string = super.matchesBranchSpec(branchName);
        if (string == null) {
            string = super.matchesBranchSpec("refs/heads/" + branchName);
        }
        return string;
    }

    @NotNull
    public BitBucketService getVcsService() {
        return this.vcsService;
    }

    public BitbucketVcsChangesConsumer(@NotNull BitBucketService vcsService, @NotNull XdBitBucketChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super(vcsService, (XdVcsHostingChangesProcessor)processor2);
        this.vcsService = vcsService;
    }

    static {
        Companion = new Companion(null);
        EMAIL_PATTERN = Pattern.compile("(([a-z0-9!#$%&'*+/=?^_`{|}~.-]+)@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*)", 2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/BitbucketVcsChangesConsumer$Companion;", "", "()V", "EMAIL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "youtrack-vcs-hosting-integration"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

