/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.vcs.CredentialsDTO;
import jetbrains.youtrack.integration.vcs.Localization;
import jetbrains.youtrack.integration.vcs.impl.JerseyClientExceptionWrapper;
import jetbrains.youtrack.integration.vcs.impl.VcsRestClient;
import jetbrains.youtrack.integration.vcs.impl.VcsRestClientKt;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20Commit;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20Hook;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20Page;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20ReferenceState;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucket20User;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitBucketRest;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.cloud.api.BitbucketCloudApi20RestSchemaKt;
import jetbrains.youtrack.integration.vcs.persistence.XdBitBucketChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00016B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J.\u0010 \u001a\u0004\u0018\u00010\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010&\u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0007J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u000e\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007J\"\u0010/\u001a\u0002002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020\u0013H\u0016J\u0014\u00104\u001a\u000205*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u00104\u001a\n \u000f*\u0004\u0018\u00010505*\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00070\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00067"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/BitBucketRest;", "Ljetbrains/youtrack/integration/vcs/impl/VcsRestClient;", "Ljetbrains/youtrack/integration/vcs/persistence/XdBitBucketChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/BitBucket20Commit;", "processor", "(Ljetbrains/youtrack/integration/vcs/persistence/XdBitBucketChangesProcessor;)V", "url", "", "getUrl", "()Ljava/lang/String;", "url$delegate", "Lkotlin/Lazy;", "wr", "Ljavax/ws/rs/client/WebTarget;", "encodedHookId", "kotlin.jvm.PlatformType", "getEncodedHookId", "(Ljetbrains/youtrack/integration/vcs/persistence/XdBitBucketChangesProcessor;)Ljava/lang/String;", "addPullRequestSupport", "", "creds", "Ljetbrains/youtrack/integration/vcs/CredentialsDTO;", "catchAppPasswordPermissionProblem", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createHook", "hookReceiverId", "deleteHook", "findCommit", "hash", "getCommit", "login", "password", "path", "getCommitsRange", "", "changesProcessor", "prevState", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/BitBucket20ReferenceState;", "lastCommit", "branch", "getHook", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/BitBucket20Hook;", "getUserNickname", "uuid", "isBaseUrl", "", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "ping", "addHeaders", "Ljavax/ws/rs/client/Invocation$Builder;", "Companion", "youtrack-vcs-hosting-integration"})
public final class BitBucketRest
extends VcsRestClient<XdBitBucketChangesProcessor, BitBucket20Commit> {
    @NotNull
    private final Lazy url$delegate;
    private WebTarget wr;
    public static final int MAX_TRUNCATED_COMMITS_TO_LOAD = 2000;
    @NotNull
    private static final List<String> PULL_REQUEST_EVENTS;
    @NotNull
    private static final List<String> REPO_EVENTS;
    public static final Companion Companion;

    @Override
    @NotNull
    protected String getUrl() {
        Lazy lazy = this.url$delegate;
        BitBucketRest bitBucketRest = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final Invocation.Builder addHeaders(@NotNull WebTarget $this$addHeaders, CredentialsDTO creds) {
        Invocation.Builder builder2 = this.addHeaders($this$addHeaders, creds.getLogin(), creds.getPassword());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"addHeaders(creds.login, creds.password)");
        return builder2;
    }

    private final Invocation.Builder addHeaders(@NotNull WebTarget $this$addHeaders, String login, String password) {
        String string = login + ':' + password;
        StringBuilder stringBuilder = new StringBuilder().append("Basic ");
        String string2 = "Authorization";
        Invocation.Builder builder2 = VcsRestClientKt.getStandardHeaders($this$addHeaders);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return builder2.header(string2, (Object)stringBuilder.append(Base64.encodeBase64String((byte[])byArray2)).toString());
    }

    @Override
    public void ping() {
        this.getHook();
    }

    private final BitBucket20Hook getHook() {
        BitBucket20Hook bitBucket20Hook;
        String string = ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getHookId();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String fullPath = "2.0/repositories/" + ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPath() + "/hooks/" + this.getEncodedHookId((XdBitBucketChangesProcessor)((Object)this.getProcessor()));
            WebTarget webTarget = this.wr.path(fullPath);
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(fullPath)");
            Invocation.Builder builder2 = this.addHeaders(webTarget, ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getLogin(), ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPassword());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"wr.path(fullPath).addHea\u2026ogin, processor.password)");
            bitBucket20Hook = this.executeGet(builder2, BitBucket20Hook.class);
        } else {
            bitBucket20Hook = null;
        }
        return bitBucket20Hook;
    }

    @Override
    @Nullable
    public BitBucket20Commit findCommit(@NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        String string = ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPath();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("No project id is available, nowhere to add");
        }
        String path = string;
        BitBucket20Commit bitBucket20Commit = this.getCommit(((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getLogin(), ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPassword(), path, hash);
        if (bitBucket20Commit == null) {
            return null;
        }
        return bitBucket20Commit;
    }

    @Override
    public void deleteHook(@NotNull CredentialsDTO creds) {
        WebTarget wr2;
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        WebTarget webTarget = wr2 = this.wr.path("2.0/repositories/" + ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPath() + "/hooks/" + this.getEncodedHookId((XdBitBucketChangesProcessor)((Object)this.getProcessor())));
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr");
        this.executeDelete(this.addHeaders(webTarget, creds));
    }

    private final <T> T catchAppPasswordPermissionProblem(Function0<? extends T> block) {
        try {
            return (T)block.invoke();
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCause() instanceof ForbiddenException) {
                throw (Throwable)new BadRequestException((String)Localization.INSTANCE.getAppPasswordHasNotPermissionToSupportPullRequests().invoke());
            }
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public String createHook(@NotNull String hookReceiverId) {
        Intrinsics.checkParameterIsNotNull((Object)hookReceiverId, (String)"hookReceiverId");
        String fullPath = "2.0/repositories/" + ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPath() + "/hooks";
        BitBucket20Hook bitBucket20Hook = new BitBucket20Hook();
        boolean bl = false;
        boolean bl2 = false;
        BitBucket20Hook $this$apply = bitBucket20Hook;
        boolean bl3 = false;
        $this$apply.setUrl(this.getLandingUrl() + "/rest/vcsHooksReceiver/bitbucket20?apiKey=" + hookReceiverId);
        $this$apply.setActive(true);
        $this$apply.setEvents(CollectionsKt.plus((Collection)PULL_REQUEST_EVENTS, (Iterable)REPO_EVENTS));
        $this$apply.setDescription((String)Localization.INSTANCE.getBitbucketHookDescription().invoke((Object)((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getProject().getName()));
        BitBucket20Hook request = bitBucket20Hook;
        BitBucket20Hook hook2 = (BitBucket20Hook)this.catchAppPasswordPermissionProblem((Function0)new Function0<BitBucket20Hook>(this, fullPath, request){
            final /* synthetic */ BitBucketRest this$0;
            final /* synthetic */ String $fullPath;
            final /* synthetic */ BitBucket20Hook $request;

            @NotNull
            public final BitBucket20Hook invoke() {
                WebTarget webTarget = BitBucketRest.access$getWr$p(this.this$0).path(this.$fullPath);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(fullPath)");
                Invocation.Builder builder2 = BitBucketRest.access$addHeaders(this.this$0, webTarget, ((XdBitBucketChangesProcessor)((Object)this.this$0.getProcessor())).getCredentials());
                Entity entity = Entity.json((Object)this.$request);
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"Entity.json(request)");
                return this.this$0.executePost(builder2, entity, BitBucket20Hook.class);
            }
            {
                this.this$0 = bitBucketRest;
                this.$fullPath = string;
                this.$request = bitBucket20Hook;
                super(0);
            }
        });
        String string = hook2.getUuid();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    public void addPullRequestSupport(@NotNull CredentialsDTO creds) {
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        String fullPath = "2.0/repositories/" + ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getPath() + "/hooks/" + this.getEncodedHookId((XdBitBucketChangesProcessor)((Object)this.getProcessor()));
        BitBucket20Hook oldHook = this.getHook();
        if (oldHook == null) {
            throw (Throwable)new RuntimeException("No configured web hook found");
        }
        oldHook.setEvents(CollectionsKt.plus((Collection)PULL_REQUEST_EVENTS, (Iterable)REPO_EVENTS));
        this.catchAppPasswordPermissionProblem((Function0)new Function0<BitBucket20Hook>(this, fullPath, oldHook){
            final /* synthetic */ BitBucketRest this$0;
            final /* synthetic */ String $fullPath;
            final /* synthetic */ BitBucket20Hook $oldHook;

            @NotNull
            public final BitBucket20Hook invoke() {
                WebTarget webTarget = BitBucketRest.access$getWr$p(this.this$0).path(this.$fullPath);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(fullPath)");
                Invocation.Builder builder2 = BitBucketRest.access$addHeaders(this.this$0, webTarget, ((XdBitBucketChangesProcessor)((Object)this.this$0.getProcessor())).getCredentials());
                Entity entity = Entity.json((Object)this.$oldHook);
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"Entity.json(oldHook)");
                return this.this$0.executePut(builder2, entity, BitBucket20Hook.class);
            }
            {
                this.this$0 = bitBucketRest;
                this.$fullPath = string;
                this.$oldHook = bitBucket20Hook;
                super(0);
            }
        });
    }

    private final String getEncodedHookId(@NotNull XdBitBucketChangesProcessor $this$encodedHookId) {
        return URLEncoder.encode($this$encodedHookId.getHookId(), StandardCharsets.UTF_8.name());
    }

    private final BitBucket20Commit getCommit(String login, String password, String path, String hash) {
        return (BitBucket20Commit)VcsRestClientKt.findCommit(path, hash, (Function0)new Function0<BitBucket20Commit>(this, path, hash, login, password){
            final /* synthetic */ BitBucketRest this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ String $hash;
            final /* synthetic */ String $login;
            final /* synthetic */ String $password;

            @NotNull
            public final BitBucket20Commit invoke() {
                WebTarget webTarget = BitBucketRest.access$getWr$p(this.this$0).path("2.0/repositories/" + this.$path + "/commit/" + this.$hash);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"2.0/repositories/$path/commit/$hash\")");
                Invocation.Builder builder2 = BitBucketRest.access$addHeaders(this.this$0, webTarget, this.$login, this.$password);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"wr.path(\"2.0/repositorie\u2026dHeaders(login, password)");
                return this.this$0.executeGet(builder2, BitBucket20Commit.class);
            }
            {
                this.this$0 = bitBucketRest;
                this.$path = string;
                this.$hash = string2;
                this.$login = string3;
                this.$password = string4;
                super(0);
            }
        });
    }

    @NotNull
    public final String getUserNickname(@NotNull String uuid) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        try {
            WebTarget webTarget = this.wr.path("2.0/users/" + uuid);
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"2.0/users/$uuid\")");
            String string2 = this.executeGet(this.addHeaders(webTarget, ((XdBitBucketChangesProcessor)((Object)this.getProcessor())).getCredentials()), BitBucket20User.class).getNickname();
            if (string2 == null) {
                string2 = uuid;
            }
            string = string2;
        }
        catch (Throwable e) {
            string = uuid;
        }
        return string;
    }

    @Override
    public boolean isBaseUrl(@NotNull String url2, @NotNull CredentialsDTO creds, @Nullable XdStorageEntry sslKey) {
        Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<BitBucket20Commit> getCommitsRange(@NotNull XdBitBucketChangesProcessor changesProcessor, @Nullable BitBucket20ReferenceState prevState, @NotNull BitBucket20Commit lastCommit, @NotNull String branch) {
        void foundStop;
        void foundStart;
        Long l;
        BitBucket20Commit prevCommit;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)lastCommit, (String)"lastCommit");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        boolean bl = false;
        ArrayList commits = new ArrayList();
        GenericType<BitBucket20Page<BitBucket20Commit>> pageGeneric2 = new GenericType<BitBucket20Page<BitBucket20Commit>>(){};
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        BitBucket20ReferenceState bitBucket20ReferenceState = prevState;
        BitBucket20Commit bitBucket20Commit = prevCommit = bitBucket20ReferenceState != null ? bitBucket20ReferenceState.getTarget() : null;
        if (bitBucket20Commit != null) {
            BitBucket20Commit bitBucket20Commit2 = bitBucket20Commit;
            boolean bl2 = false;
            boolean bl3 = false;
            BitBucket20Commit it = bitBucket20Commit2;
            boolean bl4 = false;
            l = BitbucketCloudApi20RestSchemaKt.toBitbucketDateTime(prevCommit.getDate());
        } else {
            l = null;
        }
        Long prevStateDate = l;
        long lastTruncatedCommitDate = BitbucketCloudApi20RestSchemaKt.toBitbucketDateTime(lastCommit.getDate());
        VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(lastCommit){
            final /* synthetic */ BitBucket20Commit $lastCommit;

            @NotNull
            public final String invoke() {
                return "Last truncated commit is : " + this.$lastCommit.getHash();
            }
            {
                this.$lastCommit = bitBucket20Commit;
                super(0);
            }
        });
        VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(prevState){
            final /* synthetic */ BitBucket20ReferenceState $prevState;

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("Previous state hash is : ");
                Object object = this.$prevState;
                if (object == null || (object = ((BitBucket20ReferenceState)object).getTarget()) == null || (object = ((BitBucket20Commit)object).getHash()) == null) {
                    object = " null, so we are to load all commits from new created branch";
                }
                return stringBuilder.append((String)object).toString();
            }
            {
                this.$prevState = bitBucket20ReferenceState;
                super(0);
            }
        });
        Function1 loadCommitsFromPage2 = (Function1)new Function1<BitBucket20Page<BitBucket20Commit>, Unit>((Ref.BooleanRef)foundStart, lastCommit, prevStateDate, lastTruncatedCommitDate, (Ref.BooleanRef)foundStop, prevCommit, commits, prevState){
            final /* synthetic */ Ref.BooleanRef $foundStart;
            final /* synthetic */ BitBucket20Commit $lastCommit;
            final /* synthetic */ Long $prevStateDate;
            final /* synthetic */ long $lastTruncatedCommitDate;
            final /* synthetic */ Ref.BooleanRef $foundStop;
            final /* synthetic */ BitBucket20Commit $prevCommit;
            final /* synthetic */ ArrayList $commits;
            final /* synthetic */ BitBucket20ReferenceState $prevState;

            public final void invoke(@NotNull BitBucket20Page<BitBucket20Commit> commitsPage) {
                Intrinsics.checkParameterIsNotNull(commitsPage, (String)"commitsPage");
                for (BitBucket20Commit commit : commitsPage.getValues()) {
                    VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(commit){
                        final /* synthetic */ BitBucket20Commit $commit;

                        @NotNull
                        public final String invoke() {
                            return "Checking commit " + this.$commit.getHash() + ", " + this.$commit.getDate() + ", " + this.$commit.getMessage();
                        }
                        {
                            this.$commit = bitBucket20Commit;
                            super(0);
                        }
                    });
                    if (!this.$foundStart.element) {
                        if (Intrinsics.areEqual((Object)commit.getHash(), (Object)this.$lastCommit.getHash())) {
                            VcsRestClient.Companion.getLogger().info("Found start commit " + this.$lastCommit.getHash());
                            this.$foundStart.element = true;
                            continue;
                        }
                        long commitDate = BitbucketCloudApi20RestSchemaKt.toBitbucketDateTime(commit.getDate());
                        if (this.$foundStart.element) continue;
                        Long l = this.$prevStateDate;
                        if (commitDate >= Math.max(l != null ? l : Long.MIN_VALUE, this.$lastTruncatedCommitDate)) continue;
                        VcsRestClient.Companion.getLogger().error("Failed to find first commit lastCommit in bitbucket");
                        this.$foundStop.element = true;
                        break;
                    }
                    if (this.$prevCommit != null) {
                        if (Intrinsics.areEqual((Object)commit.getHash(), (Object)this.$prevCommit.getHash()) ^ true) {
                            long l = BitbucketCloudApi20RestSchemaKt.toBitbucketDateTime(this.$prevCommit.getDate());
                            Long l2 = this.$prevStateDate;
                            if (l2 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (l >= l2) {
                                this.$commits.add(commit);
                                continue;
                            }
                        }
                        if (Intrinsics.areEqual((Object)commit.getHash(), (Object)this.$prevCommit.getHash())) {
                            VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(this){
                                final /* synthetic */ getCommitsRange.loadCommitsFromPage.1 this$0;

                                @NotNull
                                public final String invoke() {
                                    return "Found prev reference hash " + this.this$0.$prevCommit.getHash();
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                        } else {
                            VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(this, commit){
                                final /* synthetic */ getCommitsRange.loadCommitsFromPage.1 this$0;
                                final /* synthetic */ BitBucket20Commit $commit;

                                @NotNull
                                public final String invoke() {
                                    BitBucket20Commit bitBucket20Commit = this.this$0.$prevState.getTarget();
                                    return "Found commit date is lower than previous ref date (" + this.$commit.getDate() + " is lower than " + (bitBucket20Commit != null ? bitBucket20Commit.getDate() : null) + ')';
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$commit = bitBucket20Commit;
                                    super(0);
                                }
                            });
                        }
                        this.$foundStop.element = true;
                        break;
                    }
                    this.$commits.add(commit);
                }
            }
            {
                this.$foundStart = booleanRef;
                this.$lastCommit = bitBucket20Commit;
                this.$prevStateDate = l;
                this.$lastTruncatedCommitDate = l2;
                this.$foundStop = booleanRef2;
                this.$prevCommit = bitBucket20Commit2;
                this.$commits = arrayList;
                this.$prevState = bitBucket20ReferenceState;
                super(1);
            }
        };
        Object object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Invocation.Builder>(this, changesProcessor, branch){
            final /* synthetic */ BitBucketRest this$0;
            final /* synthetic */ XdBitBucketChangesProcessor $changesProcessor;
            final /* synthetic */ String $branch;

            public final Invocation.Builder invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                WebTarget webTarget = BitBucketRest.access$getWr$p(this.this$0).path("2.0/repositories/" + this.$changesProcessor.getPath() + "/commits/" + this.$branch);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"this.wr.path(\"2.0/reposi\u2026r.path}/commits/$branch\")");
                return BitBucketRest.access$addHeaders(this.this$0, webTarget, this.$changesProcessor.getLogin(), this.$changesProcessor.getPassword());
            }
            {
                this.this$0 = bitBucketRest;
                this.$changesProcessor = xdBitBucketChangesProcessor;
                this.$branch = string;
                super(1);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"transactional {\n        \u2026essor.password)\n        }");
        BitBucket20Page page2 = (BitBucket20Page)this.executeGet((Invocation.Builder)object, (GenericType)pageGeneric2);
        VcsRestClient.Companion.getLogger().info("Loading first commits page");
        loadCommitsFromPage2.invoke((Object)page2);
        int pageNumber = 1;
        while (page2.getNext() != null && !foundStop.element && commits.size() < 2000) {
            void target;
            VcsRestClient.Companion.getLogger().info("Loading next commits page " + ++pageNumber);
            String string = page2.getNext();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            URI uri = new URI(string);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = this.wr.path(uri.getPath());
            List list2 = URLEncodedUtils.parse((URI)uri, (Charset)Charsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"URLEncodedUtils.parse(uri, Charsets.UTF_8)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NameValuePair it = (NameValuePair)element$iv;
                boolean bl5 = false;
                WebTarget webTarget = (WebTarget)target.element;
                NameValuePair nameValuePair = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)nameValuePair, (String)"it");
                target.element = webTarget.queryParam(nameValuePair.getName(), new Object[]{it.getValue()});
            }
            Object object2 = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Invocation.Builder>(this, (Ref.ObjectRef)target, changesProcessor){
                final /* synthetic */ BitBucketRest this$0;
                final /* synthetic */ Ref.ObjectRef $target;
                final /* synthetic */ XdBitBucketChangesProcessor $changesProcessor;

                public final Invocation.Builder invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    WebTarget webTarget = (WebTarget)this.$target.element;
                    Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"target");
                    return BitBucketRest.access$addHeaders(this.this$0, webTarget, this.$changesProcessor.getLogin(), this.$changesProcessor.getPassword());
                }
                {
                    this.this$0 = bitBucketRest;
                    this.$target = objectRef;
                    this.$changesProcessor = xdBitBucketChangesProcessor;
                    super(1);
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"transactional {\n        \u2026r.password)\n            }");
            page2 = (BitBucket20Page)this.executeGet((Invocation.Builder)object2, (GenericType)pageGeneric2);
            loadCommitsFromPage2.invoke((Object)page2);
        }
        if (!foundStop.element && commits.size() >= 2000) {
            VcsRestClient.Companion.getLogger().info("Truncated commits size exceeded max allowed number of 2000");
        }
        return commits;
    }

    public BitBucketRest(@NotNull XdBitBucketChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super((XdVcsHostingChangesProcessor)processor2);
        this.url$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(processor2){
            final /* synthetic */ XdBitBucketChangesProcessor $processor;

            @NotNull
            public final String invoke() {
                return BitBucketRest.Companion.switchHostToApi(this.$processor.getServer().getUrl());
            }
            {
                this.$processor = xdBitBucketChangesProcessor;
                super(0);
            }
        }));
        this.wr = VcsRestClientKt.buildWebTarget(this.getUrl(), this.getSslKey());
    }

    static {
        Companion = new Companion(null);
        PULL_REQUEST_EVENTS = CollectionsKt.listOf((Object[])new String[]{"pullrequest:fulfilled", "pullrequest:unapproved", "pullrequest:approved", "pullrequest:created", "pullrequest:rejected", "pullrequest:updated"});
        REPO_EVENTS = CollectionsKt.listOf((Object)"repo:push");
    }

    public static final /* synthetic */ Invocation.Builder access$addHeaders(BitBucketRest $this, WebTarget $this$access_u24addHeaders, CredentialsDTO creds) {
        return $this.addHeaders($this$access_u24addHeaders, creds);
    }

    public static final /* synthetic */ WebTarget access$getWr$p(BitBucketRest $this) {
        return $this.wr;
    }

    public static final /* synthetic */ void access$setWr$p(BitBucketRest $this, WebTarget webTarget) {
        $this.wr = webTarget;
    }

    public static final /* synthetic */ Invocation.Builder access$addHeaders(BitBucketRest $this, WebTarget $this$access_u24addHeaders, String login, String password) {
        return $this.addHeaders($this$access_u24addHeaders, login, password);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/bitbucket/cloud/api/BitBucketRest$Companion;", "", "()V", "MAX_TRUNCATED_COMMITS_TO_LOAD", "", "PULL_REQUEST_EVENTS", "", "", "getPULL_REQUEST_EVENTS", "()Ljava/util/List;", "REPO_EVENTS", "getREPO_EVENTS", "switchHostToApi", "url", "youtrack-vcs-hosting-integration"})
    public static final class Companion {
        @NotNull
        public final List<String> getPULL_REQUEST_EVENTS() {
            return PULL_REQUEST_EVENTS;
        }

        @NotNull
        public final List<String> getREPO_EVENTS() {
            return REPO_EVENTS;
        }

        @NotNull
        public final String switchHostToApi(@NotNull String url2) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            return StringsKt.startsWith((String)url2, (String)"https://bitbucket.org", (boolean)true) ? "https://api.bitbucket.org" : url2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

