/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone;

import java.util.Collection;
import java.util.List;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.AbstractVcsChangesConsumer;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.BitBucketStandaloneService;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.BitbucketStandaloneChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.BitbucketStandaloneUserResolver;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.api.BitBucketStandalonePage;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.api.BitbucketServerChangeData;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.api.BitbucketStandaloneCommit;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.api.BitbucketStandalonePushPayload;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.api.BitbucketStandaloneRest;
import jetbrains.youtrack.integration.vcs.impl.bitbucket.standalone.api.BitbucketStandaloneUser;
import jetbrains.youtrack.integration.vcs.persistence.XdBitbucketStandaloneChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0015\u001a\u00020\u0003H\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/BitbucketStandaloneVcsChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/AbstractVcsChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/persistence/XdBitbucketStandaloneChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/api/BitbucketStandalonePushPayload;", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/api/BitbucketStandaloneCommit;", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/BitbucketStandaloneUserResolver;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/BitBucketStandaloneService;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/BitBucketStandaloneService;Ljetbrains/youtrack/integration/vcs/persistence/XdBitbucketStandaloneChangesProcessor;)V", "getProcessor", "()Ljetbrains/youtrack/integration/vcs/persistence/XdBitbucketStandaloneChangesProcessor;", "getVcsService", "()Ljetbrains/youtrack/integration/vcs/impl/bitbucket/standalone/BitBucketStandaloneService;", "createDto", "Ljetbrains/youtrack/integration/service/vcs/CommonChangeDTO;", "commit", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "getBranch", "", "payload", "getCommits", "", "getRepositoryPath", "getVersion", "matchesBranchSpec", "branchName", "resolveUser", "youtrack-vcs-hosting-integration"})
public class BitbucketStandaloneVcsChangesConsumer
extends AbstractVcsChangesConsumer<XdBitbucketStandaloneChangesProcessor, BitbucketStandalonePushPayload, BitbucketStandaloneCommit>
implements BitbucketStandaloneUserResolver {
    @NotNull
    private final BitBucketStandaloneService vcsService;

    @Override
    @NotNull
    public XdBitbucketStandaloneChangesProcessor getProcessor() {
        return (XdBitbucketStandaloneChangesProcessor)((Object)super.getProcessor());
    }

    @Override
    @NotNull
    protected String getBranch(@NotNull BitbucketStandalonePushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return ((BitbucketServerChangeData)CollectionsKt.first(payload.getChanges())).getRefId();
    }

    @Override
    @NotNull
    protected String getRepositoryPath(@NotNull BitbucketStandalonePushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return StringsKt.removePrefix((String)payload.getRepository().getProject().getKey(), (CharSequence)"~") + '/' + payload.getRepository().getSlug();
    }

    @Override
    @NotNull
    protected List<BitbucketStandaloneCommit> getCommits(@NotNull BitbucketStandalonePushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.getProcessor().logInfo("Loading comments for bitbucket server " + payload.getRepository().getProject().getKey() + '/' + payload.getRepository().getSlug());
        BitbucketStandaloneRest rest = this.getVcsService().rest(this.getProcessor());
        String since = Intrinsics.areEqual((Object)((BitbucketServerChangeData)CollectionsKt.first(payload.getChanges())).getType(), (Object)"ADD") ? null : ((BitbucketServerChangeData)CollectionsKt.first(payload.getChanges())).getFromHash();
        String until = ((BitbucketServerChangeData)CollectionsKt.last(payload.getChanges())).getToHash();
        BitBucketStandalonePage<BitbucketStandaloneCommit> commitPage = BitbucketStandaloneRest.getCommits$default(rest, this.getProcessor(), since, until, 0, 8, null);
        this.getProcessor().logInfo("Loaded " + commitPage.getSize() + " from bitbucket server from " + since + " to " + until + ". " + (commitPage.getLastPage() ? "All" : "Has more pages..."));
        List commits = CollectionsKt.toList((Iterable)commitPage.getValues());
        int requestCount = 0;
        while (!commitPage.getLastPage() && requestCount < 30) {
            Collection collection = commitPage.getValues();
            boolean bl = false;
            if (!(!collection.isEmpty()) || commitPage.getNextPageStart() == null) break;
            ++requestCount;
            XdBitbucketStandaloneChangesProcessor xdBitbucketStandaloneChangesProcessor = this.getProcessor();
            Integer n = commitPage.getNextPageStart();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            commitPage = rest.getCommits(xdBitbucketStandaloneChangesProcessor, since, until, n);
            this.getProcessor().logInfo("Loaded " + commitPage.getSize() + " from bitbucket server from " + since + " to " + until + ". From page " + requestCount);
            commits = CollectionsKt.plus((Collection)commits, (Iterable)commitPage.getValues());
        }
        return commits;
    }

    @Override
    @NotNull
    protected CommonChangeDTO createDto(@NotNull BitbucketStandaloneCommit commit, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        return new BitbucketStandaloneChangeDTO(null, userResolution.getUser(), userResolution.getNoUserReason(), commit, this.getProcessor(), null);
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull BitbucketStandaloneCommit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return commit.getId();
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull BitbucketStandaloneCommit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return this.resolveUser(commit.getAuthor());
    }

    @Override
    @Nullable
    public String matchesBranchSpec(@NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        String string = super.matchesBranchSpec(branchName);
        if (string == null) {
            string = StringsKt.startsWith$default((String)branchName, (String)"refs/heads/", (boolean)false, (int)2, null) ? super.matchesBranchSpec(StringsKt.substringAfter$default((String)branchName, (String)"refs/heads/", null, (int)2, null)) : null;
        }
        return string;
    }

    @NotNull
    public BitBucketStandaloneService getVcsService() {
        return this.vcsService;
    }

    public BitbucketStandaloneVcsChangesConsumer(@NotNull BitBucketStandaloneService vcsService, @NotNull XdBitbucketStandaloneChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super(vcsService, (XdVcsHostingChangesProcessor)processor2);
        this.vcsService = vcsService;
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull BitbucketStandaloneUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return BitbucketStandaloneUserResolver.DefaultImpls.resolveUser(this, user);
    }
}

