/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.github;

import java.util.List;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.AbstractVcsChangesConsumer;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubPushEvent;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubService;
import jetbrains.youtrack.integration.vcs.persistence.XdGitHubChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/github/GitHubChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/AbstractVcsChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/github/GitHubPushEvent;", "Lorg/eclipse/egit/github/core/Commit;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/github/GitHubService;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/github/GitHubService;Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;)V", "createDto", "Ljetbrains/youtrack/integration/service/vcs/CommonChangeDTO;", "commit", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "getBranch", "", "payload", "getCommits", "", "getRepositoryPath", "getVersion", "resolveUser", "youtrack-vcs-hosting-integration"})
public final class GitHubChangesConsumer
extends AbstractVcsChangesConsumer<XdGitHubChangesProcessor, GitHubPushEvent, Commit> {
    @Override
    @NotNull
    protected String getBranch(@NotNull GitHubPushEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = payload.getRef();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull GitHubPushEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return payload.getRepositoryPath();
    }

    @Override
    @NotNull
    protected List<Commit> getCommits(@NotNull GitHubPushEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return payload.getCommits();
    }

    @Override
    @NotNull
    protected CommonChangeDTO createDto(@NotNull Commit commit, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        return new GitHubChangeDTO(null, userResolution.getUser(), userResolution.getNoUserReason(), null, commit, (XdVcsChangeProcessor)this.getProcessor());
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull Commit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        String string = commit.getSha();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.sha");
        return string;
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull Commit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        CommitUser commitUser = commit.getAuthor();
        if (commitUser == null) {
            return new UserResolution(null, null, XdNoUserReason.Companion.getGITHUB_NO_USER_INFO_PROVIDED());
        }
        CommitUser author = commitUser;
        String authorEmail = author.getEmail();
        CharSequence charSequence = authorEmail;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return new UserResolution(null, author.getName(), XdNoUserReason.Companion.getGITHUB_NO_EMAIL());
        }
        return this.resolveUser(author.getName(), authorEmail, XdNoUserReason.Companion.getGITHUB_NO_USER_FOUND_IN_YOUTRACK(), XdNoUserReason.Companion.getGITHUB_USER_NOT_UNIQUE(), XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP());
    }

    public GitHubChangesConsumer(@NotNull GitHubService vcsService, @NotNull XdGitHubChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super(vcsService, (XdVcsHostingChangesProcessor)processor2);
    }
}

