/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.github;

import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.vcs.XdPullRequestState;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.vcs.CommonPullRequestDTO;
import jetbrains.youtrack.integration.service.vcs.VcsPullRequestsServiceKt;
import jetbrains.youtrack.integration.vcs.impl.AbstractPullRequestsConsumer;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubPullRequestDTO;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubPullRequestEvent;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubService;
import jetbrains.youtrack.integration.vcs.persistence.XdGitHubChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.User;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/github/GitHubPullRequestsConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/AbstractPullRequestsConsumer;", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/github/GitHubPullRequestEvent;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/github/GitHubService;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/github/GitHubService;Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;)V", "getVcsService", "()Ljetbrains/youtrack/integration/vcs/impl/github/GitHubService;", "createDto", "Ljetbrains/youtrack/integration/service/vcs/CommonPullRequestDTO;", "payload", "authorUserResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "changedByUserResolution", "getBranch", "", "getRepositoryPath", "getTitle", "resolveAuthor", "resolveChangedBy", "resolveUser", "user", "Lorg/eclipse/egit/github/core/User;", "youtrack-vcs-hosting-integration"})
public final class GitHubPullRequestsConsumer
extends AbstractPullRequestsConsumer<XdGitHubChangesProcessor, GitHubPullRequestEvent> {
    @NotNull
    private final GitHubService vcsService;

    @Override
    @NotNull
    protected String getBranch(@NotNull GitHubPullRequestEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        PullRequestMarker pullRequestMarker = payload.getPullRequest().getBase();
        return this.asGitBranch(pullRequestMarker != null ? pullRequestMarker.getRef() : null);
    }

    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull GitHubPullRequestEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return payload.getRepositoryPath();
    }

    @Override
    @NotNull
    protected CommonPullRequestDTO createDto(@NotNull GitHubPullRequestEvent payload, @NotNull UserResolution authorUserResolution, @NotNull UserResolution changedByUserResolution) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)authorUserResolution, (String)"authorUserResolution");
        Intrinsics.checkParameterIsNotNull((Object)changedByUserResolution, (String)"changedByUserResolution");
        PullRequest pullRequest2 = payload.getPullRequest();
        XdPullRequestState state = Intrinsics.areEqual((Object)pullRequest2.getState(), (Object)"closed") && pullRequest2.isMerged() ? XdPullRequestState.Companion.getMERGED() : (Intrinsics.areEqual((Object)pullRequest2.getState(), (Object)"closed") && !pullRequest2.isMerged() ? XdPullRequestState.Companion.getDECLINED() : XdPullRequestState.Companion.getOPEN());
        return new GitHubPullRequestDTO(authorUserResolution.getUser(), authorUserResolution.getVcsUser(), authorUserResolution.getNoUserReason(), changedByUserResolution.getUser(), changedByUserResolution.getVcsUser(), changedByUserResolution.getNoUserReason(), payload.getPullRequest(), (XdVcsChangeProcessor)this.getProcessor(), state);
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull GitHubPullRequestEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = payload.getPullRequest().getTitle();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public UserResolution resolveAuthor(@NotNull GitHubPullRequestEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        User user = payload.getPullRequest().getUser();
        Intrinsics.checkExpressionValueIsNotNull((Object)user, (String)"payload.pullRequest.user");
        return this.resolveUser(user);
    }

    @Override
    @NotNull
    public UserResolution resolveChangedBy(@NotNull GitHubPullRequestEvent payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return this.resolveUser(payload.getSender());
    }

    private final UserResolution resolveUser(User user) {
        String login = user.getLogin();
        CharSequence charSequence = login;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return new UserResolution(null, user.getLogin(), XdNoUserReason.Companion.getGITHUB_NO_USER_INFO_PROVIDED());
        }
        String string = user.getEmail();
        if (string == null) {
            User user2 = this.getVcsService().rest((XdGitHubChangesProcessor)((Object)this.getProcessor())).getUser((XdGitHubChangesProcessor)((Object)this.getProcessor()), login);
            string = user2 != null ? user2.getEmail() : null;
        }
        String email = string;
        CharSequence charSequence2 = email;
        bl2 = false;
        boolean bl3 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            return new UserResolution(null, user.getLogin(), XdNoUserReason.Companion.getGITHUB_NO_EMAIL());
        }
        return this.resolveUser(user.getLogin(), email, XdNoUserReason.Companion.getGITHUB_NO_USER_FOUND_IN_YOUTRACK(), XdNoUserReason.Companion.getGITHUB_USER_NOT_UNIQUE(), XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP());
    }

    @NotNull
    public GitHubService getVcsService() {
        return this.vcsService;
    }

    public GitHubPullRequestsConsumer(@NotNull GitHubService vcsService, @NotNull XdGitHubChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super(vcsService, (XdVcsHostingChangesProcessor)processor2, VcsPullRequestsServiceKt.getVcsPullRequestsService());
        this.vcsService = vcsService;
    }
}

