/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.github;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.integration.persistence.vcs.XdVcsChange;
import jetbrains.youtrack.integration.service.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.VcsHostingService;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubChangesConsumer;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubPullRequestEvent;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubPullRequestsConsumer;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubPushEvent;
import jetbrains.youtrack.integration.vcs.impl.github.GitHubUrlProvider;
import jetbrains.youtrack.integration.vcs.impl.github.api.GitHubPayload;
import jetbrains.youtrack.integration.vcs.impl.github.api.GitHubRepository;
import jetbrains.youtrack.integration.vcs.impl.github.api.GitHubRest;
import jetbrains.youtrack.integration.vcs.persistence.XdGitHubChangesProcessor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.PageIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="gitHubService")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/github/GitHubService;", "Ljetbrains/youtrack/integration/vcs/impl/VcsHostingService;", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/github/api/GitHubRest;", "()V", "entityType", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor$Companion;", "getEntityType", "()Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor$Companion;", "integrationType", "", "getIntegrationType", "()Ljava/lang/String;", "systemPropertyName", "getSystemPropertyName", "urlProvider", "Ljetbrains/youtrack/integration/vcs/impl/github/GitHubUrlProvider;", "getUrlProvider", "()Ljetbrains/youtrack/integration/vcs/impl/github/GitHubUrlProvider;", "consume", "", "processor", "payload", "", "importData", "mapChange", "Ljetbrains/youtrack/integration/vcs/impl/github/GitHubChangeDTO;", "change", "Ljetbrains/youtrack/integration/persistence/vcs/XdVcsChange;", "rest", "tryFindChange", "Ljetbrains/youtrack/integration/service/vcs/CommonChangeDTO;", "hash", "youtrack-vcs-hosting-integration"})
public final class GitHubService
extends VcsHostingService<XdGitHubChangesProcessor, GitHubRest> {
    @NotNull
    private final String integrationType = "GitHub";
    @NotNull
    private final GitHubUrlProvider urlProvider = GitHubUrlProvider.INSTANCE;

    @NotNull
    public String getIntegrationType() {
        return this.integrationType;
    }

    @NotNull
    public XdGitHubChangesProcessor.Companion getEntityType() {
        return XdGitHubChangesProcessor.Companion;
    }

    @NotNull
    public GitHubUrlProvider getUrlProvider() {
        return this.urlProvider;
    }

    @Nullable
    public CommonChangeDTO tryFindChange(@NotNull XdGitHubChangesProcessor processor2, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return new GitHubChangesConsumer(this, processor2).findCommit(hash);
    }

    @Override
    public void consume(@NotNull XdGitHubChangesProcessor processor2, @NotNull Object payload) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        if (!(payload instanceof GitHubPayload)) {
            return;
        }
        PullRequest pullRequest2 = ((GitHubPayload)payload).getPullRequest();
        Object object = ((GitHubPayload)payload).getRepository();
        if (object == null || (object = ((GitHubRepository)object).getFullName()) == null) {
            return;
        }
        Object path = object;
        if (pullRequest2 != null) {
            GitHubPullRequestsConsumer gitHubPullRequestsConsumer = new GitHubPullRequestsConsumer(this, processor2);
            User user = ((GitHubPayload)payload).getSender();
            if (user == null) {
                Intrinsics.throwNpe();
            }
            String string = ((GitHubPayload)payload).getAction();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            PullRequest pullRequest3 = pullRequest2;
            String string2 = string;
            User user2 = user;
            gitHubPullRequestsConsumer.consume(new GitHubPullRequestEvent((String)path, pullRequest3, user2, string2));
        } else {
            GitHubChangesConsumer gitHubChangesConsumer = new GitHubChangesConsumer(this, processor2);
            List list2 = ((GitHubPayload)payload).getCommits();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            gitHubChangesConsumer.consume(new GitHubPushEvent((String)path, list2, ((GitHubPayload)payload).getRef()));
        }
    }

    @NotNull
    public GitHubChangeDTO mapChange(@NotNull XdVcsChange change) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        GitHubChangeDTO gitHubChangeDTO = new GitHubChangeDTO();
        boolean bl = false;
        boolean bl2 = false;
        GitHubChangeDTO $this$apply = gitHubChangeDTO;
        boolean bl3 = false;
        this.tweakChangeDto(change, $this$apply);
        $this$apply.setId(change.getVersion());
        return gitHubChangeDTO;
    }

    @Override
    @NotNull
    public GitHubRest rest(@NotNull XdGitHubChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        return new GitHubRest(processor2);
    }

    @Override
    protected void importData(@NotNull XdGitHubChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        try {
            PageIterator<PullRequest> pager = this.rest(processor2).getOpenedPullRequests();
            GitHubPullRequestsConsumer consumer = new GitHubPullRequestsConsumer(this, processor2);
            Iterable $this$sortedBy$iv = CollectionsKt.flatten((Iterable)((Iterable)pager));
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PullRequest it = (PullRequest)a;
                    boolean bl2 = false;
                    PullRequest pullRequest2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pullRequest2, (String)"it");
                    it = (PullRequest)b;
                    Comparable comparable = pullRequest2.getCreatedAt();
                    bl2 = false;
                    PullRequest pullRequest3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pullRequest3, (String)"it");
                    Date date = pullRequest3.getCreatedAt();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)date);
                }
            };
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                User user;
                PullRequest it = (PullRequest)element$iv;
                boolean bl2 = false;
                String string2 = processor2.getPath();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                PullRequest pullRequest2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)pullRequest2, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull((Object)pullRequest2.getUser(), (String)"it.user");
                Intrinsics.checkExpressionValueIsNotNull((Object)it.getState(), (String)"it.state");
                PullRequest pullRequest3 = it;
                GitHubPullRequestEvent payload = new GitHubPullRequestEvent(string2, pullRequest3, user, string);
                try {
                    consumer.consume(payload);
                    LegacySupportKt.flush();
                }
                catch (Exception e) {
                    String message = "error adding pull request: #" + payload.getPullRequest().getNumber() + ' ' + payload.getPullRequest().getTitle();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    processor2.logException(e, message, bl3, bl4);
                    LegacySupportKt.revert();
                }
            }
        }
        catch (Exception e) {
            boolean bl = false;
            boolean bl5 = false;
            processor2.logException(e, "error importing pull requests", bl, bl5);
        }
    }

    @NotNull
    protected String getSystemPropertyName() {
        return "jetbrains.youtrack.disableGithubIntegration";
    }
}

