/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.github.api;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import jetbrains.charisma.user.XdApiKey;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.ssl.SSLContextFactoryKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.vcs.CredentialsDTO;
import jetbrains.youtrack.integration.vcs.impl.VcsRestClient;
import jetbrains.youtrack.integration.vcs.impl.VcsRestClientKt;
import jetbrains.youtrack.integration.vcs.impl.github.api.ExtendedRepositoryService;
import jetbrains.youtrack.integration.vcs.impl.github.api.GitHubException;
import jetbrains.youtrack.integration.vcs.impl.github.api.GitHubRest;
import jetbrains.youtrack.integration.vcs.impl.github.api.GitHubUpdateHook;
import jetbrains.youtrack.integration.vcs.persistence.XdGitHubChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.service.ConnectionToRemoteHostNotAllowedException;
import jetbrains.youtrack.service.OutboundConnectionManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryHook;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.UserPlan;
import org.eclipse.egit.github.core.client.DateFormatter;
import org.eclipse.egit.github.core.client.EventFormatter;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.GitHubResponse;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.github.core.service.UserService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 92\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00029:B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J-\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u0012H\u0016J\u0012\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010(\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0012J\b\u0010,\u001a\u00020-H\u0002J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000206H\u0002J\f\u00107\u001a\u00020\f*\u000208H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006;"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/github/api/GitHubRest;", "Ljetbrains/youtrack/integration/vcs/impl/VcsRestClient;", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;", "Lorg/eclipse/egit/github/core/Commit;", "processor", "(Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;)V", "openedPullRequests", "Lorg/eclipse/egit/github/core/client/PageIterator;", "Lorg/eclipse/egit/github/core/PullRequest;", "getOpenedPullRequests", "()Lorg/eclipse/egit/github/core/client/PageIterator;", "addPullRequestSupport", "", "creds", "Ljetbrains/youtrack/integration/vcs/CredentialsDTO;", "createClient", "Lorg/eclipse/egit/github/core/client/GitHubClient;", "githubUrl", "", "createHook", "hookReceiverId", "deleteHook", "doGetCommit", "Lorg/eclipse/egit/github/core/RepositoryCommit;", "repo", "sha", "executeCall", "R", "call", "Lkotlin/Function2;", "Lorg/eclipse/egit/github/core/service/RepositoryService;", "Lorg/eclipse/egit/github/core/Repository;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "findCommit", "hash", "getClient", "oauthToken", "getCommitService", "Lorg/eclipse/egit/github/core/service/CommitService;", "token", "getRepositoryService", "getUser", "Lorg/eclipse/egit/github/core/User;", "login", "hook", "Lorg/eclipse/egit/github/core/RepositoryHook;", "isBaseUrl", "", "url", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "ping", "throwNoAdminException", "e", "Lorg/eclipse/egit/github/core/client/RequestException;", "setup", "Ljava/net/HttpURLConnection;", "Companion", "GitHubCli", "youtrack-vcs-hosting-integration"})
public final class GitHubRest
extends VcsRestClient<XdGitHubChangesProcessor, Commit> {
    @NotNull
    private static final String HOOK_NAME = "web";
    public static final Companion Companion = new Companion(null);

    private final void throwNoAdminException(RequestException e) {
        String string = BeansKt.getLocalizer().localizedMsg("GitHubRest.You_do_not_have_admin_permission_on_the_repository", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026ssion_on_the_repository\")");
        throw (Throwable)new GitHubException(string, e);
    }

    private final RepositoryHook hook() {
        long l;
        XdApiKey xdApiKey = ((XdGitHubChangesProcessor)((Object)this.getProcessor())).getApiKey();
        String key = xdApiKey != null ? xdApiKey.getKey() : null;
        RepositoryHook repositoryHook = new RepositoryHook();
        boolean bl = false;
        boolean bl2 = false;
        RepositoryHook $this$apply = repositoryHook;
        boolean bl3 = false;
        $this$apply.setName(HOOK_NAME);
        $this$apply.setActive(((XdGitHubChangesProcessor)((Object)this.getProcessor())).getEnabled());
        RepositoryHook repositoryHook2 = $this$apply;
        String string = ((XdGitHubChangesProcessor)((Object)this.getProcessor())).getHookId();
        if (string != null) {
            String string2 = string;
            RepositoryHook repositoryHook3 = repositoryHook2;
            boolean bl4 = false;
            long l2 = Long.parseLong(string2);
            repositoryHook2 = repositoryHook3;
            l = l2;
        } else {
            l = 0L;
        }
        repositoryHook2.setId(l);
        $this$apply.setConfig(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"url", (Object)(this.getLandingUrl() + "/rest/vcsHooksReceiver/github?apiKey=" + key)), TuplesKt.to((Object)"content_type", (Object)"json"), TuplesKt.to((Object)"insecure_ssl", (Object)"1"), TuplesKt.to((Object)"secret", (Object)key)}));
        $this$apply.setEvents(CollectionsKt.listOf((Object[])new String[]{"push", "pull_request"}));
        return repositoryHook;
    }

    private final RepositoryService getRepositoryService(String token2) {
        return new ExtendedRepositoryService(this.getClient(token2));
    }

    private final CommitService getCommitService(String token2) {
        return new CommitService(this.getClient(token2));
    }

    private final GitHubClient getClient(String oauthToken) {
        GitHubClient gitHubClient = this.createClient(this.getUrl());
        boolean bl = false;
        boolean bl2 = false;
        GitHubClient $this$apply = gitHubClient;
        boolean bl3 = false;
        $this$apply.setOAuth2Token(oauthToken);
        return gitHubClient;
    }

    private final GitHubClient createClient(String githubUrl) {
        try {
            URL url2 = new URL(githubUrl);
            String host = url2.getHost();
            OutboundConnectionManager outboundConnectionManager = VcsRestClientKt.getOutboundConnectionManager();
            String string = host;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"host");
            if (!outboundConnectionManager.isConnectionAllowed(string)) {
                throw (Throwable)new ConnectionToRemoteHostNotAllowedException("Connection to " + host + " is not allowed");
            }
            return Intrinsics.areEqual((Object)host, (Object)"github.com") || Intrinsics.areEqual((Object)host, (Object)"gist.github.com") ? (GitHubClient)new GitHubClient(this, "api.github.com"){
                final /* synthetic */ GitHubRest this$0;

                protected HttpURLConnection createConnection(@NotNull String url2) throws IOException {
                    Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
                    HttpURLConnection httpURLConnection = super.createConnection(url2);
                    boolean bl = false;
                    boolean bl2 = false;
                    HttpURLConnection $this$apply = httpURLConnection;
                    boolean bl3 = false;
                    GitHubRest.access$setup(this.this$0, $this$apply);
                    return httpURLConnection;
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            } : (GitHubClient)new GitHubCli(this, url2, null, 2, null);
        }
        catch (MalformedURLException ex) {
            throw (Throwable)new RuntimeException("Invalid github url");
        }
    }

    @Override
    public boolean isBaseUrl(@NotNull String url2, @NotNull CredentialsDTO creds, @Nullable XdStorageEntry sslKey) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        GitHubClient gitHubClient = this.createClient(url2);
        boolean bl2 = false;
        boolean bl3 = false;
        GitHubClient $this$apply = gitHubClient;
        boolean bl4 = false;
        String string = creds.getToken();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.setOAuth2Token(string);
        GitHubClient client2 = gitHubClient;
        try {
            GitHubRequest gitHubRequest = new GitHubRequest();
            GitHubClient gitHubClient2 = client2;
            bl3 = false;
            boolean bl5 = false;
            GitHubRequest $this$apply2 = gitHubRequest;
            boolean bl6 = false;
            $this$apply2.setUri("/");
            GitHubRequest gitHubRequest2 = gitHubRequest;
            GitHubResponse response = gitHubClient2.get(gitHubRequest2);
            bl = response != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    private final RepositoryCommit doGetCommit(XdGitHubChangesProcessor repo, String sha) {
        RepositoryCommit repositoryCommit;
        CommitService commitService = this.getCommitService(repo.getOauthToken());
        try {
            repositoryCommit = commitService.getCommit(new IRepositoryIdProvider(repo){
                final /* synthetic */ XdGitHubChangesProcessor $repo;

                @Nullable
                public final String generateId() {
                    return this.$repo.getPath();
                }
                {
                    this.$repo = xdGitHubChangesProcessor;
                }
            }, sha);
        }
        catch (IOException exception) {
            if (exception instanceof RequestException && ((RequestException)exception).getStatus() != 404) {
                repo.logException(exception, "Exception when getting a github commit " + sha + " in " + repo.getPath(), false, false);
            }
            repositoryCommit = null;
        }
        return repositoryCommit;
    }

    private final void setup(@NotNull HttpURLConnection $this$setup) throws IOException {
        $this$setup.setConnectTimeout(10000);
        $this$setup.setReadTimeout(100000);
    }

    @Override
    @NotNull
    public String createHook(@NotNull String hookReceiverId) {
        Intrinsics.checkParameterIsNotNull((Object)hookReceiverId, (String)"hookReceiverId");
        return (String)this.executeCall((Function2)new Function2<RepositoryService, Repository, String>(this){
            final /* synthetic */ GitHubRest this$0;

            @NotNull
            public final String invoke(@NotNull RepositoryService service, @NotNull Repository repository) {
                RepositoryHook result;
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
                RepositoryHook repositoryHook = result = service.createHook((IRepositoryIdProvider)repository, GitHubRest.access$hook(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryHook, (String)"result");
                return String.valueOf(repositoryHook.getId());
            }
            {
                this.this$0 = gitHubRest;
                super(2);
            }
        });
    }

    @Override
    public void deleteHook(@NotNull CredentialsDTO creds) {
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        ((XdGitHubChangesProcessor)((Object)this.getProcessor())).logInfo("Deleting a hook");
        RepositoryService service = this.getRepositoryService(creds.getToken());
        try {
            IRepositoryIdProvider iRepositoryIdProvider = (IRepositoryIdProvider)service.getRepository(GitHubRest.Companion.getOwner((XdGitHubChangesProcessor)((Object)this.getProcessor())), GitHubRest.Companion.getName((XdGitHubChangesProcessor)((Object)this.getProcessor())));
            String string = ((XdGitHubChangesProcessor)((Object)this.getProcessor())).getHookId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            IRepositoryIdProvider iRepositoryIdProvider2 = iRepositoryIdProvider;
            RepositoryService repositoryService = service;
            boolean bl = false;
            long l = Long.parseLong(string2);
            repositoryService.deleteHook(iRepositoryIdProvider2, l);
        }
        catch (IOException exception) {
            throw (Throwable)new GitHubException(exception);
        }
    }

    @Override
    public void addPullRequestSupport(@NotNull CredentialsDTO creds) {
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        this.executeCall((Function2)new Function2<RepositoryService, Repository, Object>(this){
            final /* synthetic */ GitHubRest this$0;

            public final Object invoke(@NotNull RepositoryService service, @NotNull Repository $noName_1) {
                long l;
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                StringBuilder stringBuilder = new StringBuilder().append("/repos/").append(((XdGitHubChangesProcessor)((Object)this.this$0.getProcessor())).getPath()).append("/hooks/");
                String string = ((XdGitHubChangesProcessor)((Object)this.this$0.getProcessor())).getHookId();
                if (string != null) {
                    String string2 = string;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    long l2 = Long.parseLong(string2);
                    stringBuilder = stringBuilder2;
                    l = l2;
                } else {
                    l = 0L;
                }
                String uri = stringBuilder.append(l).toString();
                return service.getClient().post(uri, (Object)new GitHubUpdateHook(CollectionsKt.listOf((Object[])new String[]{"push", "pull_request"}), false, 2, null), null);
            }
            {
                this.this$0 = gitHubRest;
                super(2);
            }
        });
    }

    @Override
    @Nullable
    public Commit findCommit(@NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        RepositoryCommit repositoryCommit = this.doGetCommit((XdGitHubChangesProcessor)((Object)this.getProcessor()), hash);
        if (repositoryCommit == null) {
            return null;
        }
        RepositoryCommit rc = repositoryCommit;
        Commit commit = rc.getCommit();
        boolean bl = false;
        boolean bl2 = false;
        Commit $this$apply = commit;
        boolean bl3 = false;
        $this$apply.setSha(rc.getSha());
        return commit;
    }

    @NotNull
    public final PageIterator<PullRequest> getOpenedPullRequests() {
        Object r = this.executeCall((Function2)new Function2<RepositoryService, Repository, PageIterator<PullRequest>>(this){
            final /* synthetic */ GitHubRest this$0;

            public final PageIterator<PullRequest> invoke(@NotNull RepositoryService $noName_0, @NotNull Repository repository) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
                PullRequestService prService = new PullRequestService(GitHubRest.access$getClient(this.this$0, ((XdGitHubChangesProcessor)((Object)this.this$0.getProcessor())).getOauthToken()));
                PageIterator pageIterator = prService.pagePullRequests((IRepositoryIdProvider)repository, "open");
                Intrinsics.checkExpressionValueIsNotNull((Object)pageIterator, (String)"prService.pagePullRequests(repository, \"open\")");
                return pageIterator;
            }
            {
                this.this$0 = gitHubRest;
                super(2);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(r, (String)"executeCall { _, reposit\u2026sitory, \"open\")\n        }");
        return (PageIterator)r;
    }

    @Override
    public void ping() {
        ((XdGitHubChangesProcessor)((Object)this.getProcessor())).logInfo("Listing available hooks");
        this.executeCall(ping.1.INSTANCE);
    }

    @Nullable
    public final User getUser(@NotNull XdGitHubChangesProcessor processor2, @NotNull String login) {
        User user;
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        try {
            UserService service = new UserService(this.getClient(processor2.getOauthToken()));
            user = service.getUser(login);
        }
        catch (Exception e) {
            VcsRestClient.Companion.getLogger().warn((Throwable)e, (Function0)new Function0<String>(login){
                final /* synthetic */ String $login;

                @NotNull
                public final String invoke() {
                    return "can't resolve user by " + this.$login;
                }
                {
                    this.$login = string;
                    super(0);
                }
            });
            user = null;
        }
        return user;
    }

    private final <R> R executeCall(Function2<? super RepositoryService, ? super Repository, ? extends R> call) {
        try {
            Repository repository;
            RepositoryService service = this.getRepositoryService(((XdGitHubChangesProcessor)((Object)this.getProcessor())).getOauthToken());
            Repository repository2 = repository = service.getRepository(GitHubRest.Companion.getOwner((XdGitHubChangesProcessor)((Object)this.getProcessor())), GitHubRest.Companion.getName((XdGitHubChangesProcessor)((Object)this.getProcessor())));
            Intrinsics.checkExpressionValueIsNotNull((Object)repository2, (String)"repository");
            return (R)call.invoke((Object)service, (Object)repository2);
        }
        catch (RequestException e) {
            if (e.getStatus() == 404) {
                this.throwNoAdminException(e);
            }
            throw (Throwable)new GitHubException((Exception)((Object)e));
        }
        catch (IOException ex) {
            throw (Throwable)new GitHubException(ex);
        }
    }

    public GitHubRest(@NotNull XdGitHubChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super((XdVcsHostingChangesProcessor)processor2);
    }

    static {
        HOOK_NAME = HOOK_NAME;
    }

    public static final /* synthetic */ RepositoryHook access$hook(GitHubRest $this) {
        return $this.hook();
    }

    public static final /* synthetic */ GitHubClient access$getClient(GitHubRest $this, String oauthToken) {
        return $this.getClient(oauthToken);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0005H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/github/api/GitHubRest$GitHubCli;", "Lorg/eclipse/egit/github/core/client/GitHubClient;", "url", "Ljava/net/URL;", "path", "", "(Ljetbrains/youtrack/integration/vcs/impl/github/api/GitHubRest;Ljava/net/URL;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "buildGson", "Lcom/google/gson/Gson;", "configureUri", "uri", "createConnection", "Ljava/net/HttpURLConnection;", "youtrack-vcs-hosting-integration"})
    public final class GitHubCli
    extends GitHubClient {
        @NotNull
        private final String path;
        final /* synthetic */ GitHubRest this$0;

        @NotNull
        protected HttpURLConnection createConnection(@NotNull String url2) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            HttpURLConnection httpURLConnection = super.createConnection(url2);
            boolean bl = false;
            boolean bl2 = false;
            HttpURLConnection $this$apply = httpURLConnection;
            boolean bl3 = false;
            if ($this$apply instanceof HttpsURLConnection) {
                ((HttpsURLConnection)$this$apply).setSSLSocketFactory(SSLContextFactoryKt.createSSLContext((XdStorageEntry)this.this$0.getSslKey()).getSocketFactory());
            }
            this.this$0.setup($this$apply);
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpURLConnection2, (String)"super.createConnection(u\u2026    setup()\n            }");
            return httpURLConnection2;
        }

        @NotNull
        protected String configureUri(@NotNull String uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            CharSequence charSequence = this.path;
            boolean bl = false;
            if (charSequence.length() == 0 || Intrinsics.areEqual((Object)this.path, (Object)"/")) {
                String string = super.configureUri(uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.configureUri(uri)");
                return string;
            }
            return this.path + super.configureUri(uri);
        }

        private final Gson buildGson() {
            GsonBuilder gsonBuilder = new GsonBuilder();
            boolean bl = false;
            boolean bl2 = false;
            GsonBuilder $this$apply = gsonBuilder;
            boolean bl3 = false;
            $this$apply.registerTypeAdapter((Type)((Object)Date.class), (Object)new DateFormatter());
            $this$apply.registerTypeAdapter((Type)((Object)Event.class), (Object)new EventFormatter());
            $this$apply.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
            $this$apply.serializeNulls();
            $this$apply.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

                public boolean shouldSkipField(@NotNull FieldAttributes p0) {
                    Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
                    return false;
                }

                public boolean shouldSkipClass(@NotNull Class<?> c) {
                    Intrinsics.checkParameterIsNotNull(c, (String)"c");
                    return Intrinsics.areEqual(c, UserPlan.class);
                }
            }});
            Gson gson = gsonBuilder.create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().apply {\n  \u2026})\n            }.create()");
            return gson;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public GitHubCli(@NotNull GitHubRest $outer, @NotNull URL url2, String path) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.this$0 = $outer;
            super(url2.getHost(), url2.getPort(), url2.getProtocol());
            this.path = path;
            this.gson = this.buildGson();
        }

        public /* synthetic */ GitHubCli(GitHubRest gitHubRest, URL uRL, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                String string2 = uRL.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
                string = string2;
            }
            this(gitHubRest, uRL, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/github/api/GitHubRest$Companion;", "", "()V", "HOOK_NAME", "", "getHOOK_NAME", "()Ljava/lang/String;", "getName", "repo", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitHubChangesProcessor;", "repoPath", "getOwner", "splitAndCheck", "", "youtrack-vcs-hosting-integration"})
    public static final class Companion {
        @NotNull
        public final String getHOOK_NAME() {
            return HOOK_NAME;
        }

        private final String getOwner(XdGitHubChangesProcessor repo) {
            return this.getOwner(repo.getPath());
        }

        private final String getName(XdGitHubChangesProcessor repo) {
            return this.getName(repo.getPath());
        }

        private final String getOwner(String repoPath) {
            String string = repoPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return this.splitAndCheck(string).get(0);
        }

        private final String getName(String repoPath) {
            String string = repoPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return this.splitAndCheck(string).get(1);
        }

        private final List<String> splitAndCheck(String repoPath) throws IllegalArgumentException {
            List segments = StringsKt.split$default((CharSequence)repoPath, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            if (segments.size() != 2) {
                throw (Throwable)new IllegalArgumentException("Invalid repository path format: " + repoPath);
            }
            return segments;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

