/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.gitlab;

import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.vcs.XdPullRequestState;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.vcs.CommonPullRequestDTO;
import jetbrains.youtrack.integration.service.vcs.VcsPullRequestsServiceKt;
import jetbrains.youtrack.integration.vcs.impl.AbstractPullRequestsConsumer;
import jetbrains.youtrack.integration.vcs.impl.gitlab.GitLabMergeRequestDTO;
import jetbrains.youtrack.integration.vcs.impl.gitlab.GitLabPayloadMethodsKt;
import jetbrains.youtrack.integration.vcs.impl.gitlab.GitLabService;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabHookMergeRequestPayload;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabMergeRequest;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabRestV4;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabUser;
import jetbrains.youtrack.integration.vcs.persistence.XdGitLabChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabMergeRequestConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/AbstractPullRequestsConsumer;", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitLabChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/gitlab/api/GitLabHookMergeRequestPayload;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabService;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabService;Ljetbrains/youtrack/integration/vcs/persistence/XdGitLabChangesProcessor;)V", "getVcsService", "()Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabService;", "createDto", "Ljetbrains/youtrack/integration/service/vcs/CommonPullRequestDTO;", "payload", "authorUserResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "changedByUserResolution", "getBranch", "", "getRepositoryPath", "getState", "Ljetbrains/youtrack/integration/persistence/vcs/XdPullRequestState;", "getTitle", "resolveAuthor", "resolveChangedBy", "youtrack-vcs-hosting-integration"})
public final class GitLabMergeRequestConsumer
extends AbstractPullRequestsConsumer<XdGitLabChangesProcessor, GitLabHookMergeRequestPayload> {
    @NotNull
    private final GitLabService vcsService;

    @Override
    @NotNull
    protected String getBranch(@NotNull GitLabHookMergeRequestPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        GitLabMergeRequest gitLabMergeRequest = payload.getMergeRequest();
        return this.asGitBranch(gitLabMergeRequest != null ? gitLabMergeRequest.getTargetBranch() : null);
    }

    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull GitLabHookMergeRequestPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return GitLabPayloadMethodsKt.extractRepositoryPath(payload, (XdVcsChangeProcessor)this.getProcessor());
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull GitLabHookMergeRequestPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Object object = payload.getMergeRequest();
        if (object == null || (object = ((GitLabMergeRequest)object).getTitle()) == null) {
            object = "";
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final XdPullRequestState getState(GitLabHookMergeRequestPayload payload) {
        XdPullRequestState xdPullRequestState;
        GitLabMergeRequest gitLabMergeRequest = payload.getMergeRequest();
        if (gitLabMergeRequest == null) {
            Intrinsics.throwNpe();
        }
        GitLabMergeRequest pullRequest2 = gitLabMergeRequest;
        String string = pullRequest2.getState();
        if (string != null) {
            switch (string) {
                case "merged": {
                    xdPullRequestState = XdPullRequestState.Companion.getMERGED();
                    return xdPullRequestState;
                }
                case "closed": {
                    xdPullRequestState = XdPullRequestState.Companion.getDECLINED();
                    return xdPullRequestState;
                }
            }
        }
        xdPullRequestState = XdPullRequestState.Companion.getOPEN();
        return xdPullRequestState;
    }

    @Override
    @NotNull
    public UserResolution resolveAuthor(@NotNull GitLabHookMergeRequestPayload payload) {
        GitLabUser gitLabUser;
        block9: {
            block8: {
                GitLabUser authorId;
                Object object;
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
                GitLabMergeRequest gitLabMergeRequest = payload.getMergeRequest();
                if (gitLabMergeRequest != null) {
                    GitLabMergeRequest gitLabMergeRequest2 = gitLabMergeRequest;
                    boolean bl2 = false;
                    bl = false;
                    GitLabMergeRequest it = gitLabMergeRequest2;
                    boolean bl3 = false;
                    object = it.getAuthor();
                    if (object == null || (object = ((GitLabUser)object).getId()) == null || (object = String.valueOf((Long)object)) == null) {
                        object = it.getAuthorId();
                    }
                } else {
                    object = null;
                }
                if ((gitLabUser = (authorId = object)) == null) break block8;
                GitLabUser gitLabUser2 = gitLabUser;
                bl = false;
                boolean bl4 = false;
                GitLabUser id = gitLabUser2;
                boolean bl5 = false;
                GitLabRestV4 gitLabRestV4 = this.getVcsService().rest((XdGitLabChangesProcessor)((Object)this.getProcessor()));
                String string = ((XdGitLabChangesProcessor)((Object)this.getProcessor())).getToken();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((gitLabUser = gitLabRestV4.getUser((String)((Object)id), string)) != null) break block9;
            }
            gitLabUser = new GitLabUser();
        }
        GitLabUser author = gitLabUser;
        return GitLabPayloadMethodsKt.resolveUser(author, (XdVcsChangeProcessor)this.getProcessor());
    }

    @Override
    @NotNull
    public UserResolution resolveChangedBy(@NotNull GitLabHookMergeRequestPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return GitLabPayloadMethodsKt.resolveUser(payload.getUser(), (XdVcsChangeProcessor)this.getProcessor());
    }

    @Override
    @NotNull
    protected CommonPullRequestDTO createDto(@NotNull GitLabHookMergeRequestPayload payload, @NotNull UserResolution authorUserResolution, @NotNull UserResolution changedByUserResolution) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)authorUserResolution, (String)"authorUserResolution");
        Intrinsics.checkParameterIsNotNull((Object)changedByUserResolution, (String)"changedByUserResolution");
        GitLabMergeRequest gitLabMergeRequest = payload.getMergeRequest();
        if (gitLabMergeRequest == null) {
            Intrinsics.throwNpe();
        }
        return new GitLabMergeRequestDTO(authorUserResolution, changedByUserResolution, gitLabMergeRequest, (XdVcsChangeProcessor)this.getProcessor(), this.getState(payload));
    }

    @NotNull
    public GitLabService getVcsService() {
        return this.vcsService;
    }

    public GitLabMergeRequestConsumer(@NotNull GitLabService vcsService, @NotNull XdGitLabChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super(vcsService, (XdVcsHostingChangesProcessor)processor2, VcsPullRequestsServiceKt.getVcsPullRequestsService());
        this.vcsService = vcsService;
    }
}

